/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.smb;

public enum ImpersonationLevel {
    ANONYMOUS(0),
    IDENTIFICATION(1),
    IMPERSONATION(2),
    DELEGATE(3),
    INVALID(-1);

    private final int impLevel;

    private ImpersonationLevel(int lev) {
        this.impLevel = lev;
    }

    public final int intValue() {
        return this.impLevel;
    }

    public static final ImpersonationLevel fromInt(int lev) {
        ImpersonationLevel impLev = INVALID;
        switch (lev) {
            case 0: {
                impLev = ANONYMOUS;
                break;
            }
            case 1: {
                impLev = IDENTIFICATION;
                break;
            }
            case 2: {
                impLev = IMPERSONATION;
                break;
            }
            case 3: {
                impLev = DELEGATE;
            }
        }
        return impLev;
    }
}

