/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.smb.dcerpc;

import org.filesys.smb.NTTime;
import org.filesys.smb.TransactBuffer;
import org.filesys.smb.dcerpc.DCEBufferException;
import org.filesys.smb.dcerpc.DCEDataPacker;
import org.filesys.smb.dcerpc.PolicyHandle;
import org.filesys.smb.dcerpc.UUID;
import org.filesys.util.DataBuffer;
import org.filesys.util.DataPacker;
import org.filesys.util.HexDump;

public class DCEBuffer {
    public static final int HDR_VERMAJOR = 0;
    public static final int HDR_VERMINOR = 1;
    public static final int HDR_PDUTYPE = 2;
    public static final int HDR_FLAGS = 3;
    public static final int HDR_DATAREP = 4;
    public static final int HDR_FRAGLEN = 5;
    public static final int HDR_AUTHLEN = 6;
    public static final int HDR_CALLID = 7;
    public static final int HDR_ALLOCHINT = 8;
    public static final int HDR_OPCODE = 9;
    public static final int FLG_FIRSTFRAG = 1;
    public static final int FLG_LASTFRAG = 2;
    public static final int FLG_CANCEL = 4;
    public static final int FLG_IDEMPOTENT = 32;
    public static final int FLG_BROADCAST = 64;
    public static final int FLG_ONLYFRAG = 3;
    public static final int VERSIONMAJOR = 0;
    public static final int VERSIONMINOR = 1;
    public static final int PDUTYPE = 2;
    public static final int HEADERFLAGS = 3;
    public static final int PACKEDDATAREP = 4;
    public static final int FRAGMENTLEN = 8;
    public static final int AUTHLEN = 10;
    public static final int CALLID = 12;
    public static final int DCEDATA = 16;
    public static final int ALLOCATIONHINT = 16;
    public static final int PRESENTIDENT = 20;
    public static final int OPERATIONID = 22;
    public static final int OPERATIONDATA = 24;
    private static final byte VAL_VERSIONMAJOR = 5;
    private static final byte VAL_VERSIONMINOR = 0;
    private static final int VAL_PACKEDDATAREP = 16;
    public static final int ALIGN_NONE = -1;
    public static final int ALIGN_SHORT = 0;
    public static final int ALIGN_INT = 1;
    public static final int ALIGN_LONG = 2;
    public static final int MAX_STRING_LEN = 1000;
    private static final int[] _alignMask = new int[]{-2, -4, -8};
    private static final int[] _alignRound = new int[]{1, 3, 7};
    private static final int DEFAULT_BUFSIZE = 8192;
    private static final int MAX_BUFFER_SIZE = 65536;
    private static final int DUMMY_ADDRESS = 305419896;
    private byte[] m_buffer;
    private int m_base;
    private int m_pos;
    private int m_rdpos;
    private int m_errorCode;

    public DCEBuffer() {
        this.m_buffer = new byte[8192];
        this.m_pos = 0;
        this.m_rdpos = 0;
        this.m_base = 0;
    }

    public DCEBuffer(int siz) {
        this.m_buffer = new byte[siz];
        this.m_pos = 0;
        this.m_rdpos = 0;
        this.m_base = 0;
    }

    public DCEBuffer(byte[] buf, int startPos, int len) {
        this.m_buffer = buf;
        this.m_pos = startPos + len;
        this.m_rdpos = startPos;
        this.m_base = startPos;
    }

    public DCEBuffer(byte[] buf, int startPos) {
        this.m_buffer = buf;
        this.m_pos = startPos;
        this.m_rdpos = startPos;
        this.m_base = startPos;
    }

    public DCEBuffer(TransactBuffer tbuf) {
        DataBuffer dataBuf = tbuf.getDataBuffer();
        this.m_buffer = dataBuf.getBuffer();
        this.m_rdpos = dataBuf.getOffset();
        this.m_base = dataBuf.getOffset();
        this.m_pos = this.m_rdpos + dataBuf.getLength();
    }

    public final byte[] getBuffer() {
        return this.m_buffer;
    }

    public final int getLength() {
        return this.m_pos;
    }

    public final int getReadPosition() {
        return this.m_rdpos;
    }

    public final int getWritePosition() {
        return this.m_pos;
    }

    public final int getAvailableLength() {
        return this.m_pos - this.m_rdpos;
    }

    public final int getByte(int align) throws DCEBufferException {
        if (this.m_buffer.length - this.m_rdpos < 1) {
            throw new DCEBufferException("End of DCE buffer");
        }
        int bval = this.m_buffer[this.m_rdpos++] & 0xFF;
        this.alignRxPosition(align);
        return bval;
    }

    public final byte[] getBytes(byte[] buf, int len) throws DCEBufferException {
        if (this.m_buffer.length - this.m_rdpos < len) {
            throw new DCEBufferException("End of DCE buffer");
        }
        if (buf == null) {
            buf = new byte[len];
        }
        for (int i = 0; i < len; ++i) {
            buf[i] = this.m_buffer[this.m_rdpos++];
        }
        return buf;
    }

    public final int getShort() throws DCEBufferException {
        if (this.m_buffer.length - this.m_rdpos < 2) {
            throw new DCEBufferException("End of DCE buffer");
        }
        int sval = DataPacker.getIntelShort(this.m_buffer, this.m_rdpos);
        this.m_rdpos += 2;
        return sval;
    }

    public final int getShort(int align) throws DCEBufferException {
        int sval = this.getShort();
        this.alignRxPosition(align);
        return sval;
    }

    public final int getInt() throws DCEBufferException {
        if (this.m_buffer.length - this.m_rdpos < 4) {
            throw new DCEBufferException("End of DCE buffer");
        }
        int ival = DataPacker.getIntelInt(this.m_buffer, this.m_rdpos);
        this.m_rdpos += 4;
        return ival;
    }

    public final int getPointer() throws DCEBufferException {
        return this.getInt();
    }

    public final String getStringPointer() throws DCEBufferException {
        if (this.getInt() == 0) {
            return null;
        }
        return "";
    }

    public final String getCharArrayPointer() throws DCEBufferException {
        int len = this.getShort();
        int siz = this.getShort();
        return this.getStringPointer();
    }

    public final String getCharArrayNotNull(String strVar, int align) throws DCEBufferException {
        String str = "";
        if (strVar != null) {
            str = this.getCharArray();
            this.alignRxPosition(align);
        }
        return str;
    }

    public final long getLong() throws DCEBufferException {
        if (this.m_buffer.length - this.m_rdpos < 8) {
            throw new DCEBufferException("End of DCE buffer");
        }
        long lval = DataPacker.getIntelLong(this.m_buffer, this.m_rdpos);
        this.m_rdpos += 8;
        return lval;
    }

    public final int getHeaderValue(int valTyp) {
        int result = -1;
        switch (valTyp) {
            case 0: {
                result = this.m_buffer[this.m_base + 0] & 0xFF;
                break;
            }
            case 1: {
                result = this.m_buffer[this.m_base + 1] & 0xFF;
                break;
            }
            case 2: {
                result = this.m_buffer[this.m_base + 2] & 0xFF;
                break;
            }
            case 3: {
                result = this.m_buffer[this.m_base + 3] & 0xFF;
                break;
            }
            case 4: {
                result = DataPacker.getIntelInt(this.m_buffer, this.m_base + 1);
                break;
            }
            case 6: {
                result = DataPacker.getIntelInt(this.m_buffer, this.m_base + 10);
                break;
            }
            case 5: {
                result = DataPacker.getIntelInt(this.m_buffer, this.m_base + 8);
                break;
            }
            case 7: {
                result = DataPacker.getIntelInt(this.m_buffer, this.m_base + 12);
                break;
            }
            case 8: {
                result = DataPacker.getIntelInt(this.m_buffer, this.m_base + 16);
                break;
            }
            case 9: {
                result = DataPacker.getIntelShort(this.m_buffer, this.m_base + 22);
            }
        }
        return result;
    }

    public final void setHeaderValue(int typ, int val) {
        switch (typ) {
            case 0: {
                this.m_buffer[this.m_base + 0] = (byte)(val & 0xFF);
                break;
            }
            case 1: {
                this.m_buffer[this.m_base + 1] = (byte)(val & 0xFF);
                break;
            }
            case 2: {
                this.m_buffer[this.m_base + 2] = (byte)(val & 0xFF);
                break;
            }
            case 3: {
                this.m_buffer[this.m_base + 3] = (byte)(val & 0xFF);
                break;
            }
            case 4: {
                DataPacker.putIntelInt(val, this.m_buffer, this.m_base + 4);
                break;
            }
            case 6: {
                DataPacker.putIntelInt(val, this.m_buffer, this.m_base + 10);
                break;
            }
            case 5: {
                DataPacker.putIntelInt(val, this.m_buffer, this.m_base + 8);
                break;
            }
            case 7: {
                DataPacker.putIntelInt(val, this.m_buffer, this.m_base + 12);
                break;
            }
            case 8: {
                DataPacker.putIntelInt(val, this.m_buffer, this.m_base + 16);
                break;
            }
            case 9: {
                DataPacker.putIntelShort(val, this.m_buffer, this.m_base + 22);
            }
        }
    }

    public final boolean isFirstFragment() {
        return (this.getHeaderValue(3) & 1) != 0;
    }

    public final boolean isLastFragment() {
        return (this.getHeaderValue(3) & 2) != 0;
    }

    public final boolean isOnlyFragment() {
        return (this.getHeaderValue(3) & 3) == 3;
    }

    public final boolean hasMoreEntries() {
        return this.getStatusCode() == 261;
    }

    public final boolean hasSuccessStatus() {
        return this.getStatusCode() == 0;
    }

    public final void skipBytes(int cnt) throws DCEBufferException {
        if (this.m_buffer.length - this.m_rdpos < cnt) {
            throw new DCEBufferException("End of DCE buffer");
        }
        this.m_rdpos += cnt;
    }

    public final void skipPointer() throws DCEBufferException {
        if (this.m_buffer.length - this.m_rdpos < 4) {
            throw new DCEBufferException("End of DCE buffer");
        }
        this.m_rdpos += 4;
    }

    public final void positionAt(int pos) throws DCEBufferException {
        if (this.m_buffer.length < pos) {
            throw new DCEBufferException("End of DCE buffer");
        }
        this.m_rdpos = pos;
    }

    public final String getChars(int len) throws DCEBufferException {
        if (this.m_buffer.length - this.m_rdpos < len * 2) {
            throw new DCEBufferException("End of DCE buffer");
        }
        StringBuffer str = new StringBuffer(len);
        while (len-- > 0) {
            char curChar = (char)((this.m_buffer[this.m_rdpos + 1] << 8) + this.m_buffer[this.m_rdpos]);
            this.m_rdpos += 2;
            str.append(curChar);
        }
        return str.toString();
    }

    public final int getStatusCode() {
        int ival = DataPacker.getIntelInt(this.m_buffer, this.m_pos - 4);
        return ival;
    }

    public final String getString() throws DCEBufferException {
        if (this.m_buffer.length - this.m_rdpos < 12) {
            throw new DCEBufferException("End of DCE buffer");
        }
        int maxLen = this.getInt();
        this.skipBytes(4);
        int strLen = this.getInt();
        String str = DataPacker.getUnicodeString(this.m_buffer, this.m_rdpos, strLen);
        this.m_rdpos += strLen * 2;
        return str;
    }

    public final String getCharArray() throws DCEBufferException {
        if (this.m_buffer.length - this.m_rdpos < 12) {
            throw new DCEBufferException("End of DCE buffer");
        }
        int maxLen = this.getInt();
        this.skipBytes(4);
        int strLen = this.getInt();
        String str = null;
        if (strLen > 0) {
            str = DataPacker.getUnicodeString(this.m_buffer, this.m_rdpos, strLen);
            this.m_rdpos += strLen * 2;
        }
        return str;
    }

    public final String getCharArray(int align) throws DCEBufferException {
        String str = this.getCharArray();
        this.alignRxPosition(align);
        return str;
    }

    public final String getString(int align) throws DCEBufferException {
        String str = this.getString();
        this.alignRxPosition(align);
        return str;
    }

    public final String getStringNotNull(String strVar, int align) throws DCEBufferException {
        String str = "";
        if (strVar != null) {
            str = this.getString();
            this.alignRxPosition(align);
        }
        return str;
    }

    public final String getStringAt(int pos) throws DCEBufferException {
        if (this.m_buffer.length < pos) {
            throw new DCEBufferException("Buffer offset out of range, " + pos);
        }
        String str = DataPacker.getUnicodeString(this.m_buffer, pos, 1000);
        return str;
    }

    public final int getUnicodeHeaderLength() throws DCEBufferException {
        if (this.m_buffer.length - this.m_rdpos < 8) {
            throw new DCEBufferException("End of DCE buffer");
        }
        int len = DataPacker.getIntelShort(this.m_buffer, this.m_rdpos);
        this.m_rdpos += 4;
        int ptr = DataPacker.getIntelInt(this.m_buffer, this.m_rdpos);
        this.m_rdpos += 4;
        if (ptr == 0) {
            return -1;
        }
        return len;
    }

    public final String getUnicodeString() throws DCEBufferException {
        if (this.m_buffer.length - this.m_rdpos <= 0) {
            throw new DCEBufferException("No more buffer");
        }
        String str = DataPacker.getUnicodeString(this.m_buffer, this.m_rdpos, 1000);
        if (str != null) {
            this.m_rdpos += str.length() * 2 + 2;
        }
        return str;
    }

    public final byte[] getDataBlock(int align) throws DCEBufferException {
        if (this.m_buffer.length - this.m_rdpos < 12) {
            throw new DCEBufferException("End of DCE buffer");
        }
        int len = this.getInt();
        this.m_rdpos += 8;
        byte[] dataBlk = null;
        if (len > 0) {
            dataBlk = new byte[len];
            System.arraycopy(this.m_buffer, this.m_rdpos, dataBlk, 0, len);
        }
        this.m_rdpos += len;
        this.alignRxPosition(align);
        return dataBlk;
    }

    public final UUID getUUID(boolean readVer) throws DCEBufferException {
        int len = 16;
        if (readVer) {
            len += 4;
        }
        if (this.m_buffer.length - this.m_rdpos < len) {
            throw new DCEBufferException("End of DCE buffer");
        }
        UUID uuid = new UUID(this.m_buffer, this.m_rdpos);
        this.m_rdpos += 16;
        if (readVer) {
            int ver = this.getInt();
            uuid.setVersion(ver);
        }
        return uuid;
    }

    public final long getNTTime() throws DCEBufferException {
        long ntTime = this.getLong();
        if (ntTime == 0L || ntTime == Long.MAX_VALUE) {
            return ntTime;
        }
        return NTTime.toJavaDate(ntTime);
    }

    public final byte[] getByteStructure(byte[] buf) throws DCEBufferException {
        if (this.m_buffer.length - this.m_rdpos < 12) {
            throw new DCEBufferException("End of DCE buffer");
        }
        int maxLen = this.getInt();
        this.skipBytes(4);
        int bytLen = this.getInt();
        byte[] bytBuf = buf;
        if (bytBuf.length < bytLen) {
            bytBuf = new byte[bytLen];
        }
        return this.getBytes(bytBuf, bytLen);
    }

    public final void getHandle(PolicyHandle handle) throws DCEBufferException {
        if (this.m_buffer.length - this.m_rdpos < 20) {
            throw new DCEBufferException("End of DCE buffer");
        }
        this.m_rdpos = handle.loadPolicyHandle(this.m_buffer, this.m_rdpos);
    }

    public final int copyData(byte[] buf, int off, int cnt) throws DCEBufferException {
        if (this.m_rdpos == this.m_pos) {
            return 0;
        }
        int siz = this.m_pos - this.m_rdpos;
        if (siz > cnt) {
            siz = cnt;
        }
        System.arraycopy(this.m_buffer, this.m_rdpos, buf, off, siz);
        this.m_rdpos += siz;
        return siz;
    }

    public final void appendData(byte[] buf, int off, int len) throws DCEBufferException {
        if (this.m_buffer.length - this.m_pos < len) {
            this.extendBuffer(len);
        }
        System.arraycopy(buf, off, this.m_buffer, this.m_pos, len);
        this.m_pos += len;
    }

    public final void putInt(int ival) {
        if (this.m_buffer.length - this.m_pos < 4) {
            this.extendBuffer();
        }
        DataPacker.putIntelInt(ival, this.m_buffer, this.m_pos);
        this.m_pos += 4;
    }

    public final void putByte(int bval) {
        if (this.m_buffer.length - this.m_pos < 1) {
            this.extendBuffer();
        }
        this.m_buffer[this.m_pos++] = (byte)(bval & 0xFF);
    }

    public final void putByte(byte bval, int align) {
        if (this.m_buffer.length - this.m_pos < 1) {
            this.extendBuffer();
        }
        this.m_buffer[this.m_pos++] = bval;
        this.alignPosition(align);
    }

    public final void putByte(int bval, int align) {
        if (this.m_buffer.length - this.m_pos < 1) {
            this.extendBuffer();
        }
        this.m_buffer[this.m_pos++] = (byte)(bval & 0xFF);
        this.alignPosition(align);
    }

    public final void putBytes(byte[] bval, int len) {
        if (this.m_buffer.length - this.m_pos < len) {
            this.extendBuffer();
        }
        for (int i = 0; i < len; ++i) {
            this.m_buffer[this.m_pos++] = bval[i];
        }
    }

    public final void putBytes(byte[] bval, int len, int align) {
        if (this.m_buffer.length - this.m_pos < len) {
            this.extendBuffer();
        }
        for (int i = 0; i < len; ++i) {
            this.m_buffer[this.m_pos++] = bval[i];
        }
        this.alignPosition(align);
    }

    public final void putShort(int sval) {
        if (this.m_buffer.length - this.m_pos < 2) {
            this.extendBuffer();
        }
        DataPacker.putIntelShort(sval, this.m_buffer, this.m_pos);
        this.m_pos += 2;
    }

    public final void putString(String str) {
        int reqLen = str.length() * 2 + 24;
        if (this.m_buffer.length - this.m_pos < reqLen) {
            this.extendBuffer(reqLen);
        }
        this.m_pos = DCEDataPacker.putDCEString(this.m_buffer, this.m_pos, str, false);
    }

    public final void putString(String str, int align) {
        int reqLen = str.length() * 2 + 24;
        if (this.m_buffer.length - this.m_pos < reqLen) {
            this.extendBuffer(reqLen);
        }
        this.m_pos = DCEDataPacker.putDCEString(this.m_buffer, this.m_pos, str, false);
        this.alignPosition(align);
    }

    public final void putString(String str, int align, boolean incNul) {
        int reqLen = str.length() * 2 + 24;
        if (incNul) {
            reqLen += 2;
        }
        if (this.m_buffer.length - this.m_pos < reqLen) {
            this.extendBuffer(reqLen);
        }
        this.m_pos = DCEDataPacker.putDCEString(this.m_buffer, this.m_pos, str, incNul);
        this.alignPosition(align);
    }

    public final void putStringReturn(int len, int align) {
        if (this.m_buffer.length - this.m_pos < 20) {
            this.extendBuffer();
        }
        DataPacker.putIntelInt(len, this.m_buffer, this.m_pos);
        DataPacker.putZeros(this.m_buffer, this.m_pos + 4, 8);
        DataPacker.putIntelInt(305419896, this.m_buffer, this.m_pos + 12);
        this.m_pos += 16;
        this.alignPosition(align);
    }

    public final void putUnicodeHeader(String str, boolean incNul) {
        if (this.m_buffer.length - this.m_pos < 8) {
            this.extendBuffer();
        }
        int sLen = 0;
        if (str != null) {
            sLen = str.length() * 2;
        }
        if (str != null) {
            DataPacker.putIntelShort(incNul ? sLen + 2 : sLen, this.m_buffer, this.m_pos);
        } else {
            DataPacker.putIntelShort(0, this.m_buffer, this.m_pos);
        }
        DataPacker.putIntelShort(sLen != 0 ? sLen + 2 : 0, this.m_buffer, this.m_pos + 2);
        DataPacker.putIntelInt(str != null ? 305419896 : 0, this.m_buffer, this.m_pos + 4);
        this.m_pos += 8;
    }

    public final void putUnicodeReturn(int len) {
        if (this.m_buffer.length - this.m_pos < 8) {
            this.extendBuffer();
        }
        DataPacker.putIntelShort(0, this.m_buffer, this.m_pos);
        DataPacker.putIntelShort(len, this.m_buffer, this.m_pos + 2);
        DataPacker.putIntelInt(305419896, this.m_buffer, this.m_pos + 4);
        this.m_pos += 8;
    }

    public final void putUnicodeHeader(int len) {
        if (this.m_buffer.length - this.m_pos < 8) {
            this.extendBuffer();
        }
        int sLen = len * 2;
        DataPacker.putIntelShort(sLen, this.m_buffer, this.m_pos);
        DataPacker.putIntelShort(sLen + 2, this.m_buffer, this.m_pos + 2);
        DataPacker.putIntelInt(sLen != 0 ? 305419896 : 0, this.m_buffer, this.m_pos + 4);
        this.m_pos += 8;
    }

    public final void putUnicodeBytes(String str, int align) {
        if (this.m_buffer.length - this.m_pos < str.length() * 2) {
            this.extendBuffer();
        }
        this.m_pos = DataPacker.putString(str, this.m_buffer, this.m_pos, false, true);
        this.alignPosition(align);
    }

    public final void putASCIIString(String str, boolean incNul) {
        if (this.m_buffer.length - this.m_pos < str.length() + 1) {
            this.extendBuffer(str.length() + 2);
        }
        this.m_pos = DataPacker.putString(str, this.m_buffer, this.m_pos, incNul);
    }

    public final void putASCIIString(String str, boolean incNul, int align) {
        if (this.m_buffer.length - this.m_pos < str.length() + 1) {
            this.extendBuffer(str.length() + 8);
        }
        this.m_pos = DataPacker.putString(str, this.m_buffer, this.m_pos, incNul);
        this.alignPosition(align);
    }

    public final void putPointer(Object obj) {
        if (this.m_buffer.length - this.m_pos < 4) {
            this.extendBuffer();
        }
        if (obj == null) {
            DataPacker.putZeros(this.m_buffer, this.m_pos, 4);
        } else {
            DataPacker.putIntelInt(305419896, this.m_buffer, this.m_pos);
        }
        this.m_pos += 4;
    }

    public final void putPointer(boolean notNull) {
        if (this.m_buffer.length - this.m_pos < 4) {
            this.extendBuffer();
        }
        if (!notNull) {
            DataPacker.putZeros(this.m_buffer, this.m_pos, 4);
        } else {
            DataPacker.putIntelInt(305419896, this.m_buffer, this.m_pos);
        }
        this.m_pos += 4;
    }

    public final void putUUID(UUID uuid, boolean writeVer) {
        int len = 16;
        if (writeVer) {
            len += 4;
        }
        if (this.m_buffer.length - this.m_pos < len) {
            this.extendBuffer();
        }
        this.m_pos = uuid.storeUUID(this.m_buffer, this.m_pos, writeVer);
    }

    public final void putHandle(PolicyHandle handle) {
        if (this.m_buffer.length - this.m_pos < 20) {
            this.extendBuffer(20);
        }
        this.m_pos = handle.storePolicyHandle(this.m_buffer, this.m_pos);
    }

    public final void putBuffer(DCEBuffer buf) {
        try {
            this.appendData(buf.getBuffer(), buf.getReadPosition(), buf.getLength());
        }
        catch (DCEBufferException dCEBufferException) {
            // empty catch block
        }
    }

    public final void putErrorStatus(int sts) {
        if (this.m_buffer.length - this.m_pos < 4) {
            this.extendBuffer();
        }
        DataPacker.putIntelInt(sts, this.m_buffer, this.m_pos);
        this.m_pos += 4;
        this.m_errorCode = sts;
    }

    public final void putHeader(int pdutyp, int callid) {
        this.m_buffer[this.m_pos++] = 5;
        this.m_buffer[this.m_pos++] = 0;
        this.m_buffer[this.m_pos++] = (byte)(pdutyp & 0xFF);
        this.m_buffer[this.m_pos++] = 0;
        DataPacker.putIntelInt(16, this.m_buffer, this.m_pos);
        this.m_pos += 4;
        DataPacker.putZeros(this.m_buffer, this.m_pos, 4);
        this.m_pos += 4;
        DataPacker.putIntelInt(callid, this.m_buffer, this.m_pos);
        this.m_pos += 4;
    }

    public final void putBindHeader(int callid) {
        this.putHeader(11, callid);
    }

    public final void putBindAckHeader(int callid) {
        this.putHeader(12, callid);
    }

    public final void putRequestHeader(int callid, int opcode, int allocHint) {
        this.putHeader(0, callid);
        DataPacker.putIntelInt(allocHint, this.m_buffer, this.m_pos);
        this.m_pos += 4;
        DataPacker.putZeros(this.m_buffer, this.m_pos, 2);
        this.m_pos += 2;
        DataPacker.putIntelShort(opcode, this.m_buffer, this.m_pos);
        this.m_pos += 2;
    }

    public final void putResponseHeader(int callid, int allocHint) {
        this.putHeader(2, callid);
        DataPacker.putIntelInt(allocHint, this.m_buffer, this.m_pos);
        this.m_pos += 4;
        DataPacker.putZeros(this.m_buffer, this.m_pos, 4);
        this.m_pos += 4;
    }

    public final void putZeroInts(int cnt) {
        int bytCnt = cnt * 4;
        if (this.m_buffer.length - this.m_pos < bytCnt) {
            this.extendBuffer(bytCnt * 2);
        }
        DataPacker.putZeros(this.m_buffer, this.m_pos, bytCnt);
        this.m_pos += bytCnt;
    }

    public final void resetBuffer() {
        this.m_pos = 0;
        this.m_rdpos = 0;
        if (this.m_buffer.length >= 65536) {
            this.m_buffer = new byte[8192];
        }
    }

    public final void setWritePosition(int pos) {
        this.m_pos = pos;
    }

    public final void updateWritePosition(int len) {
        this.m_pos += len;
    }

    public final boolean hasErrorStatus() {
        return this.m_errorCode != 0;
    }

    public final int getErrorStatus() {
        return this.m_errorCode;
    }

    public final void setErrorStatus(int sts) {
        this.m_errorCode = sts;
    }

    private final void extendBuffer(int ext) {
        byte[] newBuf = new byte[this.m_buffer.length + ext];
        System.arraycopy(this.m_buffer, 0, newBuf, 0, this.m_buffer.length);
        this.m_buffer = newBuf;
    }

    private final void extendBuffer() {
        this.extendBuffer(this.m_buffer.length * 2);
    }

    private final void alignPosition(int align) {
        if (align < 0 || align > 2) {
            return;
        }
        this.m_pos = this.m_pos + _alignRound[align] & _alignMask[align];
    }

    private final void alignRxPosition(int align) {
        if (align < 0 || align > 2 || this.m_rdpos >= this.m_buffer.length) {
            return;
        }
        this.m_rdpos = this.m_rdpos + _alignRound[align] & _alignMask[align];
    }

    public final void Dump() {
        int len = this.getLength();
        if (len == 0) {
            len = 24;
        }
        HexDump.Dump(this.getBuffer(), len, this.m_base);
    }
}

