/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.smb.dcerpc;

import java.util.HashMap;
import java.util.Map;
import org.filesys.smb.dcerpc.UUID;

public enum DCEPipeType {
    PIPE_SRVSVC(0),
    PIPE_SAMR(1),
    PIPE_WINREG(2),
    PIPE_WKSSVC(3),
    PIPE_NETLOGON(4),
    PIPE_LSARPC(5),
    PIPE_SPOOLSS(6),
    PIPE_NETDFS(7),
    PIPE_SVCCTL(8),
    PIPE_EVENTLOG(9),
    PIPE_NETLOGON1(10),
    PIPE_INITSHUT(11),
    PIPE_INVALID(-1);

    private final int pipeId;
    private static Map<Integer, DCEPipeType> _typeMap;
    private static final String[] _pipeNames;
    private static final String[] _srvNames;
    private static UUID _uuidNetLogon;
    private static UUID _uuidWinReg;
    private static UUID _uuidSvcCtl;
    private static UUID _uuidLsaRpc;
    private static UUID _uuidSrvSvc;
    private static UUID _uuidWksSvc;
    private static UUID _uuidSamr;
    private static UUID _uuidSpoolss;
    private static UUID _uuidSvcctl;
    private static UUID _uuidEventLog;
    private static UUID _uuidNetLogon1;
    private static UUID _uuidInitShut;

    private DCEPipeType(int typ) {
        this.pipeId = typ;
    }

    public final int intValue() {
        return this.pipeId;
    }

    public static final DCEPipeType fromInt(int typ) {
        if (_typeMap.containsKey(typ)) {
            return _typeMap.get(typ);
        }
        return PIPE_INVALID;
    }

    public static final DCEPipeType getNameAsType(String name) {
        for (int i = 0; i < _pipeNames.length; ++i) {
            if (!_pipeNames[i].equals(name)) continue;
            return DCEPipeType.fromInt(i);
        }
        return PIPE_INVALID;
    }

    public static final String getTypeAsString(DCEPipeType typ) {
        int iTyp = typ.intValue();
        if (iTyp >= 0 && iTyp < _pipeNames.length) {
            return _pipeNames[iTyp];
        }
        return null;
    }

    public static final String getTypeAsStringShort(DCEPipeType typ) {
        int iTyp = typ.intValue();
        if (iTyp >= 0 && iTyp < _pipeNames.length) {
            return _pipeNames[iTyp];
        }
        return null;
    }

    public static final UUID getUUIDForType(DCEPipeType typ) {
        UUID ret = null;
        switch (typ) {
            case PIPE_NETLOGON: {
                ret = _uuidNetLogon;
                break;
            }
            case PIPE_NETLOGON1: {
                ret = _uuidNetLogon1;
                break;
            }
            case PIPE_WINREG: {
                ret = _uuidWinReg;
                break;
            }
            case PIPE_LSARPC: {
                ret = _uuidLsaRpc;
                break;
            }
            case PIPE_WKSSVC: {
                ret = _uuidWksSvc;
                break;
            }
            case PIPE_SAMR: {
                ret = _uuidSamr;
                break;
            }
            case PIPE_SRVSVC: {
                ret = _uuidSrvSvc;
                break;
            }
            case PIPE_SPOOLSS: {
                ret = _uuidSpoolss;
                break;
            }
            case PIPE_SVCCTL: {
                ret = _uuidSvcCtl;
                break;
            }
            case PIPE_EVENTLOG: {
                ret = _uuidEventLog;
                break;
            }
            case PIPE_INITSHUT: {
                ret = _uuidInitShut;
            }
        }
        return ret;
    }

    public static final String getServerPipeName(DCEPipeType typ) {
        int iTyp = typ.intValue();
        if (iTyp >= 0 && iTyp < _srvNames.length) {
            return _srvNames[iTyp];
        }
        return null;
    }

    static {
        _typeMap = new HashMap<Integer, DCEPipeType>();
        for (DCEPipeType pipeTyp : DCEPipeType.values()) {
            _typeMap.put(pipeTyp.intValue(), pipeTyp);
        }
        _pipeNames = new String[]{"\\PIPE\\srvsvc", "\\PIPE\\samr", "\\PIPE\\winreg", "\\PIPE\\wkssvc", "\\PIPE\\NETLOGON", "\\PIPE\\lsarpc", "\\PIPE\\spoolss", "\\PIPE\\netdfs", "\\PIPE\\svcctl", "\\PIPE\\EVENTLOG", "\\PIPE\\NETLOGON", "\\PIPE\\InitShutdown"};
        _srvNames = new String[]{"\\PIPE\\srvsvc", "\\PIPE\\lsass", "\\PIPE\\winreg", "\\PIPE\\ntsvcs", "\\PIPE\\lsass", "\\PIPE\\lsass", "\\PIPE\\spoolss", "\\PIPE\\netdfs", "\\PIPE\\svcctl", "\\PIPE\\EVENTLOG", "\\PIPE\\InitShutdown"};
        _uuidNetLogon = new UUID("8a885d04-1ceb-11c9-9fe8-08002b104860", 2);
        _uuidWinReg = new UUID("338cd001-2244-31f1-aaaa-900038001003", 1);
        _uuidSvcCtl = new UUID("367abb81-9844-35f1-ad32-98f038001003", 2);
        _uuidLsaRpc = new UUID("12345678-1234-abcd-ef00-0123456789ab", 0);
        _uuidSrvSvc = new UUID("4b324fc8-1670-01d3-1278-5a47bf6ee188", 3);
        _uuidWksSvc = new UUID("6bffd098-a112-3610-9833-46c3f87e345a", 1);
        _uuidSamr = new UUID("12345778-1234-abcd-ef00-0123456789ac", 1);
        _uuidSpoolss = new UUID("12345778-1234-abcd-ef00-0123456789ab", 1);
        _uuidSvcctl = new UUID("367abb81-9844-35f1-ad32-98f038001003", 2);
        _uuidEventLog = new UUID("82273FDC-E32A-18C3-3F78-827929DC23EA", 0);
        _uuidNetLogon1 = new UUID("12345678-1234-abcd-ef00-01234567cffb", 1);
        _uuidInitShut = new UUID("894de0c0-0d55-11d3-a322-00c04fa321a1", 1);
    }
}

