/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.smb.dcerpc.client;

import org.filesys.client.SMBPacket;
import org.filesys.client.TransPacket;
import org.filesys.debug.Debug;
import org.filesys.smb.dcerpc.DCEBuffer;
import org.filesys.smb.dcerpc.DCEBufferException;
import org.filesys.smb.dcerpc.DCECommand;
import org.filesys.smb.dcerpc.DCEDataPacker;
import org.filesys.smb.dcerpc.DCEPipeType;
import org.filesys.util.DataPacker;

public class DCEPacket
extends TransPacket {
    public static final int VERSIONMAJOR = 0;
    public static final int VERSIONMINOR = 1;
    public static final int PDUTYPE = 2;
    public static final int HEADERFLAGS = 3;
    public static final int PACKEDDATAREP = 4;
    public static final int FRAGMENTLEN = 8;
    public static final int AUTHLEN = 10;
    public static final int CALLID = 12;
    public static final int DCEDATA = 16;
    public static final int ALLOCATIONHINT = 16;
    public static final int PRESENTIDENT = 20;
    public static final int OPERATIONID = 22;
    public static final int OPERATIONDATA = 24;
    public static final int FLG_FIRSTFRAG = 1;
    public static final int FLG_LASTFRAG = 2;
    public static final int FLG_CANCEL = 4;
    public static final int FLG_IDEMPOTENT = 32;
    public static final int FLG_BROADCAST = 64;
    public static final int FLG_ONLYFRAG = 3;
    private static final byte HDR_VERSIONMAJOR = 5;
    private static final byte HDR_VERSIONMINOR = 0;
    private static final int HDR_PACKEDDATAREP = 16;
    private static final int BIND_DATALEN = 56;
    private static final int BIND_LENGTH = 72;
    public static final int HDRLEN_STANDARD = 16;
    public static final int HDRLEN_REQUEST = 24;
    private static final int WriteDataOffset = 64;
    private int m_offset;

    public DCEPacket(byte[] buf) {
        super(buf);
        this.m_offset = this.getParameterOffset();
    }

    public DCEPacket(int siz) {
        super(siz);
    }

    public DCEPacket(int siz, SMBPacket pkt) {
        super(siz);
        this.setTreeId(pkt.getTreeId());
        this.setUserId(pkt.getUserId());
        this.setProcessId(pkt.getProcessId());
    }

    public final int getParameterOffset() {
        int prmIdx = this.isResponse() ? 4 : 10;
        return this.getParameter(prmIdx) + 4;
    }

    public final int getMajorVersion() {
        return this.getBuffer()[this.m_offset + 0] & 0xFF;
    }

    public final int getMinorVersion() {
        return this.getBuffer()[this.m_offset + 1] & 0xFF;
    }

    public final int getPDUType() {
        return this.getBuffer()[this.m_offset + 2] & 0xFF;
    }

    public final int getHeaderFlags() {
        return this.getBuffer()[this.m_offset + 3] & 0xFF;
    }

    public final void setHeaderFlags(int flags) {
        this.getBuffer()[this.m_offset + 3] = (byte)(flags & 0xFF);
    }

    public final int getPackedDataRepresentation() {
        return DataPacker.getIntelInt(this.getBuffer(), this.m_offset + 4);
    }

    public final int getFragmentLength() {
        return DataPacker.getIntelShort(this.getBuffer(), this.m_offset + 8);
    }

    public final void setFragmentLength(int len) {
        DataPacker.putIntelShort(len, this.getBuffer(), this.m_offset + 8);
    }

    public final int getAuthenticationLength() {
        return DataPacker.getIntelShort(this.getBuffer(), this.m_offset + 10);
    }

    public final int getCallId() {
        return DataPacker.getIntelInt(this.getBuffer(), this.m_offset + 12);
    }

    public final boolean isFirstFragment() {
        return (this.getHeaderFlags() & 1) != 0;
    }

    public final boolean isLastFragment() {
        return (this.getHeaderFlags() & 2) != 0;
    }

    public final boolean isOnlyFragment() {
        return (this.getHeaderFlags() & 3) == 3;
    }

    public final int getDCEOffset() {
        return this.getParameterOffset();
    }

    public final int getDCEBaseOffset() {
        return this.m_offset;
    }

    public final int getDCEDataOffset() {
        this.m_offset = this.getParameterOffset();
        int dataOff = -1;
        switch (this.getPDUType()) {
            case 11: 
            case 12: {
                dataOff = this.m_offset + 16;
                break;
            }
            case 0: 
            case 2: {
                dataOff = this.m_offset + 24;
            }
        }
        return dataOff;
    }

    public final void resetDCEOffset() {
        this.m_offset = this.getParameterOffset();
    }

    public final int getAllocationHint() {
        return DataPacker.getIntelInt(this.getBuffer(), this.m_offset + 16);
    }

    public final void setAllocationHint(int alloc) {
        DataPacker.putIntelInt(alloc, this.getBuffer(), this.m_offset + 16);
    }

    public final int getPresentationIdentifier() {
        return DataPacker.getIntelShort(this.getBuffer(), this.m_offset + 20);
    }

    public final void setPresentationIdentifier(int ident) {
        DataPacker.putIntelShort(ident, this.getBuffer(), this.m_offset + 20);
    }

    public final int getOperationId() {
        return DataPacker.getIntelShort(this.getBuffer(), this.m_offset + 22);
    }

    public final void setOperationId(int opCode) {
        DataPacker.putIntelShort(opCode, this.getBuffer(), this.m_offset + 22);
    }

    protected final void initializeDCETransaction(int handle, byte typ, int flags, int callId) {
        this.setCommand(37);
        this.setFlags(0);
        this.setFlags2(16384);
        this.setParameterCount(16);
        this.setParameter(0, 0);
        this.setParameter(1, 0);
        this.setParameter(2, 0);
        this.setParameter(3, 1024);
        this.setParameter(4, 0);
        this.setParameter(5, 0);
        this.setParameter(6, 0);
        this.setParameter(7, 0);
        this.setParameter(8, 0);
        this.setParameter(9, 0);
        this.setParameter(11, 0);
        this.setParameter(13, 2);
        this.setSetupParameter(0, 38);
        this.setSetupParameter(1, handle);
        int bytPos = this.getByteOffset();
        bytPos = DataPacker.putString("\\PIPE\\", this.getBuffer(), bytPos, true);
        this.m_offset = DCEDataPacker.longwordAlign(bytPos);
        this.setParameter(10, this.m_offset - 4);
        this.setParameter(12, this.m_offset - 4);
        byte[] buf = this.getBuffer();
        DataPacker.putZeros(buf, this.m_offset, 24);
        buf[this.m_offset + 0] = 5;
        buf[this.m_offset + 1] = 0;
        buf[this.m_offset + 2] = typ;
        buf[this.m_offset + 3] = (byte)(flags & 0xFF);
        DataPacker.putIntelInt(16, buf, this.m_offset + 4);
        DataPacker.putIntelInt(0, buf, this.m_offset + 10);
        DataPacker.putIntelInt(callId, buf, this.m_offset + 12);
    }

    public final void initializeDCEWrite(int handle, int flags, int callId, int fragLen) {
        this.setCommand(47);
        this.setFlags(0);
        this.setFlags2(16384);
        this.setParameterCount(14);
        this.setAndXCommand(255);
        this.setParameter(1, 0);
        this.setParameter(2, handle);
        this.setParameterLong(3, 0);
        this.setParameterLong(5, -1);
        this.setParameter(7, 8);
        this.setParameter(8, fragLen);
        this.setParameter(9, 0);
        this.setParameter(10, fragLen);
        this.setParameter(11, 64);
        this.setParameter(12, 0);
        this.setParameterLong(13, 0);
        this.m_offset = DCEDataPacker.wordAlign(this.getByteOffset());
        byte[] buf = this.getBuffer();
        DataPacker.putZeros(buf, this.m_offset, 24);
        buf[this.m_offset + 0] = 5;
        buf[this.m_offset + 1] = 0;
        buf[this.m_offset + 2] = 0;
        buf[this.m_offset + 3] = (byte)(flags & 0xFF);
        DataPacker.putIntelInt(16, buf, this.m_offset + 4);
        DataPacker.putIntelInt(0, buf, this.m_offset + 10);
        DataPacker.putIntelInt(callId, buf, this.m_offset + 12);
    }

    public final void initializeDCEReply(byte typ, int flags, int callId) {
        this.setParameterCount(10);
        this.setParameter(0, 0);
        this.setParameter(1, 0);
        int bytPos = DCEDataPacker.longwordAlign(this.getByteOffset());
        this.setParameter(3, 0);
        this.setParameter(4, bytPos - 4);
        this.setParameter(5, 0);
        this.setParameter(6, 0);
        this.setParameter(7, bytPos - 4);
        this.setParameter(8, 0);
        this.setParameter(9, 0);
        this.m_offset = bytPos;
        byte[] buf = this.getBuffer();
        DataPacker.putZeros(buf, this.m_offset, 24);
        buf[this.m_offset + 0] = 5;
        buf[this.m_offset + 1] = 0;
        buf[this.m_offset + 2] = typ;
        buf[this.m_offset + 3] = (byte)(flags & 0xFF);
        DataPacker.putIntelInt(16, buf, this.m_offset + 4);
        DataPacker.putIntelInt(0, buf, this.m_offset + 10);
        DataPacker.putIntelInt(callId, buf, this.m_offset + 12);
    }

    public final void initializeDCEBind(int pipeHandle, int maxTx, int maxRx, DCEPipeType pipeId, int callId) {
        this.initializeDCETransaction(pipeHandle, (byte)11, 3, callId);
        DCEBuffer dceBuf = new DCEBuffer(this.getBuffer(), this.getDCEDataOffset());
        dceBuf.putShort(maxTx);
        dceBuf.putShort(maxRx);
        dceBuf.putInt(0);
        dceBuf.putByte(1);
        dceBuf.putByte(0);
        dceBuf.putInt(0);
        dceBuf.putByte(1);
        dceBuf.putByte(0);
        if (pipeId == DCEPipeType.PIPE_NETLOGON) {
            dceBuf.putUUID(DCEPipeType.getUUIDForType(DCEPipeType.PIPE_NETLOGON1), true);
        } else {
            dceBuf.putUUID(DCEPipeType.getUUIDForType(pipeId), true);
        }
        dceBuf.putUUID(DCEPipeType.getUUIDForType(DCEPipeType.PIPE_NETLOGON), true);
        this.setFragmentLength(72);
        this.setParameter(1, 72);
        this.setParameter(11, 72);
        int len = this.getDCEDataOffset() + 56 - this.getByteOffset();
        this.setByteCount(len);
    }

    public final void initializeDCERequest(int pipeHandle, int opCode, DCEBuffer buf, int maxTx, int callId) throws DCEBufferException {
        int flags = 0;
        if (buf.getReadPosition() == 0) {
            flags = 1;
        }
        this.initializeDCETransaction(pipeHandle, (byte)0, flags, callId);
        this.setOperationId(opCode);
        int len = buf.copyData(this.getBuffer(), this.getDCEDataOffset(), maxTx - 24);
        int fragLen = len + 24;
        this.setFragmentLength(fragLen);
        this.setAllocationHint(buf.getLength());
        if (buf.getAvailableLength() == 0) {
            this.setHeaderFlags(flags += 2);
        }
        this.setParameter(1, fragLen);
        this.setParameter(11, fragLen);
        int bytLen = this.getDCEDataOffset() + len - this.getByteOffset();
        this.setByteCount(bytLen);
    }

    public final void DumpHeader() {
        Debug.println("** DCE/RPC Header - PDU Type = " + DCECommand.getCommandString(this.getPDUType()));
        Debug.println("  Version         : " + this.getMajorVersion() + "." + this.getMinorVersion());
        Debug.println("  Flags           : 0x" + this.getHeaderFlags());
        Debug.println("  Packed Data Rep : 0x" + this.getPackedDataRepresentation());
        Debug.println("  Fragment Length : " + this.getFragmentLength());
        Debug.println("  Auth Length     : " + this.getAuthenticationLength());
        Debug.println("  Call ID         : " + this.getCallId());
    }
}

