/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.smb.dcerpc.info;

import java.io.UnsupportedEncodingException;
import java.util.StringTokenizer;
import org.filesys.smb.dcerpc.DCEBuffer;
import org.filesys.smb.dcerpc.DCEBufferException;
import org.filesys.smb.dcerpc.DCEReadable;
import org.filesys.smb.dcerpc.DCEWriteable;
import org.filesys.util.StringList;

public class ServiceConfigInfo
implements DCEReadable,
DCEWriteable {
    private int m_serviceType = -1;
    private int m_startType = -1;
    private int m_errorControl = -1;
    private String m_binaryPathName;
    private String m_loadOrderGroup;
    private int m_tagId;
    private StringList m_depends;
    private String m_startName;
    private String m_displayName;

    public final int getServiceType() {
        return this.m_serviceType;
    }

    public final int getStartType() {
        return this.m_startType;
    }

    public final int getErrorControl() {
        return this.m_errorControl;
    }

    public final String getBinaryPath() {
        return this.m_binaryPathName;
    }

    public final String getLoadOrderGroup() {
        return this.m_loadOrderGroup;
    }

    public final int getLoadOrderTag() {
        return this.m_tagId;
    }

    public final boolean hasDependencies() {
        return this.m_depends != null;
    }

    public final StringList getDependencies() {
        return this.m_depends;
    }

    public final String getStartName() {
        return this.m_startName;
    }

    public final String getDisplayName() {
        return this.m_displayName;
    }

    public final void setServiceType(int typ) {
        this.m_serviceType = typ;
    }

    public final void setStartType(int typ) {
        this.m_startType = typ;
    }

    public final void setErrorControl(int errCtrl) {
        this.m_errorControl = errCtrl;
    }

    public final void setBinaryPath(String path) {
        this.m_binaryPathName = path;
    }

    public final void setLoadOrderGroup(String group) {
        this.m_loadOrderGroup = group;
    }

    public final void setDependencies(StringList depList) {
        this.m_depends = depList;
    }

    public final void setStartName(String name) {
        this.m_startName = name;
    }

    public final void setDisplayName(String dispName) {
        this.m_displayName = dispName;
    }

    @Override
    public void readObject(DCEBuffer buf) throws DCEBufferException {
        this.m_serviceType = buf.getInt();
        this.m_startType = buf.getInt();
        this.m_errorControl = buf.getInt();
        int pBinPath = buf.getPointer();
        int pLoadGroup = buf.getPointer();
        this.m_tagId = buf.getInt();
        int pDeps = buf.getPointer();
        int pStartName = buf.getPointer();
        int pDispName = buf.getPointer();
        if (pBinPath != 0) {
            this.m_binaryPathName = buf.getString(1);
        }
        if (pLoadGroup != 0) {
            this.m_loadOrderGroup = buf.getString(1);
        }
        if (pDeps != 0) {
            String deps = buf.getString(1);
            this.m_depends = new StringList();
            StringTokenizer token = new StringTokenizer(deps, "/");
            while (token.hasMoreTokens()) {
                this.m_depends.addString(token.nextToken());
            }
        }
        if (pStartName != 0) {
            this.m_startName = buf.getString(1);
        }
        if (pDispName != 0) {
            this.m_displayName = buf.getString(1);
        }
    }

    @Override
    public void readStrings(DCEBuffer buf) throws DCEBufferException {
    }

    @Override
    public void writeObject(DCEBuffer buf, DCEBuffer strBuf) throws DCEBufferException {
        buf.putInt(this.getServiceType());
        buf.putInt(this.getStartType());
        buf.putInt(this.getErrorControl());
        if (this.m_binaryPathName != null) {
            buf.putPointer(true);
            buf.putString(this.m_binaryPathName, 1, true);
        } else {
            buf.putPointer(false);
        }
        if (this.m_loadOrderGroup != null) {
            buf.putPointer(true);
            buf.putString(this.m_loadOrderGroup, 1, true);
            buf.putPointer(true);
        } else {
            buf.putPointer(false);
            buf.putPointer(false);
        }
        if (this.m_depends != null && this.m_depends.numberOfStrings() > 0) {
            StringBuffer depStr = new StringBuffer();
            for (int i = 0; i < this.m_depends.numberOfStrings(); ++i) {
                depStr.append(this.m_depends.getStringAt(i));
                depStr.append("\u0000");
            }
            depStr.append("\u0000");
            byte[] depByts = null;
            try {
                depByts = depStr.toString().getBytes("UnicodeLittleUnmarked");
            }
            catch (UnsupportedEncodingException ex) {
                throw new DCEBufferException("Failed to convert string, " + ex.getMessage());
            }
            buf.putPointer(true);
            buf.putInt(depByts.length);
            buf.putBytes(depByts, depByts.length, 1);
            buf.putInt(depByts.length);
        } else {
            buf.putZeroInts(2);
        }
        if (this.m_startName != null) {
            buf.putPointer(true);
            buf.putString(this.m_startName, 1, true);
        } else {
            buf.putPointer(false);
        }
        buf.putPointer(false);
        buf.putInt(0);
        if (this.m_displayName != null) {
            buf.putPointer(true);
            buf.putString(this.m_displayName, 1, true);
        } else {
            buf.putPointer(false);
        }
        buf.putInt(0);
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("[");
        str.append(this.getDisplayName());
        str.append(":");
        str.append(this.getBinaryPath());
        str.append(",0x");
        str.append(Integer.toHexString(this.getServiceType()));
        str.append(",0x");
        str.append(Integer.toHexString(this.getStartType()));
        str.append(",0x");
        str.append(Integer.toHexString(this.getErrorControl()));
        str.append(",");
        str.append(this.getLoadOrderGroup());
        str.append(",");
        str.append(this.getLoadOrderTag());
        str.append("]");
        return str.toString();
    }
}

