/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.smb.dcerpc.info;

import org.filesys.smb.dcerpc.DCEBuffer;
import org.filesys.smb.dcerpc.DCEBufferException;
import org.filesys.smb.dcerpc.DCEReadable;
import org.filesys.smb.dcerpc.info.NTService;

public class ServiceStatusInfo
implements DCEReadable {
    private String m_srvName;
    private String m_dispName;
    private int m_srvType;
    private int m_currentState;
    private int m_ctrlAccepted;
    private int m_win32ExitCode;
    private int m_srvExitCode;
    private int m_checkPoint;
    private int m_waitHint;

    public ServiceStatusInfo() {
    }

    public ServiceStatusInfo(String name, String dispname) {
        this.m_srvName = name;
        this.m_dispName = dispname;
    }

    public ServiceStatusInfo(String name, String dispname, int typ, int state, int ctrl, int win32code, int srvexit, int chkpoint, int waithint) {
        this.m_srvName = name;
        this.m_dispName = dispname;
        this.m_srvType = typ;
        this.m_currentState = state;
        this.m_ctrlAccepted = ctrl;
        this.m_win32ExitCode = win32code;
        this.m_srvExitCode = srvexit;
        this.m_checkPoint = chkpoint;
        this.m_waitHint = waithint;
    }

    public final String getName() {
        return this.m_srvName;
    }

    public final String getDisplayName() {
        return this.m_dispName;
    }

    public final int getType() {
        return this.m_srvType;
    }

    public final int getCurrentState() {
        return this.m_currentState;
    }

    public final int getControlsAccepted() {
        return this.m_ctrlAccepted;
    }

    public final int getWin32ErrorCode() {
        return this.m_win32ExitCode;
    }

    public final int getServiceErrorCode() {
        return this.m_srvExitCode;
    }

    public final int getCheckpoint() {
        return this.m_checkPoint;
    }

    public final int getWaitHint() {
        return this.m_waitHint;
    }

    public final void setName(String name) {
        this.m_srvName = name;
    }

    public final void setDisplayName(String dispname) {
        this.m_dispName = dispname;
    }

    protected final void clearStrings() {
        this.m_srvName = null;
        this.m_dispName = null;
    }

    @Override
    public void readObject(DCEBuffer buf) throws DCEBufferException {
        this.m_srvType = buf.getInt();
        this.m_currentState = buf.getInt();
        this.m_ctrlAccepted = buf.getInt();
        this.m_win32ExitCode = buf.getInt();
        this.m_srvExitCode = buf.getInt();
        this.m_checkPoint = buf.getInt();
        this.m_waitHint = buf.getInt();
    }

    @Override
    public void readStrings(DCEBuffer buf) throws DCEBufferException {
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("[");
        str.append(this.getDisplayName());
        str.append(",");
        str.append(this.getName());
        str.append(",");
        str.append(NTService.getTypeAsString(this.getType()));
        str.append(":");
        str.append(NTService.getStateAsString(this.getCurrentState()));
        str.append(":");
        str.append(NTService.getControlsAcceptedAsString(this.getControlsAccepted()));
        str.append("]");
        return str.toString();
    }
}

