/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.smb.nt;

import java.util.ArrayList;
import java.util.List;
import org.filesys.smb.nt.SID;

public class SIDList {
    private List<SID> m_list = new ArrayList<SID>();

    public final void addSID(SID sid) {
        this.m_list.add(sid);
    }

    public final SID getSIDAt(int idx) {
        if (idx < 0 || idx >= this.m_list.size()) {
            return null;
        }
        return this.m_list.get(idx);
    }

    public final int numberOfSIDs() {
        return this.m_list.size();
    }

    public final SID findSID(String name) {
        for (int i = 0; i < this.m_list.size(); ++i) {
            SID curSID = this.m_list.get(i);
            if (!curSID.hasName() || !curSID.getName().equals(name)) continue;
            return curSID;
        }
        return null;
    }

    public final SID findSID(SID sid) {
        for (int i = 0; i < this.m_list.size(); ++i) {
            SID curSID = this.m_list.get(i);
            if (!curSID.equalsSID(sid)) continue;
            return curSID;
        }
        return null;
    }

    public final SID removeSID(SID sid) {
        for (int i = 0; i < this.m_list.size(); ++i) {
            SID curSID = this.m_list.get(i);
            if (!curSID.equalsSID(sid)) continue;
            this.m_list.remove(i);
            return curSID;
        }
        return null;
    }

    public final void removeAllSIDs() {
        this.m_list.clear();
    }
}

