/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.smb.nt;

import org.filesys.smb.nt.ACL;
import org.filesys.smb.nt.LoadException;
import org.filesys.smb.nt.SID;
import org.filesys.smb.nt.SaveException;
import org.filesys.util.DataBuffer;
import org.filesys.util.DataPacker;

public class SecurityDescriptor {
    public static final int Owner = 1;
    public static final int Group = 2;
    public static final int DACL = 4;
    public static final int SACL = 8;
    public static final int OwnerDefaulted = 1;
    public static final int GroupDefaulted = 2;
    public static final int DACLPresent = 4;
    public static final int DACLDefaulted = 8;
    public static final int SACLPresent = 16;
    public static final int SACLDefaulted = 32;
    public static final int DACLAutoInheritReq = 256;
    public static final int SACLAutoInheritReq = 512;
    public static final int DACLAutoInherited = 1024;
    public static final int SACLAutoInherited = 2048;
    public static final int DACLProtected = 4096;
    public static final int SACLProtected = 8192;
    public static final int SelfRelative = 32768;
    public static final int File = 0;
    public static final int Directory = 1;
    public static final int NamedPipe = 2;
    public static final int RegistryKey = 3;
    public static final int User = 4;
    public static final int Kernel = 5;
    private String m_name;
    private int m_type;
    private int m_revision = 1;
    private int m_control;
    private SID m_owner;
    private SID m_group;
    private ACL m_dacl;
    private ACL m_sacl;

    public SecurityDescriptor() {
    }

    public SecurityDescriptor(String name, int type) {
        this.m_name = name;
        this.m_type = type;
    }

    public SecurityDescriptor(String name, int type, SID owner, SID group, ACL dacl, ACL sacl) {
        this.m_name = name;
        this.m_type = type;
        this.m_owner = owner;
        this.m_group = group;
        this.m_dacl = dacl;
        this.m_sacl = sacl;
    }

    public final boolean isSelfRelative() {
        return this.hasControlFlag(32768);
    }

    public final int getRevision() {
        return this.m_revision;
    }

    public final boolean hasOwner() {
        return this.m_owner != null;
    }

    public final SID getOwner() {
        return this.m_owner;
    }

    public final boolean hasGroup() {
        return this.m_group != null;
    }

    public final SID getGroup() {
        return this.m_group;
    }

    public final boolean hasDACL() {
        return this.m_dacl != null;
    }

    public final ACL getDACL() {
        return this.m_dacl;
    }

    public final boolean hasSACL() {
        return this.m_sacl != null;
    }

    public final ACL getSACL() {
        return this.m_sacl;
    }

    public final void setOwner(SID sid) {
        this.m_owner = sid;
    }

    public final void setGroup(SID sid) {
        this.m_group = sid;
    }

    public final void setDACL(ACL acl) {
        this.m_dacl = acl;
    }

    public final void setSACL(ACL acl) {
        this.m_sacl = acl;
    }

    public final void setControlFlags(int flg) {
        this.m_control = flg;
    }

    public final int loadDescriptor(byte[] buf, int off) throws LoadException {
        this.m_revision = DataPacker.getIntelShort(buf, off);
        this.m_control = DataPacker.getIntelShort(buf, off + 2);
        if (!this.isSelfRelative()) {
            throw new LoadException("Security descriptor not self-relative, cannot load");
        }
        this.m_owner = null;
        this.m_group = null;
        this.m_dacl = null;
        this.m_sacl = null;
        int pos = DataPacker.getIntelInt(buf, off + 4);
        int endPos = off + 20;
        if (pos != 0) {
            this.m_owner = new SID();
            endPos = this.m_owner.loadSID(buf, off + pos, false);
        }
        if ((pos = DataPacker.getIntelInt(buf, off + 8)) != 0) {
            this.m_group = new SID();
            endPos = this.m_group.loadSID(buf, off + pos, false);
        }
        if ((pos = DataPacker.getIntelInt(buf, off + 12)) != 0) {
            this.m_sacl = new ACL();
            endPos = this.m_sacl.loadACL(buf, off + pos);
        }
        if ((pos = DataPacker.getIntelInt(buf, off + 16)) != 0) {
            this.m_dacl = new ACL();
            endPos = this.m_dacl.loadACL(buf, off + pos);
        }
        return endPos;
    }

    public final int loadDescriptor(DataBuffer buf) throws LoadException {
        int startPos = buf.getPosition();
        this.m_revision = buf.getByte();
        buf.skipBytes(1);
        this.m_control = buf.getShort();
        if (!this.isSelfRelative()) {
            throw new LoadException("Security descriptor not self-relative, cannot load");
        }
        this.m_owner = null;
        this.m_group = null;
        this.m_dacl = null;
        this.m_sacl = null;
        int pos = buf.getInt();
        if (pos != 0) {
            this.m_owner = new SID();
            buf.setPosition(startPos + pos);
            this.m_owner.loadSID(buf, false);
        }
        buf.setPosition(startPos + 8);
        pos = buf.getInt();
        if (pos != 0) {
            this.m_group = new SID();
            buf.setPosition(startPos + pos);
            this.m_group.loadSID(buf, false);
        }
        buf.setPosition(startPos + 12);
        pos = buf.getInt();
        if (pos != 0) {
            this.m_sacl = new ACL();
            buf.setPosition(startPos + pos);
            this.m_sacl.loadACL(buf);
        }
        buf.setPosition(startPos + 16);
        pos = buf.getInt();
        if (pos != 0) {
            this.m_dacl = new ACL();
            buf.setPosition(startPos + pos);
            this.m_dacl.loadACL(buf);
        }
        return buf.getPosition();
    }

    public final int saveDescriptor(byte[] buf, int off) throws SaveException {
        DataPacker.putIntelShort(this.m_revision, buf, off);
        if (!this.isSelfRelative()) {
            this.m_control += 32768;
        }
        if (this.hasSACL() && !this.hasControlFlag(16)) {
            this.m_control += 16;
        }
        if (this.hasDACL() && !this.hasControlFlag(4)) {
            this.m_control += 4;
        }
        DataPacker.putIntelShort(this.m_control, buf, off + 2);
        DataPacker.putZeros(buf, off + 4, 16);
        int pos = off + 20;
        if (this.hasOwner()) {
            DataPacker.putIntelInt(pos - off, buf, off + 4);
            pos = this.getOwner().saveSID(buf, pos);
        }
        if (this.hasGroup()) {
            DataPacker.putIntelInt(pos - off, buf, off + 8);
            pos = this.getGroup().saveSID(buf, pos);
        }
        if (this.hasSACL()) {
            DataPacker.putIntelInt(pos - off, buf, off + 12);
            pos = this.getSACL().saveACL(buf, pos);
        }
        if (this.hasDACL()) {
            DataPacker.putIntelInt(pos - off, buf, off + 16);
            pos = this.getDACL().saveACL(buf, pos);
        }
        return pos;
    }

    public final int saveDescriptor(DataBuffer buf) throws SaveException {
        int startPos = buf.getPosition();
        buf.putShort(this.m_revision);
        if (!this.isSelfRelative()) {
            this.m_control += 32768;
        }
        if (this.hasSACL() && !this.hasControlFlag(16)) {
            this.m_control += 16;
        }
        if (this.hasDACL() && !this.hasControlFlag(4)) {
            this.m_control += 4;
        }
        buf.putShort(this.m_control);
        buf.putZeros(16);
        int pos = startPos + 20;
        if (this.hasOwner()) {
            buf.setPosition(startPos + 4);
            buf.putInt(pos - startPos);
            buf.setPosition(pos);
            pos = this.getOwner().saveSID(buf);
        }
        if (this.hasGroup()) {
            buf.setPosition(startPos + 8);
            buf.putInt(pos - startPos);
            buf.setPosition(pos);
            pos = this.getGroup().saveSID(buf);
        }
        if (this.hasSACL()) {
            buf.setPosition(startPos + 12);
            buf.putInt(pos - startPos);
            buf.setPosition(pos);
            pos = this.getSACL().saveACL(buf);
        }
        if (this.hasDACL()) {
            buf.setPosition(startPos + 16);
            buf.putInt(pos - startPos);
            buf.setPosition(pos);
            pos = this.getDACL().saveACL(buf);
        }
        return pos;
    }

    protected final boolean hasControlFlag(int flg) {
        return (this.m_control & flg) != 0;
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("[");
        if (this.hasOwner()) {
            str.append("Owner:");
            str.append(this.getOwner().toString());
            str.append(",");
        }
        if (this.hasGroup()) {
            str.append("Group:");
            str.append(this.getGroup().toString());
            str.append(",");
        }
        if (this.hasDACL()) {
            str.append("DACL:");
            str.append(this.getDACL().toString());
            str.append(",");
        }
        if (this.hasSACL()) {
            str.append("SACL:");
            str.append(this.getSACL().toString());
        }
        str.append("]");
        return str.toString();
    }
}

