/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.smb.server;

import java.io.IOException;
import org.filesys.debug.Debug;
import org.filesys.server.auth.ISMBAuthenticator;
import org.filesys.server.auth.InvalidUserException;
import org.filesys.server.core.InvalidDeviceInterfaceException;
import org.filesys.server.core.ShareType;
import org.filesys.server.core.SharedDevice;
import org.filesys.server.filesys.AccessDeniedException;
import org.filesys.server.filesys.DirectoryNotEmptyException;
import org.filesys.server.filesys.DiskDeviceContext;
import org.filesys.server.filesys.DiskInterface;
import org.filesys.server.filesys.FileExistsException;
import org.filesys.server.filesys.FileInfo;
import org.filesys.server.filesys.FileName;
import org.filesys.server.filesys.FileOpenParams;
import org.filesys.server.filesys.FileSharingException;
import org.filesys.server.filesys.FileStatus;
import org.filesys.server.filesys.NetworkFile;
import org.filesys.server.filesys.SearchContext;
import org.filesys.server.filesys.SrvDiskInfo;
import org.filesys.server.filesys.TooManyConnectionsException;
import org.filesys.server.filesys.TooManyFilesException;
import org.filesys.server.filesys.TooManySearchesException;
import org.filesys.server.filesys.TreeConnection;
import org.filesys.server.filesys.VolumeInfo;
import org.filesys.smb.InvalidUNCPathException;
import org.filesys.smb.PCShare;
import org.filesys.smb.SMBDate;
import org.filesys.smb.server.CoreResumeKey;
import org.filesys.smb.server.ProtocolHandler;
import org.filesys.smb.server.SMBSrvException;
import org.filesys.smb.server.SMBSrvPacket;
import org.filesys.smb.server.SMBSrvSession;
import org.filesys.smb.server.SMBV1Parser;
import org.filesys.smb.server.VirtualCircuit;
import org.filesys.util.DataPacker;
import org.filesys.util.WildCard;

class CoreProtocolHandler
extends ProtocolHandler {
    private static final int RESUME_START = 32771;
    private static final int RESUME_DOT = 32770;
    private static final int RESUME_DOTDOT = 32769;
    private static final int MaxWordValue = 65535;
    protected static final int StandardAttributes = 63;
    protected static final int SearchInfoLen = 43;
    private int m_defFlags;
    private int m_defFlags2;

    protected CoreProtocolHandler() {
    }

    protected CoreProtocolHandler(SMBSrvSession sess) {
        super(sess);
    }

    @Override
    public String getName() {
        return "Core Protocol";
    }

    protected final void MapExceptionToSMBError(Exception ex) {
    }

    public final int getDefaultFlags() {
        return this.m_defFlags;
    }

    public final int getDefaultFlags2() {
        return this.m_defFlags2;
    }

    public final void setDefaultFlags(int flags) {
        this.m_defFlags = flags;
    }

    public final void setDefaultFlags2(int flags) {
        this.m_defFlags2 = flags;
    }

    protected final int packSearchInfo(byte[] buf, int bufPos, String searchStr, int resumeId, int searchId, FileInfo info) {
        CoreResumeKey.putResumeKey(buf, bufPos, searchStr, resumeId + (searchId << 16));
        bufPos += 21;
        buf[bufPos++] = (byte)(info.getFileAttributes() & 0x3F);
        SMBDate dateTime = new SMBDate(info.getModifyDateTime());
        if (dateTime != null) {
            DataPacker.putIntelShort(dateTime.asSMBTime(), buf, bufPos);
            DataPacker.putIntelShort(dateTime.asSMBDate(), buf, bufPos + 2);
        } else {
            DataPacker.putIntelShort(0, buf, bufPos);
            DataPacker.putIntelShort(0, buf, bufPos + 2);
        }
        DataPacker.putIntelInt((int)info.getSize(), buf, bufPos += 4);
        bufPos += 4;
        StringBuilder str = new StringBuilder();
        str.append(info.getFileName());
        while (str.length() < 13) {
            str.append('\u0000');
        }
        if (str.length() > 12) {
            str.setLength(12);
        }
        DataPacker.putString(str.toString().toUpperCase(), buf, bufPos, true);
        return bufPos += 13;
    }

    protected void procCheckDirectory(SMBSrvPacket smbPkt, SMBV1Parser parser) throws IOException, SMBSrvException {
        if (!parser.checkPacketIsValid(0, 2)) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 64, 2);
            return;
        }
        VirtualCircuit vc = this.m_sess.findVirtualCircuit(parser.getUserId());
        if (vc == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
            return;
        }
        int treeId = parser.getTreeId();
        TreeConnection conn = vc.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 15, 1);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 5, 1);
            return;
        }
        int dataPos = parser.getByteOffset();
        int dataLen = parser.getByteCount();
        byte[] buf = parser.getBuffer();
        String dirName = DataPacker.getDataString('\u0004', buf, dataPos, dataLen, parser.isUnicode());
        if (dirName == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 13, 1);
            return;
        }
        if (this.m_sess.hasDebug(512)) {
            this.m_sess.debugPrintln("Directory Check [" + treeId + "] name=" + dirName);
        }
        try {
            DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
            if (disk.fileExists(this.m_sess, conn, dirName) == FileStatus.DirectoryExists) {
                parser.setParameterCount(0);
                parser.setByteCount(0);
                this.m_sess.sendResponseSMB(smbPkt);
            } else {
                this.m_sess.sendErrorResponseSMB(smbPkt, 3, 1);
            }
        }
        catch (InvalidDeviceInterfaceException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 13, 1);
            return;
        }
        catch (IOException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 3, 1);
            return;
        }
    }

    protected void procCloseFile(SMBSrvPacket smbPkt, SMBV1Parser parser) throws IOException, SMBSrvException {
        if (!parser.checkPacketIsValid(3, 0)) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 64, 2);
            return;
        }
        VirtualCircuit vc = this.m_sess.findVirtualCircuit(parser.getUserId());
        if (vc == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
            return;
        }
        int treeId = parser.getTreeId();
        TreeConnection conn = vc.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 15, 1);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 5, 1);
            return;
        }
        int fid = parser.getParameter(0);
        int ftime = parser.getParameter(1);
        int fdate = parser.getParameter(2);
        NetworkFile netFile = conn.findFile(fid);
        if (netFile == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 6, 1);
            return;
        }
        if (this.m_sess.hasDebug(512)) {
            this.m_sess.debugPrintln("File close [" + treeId + "] fid=" + fid);
        }
        try {
            DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
            if (disk != null) {
                disk.closeFile(this.m_sess, conn, netFile);
            }
            netFile.setClosed(true);
        }
        catch (InvalidDeviceInterfaceException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 13, 1);
            return;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        conn.removeFile(fid, this.getSession());
        parser.setParameterCount(0);
        parser.setByteCount(0);
        this.m_sess.sendResponseSMB(smbPkt);
    }

    protected void procCreateDirectory(SMBSrvPacket smbPkt, SMBV1Parser parser) throws IOException, SMBSrvException {
        if (!parser.checkPacketIsValid(0, 2)) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 64, 2);
            return;
        }
        VirtualCircuit vc = this.m_sess.findVirtualCircuit(parser.getUserId());
        if (vc == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
            return;
        }
        int treeId = parser.getTreeId();
        TreeConnection conn = vc.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 15, 1);
            return;
        }
        if (!conn.hasWriteAccess()) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 5, 1);
            return;
        }
        int dataPos = parser.getByteOffset();
        int dataLen = parser.getByteCount();
        byte[] buf = parser.getBuffer();
        String dirName = DataPacker.getDataString('\u0004', buf, dataPos, dataLen, parser.isUnicode());
        if (dirName == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 13, 1);
            return;
        }
        if (!FileName.isValidPath(dirName)) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741773, 13, 1);
            return;
        }
        if (this.m_sess.hasDebug(512)) {
            this.m_sess.debugPrintln("Directory Create [" + treeId + "] name=" + dirName);
        }
        try {
            DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
            FileOpenParams params = new FileOpenParams(dirName, 16, 2, 16, parser.getProcessIdFull());
            disk.createDirectory(this.m_sess, conn, params);
        }
        catch (InvalidDeviceInterfaceException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 13, 1);
            return;
        }
        catch (FileExistsException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741771, 80, 1);
            return;
        }
        catch (AccessDeniedException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741790, 15, 1);
            return;
        }
        catch (IOException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 3, 1);
            return;
        }
        parser.setParameterCount(0);
        parser.setByteCount(0);
        this.m_sess.sendResponseSMB(smbPkt);
    }

    protected void procCreateFile(SMBSrvPacket smbPkt, SMBV1Parser parser) throws IOException, SMBSrvException {
        int fid;
        if (!parser.checkPacketIsValid(3, 2)) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 64, 2);
            return;
        }
        VirtualCircuit vc = this.m_sess.findVirtualCircuit(parser.getUserId());
        if (vc == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
            return;
        }
        int treeId = parser.getTreeId();
        TreeConnection conn = vc.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 15, 1);
            return;
        }
        if (!conn.hasWriteAccess()) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 5, 1);
            return;
        }
        int dataPos = parser.getByteOffset();
        int dataLen = parser.getByteCount();
        byte[] buf = parser.getBuffer();
        String fileName = DataPacker.getDataString('\u0004', buf, dataPos, dataLen, parser.isUnicode());
        if (fileName == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 13, 1);
            return;
        }
        if (!FileName.isValidPath(fileName)) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741773, 13, 1);
            return;
        }
        int attr = parser.getParameter(0);
        FileOpenParams params = new FileOpenParams(fileName, 16, 2, attr, parser.getProcessIdFull());
        if (this.m_sess.hasDebug(512)) {
            this.m_sess.debugPrintln("File Create [" + treeId + "] params=" + params);
        }
        NetworkFile netFile = null;
        try {
            DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
            netFile = disk.createFile(this.m_sess, conn, params);
            fid = conn.addFile(netFile, this.getSession());
        }
        catch (InvalidDeviceInterfaceException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 13, 1);
            return;
        }
        catch (TooManyFilesException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 4, 1);
            return;
        }
        catch (FileExistsException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 80, 1);
            return;
        }
        catch (IOException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 2, 1);
            return;
        }
        parser.setParameterCount(1);
        parser.setParameter(0, fid);
        parser.setByteCount(0);
        this.m_sess.sendResponseSMB(smbPkt);
    }

    protected void procCreateTemporaryFile(SMBSrvPacket smbPkt, SMBV1Parser parser) throws IOException, SMBSrvException {
    }

    protected void procDeleteDirectory(SMBSrvPacket smbPkt, SMBV1Parser parser) throws IOException, SMBSrvException {
        if (!parser.checkPacketIsValid(0, 2)) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 64, 2);
            return;
        }
        VirtualCircuit vc = this.m_sess.findVirtualCircuit(parser.getUserId());
        if (vc == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
            return;
        }
        int treeId = parser.getTreeId();
        TreeConnection conn = vc.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 15, 1);
            return;
        }
        if (!conn.hasWriteAccess()) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 5, 1);
            return;
        }
        int dataPos = parser.getByteOffset();
        int dataLen = parser.getByteCount();
        byte[] buf = parser.getBuffer();
        String dirName = DataPacker.getDataString('\u0004', buf, dataPos, dataLen, parser.isUnicode());
        if (dirName == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 13, 1);
            return;
        }
        if (!FileName.isValidPath(dirName)) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741773, 13, 1);
            return;
        }
        if (this.m_sess.hasDebug(512)) {
            this.m_sess.debugPrintln("Directory Delete [" + treeId + "] name=" + dirName);
        }
        try {
            DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
            disk.deleteDirectory(this.m_sess, conn, dirName);
        }
        catch (InvalidDeviceInterfaceException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 13, 1);
            return;
        }
        catch (AccessDeniedException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741790, 5, 1);
            return;
        }
        catch (DirectoryNotEmptyException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 145, 1);
            return;
        }
        catch (IOException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 3, 1);
            return;
        }
        parser.setParameterCount(0);
        parser.setByteCount(0);
        this.m_sess.sendResponseSMB(smbPkt);
    }

    protected void procDeleteFile(SMBSrvPacket smbPkt, SMBV1Parser parser) throws IOException, SMBSrvException {
        if (!parser.checkPacketIsValid(1, 2)) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 64, 2);
            return;
        }
        VirtualCircuit vc = this.m_sess.findVirtualCircuit(parser.getUserId());
        if (vc == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
            return;
        }
        int treeId = parser.getTreeId();
        TreeConnection conn = vc.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 15, 1);
            return;
        }
        if (!conn.hasWriteAccess()) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 5, 1);
            return;
        }
        int dataPos = parser.getByteOffset();
        int dataLen = parser.getByteCount();
        byte[] buf = parser.getBuffer();
        String fileName = DataPacker.getDataString('\u0004', buf, dataPos, dataLen, parser.isUnicode());
        if (fileName == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 13, 1);
            return;
        }
        if (!FileName.isValidPath(fileName)) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741773, 13, 1);
            return;
        }
        if (this.m_sess.hasDebug(512)) {
            this.m_sess.debugPrintln("File Delete [" + treeId + "] name=" + fileName);
        }
        Object netFile = null;
        try {
            DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
            disk.deleteFile(this.m_sess, conn, fileName);
        }
        catch (InvalidDeviceInterfaceException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 13, 1);
            return;
        }
        catch (IOException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 2, 1);
            return;
        }
        parser.setParameterCount(0);
        parser.setByteCount(0);
        this.m_sess.sendResponseSMB(smbPkt);
    }

    protected void procDiskAttributes(SMBSrvPacket smbPkt, SMBV1Parser parser) throws IOException, SMBSrvException {
        if (this.m_sess.hasDebug(256)) {
            this.m_sess.debugPrintln("Get disk attributes");
        }
        if (parser.getParameterCount() != 0 && parser.getByteCount() != 0) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 13, 1);
            return;
        }
        VirtualCircuit vc = this.m_sess.findVirtualCircuit(parser.getUserId());
        if (vc == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
            return;
        }
        int treeId = parser.getTreeId();
        TreeConnection conn = vc.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 5, 2);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 5, 1);
            return;
        }
        DiskInterface disk = null;
        DiskDeviceContext diskCtx = null;
        try {
            disk = (DiskInterface)conn.getSharedDevice().getInterface();
            diskCtx = (DiskDeviceContext)conn.getContext();
        }
        catch (InvalidDeviceInterfaceException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 13, 1);
            return;
        }
        SrvDiskInfo diskInfo = this.getDiskInformation(disk, diskCtx);
        if (this.m_sess.hasDebug(256)) {
            this.m_sess.debugPrintln("  Disk info - total=" + diskInfo.getTotalUnits() + ", free=" + diskInfo.getFreeUnits() + ", blocksPerUnit=" + diskInfo.getBlocksPerAllocationUnit() + ", blockSize=" + diskInfo.getBlockSize());
        }
        long totUnits = diskInfo.getTotalUnits();
        long freeUnits = diskInfo.getFreeUnits();
        int blocksUnit = diskInfo.getBlocksPerAllocationUnit();
        while (totUnits > 65535L && blocksUnit <= 65535) {
            blocksUnit *= 2;
            totUnits /= 2L;
            freeUnits /= 2L;
        }
        if (totUnits > 65535L || blocksUnit > 65535) {
            totUnits = 65535L;
            if (freeUnits > 65535L) {
                freeUnits = 32767L;
            }
            if (blocksUnit > 65535) {
                blocksUnit = 65535;
            }
        }
        parser.setParameterCount(5);
        parser.setParameter(0, (int)totUnits);
        parser.setParameter(1, blocksUnit);
        parser.setParameter(2, diskInfo.getBlockSize());
        parser.setParameter(3, (int)freeUnits);
        parser.setParameter(4, 0);
        parser.setByteCount(0);
        this.m_sess.sendResponseSMB(smbPkt);
    }

    protected void procEcho(SMBSrvPacket smbPkt, SMBV1Parser parser) throws IOException, SMBSrvException {
        if (!parser.checkPacketIsValid(1, 0)) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 64, 2);
            return;
        }
        int echoCnt = parser.getParameter(0);
        if (this.m_sess.hasDebug(4096)) {
            this.m_sess.debugPrintln("Echo - Count = " + echoCnt);
        }
        int echoSeq = 1;
        while (echoCnt > 0) {
            parser.setParameter(0, echoSeq++);
            this.m_sess.sendResponseSMB(smbPkt);
            --echoCnt;
            if (!this.m_sess.hasDebug(4096)) continue;
            this.m_sess.debugPrintln("Echo Packet, Seq = " + echoSeq);
        }
    }

    protected void procFlushFile(SMBSrvPacket smbPkt, SMBV1Parser parser) throws IOException, SMBSrvException {
        if (!parser.checkPacketIsValid(1, 0)) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 64, 2);
            return;
        }
        VirtualCircuit vc = this.m_sess.findVirtualCircuit(parser.getUserId());
        if (vc == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
            return;
        }
        int treeId = parser.getTreeId();
        TreeConnection conn = vc.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 15, 1);
            return;
        }
        if (!conn.hasWriteAccess()) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 5, 1);
            return;
        }
        int fid = parser.getParameter(0);
        NetworkFile netFile = conn.findFile(fid);
        if (netFile == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 6, 1);
            return;
        }
        if (this.m_sess.hasDebug(512)) {
            this.m_sess.debugPrintln("File Flush [" + netFile.getFileId() + "]");
        }
        try {
            DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
            disk.flushFile(this.m_sess, conn, netFile);
        }
        catch (InvalidDeviceInterfaceException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 13, 1);
            return;
        }
        catch (IOException ex) {
            if (this.m_sess.hasDebug(512)) {
                this.m_sess.debugPrintln("File Flush Error [" + netFile.getFileId() + "] : " + ex.toString());
            }
            this.m_sess.sendErrorResponseSMB(smbPkt, 29, 3);
            return;
        }
        parser.setParameterCount(0);
        parser.setByteCount(0);
        this.m_sess.sendResponseSMB(smbPkt);
    }

    protected void procGetFileAttributes(SMBSrvPacket smbPkt, SMBV1Parser parser) throws IOException, SMBSrvException {
        if (!parser.checkPacketIsValid(0, 2)) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 64, 2);
            return;
        }
        VirtualCircuit vc = this.m_sess.findVirtualCircuit(parser.getUserId());
        if (vc == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
            return;
        }
        int treeId = parser.getTreeId();
        TreeConnection conn = vc.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 15, 1);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 5, 1);
            return;
        }
        int dataPos = parser.getByteOffset();
        int dataLen = parser.getByteCount();
        byte[] buf = parser.getBuffer();
        String fileName = DataPacker.getDataString('\u0004', buf, dataPos, dataLen, parser.isUnicode());
        if (fileName == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 13, 1);
            return;
        }
        if (this.m_sess.hasDebug(512)) {
            this.m_sess.debugPrintln("Get File Information [" + treeId + "] name=" + fileName);
        }
        try {
            DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
            FileInfo finfo = disk.getFileInformation(this.m_sess, conn, fileName);
            if (finfo != null) {
                finfo.setFileAttributes(finfo.getFileAttributes() & 0x3F);
                if (conn.getSharedDevice().isReadOnly() && !finfo.isReadOnly()) {
                    finfo.setFileAttributes(finfo.getFileAttributes() + 1);
                }
                parser.setParameterCount(10);
                parser.setParameter(0, finfo.getFileAttributes());
                if (finfo.getModifyDateTime() != 0L) {
                    SMBDate dateTime = new SMBDate(finfo.getModifyDateTime());
                    parser.setParameter(1, dateTime.asSMBTime());
                    parser.setParameter(2, dateTime.asSMBDate());
                } else {
                    parser.setParameter(1, 0);
                    parser.setParameter(2, 0);
                }
                parser.setParameter(3, (int)finfo.getSize() & 0xFFFF);
                parser.setParameter(4, (int)(finfo.getSize() & 0xFFFFFFFFFFFF0000L) >> 16);
                for (int i = 5; i < 10; ++i) {
                    parser.setParameter(i, 0);
                }
                parser.setByteCount(0);
                this.m_sess.sendResponseSMB(smbPkt);
                return;
            }
        }
        catch (InvalidDeviceInterfaceException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 13, 1);
            return;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.m_sess.sendErrorResponseSMB(smbPkt, 2, 1);
    }

    protected void procGetFileInformation(SMBSrvPacket smbPkt, SMBV1Parser parser) throws IOException, SMBSrvException {
        if (!parser.checkPacketIsValid(1, 0)) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 64, 2);
            return;
        }
        VirtualCircuit vc = this.m_sess.findVirtualCircuit(parser.getUserId());
        if (vc == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
            return;
        }
        int treeId = parser.getTreeId();
        TreeConnection conn = vc.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 15, 1);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 5, 1);
            return;
        }
        int fid = parser.getParameter(0);
        NetworkFile netFile = conn.findFile(fid);
        if (netFile == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 6, 1);
            return;
        }
        if (this.m_sess.hasDebug(512)) {
            this.m_sess.debugPrintln("Get File Information 2 [" + netFile.getFileId() + "]");
        }
        try {
            DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
            FileInfo finfo = disk.getFileInformation(this.m_sess, conn, netFile.getFullName());
            if (finfo != null) {
                finfo.setFileAttributes(finfo.getFileAttributes() & 0x3F);
                if (conn.getSharedDevice().isReadOnly() && !finfo.isReadOnly()) {
                    finfo.setFileAttributes(finfo.getFileAttributes() + 1);
                }
                parser.setParameterCount(11);
                parser.setByteCount(0);
                SMBDate dateTime = new SMBDate(0);
                if (finfo.getCreationDateTime() != 0L) {
                    dateTime.setTime(finfo.getCreationDateTime());
                    parser.setParameter(0, dateTime.asSMBDate());
                    parser.setParameter(1, dateTime.asSMBTime());
                } else {
                    parser.setParameter(0, 0);
                    parser.setParameter(1, 0);
                }
                if (finfo.getAccessDateTime() != 0L) {
                    dateTime.setTime(finfo.getAccessDateTime());
                    parser.setParameter(2, dateTime.asSMBDate());
                    parser.setParameter(3, dateTime.asSMBTime());
                } else {
                    parser.setParameter(2, 0);
                    parser.setParameter(3, 0);
                }
                if (finfo.getModifyDateTime() != 0L) {
                    dateTime.setTime(finfo.getModifyDateTime());
                    parser.setParameter(4, dateTime.asSMBDate());
                    parser.setParameter(5, dateTime.asSMBTime());
                } else {
                    parser.setParameter(4, 0);
                    parser.setParameter(5, 0);
                }
                parser.setParameter(6, (int)finfo.getSize() & 0xFFFF);
                parser.setParameter(7, (int)(finfo.getSize() & 0xFFFFFFFFFFFF0000L) >> 16);
                parser.setParameter(8, (int)finfo.getSize() & 0xFFFF);
                parser.setParameter(9, (int)(finfo.getSize() & 0xFFFFFFFFFFFF0000L) >> 16);
                parser.setParameter(10, finfo.getFileAttributes());
                this.m_sess.sendResponseSMB(smbPkt);
                return;
            }
        }
        catch (InvalidDeviceInterfaceException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 13, 1);
            return;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.m_sess.sendErrorResponseSMB(smbPkt, 2, 1);
    }

    protected void procLockFile(SMBSrvPacket smbPkt, SMBV1Parser parser) throws IOException, SMBSrvException {
        if (!parser.checkPacketIsValid(5, 0)) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 64, 2);
            return;
        }
        VirtualCircuit vc = this.m_sess.findVirtualCircuit(parser.getUserId());
        if (vc == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
            return;
        }
        int treeId = parser.getTreeId();
        TreeConnection conn = vc.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 15, 1);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 5, 1);
            return;
        }
        int fid = parser.getParameter(0);
        long lockcnt = parser.getParameterLong(1);
        long lockoff = parser.getParameterLong(3);
        NetworkFile netFile = conn.findFile(fid);
        if (netFile == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 6, 1);
            return;
        }
        if (this.m_sess.hasDebug(1024)) {
            this.m_sess.debugPrintln("File Lock [" + netFile.getFileId() + "] : Offset=" + lockoff + " ,Count=" + lockcnt);
        }
        parser.setParameterCount(0);
        parser.setByteCount(0);
        this.m_sess.sendResponseSMB(smbPkt);
    }

    protected void procOpenFile(SMBSrvPacket smbPkt, SMBV1Parser parser) throws IOException, SMBSrvException {
        int fid;
        if (!parser.checkPacketIsValid(2, 2)) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 64, 2);
            return;
        }
        VirtualCircuit vc = this.m_sess.findVirtualCircuit(parser.getUserId());
        if (vc == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
            return;
        }
        int treeId = parser.getTreeId();
        TreeConnection conn = vc.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 15, 1);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 5, 1);
            return;
        }
        int dataPos = parser.getByteOffset();
        int dataLen = parser.getByteCount();
        byte[] buf = parser.getBuffer();
        String fileName = DataPacker.getDataString('\u0004', buf, dataPos, dataLen, parser.isUnicode());
        if (fileName == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 13, 1);
            return;
        }
        int mode = parser.getParameter(0);
        int attr = parser.getParameter(1);
        FileOpenParams params = new FileOpenParams(fileName, mode, 2, attr, parser.getProcessIdFull());
        if (this.m_sess.hasDebug(512)) {
            this.m_sess.debugPrintln("File Open [" + treeId + "] params=" + params);
        }
        NetworkFile netFile = null;
        try {
            DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
            netFile = disk.openFile(this.m_sess, conn, params);
            fid = conn.addFile(netFile, this.getSession());
        }
        catch (InvalidDeviceInterfaceException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 13, 1);
            return;
        }
        catch (TooManyFilesException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 4, 1);
            return;
        }
        catch (AccessDeniedException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 5, 1);
            return;
        }
        catch (FileSharingException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 32, 1);
            return;
        }
        catch (IOException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 2, 1);
            return;
        }
        parser.setParameterCount(7);
        parser.setParameter(0, fid);
        parser.setParameter(1, 0);
        if (netFile.hasModifyDate()) {
            parser.setParameterLong(2, (int)(netFile.getModifyDate() / 1000L));
        } else {
            parser.setParameterLong(2, 0);
        }
        parser.setParameterLong(4, netFile.getFileSizeInt());
        parser.setParameter(6, netFile.getGrantedAccess().intValue());
        parser.setByteCount(0);
        this.m_sess.sendResponseSMB(smbPkt);
    }

    protected void procProcessExit(SMBSrvPacket smbPkt, SMBV1Parser parser) throws IOException, SMBSrvException {
        if (!parser.checkPacketIsValid(0, 0)) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 64, 2);
            return;
        }
        VirtualCircuit vc = this.m_sess.findVirtualCircuit(parser.getUserId());
        if (vc == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
            return;
        }
        int treeId = parser.getTreeId();
        TreeConnection conn = vc.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 15, 1);
            return;
        }
        if (this.m_sess.hasDebug(512)) {
            this.m_sess.debugPrintln("Process Exit - Open files = " + conn.openFileCount());
        }
        if (conn.openFileCount() > 0) {
            conn.closeConnection(this.getSession());
        }
        parser.setParameterCount(0);
        parser.setByteCount(0);
        this.m_sess.sendResponseSMB(smbPkt);
    }

    protected void procReadFile(SMBSrvPacket smbPkt, SMBV1Parser parser) throws IOException, SMBSrvException {
        if (!parser.checkPacketIsValid(5, 0)) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 64, 2);
            return;
        }
        VirtualCircuit vc = this.m_sess.findVirtualCircuit(parser.getUserId());
        if (vc == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
            return;
        }
        int treeId = parser.getTreeId();
        TreeConnection conn = vc.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 15, 1);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 5, 1);
            return;
        }
        int fid = parser.getParameter(0);
        int reqcnt = parser.getParameter(1);
        int reqoff = parser.getParameterLong(2);
        NetworkFile netFile = conn.findFile(fid);
        if (netFile == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 6, 1);
            return;
        }
        if (this.m_sess.hasDebug(1024)) {
            this.m_sess.debugPrintln("File Read [" + netFile.getFileId() + "] : Size=" + reqcnt + " ,Pos=" + reqoff);
        }
        SMBSrvPacket respPkt = smbPkt;
        byte[] buf = respPkt.getBuffer();
        int rdlen = 0;
        try {
            DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
            int dataOff = parser.getByteOffset() + 3;
            if (!this.m_sess.hasClientCapability(16384)) {
                int maxClientCnt = this.m_sess.getClientMaximumBufferSize() - dataOff;
                if (reqcnt > maxClientCnt) {
                    reqcnt = maxClientCnt;
                }
                if (this.m_sess.hasDebug(1024)) {
                    this.m_sess.debugPrintln("File Read [" + netFile.getFileId() + "] Limited to " + reqcnt);
                }
            }
            if (reqcnt > buf.length - dataOff) {
                respPkt = this.m_sess.getPacketPool().allocatePacket(reqcnt + dataOff, smbPkt);
                buf = respPkt.getBuffer();
                respPkt.setParser(SMBSrvPacket.Version.V1);
                parser = (SMBV1Parser)respPkt.getParser();
            }
            rdlen = disk.readFile(this.m_sess, conn, netFile, buf, parser.getByteOffset() + 3, reqcnt, reqoff);
        }
        catch (InvalidDeviceInterfaceException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 13, 1);
            return;
        }
        catch (IOException ex) {
            if (this.m_sess.hasDebug(1024)) {
                this.m_sess.debugPrintln("File Read Error [" + netFile.getFileId() + "] : " + ex.toString());
            }
            this.m_sess.sendErrorResponseSMB(smbPkt, 30, 3);
            return;
        }
        int bytOff = parser.getByteOffset();
        buf[bytOff] = 1;
        DataPacker.putIntelShort(rdlen, buf, bytOff + 1);
        parser.setByteCount(rdlen + 3);
        parser.setParameter(0, rdlen);
        parser.setParameter(1, 0);
        parser.setParameter(2, 0);
        parser.setParameter(3, 0);
        parser.setParameter(4, 0);
        this.m_sess.sendResponseSMB(respPkt);
    }

    protected void procRenameFile(SMBSrvPacket smbPkt, SMBV1Parser parser) throws IOException, SMBSrvException {
        boolean isUni;
        if (!parser.checkPacketIsValid(1, 4)) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 64, 2);
            return;
        }
        VirtualCircuit vc = this.m_sess.findVirtualCircuit(parser.getUserId());
        if (vc == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
            return;
        }
        int treeId = parser.getTreeId();
        TreeConnection conn = vc.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 15, 1);
            return;
        }
        if (!conn.hasWriteAccess()) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 5, 1);
            return;
        }
        int dataPos = parser.getByteOffset();
        int dataLen = parser.getByteCount();
        byte[] buf = parser.getBuffer();
        String oldName = DataPacker.getDataString('\u0004', buf, dataPos, dataLen, isUni = parser.isUnicode());
        if (oldName == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 13, 1);
            return;
        }
        if (isUni) {
            int len = oldName.length() * 2 + 2;
            dataPos = DataPacker.wordAlign(dataPos + 1) + len;
            dataLen -= len;
        } else {
            dataPos += oldName.length() + 2;
            dataLen -= oldName.length() + 2;
        }
        String newName = DataPacker.getDataString('\u0004', buf, dataPos, dataLen, isUni);
        if (newName == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 13, 1);
            return;
        }
        if (this.m_sess.hasDebug(512)) {
            this.m_sess.debugPrintln("File Rename [" + treeId + "] old name=" + oldName + ", new name=" + newName);
        }
        Object netFile = null;
        try {
            DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
            disk.renameFile(this.m_sess, conn, oldName, newName);
        }
        catch (InvalidDeviceInterfaceException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 13, 1);
            return;
        }
        catch (IOException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 2, 1);
            return;
        }
        parser.setParameterCount(0);
        parser.setByteCount(0);
        this.m_sess.sendResponseSMB(smbPkt);
    }

    protected final void procSearch(SMBSrvPacket smbPkt, SMBV1Parser parser) throws IOException, SMBSrvException {
        if (!parser.checkPacketIsValid(2, 5)) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 64, 2);
            return;
        }
        VirtualCircuit vc = this.m_sess.findVirtualCircuit(parser.getUserId());
        if (vc == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
            return;
        }
        int treeId = parser.getTreeId();
        TreeConnection conn = vc.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 5, 2);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 5, 1);
            return;
        }
        int maxFiles = parser.getParameter(0);
        int srchAttr = parser.getParameter(1);
        if ((srchAttr & 8) != 0) {
            this.procSearchVolumeLabel(smbPkt, parser);
            return;
        }
        int dataPos = parser.getByteOffset();
        int dataLen = parser.getByteCount();
        byte[] buf = parser.getBuffer();
        String srchPath = DataPacker.getDataString('\u0004', buf, dataPos, dataLen, parser.isUnicode());
        if (srchPath == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 1, 1);
            return;
        }
        dataPos += srchPath.length() + 2;
        dataLen -= srchPath.length() + 2;
        int resumeLen = 0;
        if (buf[dataPos++] == 5) {
            resumeLen = DataPacker.getIntelShort(buf, dataPos);
            dataPos += 2;
            if (resumeLen > (dataLen -= 3)) {
                this.m_sess.sendErrorResponseSMB(smbPkt, 13, 1);
                return;
            }
        }
        SearchContext ctx = null;
        DiskInterface disk = null;
        try {
            disk = (DiskInterface)conn.getSharedDevice().getInterface();
        }
        catch (InvalidDeviceInterfaceException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 13, 1);
            return;
        }
        byte[] resumeKey = null;
        int searchId = -1;
        int resumeId = 32771;
        if (resumeLen == 0 && srchPath.length() > 0) {
            try {
                searchId = vc.allocateSearchSlot();
            }
            catch (TooManySearchesException ex) {
                int idx = 0;
                ctx = vc.getSearchContext(idx);
                while (ctx != null && searchId == -1) {
                    if (ctx.getSearchString().compareTo("????????.???") == 0) {
                        if (this.m_sess.hasDebug(128)) {
                            this.m_sess.debugPrintln("Release leaked search [" + idx + "]");
                        }
                        vc.deallocateSearchSlot(idx);
                        try {
                            searchId = vc.allocateSearchSlot();
                            continue;
                        }
                        catch (TooManySearchesException ex2) {
                            this.m_sess.sendErrorResponseSMB(smbPkt, 89, 2);
                            return;
                        }
                    }
                    ctx = vc.getSearchContext(++idx);
                }
            }
            if (this.m_sess.hasDebug(128)) {
                this.m_sess.debugPrintln("Start search [" + searchId + "] - " + srchPath + ", attr=0x" + Integer.toHexString(srchAttr) + ", maxFiles=" + maxFiles);
            }
            if ((ctx = disk.startSearch(this.m_sess, conn, srchPath, srchAttr)) != null) {
                ctx.setTreeId(treeId);
                ctx.setMaximumFiles(maxFiles);
            }
            vc.setSearchContext(searchId, ctx);
        } else {
            resumeKey = new byte[21];
            CoreResumeKey.getResumeKey(buf, dataPos, resumeKey);
            int id = CoreResumeKey.getServerArea(resumeKey, 0);
            searchId = (id & 0xFFFF0000) >> 16;
            ctx = vc.getSearchContext(searchId);
            if (ctx == null) {
                this.m_sess.sendErrorResponseSMB(smbPkt, 13, 1);
                return;
            }
            resumeId = id & 0xFFFF;
            if (resumeId < 32769 && ctx.getResumeId() != resumeId) {
                if (this.m_sess.hasDebug(128)) {
                    this.m_sess.debugPrintln("Search resume at " + resumeId);
                }
                if (!ctx.restartAt(resumeId)) {
                    if (this.m_sess.hasDebug(128)) {
                        this.m_sess.debugPrintln("Search restart failed");
                    }
                    this.m_sess.sendErrorResponseSMB(smbPkt, 18, 1);
                    vc.deallocateSearchSlot(searchId);
                    return;
                }
            }
        }
        if (ctx == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 13, 1);
            return;
        }
        if (ctx.getTreeId() != treeId) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 5, 2);
            return;
        }
        boolean wildcardSearch = WildCard.containsWildcards(srchPath);
        SMBSrvPacket respPkt = smbPkt;
        if (wildcardSearch) {
            int pktSize = parser.calculateHeaderLength(1) + maxFiles * 43;
            respPkt = this.m_sess.getPacketPool().allocatePacket(pktSize, smbPkt);
            buf = respPkt.getBuffer();
            respPkt.setParser(SMBSrvPacket.Version.V1);
            parser = (SMBV1Parser)respPkt.getParser();
        }
        parser.setParameterCount(1);
        int bufPos = parser.getByteOffset();
        buf[bufPos] = 5;
        bufPos += 3;
        int fileCnt = 0;
        if ((srchAttr & 0x10) != 0 && resumeId >= 32769 && wildcardSearch) {
            String workDir = FileName.removeFileName(srchPath);
            FileInfo dirInfo = disk.getFileInformation(this.m_sess, conn, workDir);
            if (dirInfo != null) {
                dirInfo = new FileInfo(".", 0L, 16);
            }
            if (this.m_sess.hasDebug(128)) {
                this.m_sess.debugPrintln("Search adding . and .. entries:  " + dirInfo.toString());
            }
            if (resumeId == 32771) {
                dirInfo.setFileName(".");
                resumeId = 32770;
                bufPos = this.packSearchInfo(buf, bufPos, ctx.getSearchString(), 32770, searchId, dirInfo);
                ++fileCnt;
            }
            if (resumeId == 32770) {
                dirInfo.setFileName("..");
                bufPos = this.packSearchInfo(buf, bufPos, ctx.getSearchString(), 32769, searchId, dirInfo);
                ++fileCnt;
            }
        }
        FileInfo fileInfo = new FileInfo();
        while (fileCnt < ctx.getMaximumFiles() && ctx.nextFileInfo(fileInfo)) {
            if (fileInfo.getFileName().startsWith(".")) continue;
            resumeId = ctx.getResumeId();
            if (this.m_sess.hasDebug(128)) {
                this.m_sess.debugPrintln("Search return file " + fileInfo.toString() + ", resumeId=" + resumeId);
            }
            if (conn.getSharedDevice().isReadOnly() && !fileInfo.isReadOnly()) {
                fileInfo.setFileAttributes(fileInfo.getFileAttributes() + 1);
            }
            bufPos = this.packSearchInfo(buf, bufPos, ctx.getSearchString(), resumeId, searchId, fileInfo);
            ++fileCnt;
            fileInfo.resetInfo();
        }
        if (fileCnt == 0) {
            parser.setParameterCount(1);
            parser.setParameter(0, 0);
            parser.setByteCount(0);
            parser.setErrorClass(1);
            parser.setErrorCode(18);
            this.m_sess.sendResponseSMB(respPkt);
            if (this.m_sess.hasDebug(128)) {
                this.m_sess.debugPrintln("End search [" + searchId + "]");
            }
            vc.deallocateSearchSlot(searchId);
        } else {
            dataLen = bufPos - parser.getByteOffset();
            parser.setByteCount(dataLen);
            bufPos = parser.getByteOffset() + 1;
            DataPacker.putIntelShort(dataLen - 3, buf, bufPos);
            parser.setParameter(0, fileCnt);
            this.m_sess.sendResponseSMB(respPkt);
            if (fileCnt == 1 && resumeLen == 0 && !WildCard.containsWildcards(srchPath)) {
                if (this.m_sess.hasDebug(128)) {
                    this.m_sess.debugPrintln("End search [" + searchId + "] (Not wildcard)");
                }
                vc.deallocateSearchSlot(searchId);
            }
        }
        if (this.m_sess.hasDebug(8)) {
            this.m_sess.debugPrintln("Tx " + parser.getLength() + " bytes");
        }
    }

    protected final void procSearchVolumeLabel(SMBSrvPacket smbPkt, SMBV1Parser parser) throws IOException, SMBSrvException {
        VirtualCircuit vc = this.m_sess.findVirtualCircuit(parser.getUserId());
        if (vc == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
            return;
        }
        int treeId = parser.getTreeId();
        TreeConnection conn = vc.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 5, 2);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 5, 1);
            return;
        }
        if (this.m_sess.hasDebug(128)) {
            this.m_sess.debugPrintln("Start Search - Volume Label");
        }
        DiskInterface disk = null;
        DiskDeviceContext diskCtx = null;
        try {
            disk = (DiskInterface)conn.getSharedDevice().getInterface();
            diskCtx = (DiskDeviceContext)conn.getContext();
        }
        catch (InvalidDeviceInterfaceException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 13, 1);
            return;
        }
        VolumeInfo volInfo = diskCtx.getVolumeInformation();
        String volLabel = "";
        if (volInfo != null) {
            volLabel = volInfo.getVolumeLabel();
        }
        parser.setParameterCount(1);
        int bufPos = parser.getByteOffset();
        byte[] buf = parser.getBuffer();
        buf[bufPos++] = 5;
        int dataLen = 43;
        DataPacker.putIntelShort(dataLen, buf, bufPos);
        CoreResumeKey.putResumeKey(buf, bufPos += 2, volLabel, -1);
        bufPos += 21;
        buf[bufPos++] = 8;
        for (int i = 0; i < 8; ++i) {
            buf[bufPos++] = 0;
        }
        StringBuffer volBuf = new StringBuffer();
        volBuf.append(volLabel);
        while (volBuf.length() < 13) {
            volBuf.append(" ");
        }
        if (volBuf.length() > 12) {
            volBuf.setLength(12);
        }
        bufPos = DataPacker.putString(volBuf.toString().toUpperCase(), buf, bufPos, true);
        dataLen = bufPos - parser.getByteOffset();
        parser.setByteCount(dataLen);
        this.m_sess.sendResponseSMB(smbPkt);
        if (this.m_sess.hasDebug(128)) {
            this.m_sess.debugPrintln("Volume label for " + conn.toString() + " is " + volLabel);
        }
    }

    protected final void procSeekFile(SMBSrvPacket smbPkt, SMBV1Parser parser) throws IOException, SMBSrvException {
        if (!parser.checkPacketIsValid(4, 0)) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 64, 2);
            return;
        }
        VirtualCircuit vc = this.m_sess.findVirtualCircuit(parser.getUserId());
        if (vc == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
            return;
        }
        int treeId = parser.getTreeId();
        TreeConnection conn = vc.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 15, 1);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 5, 1);
            return;
        }
        int fid = parser.getParameter(0);
        int seekMode = parser.getParameter(1);
        long seekPos = parser.getParameterLong(2);
        NetworkFile netFile = conn.findFile(fid);
        if (netFile == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 6, 1);
            return;
        }
        if (this.m_sess.hasDebug(512)) {
            this.m_sess.debugPrintln("File Seek [" + netFile.getFileId() + "] : Mode = " + seekMode + ", Pos = " + seekPos);
        }
        byte[] buf = parser.getBuffer();
        long pos = 0L;
        try {
            DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
            pos = disk.seekFile(this.m_sess, conn, netFile, seekPos, seekMode);
        }
        catch (InvalidDeviceInterfaceException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 13, 1);
            return;
        }
        catch (IOException ex) {
            if (this.m_sess.hasDebug(512)) {
                this.m_sess.debugPrintln("File Seek Error [" + netFile.getFileId() + "] : " + ex.toString());
            }
            this.m_sess.sendErrorResponseSMB(smbPkt, 30, 3);
            return;
        }
        parser.setParameterCount(2);
        parser.setParameterLong(0, (int)(pos & 0xFFFFFFFFL));
        parser.setByteCount(0);
        this.m_sess.sendResponseSMB(smbPkt);
    }

    protected void procSessionSetup(SMBSrvPacket smbPkt, SMBV1Parser parser) throws SMBSrvException, IOException, TooManyConnectionsException {
        this.m_sess.sendErrorResponseSMB(smbPkt, 5, 1);
    }

    protected void procSetFileAttributes(SMBSrvPacket smbPkt, SMBV1Parser parser) throws IOException, SMBSrvException {
        if (!parser.checkPacketIsValid(8, 0)) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 64, 2);
            return;
        }
        VirtualCircuit vc = this.m_sess.findVirtualCircuit(parser.getUserId());
        if (vc == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
            return;
        }
        int treeId = parser.getTreeId();
        TreeConnection conn = vc.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 15, 1);
            return;
        }
        if (!conn.hasWriteAccess()) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 5, 1);
            return;
        }
        int dataPos = parser.getByteOffset();
        int dataLen = parser.getByteCount();
        byte[] buf = parser.getBuffer();
        String fileName = DataPacker.getDataString('\u0004', buf, dataPos, dataLen, parser.isUnicode());
        if (fileName == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 13, 1);
            return;
        }
        int fattr = parser.getParameter(0);
        int setFlags = 4;
        FileInfo finfo = new FileInfo(fileName, 0L, fattr);
        int fdate = parser.getParameter(1);
        int ftime = parser.getParameter(2);
        if (fdate != 0 && ftime != 0) {
            finfo.setModifyDateTime(new SMBDate(fdate, ftime).getTime());
            setFlags += 8;
        }
        if (this.m_sess.hasDebug(512)) {
            this.m_sess.debugPrintln("Set File Attributes [" + treeId + "] name=" + fileName + ", attr=0x" + Integer.toHexString(fattr) + ", fdate=" + fdate + ", ftime=" + ftime);
        }
        try {
            DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
            finfo.setFileInformationFlags(setFlags);
            disk.setFileInformation(this.m_sess, conn, fileName, finfo);
        }
        catch (InvalidDeviceInterfaceException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 13, 1);
            return;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        parser.setParameterCount(0);
        parser.setByteCount(0);
        this.m_sess.sendResponseSMB(smbPkt);
    }

    protected void procSetFileInformation(SMBSrvPacket smbPkt, SMBV1Parser parser) throws IOException, SMBSrvException {
        if (!parser.checkPacketIsValid(7, 0)) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 64, 2);
            return;
        }
        VirtualCircuit vc = this.m_sess.findVirtualCircuit(parser.getUserId());
        if (vc == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
            return;
        }
        int treeId = parser.getTreeId();
        TreeConnection conn = vc.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 15, 1);
            return;
        }
        if (!conn.hasWriteAccess()) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 5, 1);
            return;
        }
        int fid = parser.getParameter(0);
        NetworkFile netFile = conn.findFile(fid);
        if (netFile == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 6, 1);
            return;
        }
        int setFlags = 0;
        FileInfo finfo = new FileInfo(netFile.getName(), 0L, 0);
        int fdate = parser.getParameter(1);
        int ftime = parser.getParameter(2);
        if (fdate != 0 && ftime != 0) {
            finfo.setCreationDateTime(new SMBDate(fdate, ftime).getTime());
            setFlags += 16;
        }
        fdate = parser.getParameter(3);
        ftime = parser.getParameter(4);
        if (fdate != 0 && ftime != 0) {
            finfo.setAccessDateTime(new SMBDate(fdate, ftime).getTime());
            setFlags += 32;
        }
        fdate = parser.getParameter(5);
        ftime = parser.getParameter(6);
        if (fdate != 0 && ftime != 0) {
            finfo.setModifyDateTime(new SMBDate(fdate, ftime).getTime());
            setFlags += 8;
        }
        if (this.m_sess.hasDebug(512)) {
            this.m_sess.debugPrintln("Set File Information 2 [" + netFile.getFileId() + "] " + finfo.toString());
        }
        try {
            DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
            finfo.setFileInformationFlags(setFlags);
            disk.setFileInformation(this.m_sess, conn, netFile.getFullName(), finfo);
        }
        catch (InvalidDeviceInterfaceException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 13, 1);
            return;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        parser.setParameterCount(0);
        parser.setByteCount(0);
        this.m_sess.sendResponseSMB(smbPkt);
    }

    protected void procTreeConnect(SMBSrvPacket smbPkt, SMBV1Parser parser) throws SMBSrvException, TooManyConnectionsException, IOException {
        boolean isUni;
        if (!parser.checkPacketIsValid(0, 4)) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 64, 2);
            return;
        }
        VirtualCircuit vc = this.m_sess.findVirtualCircuit(parser.getUserId());
        if (vc == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
            return;
        }
        int dataPos = parser.getByteOffset();
        int dataLen = parser.getByteCount();
        byte[] buf = parser.getBuffer();
        String uncPath = DataPacker.getDataString('\u0004', buf, dataPos, dataLen, isUni = parser.isUnicode());
        if (uncPath == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 13, 1);
            return;
        }
        if (isUni) {
            dataPos = DataPacker.wordAlign(dataPos + 1) + uncPath.length() * 2 + 2;
            dataLen -= uncPath.length() * 2 + 2;
        } else {
            dataPos += uncPath.length() + 2;
            dataLen -= uncPath.length() + 2;
        }
        String pwd = DataPacker.getDataString('\u0004', buf, dataPos, dataLen, isUni);
        if (pwd == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 13, 1);
            return;
        }
        if (isUni) {
            dataPos = DataPacker.wordAlign(dataPos + 1) + pwd.length() * 2 + 2;
            dataLen -= pwd.length() * 2 + 2;
        } else {
            dataPos += pwd.length() + 2;
            dataLen -= pwd.length() + 2;
        }
        String service = DataPacker.getDataString('\u0004', buf, dataPos, dataLen, isUni);
        if (service == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 13, 1);
            return;
        }
        ShareType servType = ShareType.ServiceAsType(service);
        if (servType == ShareType.UNKNOWN) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 13, 1);
            return;
        }
        if (this.m_sess.hasDebug(64)) {
            this.m_sess.debugPrintln("Tree connect - " + uncPath + ", " + service);
        }
        PCShare share = null;
        try {
            share = new PCShare(uncPath);
        }
        catch (InvalidUNCPathException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 13, 1);
            return;
        }
        if (servType == ShareType.NAMEDPIPE && share.getShareName().compareTo("IPC$") == 0) {
            servType = ShareType.ADMINPIPE;
        }
        SharedDevice shareDev = null;
        try {
            shareDev = this.m_sess.getSMBServer().findShare(share.getNodeName(), share.getShareName(), servType, this.getSession(), true);
        }
        catch (InvalidUserException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 5, 1);
            return;
        }
        catch (Exception ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 6, 2);
            return;
        }
        if (shareDev == null || shareDev.getType() != servType) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 15, 1);
            return;
        }
        int treeId = vc.addConnection(shareDev);
        ISMBAuthenticator auth = this.getSession().getSMBServer().getSMBAuthenticator();
        ISMBAuthenticator.ShareStatus sharePerm = ISMBAuthenticator.ShareStatus.WRITEABLE;
        if (auth != null && (sharePerm = auth.authenticateShareConnect(this.m_sess.getClientInformation(), shareDev, pwd, this.m_sess)) == ISMBAuthenticator.ShareStatus.NO_ACCESS) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 4, 2);
            return;
        }
        TreeConnection tree = vc.findConnection(treeId);
        tree.setPermission(sharePerm);
        parser.setParameterCount(2);
        parser.setParameter(0, buf.length - 4);
        parser.setParameter(1, treeId);
        parser.setByteCount(0);
        parser.setAndXCommand(255);
        this.m_sess.sendResponseSMB(smbPkt);
        if (tree.getInterface() != null) {
            tree.getInterface().treeOpened(this.m_sess, tree);
        }
    }

    protected void procTreeDisconnect(SMBSrvPacket smbPkt, SMBV1Parser parser) throws IOException, SMBSrvException {
        if (!parser.checkPacketIsValid(0, 0)) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 64, 2);
            return;
        }
        VirtualCircuit vc = this.m_sess.findVirtualCircuit(parser.getUserId());
        if (vc == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
            return;
        }
        int treeId = parser.getTreeId();
        TreeConnection conn = vc.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 15, 1);
            return;
        }
        if (this.m_sess.hasDebug(64)) {
            this.m_sess.debugPrintln("Tree disconnect - " + treeId + ", " + conn.toString());
        }
        vc.removeConnection(treeId, this.m_sess);
        if (vc.getConnectionCount() == 0 && !vc.isLoggedOn()) {
            this.m_sess.removeVirtualCircuit(vc.getId());
            if (this.m_sess.hasDebug(64)) {
                this.m_sess.debugPrintln("  Removed virtual circuit " + vc);
            }
        }
        parser.setParameterCount(0);
        parser.setByteCount(0);
        this.m_sess.sendResponseSMB(smbPkt);
        if (this.m_sess.numberOfVirtualCircuits() == 0) {
            if (this.m_sess.hasDebug(32)) {
                Debug.println("  Closing session, no more virtual circuits");
            }
            this.m_sess.hangupSession("Tree disconnect");
        }
        if (conn.getInterface() != null) {
            conn.getInterface().treeClosed(this.m_sess, conn);
        }
    }

    protected void procUnLockFile(SMBSrvPacket smbPkt, SMBV1Parser parser) throws IOException, SMBSrvException {
        if (!parser.checkPacketIsValid(5, 0)) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 64, 2);
            return;
        }
        VirtualCircuit vc = this.m_sess.findVirtualCircuit(parser.getUserId());
        if (vc == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
            return;
        }
        int treeId = parser.getTreeId();
        TreeConnection conn = vc.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 15, 1);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 5, 1);
            return;
        }
        int fid = parser.getParameter(0);
        long lockcnt = parser.getParameterLong(1);
        long lockoff = parser.getParameterLong(3);
        NetworkFile netFile = conn.findFile(fid);
        if (netFile == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 6, 1);
            return;
        }
        if (this.m_sess.hasDebug(1024)) {
            this.m_sess.debugPrintln("File UnLock [" + netFile.getFileId() + "] : Offset=" + lockoff + " ,Count=" + lockcnt);
        }
        parser.setParameterCount(0);
        parser.setByteCount(0);
        this.m_sess.sendResponseSMB(smbPkt);
    }

    protected final void procUnsupported(SMBSrvPacket smbPkt, SMBV1Parser parser) throws IOException, SMBSrvException {
        this.m_sess.sendErrorResponseSMB(smbPkt, 65535, 2);
    }

    protected void procWriteFile(SMBSrvPacket smbPkt, SMBV1Parser parser) throws IOException, SMBSrvException {
        if (!parser.checkPacketIsValid(5, 0)) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 64, 2);
            return;
        }
        VirtualCircuit vc = this.m_sess.findVirtualCircuit(parser.getUserId());
        if (vc == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
            return;
        }
        int treeId = parser.getTreeId();
        TreeConnection conn = vc.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 15, 1);
            return;
        }
        if (!conn.hasWriteAccess()) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 5, 1);
            return;
        }
        int fid = parser.getParameter(0);
        int wrtcnt = parser.getParameter(1);
        long wrtoff = (long)parser.getParameter(2) + ((long)(parser.getParameter(3) << 16) & 0xFFFFFFFFL);
        NetworkFile netFile = conn.findFile(fid);
        if (netFile == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 6, 1);
            return;
        }
        if (this.m_sess.hasDebug(1024)) {
            this.m_sess.debugPrintln("File Write [" + netFile.getFileId() + "] : Size=" + wrtcnt + " ,Pos=" + wrtoff);
        }
        byte[] buf = parser.getBuffer();
        int pos = parser.getByteOffset();
        int wrtlen = 0;
        if (buf[pos] != 1) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 13, 1);
            return;
        }
        try {
            DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
            pos += 3;
            if (wrtcnt == 0) {
                disk.truncateFile(this.m_sess, conn, netFile, wrtoff);
            } else {
                wrtlen = disk.writeFile(this.m_sess, conn, netFile, buf, pos, wrtcnt, wrtoff);
            }
        }
        catch (InvalidDeviceInterfaceException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 13, 1);
            return;
        }
        catch (IOException ex) {
            if (this.m_sess.hasDebug(1024)) {
                this.m_sess.debugPrintln("File Write Error [" + netFile.getFileId() + "] : " + ex.toString());
            }
            this.m_sess.sendErrorResponseSMB(smbPkt, 29, 3);
            return;
        }
        parser.setParameterCount(1);
        parser.setParameter(0, wrtlen);
        parser.setByteCount(0);
        this.m_sess.sendResponseSMB(smbPkt);
    }

    protected void procWriteAndCloseFile(SMBSrvPacket smbPkt, SMBV1Parser parser) throws IOException, SMBSrvException {
        if (!parser.checkPacketIsValid(6, 0)) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 64, 2);
            return;
        }
        VirtualCircuit vc = this.m_sess.findVirtualCircuit(parser.getUserId());
        if (vc == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
            return;
        }
        int treeId = parser.getTreeId();
        TreeConnection conn = vc.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 15, 1);
            return;
        }
        if (!conn.hasWriteAccess()) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 5, 1);
            return;
        }
        int fid = parser.getParameter(0);
        int wrtcnt = parser.getParameter(1);
        int wrtoff = parser.getParameterLong(2);
        NetworkFile netFile = conn.findFile(fid);
        if (netFile == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 6, 1);
            return;
        }
        if (this.m_sess.hasDebug(1024)) {
            this.m_sess.debugPrintln("File Write And Close [" + netFile.getFileId() + "] : Size=" + wrtcnt + " ,Pos=" + wrtoff);
        }
        byte[] buf = parser.getBuffer();
        int pos = parser.getByteOffset() + 1;
        int wrtlen = 0;
        try {
            DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
            wrtlen = disk.writeFile(this.m_sess, conn, netFile, buf, pos, wrtcnt, wrtoff);
            if (disk != null) {
                disk.closeFile(this.m_sess, conn, netFile);
            }
            netFile.setClosed(true);
        }
        catch (InvalidDeviceInterfaceException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 13, 1);
            return;
        }
        catch (IOException ex) {
            if (this.m_sess.hasDebug(1024)) {
                this.m_sess.debugPrintln("File Write Error [" + netFile.getFileId() + "] : " + ex.toString());
            }
            this.m_sess.sendErrorResponseSMB(smbPkt, 29, 3);
            return;
        }
        parser.setParameterCount(1);
        parser.setParameter(0, wrtlen);
        parser.setByteCount(0);
        parser.setError(0, 0);
        this.m_sess.sendResponseSMB(smbPkt);
    }

    @Override
    public boolean runProtocol(SMBSrvPacket smbPkt) throws IOException, SMBSrvException, TooManyConnectionsException {
        if (!smbPkt.hasParser()) {
            throw new IOException("SMB packet does not have a parser");
        }
        SMBV1Parser parser = (SMBV1Parser)smbPkt.getParser();
        boolean handledOK = true;
        switch (parser.getCommand()) {
            case 115: {
                this.procSessionSetup(smbPkt, parser);
                break;
            }
            case 112: {
                this.procTreeConnect(smbPkt, parser);
                break;
            }
            case 113: {
                this.procTreeDisconnect(smbPkt, parser);
                break;
            }
            case 129: {
                this.procSearch(smbPkt, parser);
                break;
            }
            case 128: {
                this.procDiskAttributes(smbPkt, parser);
                break;
            }
            case 8: {
                this.procGetFileAttributes(smbPkt, parser);
                break;
            }
            case 9: {
                this.procSetFileAttributes(smbPkt, parser);
                break;
            }
            case 35: {
                this.procGetFileInformation(smbPkt, parser);
                break;
            }
            case 34: {
                this.procSetFileInformation(smbPkt, parser);
                break;
            }
            case 2: {
                this.procOpenFile(smbPkt, parser);
                break;
            }
            case 10: {
                this.procReadFile(smbPkt, parser);
                break;
            }
            case 18: {
                this.procSeekFile(smbPkt, parser);
                break;
            }
            case 4: {
                this.procCloseFile(smbPkt, parser);
                break;
            }
            case 3: 
            case 15: {
                this.procCreateFile(smbPkt, parser);
                break;
            }
            case 11: {
                this.procWriteFile(smbPkt, parser);
                break;
            }
            case 44: {
                this.procWriteAndCloseFile(smbPkt, parser);
                break;
            }
            case 5: {
                this.procFlushFile(smbPkt, parser);
                break;
            }
            case 7: {
                this.procRenameFile(smbPkt, parser);
                break;
            }
            case 6: {
                this.procDeleteFile(smbPkt, parser);
                break;
            }
            case 0: {
                this.procCreateDirectory(smbPkt, parser);
                break;
            }
            case 1: {
                this.procDeleteDirectory(smbPkt, parser);
                break;
            }
            case 16: {
                this.procCheckDirectory(smbPkt, parser);
                break;
            }
            case 39: {
                this.procUnsupported(smbPkt, parser);
                break;
            }
            case 43: {
                this.procEcho(smbPkt, parser);
                break;
            }
            case 17: {
                this.procProcessExit(smbPkt, parser);
                break;
            }
            case 14: {
                this.procCreateTemporaryFile(smbPkt, parser);
                break;
            }
            case 12: {
                this.procLockFile(smbPkt, parser);
                break;
            }
            case 13: {
                this.procUnLockFile(smbPkt, parser);
                break;
            }
            default: {
                Debug.println("<<<<< Unknown SMB type : 0x" + Integer.toHexString(parser.getCommand()) + " >>>>>");
                handledOK = false;
            }
        }
        this.runRequestPostProcessors(this.m_sess);
        return handledOK;
    }
}

