/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.smb.server;

import java.io.IOException;
import org.filesys.debug.Debug;
import org.filesys.server.filesys.TreeConnection;
import org.filesys.smb.TransactBuffer;
import org.filesys.smb.dcerpc.DCEBuffer;
import org.filesys.smb.dcerpc.DCEBufferException;
import org.filesys.smb.dcerpc.DCEDataPacker;
import org.filesys.smb.dcerpc.DCEPipeType;
import org.filesys.smb.dcerpc.UUID;
import org.filesys.smb.dcerpc.server.DCEPipeFile;
import org.filesys.smb.dcerpc.server.DCESrvPacket;
import org.filesys.smb.server.SMBSrvException;
import org.filesys.smb.server.SMBSrvPacket;
import org.filesys.smb.server.SMBSrvSession;
import org.filesys.smb.server.SMBSrvTransPacket;
import org.filesys.smb.server.SMBV1Parser;
import org.filesys.smb.server.VirtualCircuit;
import org.filesys.util.DataBuffer;
import org.filesys.util.DataPacker;

public class DCERPCHandler {
    public static final void processDCERPCRequest(SMBSrvSession sess, SMBSrvTransPacket srvTrans, SMBSrvPacket smbPkt) throws IOException, SMBSrvException {
        TreeConnection conn = sess.findTreeConnection(srvTrans);
        if (conn == null) {
            sess.sendErrorResponseSMB(smbPkt, 15, 1);
            return;
        }
        SMBV1Parser parser = (SMBV1Parser)srvTrans.getParser();
        int fid = srvTrans.getSetupParameter(1);
        int maxData = parser.getParameter(3) - 24;
        DCEPipeFile pipeFile = (DCEPipeFile)conn.findFile(fid);
        if (pipeFile == null) {
            sess.sendErrorResponseSMB(smbPkt, 6, 1);
            return;
        }
        DCEBuffer dceBuf = new DCEBuffer(srvTrans.getBuffer(), parser.getParameter(10) + 4);
        if (sess.hasDebug(65536)) {
            sess.debugPrintln("TransactNmPipe pipeFile=" + pipeFile.getName() + ", fid=" + fid + ", dceCmd=0x" + Integer.toHexString(dceBuf.getHeaderValue(2)));
        }
        DCERPCHandler.processDCEBuffer(sess, dceBuf, pipeFile, smbPkt);
        if (!pipeFile.hasBufferedData()) {
            return;
        }
        DCEBuffer txBuf = pipeFile.getBufferedData();
        DCESrvPacket dcePkt = new DCESrvPacket(smbPkt.getBuffer());
        SMBV1Parser respParser = (SMBV1Parser)smbPkt.getParser();
        int flags = 3;
        dcePkt.initializeDCEReply();
        txBuf.setHeaderValue(3, flags);
        byte[] buf = dcePkt.getBuffer();
        int pos = DCEDataPacker.longwordAlign(respParser.getByteOffset());
        int dataLen = txBuf.getLength();
        txBuf.setHeaderValue(5, dataLen);
        int len = txBuf.getLength();
        int sts = 0;
        if (len > maxData) {
            len = maxData + 24;
            dataLen = maxData + 24;
            sts = -2147483643;
        } else {
            pipeFile.setBufferedData(null);
        }
        if (sess.hasDebug(65536)) {
            sess.debugPrintln("Reply DCEbuf flags=0x" + Integer.toHexString(flags) + ", len=" + len + ", status=0x" + Integer.toHexString(sts));
        }
        try {
            pos += txBuf.copyData(buf, pos, len);
        }
        catch (DCEBufferException ex) {
            sess.sendErrorResponseSMB(smbPkt, 65535, 2);
            return;
        }
        int byteLen = pos - respParser.getByteOffset();
        respParser.setParameter(1, dataLen);
        respParser.setParameter(6, dataLen);
        respParser.setByteCount(byteLen);
        respParser.setFlags2(16384);
        respParser.setLongErrorCode(sts);
        respParser.setResponse();
        sess.sendResponseSMB(dcePkt);
        if (dcePkt.hasAssociatedPacket()) {
            if (sess.hasDebug(0x400000)) {
                Debug.println("[SMB] DCERPCHandler allocated associated packet, len=" + dcePkt.getAssociatedPacket().getBufferLength());
            }
            smbPkt.setAssociatedPacket(dcePkt.getAssociatedPacket());
            dcePkt.setAssociatedPacket(null);
        }
    }

    public static final void processDCERPCRequest(SMBSrvSession sess, VirtualCircuit vc, TransactBuffer tbuf, SMBSrvPacket smbPkt) throws IOException, SMBSrvException {
        if (!tbuf.hasSetupBuffer() || !tbuf.hasDataBuffer()) {
            sess.sendErrorResponseSMB(smbPkt, 64, 2);
            return;
        }
        int treeId = tbuf.getTreeId();
        TreeConnection conn = vc.findConnection(treeId);
        if (conn == null) {
            sess.sendErrorResponseSMB(smbPkt, 15, 1);
            return;
        }
        DataBuffer setupBuf = tbuf.getSetupBuffer();
        setupBuf.skipBytes(2);
        int fid = setupBuf.getShort();
        int maxData = tbuf.getReturnDataLimit() - 24;
        DCEPipeFile pipeFile = (DCEPipeFile)conn.findFile(fid);
        if (pipeFile == null) {
            sess.sendErrorResponseSMB(smbPkt, 6, 1);
            return;
        }
        DCEBuffer dceBuf = new DCEBuffer(tbuf);
        if (sess.hasDebug(65536)) {
            sess.debugPrintln("TransactNmPipe pipeFile=" + pipeFile.getName() + ", fid=" + fid + ", dceCmd=0x" + Integer.toHexString(dceBuf.getHeaderValue(2)));
        }
        DCERPCHandler.processDCEBuffer(sess, dceBuf, pipeFile, smbPkt);
        if (!pipeFile.hasBufferedData()) {
            return;
        }
        DCEBuffer txBuf = pipeFile.getBufferedData();
        DCESrvPacket dcePkt = new DCESrvPacket(smbPkt.getBuffer());
        SMBV1Parser parser = (SMBV1Parser)smbPkt.getParser();
        int flags = 3;
        dcePkt.initializeDCEReply();
        txBuf.setHeaderValue(3, flags);
        byte[] buf = dcePkt.getBuffer();
        int pos = DCEDataPacker.longwordAlign(parser.getByteOffset());
        int dataLen = txBuf.getLength();
        txBuf.setHeaderValue(5, dataLen);
        int len = txBuf.getLength();
        int sts = 0;
        if (len > maxData) {
            len = maxData + 24;
            dataLen = maxData + 24;
            sts = -2147483643;
        } else {
            pipeFile.setBufferedData(null);
        }
        int pktLen = parser.getByteOffset() + len + 4;
        if (smbPkt.getBufferLength() < pktLen) {
            SMBSrvPacket respPkt = sess.getPacketPool().allocatePacket(pktLen, smbPkt, parser.getByteOffset());
            buf = respPkt.getBuffer();
            dcePkt.setBuffer(buf);
            dcePkt.setParser(SMBSrvPacket.Version.V1);
            parser = (SMBV1Parser)dcePkt.getParser();
        }
        if (sess.hasDebug(65536)) {
            sess.debugPrintln("Reply DCEbuf flags=0x" + Integer.toHexString(flags) + ", len=" + len + ", status=0x" + Integer.toHexString(sts));
        }
        try {
            pos += txBuf.copyData(buf, pos, len);
        }
        catch (DCEBufferException ex) {
            sess.sendErrorResponseSMB(smbPkt, 65535, 2);
            return;
        }
        int byteLen = pos - parser.getByteOffset();
        parser.setParameter(1, dataLen);
        parser.setParameter(6, dataLen);
        parser.setByteCount(byteLen);
        parser.setFlags2(16384);
        parser.setLongErrorCode(sts);
        parser.setResponse();
        sess.sendResponseSMB(dcePkt);
        if (dcePkt.hasAssociatedPacket()) {
            if (sess.hasDebug(0x400000)) {
                Debug.println("[SMB] DCERPCHandler allocated associated packet, len=" + dcePkt.getAssociatedPacket().getBufferLength());
            }
            smbPkt.setAssociatedPacket(dcePkt.getAssociatedPacket());
            dcePkt.setAssociatedPacket(null);
        }
    }

    public static final void processDCERPCRequest(SMBSrvSession sess, SMBSrvPacket smbPkt) throws IOException, SMBSrvException {
        TreeConnection conn = sess.findTreeConnection(smbPkt);
        if (conn == null) {
            sess.sendErrorResponseSMB(smbPkt, 15, 1);
            return;
        }
        SMBV1Parser parser = (SMBV1Parser)smbPkt.getParser();
        int cmd = parser.getCommand();
        int fid = -1;
        fid = cmd == 11 ? parser.getParameter(0) : parser.getParameter(2);
        DCEPipeFile pipeFile = (DCEPipeFile)conn.findFile(fid);
        if (pipeFile == null) {
            sess.sendErrorResponseSMB(smbPkt, 6, 1);
            return;
        }
        DCEBuffer dceBuf = null;
        byte[] buf = parser.getBuffer();
        int pos = 0;
        int len = 0;
        if (cmd == 11) {
            pos = parser.getByteOffset();
            if (buf[pos++] != 1) {
                sess.sendErrorResponseSMB(smbPkt, 13, 1);
                return;
            }
            len = DataPacker.getIntelShort(buf, pos);
            pos += 2;
        } else {
            len = parser.getParameter(10);
            pos = parser.getParameter(11) + 4;
        }
        dceBuf = new DCEBuffer(buf, pos);
        if (sess.hasDebug(16384)) {
            sess.debugPrintln("Write pipeFile=" + pipeFile.getName() + ", fid=" + fid + ", dceCmd=0x" + Integer.toHexString(dceBuf.getHeaderValue(2)));
        }
        DCERPCHandler.processDCEBuffer(sess, dceBuf, pipeFile, smbPkt);
        int bufLen = 0;
        if (pipeFile.hasBufferedData()) {
            bufLen = pipeFile.getBufferedData().getLength();
        }
        if (cmd == 11) {
            parser.setParameterCount(1);
            parser.setParameter(0, len);
            parser.setByteCount(0);
        } else {
            parser.setParameterCount(6);
            parser.setAndXCommand(255);
            parser.setParameter(1, 0);
            parser.setParameter(2, len);
            parser.setParameter(3, bufLen);
            parser.setParameter(4, 0);
            parser.setParameter(5, 0);
            parser.setByteCount(0);
        }
        parser.setFlags2(16384);
        sess.sendResponseSMB(smbPkt);
    }

    public static final void processDCERPCRead(SMBSrvSession sess, SMBSrvPacket smbPkt) throws IOException, SMBSrvException {
        TreeConnection conn = sess.findTreeConnection(smbPkt);
        if (conn == null) {
            sess.sendErrorResponseSMB(smbPkt, 15, 1);
            return;
        }
        SMBV1Parser parser = (SMBV1Parser)smbPkt.getParser();
        int cmd = parser.getCommand();
        int fid = -1;
        int rdLen = -1;
        if (cmd == 10) {
            fid = parser.getParameter(0);
            rdLen = parser.getParameter(1);
        } else {
            fid = parser.getParameter(2);
            rdLen = parser.getParameter(5);
        }
        DCEPipeFile pipeFile = (DCEPipeFile)conn.findFile(fid);
        if (pipeFile == null) {
            sess.sendErrorResponseSMB(smbPkt, 6, 1);
            return;
        }
        if (sess.hasDebug(16384)) {
            sess.debugPrintln("Read pipeFile=" + pipeFile.getName() + ", fid=" + fid + ", rdLen=" + rdLen);
        }
        SMBSrvPacket respPkt = smbPkt;
        if (pipeFile.hasBufferedData()) {
            DCEBuffer bufData = pipeFile.getBufferedData();
            int bufLen = bufData.getAvailableLength();
            if (sess.hasDebug(16384)) {
                sess.debugPrintln("  Buffered data available=" + bufLen);
            }
            if (rdLen > bufLen) {
                rdLen = bufLen;
            }
            byte[] buf = parser.getBuffer();
            int pos = parser.getByteOffset();
            if (cmd == 10) {
                pos += 2;
            }
            if (rdLen > buf.length - pos) {
                respPkt = sess.getPacketPool().allocatePacket(rdLen + pos, smbPkt, pos);
                buf = respPkt.getBuffer();
                respPkt.setParser(SMBSrvPacket.Version.V1);
                parser = (SMBV1Parser)respPkt.getParser();
                if (sess.hasDebug(16384)) {
                    sess.debugPrintln("  Allocated larger reply packet, pktLen=" + respPkt.getBuffer().length);
                }
            }
            bufData.setHeaderValue(3, 3);
            bufData.setHeaderValue(5, bufData.getLength());
            if (cmd == 10) {
                parser.setParameterCount(5);
                parser.setParameter(0, rdLen);
                for (int i = 1; i < 5; ++i) {
                    parser.setParameter(i, 0);
                }
                parser.setByteCount(rdLen + 3);
                pos = parser.getByteOffset();
                buf[pos++] = 1;
                DataPacker.putIntelShort(rdLen, buf, pos);
                pos += 2;
                try {
                    bufData.copyData(buf, pos, rdLen);
                }
                catch (DCEBufferException ex) {
                    sess.debugPrintln(ex);
                }
            } else {
                parser.setParameterCount(12);
                parser.setAndXCommand(255);
                for (int i = 1; i < 12; ++i) {
                    parser.setParameter(i, 0);
                }
                pos = DCEDataPacker.longwordAlign(parser.getByteOffset());
                parser.setParameter(5, rdLen);
                parser.setParameter(6, pos - 4);
                parser.setByteCount(pos + rdLen - parser.getByteOffset());
                try {
                    bufData.copyData(buf, pos, rdLen);
                }
                catch (DCEBufferException ex) {
                    Debug.println(ex);
                }
            }
        } else {
            if (sess.hasDebug(16384)) {
                sess.debugPrintln("  No buffered data available");
            }
            if (cmd == 10) {
                parser.setParameterCount(5);
                for (int i = 0; i < 5; ++i) {
                    parser.setParameter(i, 0);
                }
                parser.setByteCount(0);
            } else {
                parser.setParameterCount(12);
                parser.setAndXCommand(255);
                for (int i = 1; i < 12; ++i) {
                    parser.setParameter(i, 0);
                }
                parser.setByteCount(0);
            }
        }
        parser.setLongErrorCode(0);
        parser.setFlags2(16384);
        sess.sendResponseSMB(respPkt);
    }

    public static final void processDCEBuffer(SMBSrvSession sess, DCEBuffer dceBuf, DCEPipeFile pipeFile, SMBSrvPacket smbPkt) throws IOException, SMBSrvException {
        switch (dceBuf.getHeaderValue(2)) {
            case 11: {
                DCERPCHandler.procDCEBind(sess, dceBuf, pipeFile, smbPkt);
                break;
            }
            case 0: {
                DCERPCHandler.procDCERequest(sess, dceBuf, pipeFile, smbPkt);
                break;
            }
            default: {
                throw new SMBSrvException(-1073741790, 4, 2);
            }
        }
    }

    public static final void procDCEBind(SMBSrvSession sess, DCEBuffer dceBuf, DCEPipeFile pipeFile, SMBSrvPacket smbPkt) throws IOException, SMBSrvException {
        try {
            if (sess.hasDebug(65536)) {
                sess.debugPrintln("DCE Bind");
            }
            int callId = dceBuf.getHeaderValue(7);
            dceBuf.skipBytes(16);
            int maxTxSize = dceBuf.getShort();
            int maxRxSize = dceBuf.getShort();
            int groupId = dceBuf.getInt();
            int ctxElems = dceBuf.getByte(0);
            dceBuf.skipBytes(2);
            int presCtxId = dceBuf.getShort();
            int trfSyntax = dceBuf.getShort();
            UUID uuid1 = dceBuf.getUUID(true);
            UUID uuid2 = dceBuf.getUUID(true);
            if (sess.hasDebug(65536)) {
                sess.debugPrintln("Bind: maxTx=" + maxTxSize + ", maxRx=" + maxRxSize + ", groupId=" + groupId + ", ctxElems=" + ctxElems + ", presCtxId=" + presCtxId + ", trfSyntax=" + trfSyntax);
                sess.debugPrintln("      uuid1=" + uuid1.toString());
                sess.debugPrintln("      uuid2=" + uuid2.toString());
            }
            pipeFile.setMaxTransmitFragmentSize(maxTxSize);
            pipeFile.setMaxReceiveFragmentSize(maxRxSize);
            DCEBuffer txBuf = new DCEBuffer();
            txBuf.putBindAckHeader(dceBuf.getHeaderValue(7));
            txBuf.setHeaderValue(3, 3);
            txBuf.putShort(maxTxSize);
            txBuf.putShort(maxRxSize);
            txBuf.putInt(21488);
            String srvPipeName = DCEPipeType.getServerPipeName(pipeFile.getPipeId());
            txBuf.putShort(srvPipeName.length() + 1);
            txBuf.putASCIIString(srvPipeName, true, 1);
            txBuf.putInt(1);
            txBuf.putShort(0);
            txBuf.putShort(0);
            txBuf.putUUID(uuid2, true);
            txBuf.setHeaderValue(5, txBuf.getLength());
            pipeFile.setBufferedData(txBuf);
        }
        catch (DCEBufferException ex) {
            throw new SMBSrvException(-1073741637, 65535, 2);
        }
    }

    public static final void procDCERequest(SMBSrvSession sess, DCEBuffer inBuf, DCEPipeFile pipeFile, SMBSrvPacket smbPkt) throws IOException, SMBSrvException {
        if (sess.hasDebug(65536)) {
            sess.debugPrintln("DCE Request opNum=0x" + Integer.toHexString(inBuf.getHeaderValue(9)));
        }
        if (!pipeFile.hasRequestHandler()) {
            throw new SMBSrvException(-1073741790, 4, 2);
        }
        pipeFile.getRequestHandler().processRequest(sess, inBuf, pipeFile, smbPkt);
    }
}

