/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.smb.server;

import org.filesys.smb.DialectSelector;
import org.filesys.smb.server.ParserFactory;
import org.filesys.smb.server.SMBParser;
import org.filesys.smb.server.SMBSrvPacket;
import org.filesys.smb.server.SMBV1Parser;
import org.filesys.smb.server.UnsupportedSMBVersionException;

public class DefaultParserFactory
implements ParserFactory {
    private static DialectSelector _supportedDialects = new DialectSelector();

    @Override
    public SMBParser createParser(SMBSrvPacket.Version smbVer, byte[] buf, int len) throws UnsupportedSMBVersionException {
        if (smbVer == SMBSrvPacket.Version.V1) {
            return new SMBV1Parser(buf, len);
        }
        throw new UnsupportedSMBVersionException();
    }

    @Override
    public DialectSelector getSupportedDialects() {
        return _supportedDialects;
    }

    static {
        _supportedDialects.enableUpTo(8);
    }
}

