/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.smb.server;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.filesys.server.filesys.DiskOfflineException;
import org.filesys.server.filesys.FileInfo;
import org.filesys.server.filesys.NetworkFile;
import org.filesys.server.filesys.PathNotFoundException;
import org.filesys.server.filesys.TooManyFilesException;
import org.filesys.server.filesys.TreeConnection;
import org.filesys.server.filesys.UnsupportedInfoLevelException;
import org.filesys.smb.dcerpc.DCEPipeType;
import org.filesys.smb.dcerpc.server.DCEPipeFile;
import org.filesys.smb.dcerpc.server.DCEPipeHandler;
import org.filesys.smb.server.DCERPCHandler;
import org.filesys.smb.server.NTParameterPacker;
import org.filesys.smb.server.NamedPipeTransaction;
import org.filesys.smb.server.PipeLanmanHandler;
import org.filesys.smb.server.QueryInfoPacker;
import org.filesys.smb.server.SMBSrvException;
import org.filesys.smb.server.SMBSrvPacket;
import org.filesys.smb.server.SMBSrvSession;
import org.filesys.smb.server.SMBSrvTransPacket;
import org.filesys.smb.server.SMBV1;
import org.filesys.smb.server.SMBV1Parser;
import org.filesys.smb.server.SrvTransactBuffer;
import org.filesys.smb.server.VirtualCircuit;
import org.filesys.util.DataBuffer;
import org.filesys.util.DataPacker;

class IPCHandler {
    IPCHandler() {
    }

    public static void processIPCRequest(SMBSrvSession sess, SMBSrvPacket smbPkt) throws IOException, SMBSrvException {
        TreeConnection conn = sess.findTreeConnection(smbPkt);
        if (conn == null) {
            sess.sendErrorResponseSMB(smbPkt, 15, 1);
            return;
        }
        SMBV1Parser parser = (SMBV1Parser)smbPkt.getParser();
        if (sess.hasDebug(16384)) {
            sess.debugPrintln("IPC$ Request [" + parser.getTreeId() + "] - cmd = " + SMBV1.getPacketTypeString(parser.getCommand()));
        }
        switch (parser.getCommand()) {
            case 2: 
            case 45: {
                IPCHandler.procIPCFileOpen(sess, smbPkt, parser);
                break;
            }
            case 10: {
                IPCHandler.procIPCFileRead(sess, smbPkt, parser);
                break;
            }
            case 46: {
                IPCHandler.procIPCFileReadAndX(sess, smbPkt, parser);
                break;
            }
            case 11: {
                IPCHandler.procIPCFileWrite(sess, smbPkt, parser);
                break;
            }
            case 47: {
                IPCHandler.procIPCFileWriteAndX(sess, smbPkt, parser);
                break;
            }
            case 4: {
                IPCHandler.procIPCFileClose(sess, smbPkt, parser);
                break;
            }
            case 162: {
                IPCHandler.procNTCreateAndX(sess, smbPkt, parser);
                break;
            }
            default: {
                sess.sendErrorResponseSMB(smbPkt, 64, 2);
            }
        }
    }

    protected static void procTransaction(VirtualCircuit vc, SrvTransactBuffer tbuf, SMBSrvSession sess, SMBSrvPacket smbPkt) throws IOException, SMBSrvException {
        if (sess.hasDebug(16384)) {
            sess.debugPrintln("IPC$ Transaction  pipe=" + tbuf.getName() + ", subCmd=" + NamedPipeTransaction.getSubCommand(tbuf.getFunction()));
        }
        if (tbuf.getName().compareTo("\\PIPE\\LANMAN") == 0 && PipeLanmanHandler.processRequest(tbuf, sess, smbPkt)) {
            return;
        }
        switch (tbuf.getFunction()) {
            case 1: {
                IPCHandler.procSetNamedPipeHandleState(sess, vc, tbuf, smbPkt);
                break;
            }
            case 38: {
                DCERPCHandler.processDCERPCRequest(sess, vc, tbuf, smbPkt);
                break;
            }
            case 7: {
                IPCHandler.procTrans2QueryFile(sess, vc, tbuf, smbPkt);
                break;
            }
            case 83: {
                sess.sendErrorResponseSMB(smbPkt, -1073741637, 65535, 2);
                break;
            }
            default: {
                sess.sendErrorResponseSMB(smbPkt, 64, 2);
            }
        }
    }

    protected static void procIPCFileOpen(SMBSrvSession sess, SMBSrvPacket smbPkt, SMBV1Parser parser) throws IOException, SMBSrvException {
        DCEPipeType pipeType;
        int dataPos = parser.getByteOffset();
        int dataLen = parser.getByteCount();
        byte[] buf = parser.getBuffer();
        String fileName = DataPacker.getString(buf, dataPos, dataLen);
        if (sess.hasDebug(16384)) {
            sess.debugPrintln("IPC$ Open file = " + fileName);
        }
        if ((pipeType = DCEPipeType.getNameAsType(fileName)) == DCEPipeType.PIPE_INVALID) {
            sess.sendErrorResponseSMB(smbPkt, 2, 1);
            return;
        }
        TreeConnection conn = sess.findTreeConnection(smbPkt);
        if (conn == null) {
            sess.sendErrorResponseSMB(smbPkt, 5, 2);
            return;
        }
        DCEPipeFile pipeFile = new DCEPipeFile(pipeType);
        pipeFile.setGrantedAccess(NetworkFile.Access.READ_WRITE);
        int fid = -1;
        try {
            fid = conn.addFile(pipeFile, sess);
        }
        catch (TooManyFilesException ex) {
            sess.sendErrorResponseSMB(smbPkt, 4, 1);
            return;
        }
        parser.setParameterCount(15);
        parser.setAndXCommand(255);
        parser.setParameter(1, 0);
        parser.setParameter(2, fid);
        parser.setParameter(3, 0);
        parser.setParameter(4, 0);
        parser.setParameter(5, 0);
        parser.setParameterLong(6, 0);
        parser.setParameter(8, 0);
        parser.setParameter(9, 0);
        parser.setParameter(10, 0);
        parser.setParameter(11, 0);
        parser.setParameter(12, 0);
        parser.setParameter(13, 0);
        parser.setParameter(14, 0);
        parser.setByteCount(0);
        sess.sendResponseSMB(smbPkt);
    }

    protected static void procIPCFileRead(SMBSrvSession sess, SMBSrvPacket smbPkt, SMBV1Parser parser) throws IOException, SMBSrvException {
        if (!parser.checkPacketIsValid(5, 0)) {
            sess.sendErrorResponseSMB(smbPkt, 64, 2);
            return;
        }
        if (sess.hasDebug(16384)) {
            sess.debugPrintln("IPC$ File Read");
        }
        DCERPCHandler.processDCERPCRead(sess, smbPkt);
    }

    protected static void procIPCFileReadAndX(SMBSrvSession sess, SMBSrvPacket smbPkt, SMBV1Parser parser) throws IOException, SMBSrvException {
        if (!parser.checkPacketIsValid(10, 0)) {
            sess.sendErrorResponseSMB(smbPkt, 64, 2);
            return;
        }
        if (sess.hasDebug(16384)) {
            sess.debugPrintln("IPC$ File Read AndX");
        }
        DCERPCHandler.processDCERPCRead(sess, smbPkt);
    }

    protected static void procIPCFileWrite(SMBSrvSession sess, SMBSrvPacket smbPkt, SMBV1Parser parser) throws IOException, SMBSrvException {
        if (!parser.checkPacketIsValid(5, 0)) {
            sess.sendErrorResponseSMB(smbPkt, 64, 2);
            return;
        }
        if (sess.hasDebug(16384)) {
            sess.debugPrintln("IPC$ File Write");
        }
        DCERPCHandler.processDCERPCRequest(sess, smbPkt);
    }

    protected static void procIPCFileWriteAndX(SMBSrvSession sess, SMBSrvPacket smbPkt, SMBV1Parser parser) throws IOException, SMBSrvException {
        if (!parser.checkPacketIsValid(12, 0)) {
            sess.sendErrorResponseSMB(smbPkt, 64, 2);
            return;
        }
        if (sess.hasDebug(16384)) {
            sess.debugPrintln("IPC$ File Write AndX");
        }
        DCERPCHandler.processDCERPCRequest(sess, smbPkt);
    }

    protected static void procIPCFileClose(SMBSrvSession sess, SMBSrvPacket smbPkt, SMBV1Parser parser) throws IOException, SMBSrvException {
        if (!parser.checkPacketIsValid(3, 0)) {
            sess.sendErrorResponseSMB(smbPkt, 64, 2);
            return;
        }
        TreeConnection conn = sess.findTreeConnection(smbPkt);
        if (conn == null) {
            sess.sendErrorResponseSMB(smbPkt, 15, 1);
            return;
        }
        int fid = parser.getParameter(0);
        DCEPipeFile netFile = (DCEPipeFile)conn.findFile(fid);
        if (netFile == null) {
            sess.sendErrorResponseSMB(smbPkt, 6, 1);
            return;
        }
        if (sess.hasDebug(16384)) {
            sess.debugPrintln("IPC$ File close [" + parser.getTreeId() + "] fid=" + fid);
        }
        conn.removeFile(fid, sess);
        parser.setParameterCount(0);
        parser.setByteCount(0);
        sess.sendResponseSMB(smbPkt);
    }

    protected static void procSetNamedPipeHandleState(SMBSrvSession sess, VirtualCircuit vc, SrvTransactBuffer tbuf, SMBSrvPacket smbPkt) throws IOException, SMBSrvException {
        DataBuffer setupBuf = tbuf.getSetupBuffer();
        setupBuf.skipBytes(2);
        int fid = setupBuf.getShort();
        DataBuffer paramBuf = tbuf.getParameterBuffer();
        int state = paramBuf.getShort();
        TreeConnection conn = vc.findConnection(tbuf.getTreeId());
        DCEPipeFile netFile = (DCEPipeFile)conn.findFile(fid);
        if (netFile == null) {
            sess.sendErrorResponseSMB(smbPkt, 6, 1);
            return;
        }
        if (sess.hasDebug(16384)) {
            sess.debugPrintln("  SetNmPHandState pipe=" + netFile.getName() + ", fid=" + fid + ", state=0x" + Integer.toHexString(state));
        }
        netFile.setPipeState(state);
        SMBSrvTransPacket.initTransactReply(smbPkt, 0, 0, 0, 0);
        sess.sendResponseSMB(smbPkt);
    }

    protected static void procNTCreateAndX(SMBSrvSession sess, SMBSrvPacket smbPkt, SMBV1Parser parser) throws IOException, SMBSrvException {
        DCEPipeType pipeType;
        TreeConnection conn = sess.findTreeConnection(smbPkt);
        if (conn == null) {
            sess.sendErrorResponseSMB(smbPkt, -1073741811, 6);
            return;
        }
        NTParameterPacker prms = new NTParameterPacker(parser.getBuffer(), 42);
        int nameLen = prms.unpackWord();
        int flags = prms.unpackInt();
        int rootFID = prms.unpackInt();
        int accessMask = prms.unpackInt();
        long allocSize = prms.unpackLong();
        int attrib = prms.unpackInt();
        int shrAccess = prms.unpackInt();
        int createDisp = prms.unpackInt();
        int createOptn = prms.unpackInt();
        int impersonLev = prms.unpackInt();
        int secFlags = prms.unpackByte();
        int pos = DataPacker.wordAlign(parser.getByteOffset());
        String fileName = DataPacker.getUnicodeString(parser.getBuffer(), pos, nameLen);
        if (fileName == null) {
            sess.sendErrorResponseSMB(smbPkt, -1073741811, 6);
            return;
        }
        if (sess.hasDebug(16384)) {
            sess.debugPrintln("NT Create AndX [" + parser.getTreeId() + "] name=" + fileName + ", flags=0x" + Integer.toHexString(flags) + ", attr=0x" + Integer.toHexString(attrib) + ", allocSize=" + allocSize);
        }
        if (!fileName.startsWith("\\PIPE")) {
            fileName = "\\PIPE" + fileName;
        }
        if ((pipeType = DCEPipeType.getNameAsType(fileName)) == DCEPipeType.PIPE_INVALID) {
            sess.sendErrorResponseSMB(smbPkt, -1073741772, 6);
            return;
        }
        if (DCEPipeHandler.getHandlerForType(pipeType) == null) {
            sess.sendErrorResponseSMB(smbPkt, -1073741790, 6);
            return;
        }
        DCEPipeFile pipeFile = new DCEPipeFile(pipeType);
        pipeFile.setGrantedAccess(NetworkFile.Access.READ_WRITE);
        int fid = -1;
        try {
            fid = conn.addFile(pipeFile, sess);
        }
        catch (TooManyFilesException ex) {
            sess.sendErrorResponseSMB(smbPkt, 6, 6);
            return;
        }
        boolean extendedResponse = (flags & 0x10) != 0;
        parser.setParameterCount(extendedResponse ? 42 : 34);
        prms.reset(parser.getBuffer(), 41);
        prms.packByte(0);
        prms.packWord(fid);
        prms.packInt(1);
        prms.packLong(0L);
        prms.packLong(0L);
        prms.packLong(0L);
        prms.packLong(0L);
        prms.packInt(128);
        prms.packLong(0L);
        prms.packLong(0L);
        prms.packWord(2);
        prms.packByte(255);
        prms.packByte(5);
        prms.packByte(0);
        prms.packWord(0);
        if (extendedResponse) {
            prms.packLong(0L);
            prms.packLong(0L);
            prms.packInt(0);
            prms.packWord(0);
            prms.packInt(0x1F01FF);
            prms.packInt(1180059);
            prms.packInt(0);
        }
        int endPos = prms.getPosition();
        parser.setParameter(1, endPos - 4);
        parser.setLongErrorCode(0);
        sess.sendResponseSMB(smbPkt, endPos - 4);
    }

    protected static final void procTrans2QueryFile(SMBSrvSession sess, VirtualCircuit vc, SrvTransactBuffer tbuf, SMBSrvPacket smbPkt) throws IOException, SMBSrvException {
        int treeId = tbuf.getTreeId();
        TreeConnection conn = vc.findConnection(treeId);
        if (conn == null) {
            sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
            return;
        }
        if (!conn.hasReadAccess()) {
            sess.sendErrorResponseSMB(smbPkt, -1073741790, 5, 1);
            return;
        }
        DataBuffer paramBuf = tbuf.getParameterBuffer();
        int fid = paramBuf.getShort();
        int infoLevl = paramBuf.getShort();
        NetworkFile netFile = conn.findFile(fid);
        if (netFile == null) {
            sess.sendErrorResponseSMB(smbPkt, 6, 1);
            return;
        }
        if (sess.hasDebug(16384)) {
            sess.debugPrintln("IPC$ Query File - level=0x" + Integer.toHexString(infoLevl) + ", fid=" + fid + ", name=" + netFile.getFullName());
        }
        try {
            SMBV1Parser parser = (SMBV1Parser)smbPkt.getParser();
            parser.setParameterCount(10);
            byte[] buf = parser.getBuffer();
            int prmPos = DataPacker.longwordAlign(parser.getByteOffset());
            int dataPos = prmPos + 4;
            parser.setPosition(prmPos);
            parser.packWord(0);
            DataBuffer replyBuf = new DataBuffer(buf, dataPos, buf.length - dataPos);
            FileInfo fileInfo = new FileInfo(netFile.getName(), netFile.getFileSize(), netFile.getFileAttributes());
            fileInfo.setAccessDateTime(netFile.getAccessDate());
            fileInfo.setCreationDateTime(netFile.getCreationDate());
            fileInfo.setModifyDateTime(netFile.getModifyDate());
            fileInfo.setChangeDateTime(netFile.getModifyDate());
            fileInfo.setFileId(netFile.getFileId());
            fileInfo.setAllocationSize(4096L);
            int dataLen = QueryInfoPacker.packInfo(fileInfo, replyBuf, infoLevl, true);
            if (dataLen == 0) {
                sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
                return;
            }
            SMBSrvTransPacket.initTransactReply(smbPkt, 2, prmPos, dataLen, dataPos);
            parser.setByteCount(replyBuf.getPosition() - parser.getByteOffset());
            sess.sendResponseSMB(smbPkt);
        }
        catch (FileNotFoundException ex) {
            sess.sendErrorResponseSMB(smbPkt, -1073741772, 2, 1);
            return;
        }
        catch (PathNotFoundException ex) {
            sess.sendErrorResponseSMB(smbPkt, -1073741766, 2, 1);
            return;
        }
        catch (UnsupportedInfoLevelException ex) {
            sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
            return;
        }
        catch (DiskOfflineException ex) {
            sess.sendErrorResponseSMB(smbPkt, -1073741766, 21, 3);
        }
    }
}

