/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.smb.server;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.filesys.debug.Debug;
import org.filesys.server.auth.ClientInfo;
import org.filesys.server.auth.ISMBAuthenticator;
import org.filesys.server.auth.InvalidUserException;
import org.filesys.server.config.GlobalConfigSection;
import org.filesys.server.core.InvalidDeviceInterfaceException;
import org.filesys.server.core.ShareType;
import org.filesys.server.core.SharedDevice;
import org.filesys.server.filesys.AccessDeniedException;
import org.filesys.server.filesys.DiskDeviceContext;
import org.filesys.server.filesys.DiskInterface;
import org.filesys.server.filesys.FileAction;
import org.filesys.server.filesys.FileInfo;
import org.filesys.server.filesys.FileOfflineException;
import org.filesys.server.filesys.FileOpenParams;
import org.filesys.server.filesys.FileSharingException;
import org.filesys.server.filesys.FileStatus;
import org.filesys.server.filesys.NetworkFile;
import org.filesys.server.filesys.PathNotFoundException;
import org.filesys.server.filesys.SearchContext;
import org.filesys.server.filesys.SrvDiskInfo;
import org.filesys.server.filesys.TooManyConnectionsException;
import org.filesys.server.filesys.TooManyFilesException;
import org.filesys.server.filesys.TooManySearchesException;
import org.filesys.server.filesys.TreeConnection;
import org.filesys.server.filesys.UnsupportedInfoLevelException;
import org.filesys.server.filesys.VolumeInfo;
import org.filesys.smb.InvalidUNCPathException;
import org.filesys.smb.PCShare;
import org.filesys.smb.SMBDate;
import org.filesys.smb.server.CoreProtocolHandler;
import org.filesys.smb.server.DiskInfoPacker;
import org.filesys.smb.server.FindInfoPacker;
import org.filesys.smb.server.IPCHandler;
import org.filesys.smb.server.QueryInfoPacker;
import org.filesys.smb.server.SMBSrvException;
import org.filesys.smb.server.SMBSrvPacket;
import org.filesys.smb.server.SMBSrvSession;
import org.filesys.smb.server.SMBSrvTransPacket;
import org.filesys.smb.server.SMBV1Parser;
import org.filesys.smb.server.SessionState;
import org.filesys.smb.server.SrvTransactBuffer;
import org.filesys.smb.server.VirtualCircuit;
import org.filesys.smb.server.ntfs.NTFSStreamsInterface;
import org.filesys.smb.server.ntfs.StreamInfoList;
import org.filesys.util.DataBuffer;
import org.filesys.util.DataPacker;
import org.filesys.util.WildCard;

class LanManProtocolHandler
extends CoreProtocolHandler {
    protected static final int LockShared = 1;
    protected static final int LockOplockRelease = 2;
    protected static final int LockChangeType = 4;
    protected static final int LockCancel = 8;
    protected static final int LockLargeFiles = 16;
    public static final long DotFileDateTime = System.currentTimeMillis();

    protected LanManProtocolHandler() {
    }

    protected LanManProtocolHandler(SMBSrvSession sess) {
        super(sess);
    }

    @Override
    public String getName() {
        return "LanMan";
    }

    protected final int procAndXCommands(SMBSrvPacket smbPkt, NetworkFile file) {
        SMBSrvPacket respPkt = smbPkt.getAssociatedPacket();
        if (respPkt == null) {
            throw new RuntimeException("No response packet allocated for AndX request");
        }
        SMBV1Parser parser = (SMBV1Parser)smbPkt.getParser();
        int andxCmd = parser.getAndXCommand();
        int andxOff = parser.getParameter(1) + 4;
        respPkt.setParser(SMBSrvPacket.Version.V1);
        SMBV1Parser respParser = (SMBV1Parser)respPkt.getParser();
        respParser.setAndXCommand(andxCmd);
        respParser.setParameter(1, andxOff - 4);
        int paramBlk = 36;
        int endOfPkt = respParser.getByteOffset() + respParser.getByteCount();
        boolean andxErr = false;
        while (andxCmd != 255 && !andxErr) {
            int prevEndOfPkt = endOfPkt;
            switch (andxCmd) {
                case 117: {
                    endOfPkt = this.procChainedTreeConnectAndX(andxOff, smbPkt, respPkt, endOfPkt);
                    break;
                }
                case 4: {
                    endOfPkt = this.procChainedClose(andxOff, smbPkt, respPkt, endOfPkt);
                    break;
                }
                case 46: {
                    endOfPkt = this.procChainedReadAndX(andxOff, smbPkt, respPkt, endOfPkt, file);
                }
            }
            andxCmd = parser.getAndXParameter(andxOff, 0) & 0xFF;
            andxOff = parser.getAndXParameter(andxOff, 1);
            respParser.setAndXCommand(prevEndOfPkt, andxCmd);
            respParser.setAndXParameter(paramBlk, 1, prevEndOfPkt - 4);
            paramBlk = prevEndOfPkt;
            if (respParser.getErrorCode() == 0) continue;
            andxErr = true;
        }
        return endOfPkt;
    }

    protected final int procChainedTreeConnectAndX(int cmdOff, SMBSrvPacket smbPkt, SMBSrvPacket respPkt, int endOff) {
        String uncPath;
        SMBV1Parser reqParser = (SMBV1Parser)smbPkt.getParser();
        SMBV1Parser respParser = (SMBV1Parser)respPkt.getParser();
        int flags = reqParser.getAndXParameter(cmdOff, 2);
        int pwdLen = reqParser.getAndXParameter(cmdOff, 3);
        VirtualCircuit vc = this.m_sess.findVirtualCircuit(respParser.getUserId());
        if (vc == null) {
            respParser.setError(reqParser.isLongErrorCode(), -1073741811, 1, 2);
            return endOff;
        }
        int dataPos = reqParser.getAndXByteOffset(cmdOff);
        int dataLen = reqParser.getAndXByteCount(cmdOff);
        byte[] buf = reqParser.getBuffer();
        String pwd = null;
        if (pwdLen > 0) {
            pwd = new String(buf, dataPos, pwdLen);
            dataPos += pwdLen;
            dataLen -= pwdLen;
        }
        if ((uncPath = DataPacker.getString(buf, dataPos, dataLen)) == null) {
            respParser.setError(13, 1);
            return endOff;
        }
        String service = DataPacker.getString(buf, dataPos += uncPath.length() + 1, dataLen -= uncPath.length() + 1);
        if (service == null) {
            respParser.setError(13, 1);
            return endOff;
        }
        ShareType servType = ShareType.ServiceAsType(service);
        if (servType == ShareType.UNKNOWN && service.compareTo("?????") != 0) {
            respParser.setError(13, 1);
            return endOff;
        }
        if (this.m_sess.hasDebug(64)) {
            this.m_sess.debugPrintln("ANDX Tree Connect AndX - " + uncPath + ", " + service);
        }
        PCShare share = null;
        try {
            share = new PCShare(uncPath);
        }
        catch (InvalidUNCPathException ex) {
            respParser.setError(13, 1);
            return endOff;
        }
        if (share.getShareName().compareTo("IPC$") == 0) {
            servType = ShareType.ADMINPIPE;
        }
        SharedDevice shareDev = null;
        try {
            shareDev = this.m_sess.getSMBServer().findShare(share.getNodeName(), share.getShareName(), servType, this.getSession(), true);
        }
        catch (InvalidUserException ex) {
            respParser.setError(5, 1);
            return endOff;
        }
        catch (Exception ex) {
            respParser.setError(6, 2);
            return endOff;
        }
        if (shareDev == null || servType != ShareType.UNKNOWN && shareDev.getType() != servType) {
            respParser.setError(15, 1);
            return endOff;
        }
        ISMBAuthenticator auth = this.getSession().getSMBServer().getSMBAuthenticator();
        ISMBAuthenticator.ShareStatus sharePerm = ISMBAuthenticator.ShareStatus.WRITEABLE;
        if (auth != null && auth.getAccessMode() == ISMBAuthenticator.AuthMode.SHARE && (sharePerm = auth.authenticateShareConnect(this.m_sess.getClientInformation(), shareDev, pwd, this.m_sess)) == ISMBAuthenticator.ShareStatus.NO_ACCESS) {
            respParser.setError(5, 1);
            return endOff;
        }
        try {
            int treeId = vc.addConnection(shareDev);
            respParser.setTreeId(treeId);
            TreeConnection tree = vc.findConnection(treeId);
            tree.setPermission(sharePerm);
            if (tree.getInterface() != null) {
                tree.getInterface().treeOpened(this.m_sess, tree);
            }
            if (this.m_sess.hasDebug(64)) {
                this.m_sess.debugPrintln("ANDX Tree Connect AndX - Allocated Tree Id = " + treeId);
            }
        }
        catch (TooManyConnectionsException ex) {
            respParser.setError(89, 2);
            return endOff;
        }
        respParser.setAndXParameterCount(endOff, 2);
        respParser.setAndXParameter(endOff, 0, 255);
        respParser.setAndXParameter(endOff, 1, 0);
        int pos = respParser.getAndXByteOffset(endOff);
        byte[] outBuf = respPkt.getBuffer();
        pos = DataPacker.putString(ShareType.TypeAsService(shareDev.getType()), outBuf, pos, true);
        int bytLen = pos - respParser.getAndXByteOffset(endOff);
        respParser.setAndXByteCount(endOff, bytLen);
        return pos;
    }

    protected final int procChainedReadAndX(int cmdOff, SMBSrvPacket smbPkt, SMBSrvPacket respPkt, int endOff, NetworkFile netFile) {
        SMBV1Parser reqParser = (SMBV1Parser)smbPkt.getParser();
        SMBV1Parser respParser = (SMBV1Parser)respPkt.getParser();
        TreeConnection conn = this.m_sess.findTreeConnection(smbPkt);
        if (conn == null) {
            respParser.setError(15, 1);
            return endOff;
        }
        long offset = reqParser.getAndXParameterLong(cmdOff, 3);
        offset &= 0xFFFFFFFFL;
        int maxCount = reqParser.getAndXParameter(cmdOff, 5);
        if (reqParser.getAndXParameterCount(cmdOff) == 12) {
            long topOff = reqParser.getAndXParameterLong(cmdOff, 10);
            offset += topOff << 32;
        }
        if (this.m_sess.hasDebug(512)) {
            Debug.println("Chained File Read AndX : Size=" + maxCount + " ,Pos=" + offset);
        }
        byte[] buf = respPkt.getBuffer();
        int dataPos = 0;
        int rdlen = 0;
        try {
            DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
            respParser.setAndXParameterCount(endOff, 12);
            dataPos = respParser.getAndXByteOffset(endOff);
            dataPos = DataPacker.wordAlign(dataPos);
            int dataLen = buf.length - dataPos;
            if (dataLen < maxCount) {
                maxCount = dataLen;
            }
            rdlen = disk.readFile(this.m_sess, conn, netFile, buf, dataPos, maxCount, offset);
            respParser.setAndXParameter(endOff, 0, 255);
            respParser.setAndXParameter(endOff, 1, 0);
            respParser.setAndXParameter(endOff, 2, 65535);
            respParser.setAndXParameter(endOff, 3, 0);
            respParser.setAndXParameter(endOff, 4, 0);
            respParser.setAndXParameter(endOff, 5, rdlen);
            respParser.setAndXParameter(endOff, 6, dataPos - 4);
            for (int i = 7; i < 12; ++i) {
                respParser.setAndXParameter(endOff, i, 0);
            }
            respParser.setAndXByteCount(endOff, dataPos + rdlen - respParser.getAndXByteOffset(endOff));
            endOff = dataPos + rdlen;
        }
        catch (InvalidDeviceInterfaceException ex) {
            respParser.setError(13, 1);
            return endOff;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return endOff;
    }

    protected final int procChainedClose(int cmdOff, SMBSrvPacket smbPkt, SMBSrvPacket respPkt, int endOff) {
        SMBV1Parser reqParser = (SMBV1Parser)smbPkt.getParser();
        SMBV1Parser respParser = (SMBV1Parser)respPkt.getParser();
        TreeConnection conn = this.m_sess.findTreeConnection(smbPkt);
        if (conn == null) {
            respParser.setError(15, 1);
            return endOff;
        }
        int fid = reqParser.getAndXParameter(cmdOff, 0);
        NetworkFile netFile = conn.findFile(fid);
        if (netFile == null) {
            respParser.setError(15, 1);
            return endOff;
        }
        if (this.m_sess.hasDebug(512)) {
            Debug.println("Chained File Close [" + reqParser.getTreeId() + "] fid=" + fid);
        }
        try {
            DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
            if (disk != null) {
                disk.closeFile(this.m_sess, conn, netFile);
            }
            netFile.setClosed(true);
        }
        catch (InvalidDeviceInterfaceException ex) {
            respParser.setError(13, 1);
            return endOff;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        respParser.setAndXParameterCount(endOff, 0);
        respParser.setAndXByteCount(endOff, 0);
        endOff = respParser.getAndXByteOffset(endOff) - 4;
        conn.removeFile(fid, this.getSession());
        return endOff;
    }

    protected final void procFindClose(SMBSrvPacket smbPkt, SMBV1Parser parser) throws IOException, SMBSrvException {
        if (!parser.checkPacketIsValid(1, 0)) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 64, 2);
            return;
        }
        VirtualCircuit vc = this.m_sess.findVirtualCircuit(parser.getUserId());
        if (vc == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
            return;
        }
        int treeId = parser.getTreeId();
        TreeConnection conn = vc.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 5, 2);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741790, 5, 1);
            return;
        }
        int searchId = parser.getParameter(0);
        SearchContext ctx = vc.getSearchContext(searchId);
        if (ctx == null) {
            this.m_sess.sendSuccessResponseSMB(smbPkt);
            return;
        }
        if (this.m_sess.hasDebug(128)) {
            this.m_sess.debugPrintln("Close trans search [" + searchId + "]");
        }
        vc.deallocateSearchSlot(searchId);
        this.m_sess.sendSuccessResponseSMB(smbPkt);
    }

    protected final void procLockingAndX(SMBSrvPacket smbPkt, SMBV1Parser parser) throws IOException, SMBSrvException {
        if (!parser.checkPacketIsValid(8, 0)) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 64, 2);
            return;
        }
        VirtualCircuit vc = this.m_sess.findVirtualCircuit(parser.getUserId());
        if (vc == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
            return;
        }
        int treeId = parser.getTreeId();
        TreeConnection conn = vc.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 5, 2);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741790, 5, 1);
            return;
        }
        int fid = parser.getParameter(2);
        int lockType = parser.getParameter(3);
        long lockTmo = parser.getParameterLong(4);
        int lockCnt = parser.getParameter(6);
        int unlockCnt = parser.getParameter(7);
        NetworkFile netFile = conn.findFile(fid);
        if (netFile == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 6, 1);
            return;
        }
        if (this.m_sess.hasDebug(32768)) {
            this.m_sess.debugPrintln("File Lock [" + netFile.getFileId() + "] : type=0x" + Integer.toHexString(lockType) + ", tmo=" + lockTmo + ", locks=" + lockCnt + ", unlocks=" + unlockCnt);
        }
        parser.setParameterCount(2);
        parser.setAndXCommand(255);
        parser.setParameter(1, 0);
        parser.setByteCount(0);
        this.m_sess.sendResponseSMB(smbPkt);
    }

    protected final void procLogoffAndX(SMBSrvPacket smbPkt, SMBV1Parser parser) throws IOException, SMBSrvException {
        if (!parser.checkPacketIsValid(2, 0)) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
            return;
        }
        int uid = parser.getUserId();
        VirtualCircuit vc = this.m_sess.findVirtualCircuit(uid);
        if (vc == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
            return;
        }
        if (this.m_sess.hasDebug(32)) {
            Debug.println("[SMB] Logoff vc=" + vc);
        }
        this.m_sess.removeVirtualCircuit(uid);
        this.m_sess.sendSuccessResponseSMB(smbPkt);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void procOpenAndX(SMBSrvPacket smbPkt, SMBV1Parser parser) throws IOException, SMBSrvException {
        int fid;
        if (!parser.checkPacketIsValid(15, 1)) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 64, 2);
            return;
        }
        VirtualCircuit vc = this.m_sess.findVirtualCircuit(parser.getUserId());
        if (vc == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
            return;
        }
        int treeId = parser.getTreeId();
        TreeConnection conn = vc.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 5, 2);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 5, 1);
            return;
        }
        if (conn.getSharedDevice().getType() == ShareType.ADMINPIPE) {
            IPCHandler.processIPCRequest(this.m_sess, smbPkt);
            return;
        }
        if (conn.getSharedDevice().getType() != ShareType.DISK) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 4, 2);
            return;
        }
        int flags = parser.getParameter(2);
        int access = parser.getParameter(3);
        int srchAttr = parser.getParameter(4);
        int fileAttr = parser.getParameter(5);
        int crTime = parser.getParameter(6);
        int crDate = parser.getParameter(7);
        int openFunc = parser.getParameter(8);
        int allocSiz = parser.getParameterLong(9);
        String fileName = parser.unpackString(parser.isUnicode());
        if (fileName == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 13, 1);
            return;
        }
        SMBDate crDateTime = null;
        if (crTime > 0 && crDate > 0) {
            crDateTime = new SMBDate(crDate, crTime);
        }
        FileOpenParams params = new FileOpenParams(fileName, openFunc, access, srchAttr, fileAttr, allocSiz, crDateTime != null ? crDateTime.getTime() : 0L, parser.getProcessIdFull());
        if (this.m_sess.hasDebug(512)) {
            this.m_sess.debugPrintln("File Open AndX [" + treeId + "] params=" + params);
        }
        NetworkFile netFile = null;
        int respAction = 0;
        try {
            block24: {
                DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
                FileStatus fileSts = disk.fileExists(this.m_sess, conn, fileName);
                if (fileSts == FileStatus.NotExist) {
                    if (FileAction.createNotExists(openFunc)) {
                        if (!conn.hasWriteAccess()) {
                            this.m_sess.sendErrorResponseSMB(smbPkt, 5, 1);
                            return;
                        }
                        netFile = disk.createFile(this.m_sess, conn, params);
                        respAction = 2;
                        break block24;
                    } else {
                        if (fileSts == FileStatus.DirectoryExists) {
                            this.m_sess.sendErrorResponseSMB(smbPkt, 5, 1);
                            return;
                        }
                        this.m_sess.sendErrorResponseSMB(smbPkt, 2, 1);
                        return;
                    }
                }
                netFile = disk.openFile(this.m_sess, conn, params);
                respAction = FileAction.truncateExistingFile(openFunc) ? 3 : 1;
            }
            fid = conn.addFile(netFile, this.getSession());
        }
        catch (InvalidDeviceInterfaceException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 13, 1);
            return;
        }
        catch (TooManyFilesException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 4, 1);
            return;
        }
        catch (AccessDeniedException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 5, 1);
            return;
        }
        catch (FileSharingException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 32, 1);
            return;
        }
        catch (FileOfflineException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741209, 21, 3);
            return;
        }
        catch (IOException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 2, 1);
            return;
        }
        SMBSrvPacket respPkt = smbPkt;
        boolean andX = false;
        if (parser.hasAndXCommand()) {
            respPkt = this.m_sess.getPacketPool().allocatePacket(parser.getLength(), smbPkt);
            andX = true;
            respPkt.setParser(SMBSrvPacket.Version.V1);
            parser = (SMBV1Parser)respPkt.getParser();
        }
        parser.setParameterCount(15);
        parser.setAndXCommand(255);
        parser.setParameter(1, 0);
        parser.setParameter(2, fid);
        parser.setParameter(3, netFile.getFileAttributes() & 0x3F);
        long modDate = 0L;
        if (netFile.hasModifyDate()) {
            GlobalConfigSection gblConfig = (GlobalConfigSection)this.m_sess.getServer().getConfiguration().getConfigSection("Global");
            modDate = netFile.getModifyDate() / 1000L + (long)(gblConfig != null ? gblConfig.getTimeZoneOffset() : 0);
        }
        parser.setParameterLong(4, (int)modDate);
        parser.setParameterLong(6, netFile.getFileSizeInt());
        parser.setParameter(8, netFile.getGrantedAccess().intValue());
        parser.setParameter(9, 0);
        parser.setParameter(10, 0);
        parser.setParameter(11, respAction);
        parser.setParameter(12, 0);
        parser.setParameter(13, 0);
        parser.setParameter(14, 0);
        parser.setByteCount(0);
        if (andX) {
            int pos = this.procAndXCommands(smbPkt, netFile);
            this.m_sess.sendResponseSMB(respPkt, pos);
            return;
        }
        this.m_sess.sendResponseSMB(respPkt);
    }

    protected final void procReadAndX(SMBSrvPacket smbPkt, SMBV1Parser parser) throws IOException, SMBSrvException {
        if (!parser.checkPacketIsValid(10, 0)) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 64, 2);
            return;
        }
        VirtualCircuit vc = this.m_sess.findVirtualCircuit(parser.getUserId());
        if (vc == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
            return;
        }
        int treeId = parser.getTreeId();
        TreeConnection conn = vc.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 5, 2);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 5, 1);
            return;
        }
        if (conn.getSharedDevice().getType() == ShareType.ADMINPIPE) {
            IPCHandler.processIPCRequest(this.m_sess, smbPkt);
            return;
        }
        int fid = parser.getParameter(2);
        int offset = parser.getParameterLong(3);
        int maxCount = parser.getParameter(5);
        NetworkFile netFile = conn.findFile(fid);
        if (netFile == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 6, 1);
            return;
        }
        if (this.m_sess.hasDebug(1024)) {
            this.m_sess.debugPrintln("File Read AndX [" + netFile.getFileId() + "] : Size=" + maxCount + " ,Pos=" + offset);
        }
        SMBSrvPacket respPkt = smbPkt;
        byte[] buf = respPkt.getBuffer();
        int rdlen = 0;
        parser.setParameterCount(12);
        int dataPos = parser.getByteOffset();
        try {
            if (maxCount > buf.length - dataPos) {
                respPkt = this.m_sess.getPacketPool().allocatePacket(maxCount + dataPos, smbPkt);
                respPkt.setParser(SMBSrvPacket.Version.V1);
                parser = (SMBV1Parser)respPkt.getParser();
                buf = respPkt.getBuffer();
                parser.setParameterCount(12);
            }
            DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
            int dataLen = buf.length - dataPos;
            if (dataLen < maxCount) {
                maxCount = dataLen;
            }
            rdlen = disk.readFile(this.m_sess, conn, netFile, buf, dataPos, maxCount, offset);
        }
        catch (InvalidDeviceInterfaceException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 13, 1);
            return;
        }
        catch (AccessDeniedException ex) {
            if (this.m_sess.hasDebug(1024)) {
                this.m_sess.debugPrintln("File Read Error [" + netFile.getFileId() + "] : " + ex.toString());
            }
            this.m_sess.sendErrorResponseSMB(smbPkt, 5, 1);
            return;
        }
        catch (IOException ex) {
            if (this.m_sess.hasDebug(1024)) {
                this.m_sess.debugPrintln("File Read Error [" + netFile.getFileId() + "] : " + ex.toString());
            }
            this.m_sess.sendErrorResponseSMB(smbPkt, 30, 3);
            return;
        }
        parser.setAndXCommand(255);
        parser.setParameter(1, 0);
        parser.setParameter(2, 65535);
        parser.setParameter(3, 0);
        parser.setParameter(4, 0);
        parser.setParameter(5, rdlen);
        parser.setParameter(6, dataPos - 4);
        for (int i = 7; i < 12; ++i) {
            parser.setParameter(i, 0);
        }
        parser.setByteCount(dataPos + rdlen - parser.getByteOffset());
        this.m_sess.sendResponseSMB(respPkt);
    }

    protected final void procReadMPX(SMBSrvPacket smbPkt, SMBV1Parser parser) throws IOException, SMBSrvException {
        if (!parser.checkPacketIsValid(8, 0)) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 64, 2);
            return;
        }
        TreeConnection conn = this.m_sess.findTreeConnection(smbPkt);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 5, 2);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 5, 1);
            return;
        }
        if (conn.getSharedDevice().getType() == ShareType.ADMINPIPE) {
            IPCHandler.processIPCRequest(this.m_sess, smbPkt);
            return;
        }
        int fid = parser.getParameter(0);
        int offset = parser.getParameterLong(1);
        int maxCount = parser.getParameter(3);
        NetworkFile netFile = conn.findFile(fid);
        if (netFile == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 6, 1);
            return;
        }
        if (this.m_sess.hasDebug(1024)) {
            Debug.println("File ReadMPX [" + netFile.getFileId() + "] : Size=" + maxCount + " ,Pos=" + offset + ",MaxCount=" + maxCount);
        }
        int clientMaxSize = this.m_sess.getClientMaximumBufferSize();
        SMBSrvPacket respPkt = smbPkt;
        byte[] buf = respPkt.getBuffer();
        int dataPos = 0;
        int rdlen = 0;
        int rdRemaining = maxCount;
        try {
            DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
            if (parser.getBufferLength() < clientMaxSize) {
                respPkt = this.m_sess.getPacketPool().allocatePacket(clientMaxSize, smbPkt);
                buf = respPkt.getBuffer();
                respPkt.setParser(SMBSrvPacket.Version.V1);
                parser = (SMBV1Parser)respPkt.getParser();
            }
            parser.setParameterCount(8);
            dataPos = parser.getByteOffset();
            clientMaxSize -= dataPos;
            while (rdRemaining > 0) {
                rdlen = rdRemaining;
                if (rdlen > clientMaxSize) {
                    rdlen = clientMaxSize;
                }
                rdlen = disk.readFile(this.m_sess, conn, netFile, buf, dataPos, rdlen, offset);
                parser.setParameterLong(0, offset);
                parser.setParameter(2, maxCount);
                parser.setParameter(3, 65535);
                parser.setParameterLong(4, 0);
                parser.setParameter(6, rdlen);
                parser.setParameter(7, dataPos - 4);
                parser.setByteCount(rdlen);
                if (rdlen > 0) {
                    rdRemaining -= rdlen;
                    offset += rdlen;
                } else {
                    rdRemaining = 0;
                }
                parser.setCommand(28);
                if (this.m_sess.hasDebug(1024)) {
                    Debug.println("File ReadMPX Secondary [" + netFile.getFileId() + "] : Size=" + rdlen + " ,Pos=" + offset);
                }
                this.m_sess.sendResponseSMB(smbPkt);
            }
        }
        catch (InvalidDeviceInterfaceException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 13, 1);
            return;
        }
        catch (AccessDeniedException ex) {
            if (this.m_sess.hasDebug(1024)) {
                Debug.println("File ReadMPX Error [" + netFile.getFileId() + "] : " + ex.toString());
            }
            this.m_sess.sendErrorResponseSMB(smbPkt, 5, 1);
            return;
        }
        catch (IOException ex) {
            Debug.println("File ReadMPX Error [" + netFile.getFileId() + "] : " + ex);
            this.m_sess.sendErrorResponseSMB(smbPkt, 30, 3);
            return;
        }
    }

    @Override
    protected void procRenameFile(SMBSrvPacket smbPkt, SMBV1Parser parser) throws IOException, SMBSrvException {
        if (!parser.checkPacketIsValid(1, 4)) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 64, 2);
            return;
        }
        VirtualCircuit vc = this.m_sess.findVirtualCircuit(parser.getUserId());
        if (vc == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
            return;
        }
        int treeId = parser.getTreeId();
        TreeConnection conn = vc.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 15, 1);
            return;
        }
        if (!conn.hasWriteAccess()) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 5, 1);
            return;
        }
        boolean isUni = parser.isUnicode();
        parser.resetBytePointer();
        if (parser.unpackByte() != 4) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 13, 1);
            return;
        }
        String oldName = parser.unpackString(isUni);
        if (oldName == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 13, 1);
            return;
        }
        if (parser.unpackByte() != 4) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 13, 1);
            return;
        }
        String newName = parser.unpackString(isUni);
        if (oldName == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 13, 1);
            return;
        }
        if (this.m_sess.hasDebug(512)) {
            this.m_sess.debugPrintln("File Rename [" + treeId + "] old name=" + oldName + ", new name=" + newName);
        }
        Object netFile = null;
        try {
            DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
            disk.renameFile(this.m_sess, conn, oldName, newName);
        }
        catch (InvalidDeviceInterfaceException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 13, 1);
            return;
        }
        catch (IOException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 2, 1);
            return;
        }
        parser.setParameterCount(0);
        parser.setByteCount(0);
        this.m_sess.sendResponseSMB(smbPkt);
    }

    @Override
    protected void procSessionSetup(SMBSrvPacket smbPkt, SMBV1Parser parser) throws SMBSrvException, IOException, TooManyConnectionsException {
        String user;
        int dataPos = parser.getByteOffset();
        int dataLen = parser.getByteCount();
        byte[] buf = parser.getBuffer();
        int maxBufSize = parser.getParameter(2);
        int maxMpx = parser.getParameter(3);
        int vcNum = parser.getParameter(4);
        byte[] pwd = null;
        int pwdLen = parser.getParameter(7);
        if (pwdLen > 0) {
            pwd = new byte[pwdLen];
            for (int i = 0; i < pwdLen; ++i) {
                pwd[i] = buf[dataPos + i];
            }
            dataPos += pwdLen;
            dataLen -= pwdLen;
        }
        if ((user = DataPacker.getString(buf, dataPos, dataLen)) == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 13, 1);
            return;
        }
        dataPos += user.length() + 1;
        String domain = "";
        if ((dataLen -= user.length() + 1) > 0) {
            domain = DataPacker.getString(buf, dataPos, dataLen);
            if (domain == null) {
                this.m_sess.sendErrorResponseSMB(smbPkt, 13, 1);
                return;
            }
            dataLen -= domain.length() + 1;
            dataPos += domain.length() + 1;
        }
        String clientOS = "";
        if (dataLen > 0 && (clientOS = DataPacker.getString(buf, dataPos, dataLen)) == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 13, 1);
            return;
        }
        if (this.m_sess.hasDebug(32)) {
            this.m_sess.debugPrintln("Session setup from user=" + user + ", password=" + pwd + ", domain=" + domain + ", os=" + clientOS + ", VC=" + vcNum + ", maxBuf=" + maxBufSize + ", maxMpx=" + maxMpx);
        }
        this.m_sess.setClientMaximumBufferSize(maxBufSize);
        this.m_sess.setClientMaximumMultiplex(maxMpx);
        ClientInfo client = ClientInfo.createInfo(user, pwd);
        client.setDomain(domain);
        client.setOperatingSystem(clientOS);
        if (this.m_sess.hasRemoteAddress()) {
            client.setClientAddress(this.m_sess.getRemoteAddress().getHostAddress());
        }
        if (this.m_sess.getClientInformation() == null || this.m_sess.getClientInformation().getUserName().length() == 0) {
            this.m_sess.setClientInformation(client);
        } else {
            ClientInfo curClient = this.m_sess.getClientInformation();
            if (curClient.getUserName() == null || curClient.getUserName().length() == 0) {
                this.m_sess.setClientInformation(client);
            } else if (this.m_sess.hasDebug(32)) {
                this.m_sess.debugPrintln("Session already has client information set");
            }
        }
        ISMBAuthenticator auth = this.getSession().getSMBServer().getSMBAuthenticator();
        boolean isGuest = false;
        if (auth != null && auth.getAccessMode() == ISMBAuthenticator.AuthMode.USER) {
            ISMBAuthenticator.AuthStatus sts = auth.authenticateUser(client, this.m_sess, ISMBAuthenticator.PasswordAlgorithm.LANMAN);
            if (sts == ISMBAuthenticator.AuthStatus.GUEST_LOGON) {
                isGuest = true;
            } else if (sts != ISMBAuthenticator.AuthStatus.AUTHENTICATED) {
                this.m_sess.sendErrorResponseSMB(smbPkt, 5, 1);
                return;
            }
        }
        client.setGuest(isGuest);
        this.getSession().setLoggedOn(true);
        int uid = 0;
        VirtualCircuit vc = new VirtualCircuit(vcNum, client);
        uid = this.m_sess.addVirtualCircuit(vc);
        if (uid == -1) {
            if (this.m_sess.hasDebug(32)) {
                Debug.println("Failed to allocate UID for virtual circuit, " + vc);
            }
            throw new SMBSrvException(-1073741715, 1, 5);
        }
        if (this.m_sess.hasDebug(32)) {
            Debug.println("Allocated UID=" + uid + " for VC=" + vc);
        }
        SMBSrvPacket respPkt = smbPkt;
        boolean andX = false;
        if (parser.hasAndXCommand() && dataPos < smbPkt.getReceivedLength()) {
            respPkt = this.m_sess.getPacketPool().allocatePacket(parser.getLength(), smbPkt);
            andX = true;
            respPkt.setParser(SMBSrvPacket.Version.V1);
            parser = (SMBV1Parser)respPkt.getParser();
        }
        parser.setParameterCount(3);
        parser.setParameter(0, 0);
        parser.setParameter(1, 0);
        parser.setParameter(2, isGuest ? 1 : 0);
        parser.setByteCount(0);
        parser.setTreeId(0);
        parser.setUserId(uid);
        int flags = parser.getFlags();
        parser.setFlags(flags &= 0xFFFFFFF7);
        parser.setFlags2(1);
        int pos = parser.getByteOffset();
        buf = respPkt.getBuffer();
        pos = DataPacker.putString("Java", buf, pos, true);
        pos = DataPacker.putString("Java File Server " + this.m_sess.getServer().isVersion(), buf, pos, true);
        pos = DataPacker.putString(this.m_sess.getSMBServer().getSMBConfiguration().getDomainName(), buf, pos, true);
        parser.setByteCount(pos - parser.getByteOffset());
        if (andX) {
            pos = this.procAndXCommands(smbPkt, null);
        } else {
            parser.setAndXCommand(255);
        }
        this.m_sess.sendResponseSMB(respPkt, pos);
        this.m_sess.setState(SessionState.SMB_SESSION);
        this.m_sess.findVirtualCircuit(parser.getUserId());
        this.m_sess.getSMBServer().sessionLoggedOn(this.m_sess);
    }

    protected void procTransact2(SMBSrvPacket smbPkt, SMBV1Parser parser) throws IOException, SMBSrvException {
        if (!parser.checkPacketIsValid(15, 0)) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 6);
            return;
        }
        VirtualCircuit vc = this.m_sess.findVirtualCircuit(parser.getUserId());
        if (vc == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
            return;
        }
        int treeId = parser.getTreeId();
        TreeConnection conn = vc.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 6);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 5, 1);
            return;
        }
        SMBSrvTransPacket tranPkt = new SMBSrvTransPacket(parser.getBuffer());
        SrvTransactBuffer transBuf = null;
        int subCmd = tranPkt.getSubFunction();
        if (tranPkt.getTotalParameterCount() == tranPkt.getParameterBlockCount() && tranPkt.getTotalDataCount() == tranPkt.getDataBlockCount()) {
            transBuf = new SrvTransactBuffer(tranPkt);
        } else {
            transBuf = new SrvTransactBuffer(tranPkt.getSetupCount(), tranPkt.getTotalParameterCount(), tranPkt.getTotalDataCount());
            transBuf.setType(parser.getCommand());
            transBuf.setFunction(subCmd);
            byte[] buf = tranPkt.getBuffer();
            transBuf.appendSetup(buf, tranPkt.getSetupOffset(), tranPkt.getSetupCount() * 2);
            transBuf.appendParameter(buf, tranPkt.getParameterBlockOffset(), tranPkt.getParameterBlockCount());
            transBuf.appendData(buf, tranPkt.getDataBlockOffset(), tranPkt.getDataBlockCount());
        }
        transBuf.setReturnLimits(tranPkt.getMaximumReturnSetupCount(), tranPkt.getMaximumReturnParameterCount(), tranPkt.getMaximumReturnDataCount());
        if (transBuf.isMultiPacket()) {
            vc.setTransaction(transBuf);
            this.m_sess.sendSuccessResponseSMB(smbPkt);
            return;
        }
        if (conn.getSharedDevice().getType() == ShareType.ADMINPIPE) {
            IPCHandler.procTransaction(vc, transBuf, this.m_sess, smbPkt);
            return;
        }
        if (this.m_sess.hasDebug(2048)) {
            this.m_sess.debugPrintln("Transaction [" + treeId + "] tbuf=" + transBuf);
        }
        this.processTransactionBuffer(transBuf, smbPkt, parser);
    }

    protected void procTransact2Secondary(SMBSrvPacket smbPkt, SMBV1Parser parser) throws IOException, SMBSrvException {
        int dlen;
        if (!parser.checkPacketIsValid(8, 0)) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 6);
            return;
        }
        VirtualCircuit vc = this.m_sess.findVirtualCircuit(parser.getUserId());
        if (vc == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
            return;
        }
        int treeId = parser.getTreeId();
        TreeConnection conn = vc.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 6);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 5, 1);
            return;
        }
        if (!vc.hasTransaction() || vc.getTransaction().isType() == 37 && parser.getCommand() != 38 || vc.getTransaction().isType() == 50 && parser.getCommand() != 51) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 1, 2);
            return;
        }
        SMBSrvTransPacket tpkt = new SMBSrvTransPacket(parser.getBuffer());
        byte[] buf = tpkt.getBuffer();
        SrvTransactBuffer transBuf = vc.getTransaction();
        int plen = tpkt.getSecondaryParameterBlockCount();
        if (plen > 0) {
            DataBuffer paramBuf = transBuf.getParameterBuffer();
            paramBuf.appendData(buf, tpkt.getSecondaryParameterBlockOffset(), plen);
        }
        if ((dlen = tpkt.getSecondaryDataBlockCount()) > 0) {
            DataBuffer dataBuf = transBuf.getDataBuffer();
            dataBuf.appendData(buf, tpkt.getSecondaryDataBlockOffset(), dlen);
        }
        if (this.m_sess.hasDebug(2048)) {
            this.m_sess.debugPrintln("Transaction Secondary [" + treeId + "] paramLen=" + plen + ", dataLen=" + dlen);
        }
        int totParam = tpkt.getTotalParameterCount();
        int totData = tpkt.getTotalDataCount();
        int paramDisp = tpkt.getParameterBlockDisplacement();
        int dataDisp = tpkt.getDataBlockDisplacement();
        if (paramDisp + plen == totParam && dataDisp + dlen == totData) {
            if (this.m_sess.hasDebug(2048)) {
                this.m_sess.debugPrintln("Transaction complete, processing ...");
            }
            vc.setTransaction(null);
            if (conn.getSharedDevice().getType() == ShareType.ADMINPIPE) {
                IPCHandler.procTransaction(vc, transBuf, this.m_sess, smbPkt);
                return;
            }
            if (this.m_sess.hasDebug(2048)) {
                this.m_sess.debugPrintln("Transaction second [" + treeId + "] tbuf=" + transBuf);
            }
            this.processTransactionBuffer(transBuf, smbPkt, parser);
        } else {
            this.m_sess.sendSuccessResponseSMB(smbPkt);
        }
    }

    private final void processTransactionBuffer(SrvTransactBuffer tbuf, SMBSrvPacket smbPkt, SMBV1Parser parser) throws IOException, SMBSrvException {
        switch (tbuf.getFunction()) {
            case 1: {
                this.procTrans2FindFirst(tbuf, smbPkt, parser);
                break;
            }
            case 2: {
                this.procTrans2FindNext(tbuf, smbPkt, parser);
                break;
            }
            case 3: {
                this.procTrans2QueryFileSys(tbuf, smbPkt, parser);
                break;
            }
            case 5: {
                this.procTrans2QueryPath(tbuf, smbPkt, parser);
                break;
            }
            case 7: {
                this.procTrans2QueryFile(tbuf, smbPkt, parser);
                break;
            }
            default: {
                this.m_sess.debugPrintln("Error Transact2 Command = 0x" + Integer.toHexString(tbuf.getFunction()));
                this.m_sess.sendErrorResponseSMB(smbPkt, 64, 2);
            }
        }
    }

    protected final void procTrans2FindFirst(SrvTransactBuffer tbuf, SMBSrvPacket smbPkt, SMBV1Parser parser) throws IOException, SMBSrvException {
        VirtualCircuit vc = this.m_sess.findVirtualCircuit(parser.getUserId());
        if (vc == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
            return;
        }
        int treeId = parser.getTreeId();
        TreeConnection conn = vc.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 5, 2);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 5, 1);
            return;
        }
        DataBuffer paramBuf = tbuf.getParameterBuffer();
        int srchAttr = paramBuf.getShort();
        int maxFiles = paramBuf.getShort();
        int srchFlag = paramBuf.getShort();
        int infoLevl = paramBuf.getShort();
        paramBuf.skipBytes(4);
        String srchPath = paramBuf.getString(tbuf.isUnicode());
        if (srchPath == null || srchPath.length() == 0) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 13, 1);
            return;
        }
        SearchContext ctx = null;
        DiskInterface disk = null;
        int searchId = -1;
        try {
            disk = (DiskInterface)conn.getSharedDevice().getInterface();
            searchId = vc.allocateSearchSlot();
            if (this.m_sess.hasDebug(128)) {
                this.m_sess.debugPrintln("Start trans search [" + searchId + "] - " + srchPath + ", attr=0x" + Integer.toHexString(srchAttr) + ", maxFiles=" + maxFiles + ", infoLevel=" + infoLevl + ", flags=0x" + Integer.toHexString(srchFlag));
            }
            if ((ctx = disk.startSearch(this.m_sess, conn, srchPath, srchAttr)) == null) {
                this.m_sess.sendErrorResponseSMB(smbPkt, 2, 1);
                return;
            }
            ctx.setTreeId(treeId);
            ctx.setMaximumFiles(maxFiles);
            vc.setSearchContext(searchId, ctx);
            SrvTransactBuffer replyBuf = new SrvTransactBuffer(tbuf);
            DataBuffer dataBuf = replyBuf.getDataBuffer();
            int maxLen = replyBuf.getReturnDataLimit();
            boolean resumeReq = (srchFlag & 4) != 0;
            int fileCnt = 0;
            int packLen = 0;
            int lastNameOff = 0;
            boolean pktDone = false;
            boolean searchDone = false;
            FileInfo info = new FileInfo();
            if (WildCard.containsWildcards(srchPath)) {
                if (resumeReq) {
                    dataBuf.putInt(-1);
                    maxLen -= 4;
                }
                lastNameOff = dataBuf.getPosition();
                FileInfo dotInfo = new FileInfo(".", 0L, 16);
                dotInfo.setFileId(dotInfo.getFileName().hashCode());
                dotInfo.setCreationDateTime(DotFileDateTime);
                dotInfo.setModifyDateTime(DotFileDateTime);
                dotInfo.setAccessDateTime(DotFileDateTime);
                packLen = FindInfoPacker.packInfo(dotInfo, dataBuf, infoLevl, tbuf.isUnicode());
                ++fileCnt;
                maxLen -= packLen;
                if (resumeReq) {
                    dataBuf.putInt(-2);
                    maxLen -= 4;
                }
                lastNameOff = dataBuf.getPosition();
                dotInfo.setFileName("..");
                dotInfo.setFileId(dotInfo.getFileName().hashCode());
                packLen = FindInfoPacker.packInfo(dotInfo, dataBuf, infoLevl, tbuf.isUnicode());
                ++fileCnt;
                maxLen -= packLen;
            }
            while (!pktDone && fileCnt < maxFiles) {
                if (!ctx.nextFileInfo(info)) {
                    pktDone = true;
                    searchDone = true;
                    continue;
                }
                if (FindInfoPacker.calcInfoSize(info, infoLevl, false, true) <= maxLen) {
                    if (resumeReq) {
                        dataBuf.putZeros(4);
                        maxLen -= 4;
                    }
                    lastNameOff = dataBuf.getPosition();
                    info.setFileAttributes(info.getFileAttributes() & 0x3F);
                    packLen = FindInfoPacker.packInfo(info, dataBuf, infoLevl, tbuf.isUnicode());
                    ++fileCnt;
                    maxLen -= packLen;
                    continue;
                }
                ctx.restartAt(info);
                pktDone = true;
            }
            paramBuf = replyBuf.getParameterBuffer();
            paramBuf.putShort(searchId);
            paramBuf.putShort(fileCnt);
            paramBuf.putShort(ctx.hasMoreFiles() ? 0 : 1);
            paramBuf.putShort(0);
            paramBuf.putShort(lastNameOff);
            SMBSrvTransPacket tpkt = new SMBSrvTransPacket(smbPkt);
            tpkt.doTransactionResponse(this.m_sess, replyBuf, smbPkt);
            if (this.m_sess.hasDebug(128)) {
                this.m_sess.debugPrintln("Search [" + searchId + "] Returned " + fileCnt + " files, moreFiles=" + ctx.hasMoreFiles());
            }
            if (searchDone) {
                if (this.m_sess.hasDebug(128)) {
                    this.m_sess.debugPrintln("End start search [" + searchId + "] (Search complete)");
                }
                vc.deallocateSearchSlot(searchId);
            }
        }
        catch (TooManySearchesException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 89, 2);
        }
        catch (FileNotFoundException ex) {
            if (searchId != -1) {
                vc.deallocateSearchSlot(searchId);
            }
            this.m_sess.sendErrorResponseSMB(smbPkt, 18, 1);
        }
        catch (InvalidDeviceInterfaceException ex) {
            if (searchId != -1) {
                vc.deallocateSearchSlot(searchId);
            }
            this.m_sess.sendErrorResponseSMB(smbPkt, 13, 1);
        }
        catch (UnsupportedInfoLevelException ex) {
            if (searchId != -1) {
                vc.deallocateSearchSlot(searchId);
            }
            this.m_sess.sendErrorResponseSMB(smbPkt, 65535, 2);
        }
    }

    protected final void procTrans2FindNext(SrvTransactBuffer tbuf, SMBSrvPacket smbPkt, SMBV1Parser parser) throws IOException, SMBSrvException {
        VirtualCircuit vc = this.m_sess.findVirtualCircuit(parser.getUserId());
        if (vc == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
            return;
        }
        int treeId = parser.getTreeId();
        TreeConnection conn = vc.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 5, 2);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 5, 1);
            return;
        }
        DataBuffer paramBuf = tbuf.getParameterBuffer();
        int searchId = paramBuf.getShort();
        int maxFiles = paramBuf.getShort();
        int infoLevl = paramBuf.getShort();
        int reskey = paramBuf.getInt();
        int srchFlag = paramBuf.getShort();
        String resumeName = paramBuf.getString(tbuf.isUnicode());
        SearchContext ctx = null;
        DiskInterface disk = null;
        try {
            disk = (DiskInterface)conn.getSharedDevice().getInterface();
            ctx = vc.getSearchContext(searchId);
            if (ctx == null) {
                if (this.m_sess.hasDebug(128)) {
                    this.m_sess.debugPrintln("Search context null - [" + searchId + "]");
                }
                this.m_sess.sendErrorResponseSMB(smbPkt, 18, 1);
                return;
            }
            if (this.m_sess.hasDebug(128)) {
                this.m_sess.debugPrintln("Continue search [" + searchId + "] - " + resumeName + ", maxFiles=" + maxFiles + ", infoLevel=" + infoLevl + ", flags=0x" + Integer.toHexString(srchFlag));
            }
            SrvTransactBuffer replyBuf = new SrvTransactBuffer(tbuf);
            DataBuffer dataBuf = replyBuf.getDataBuffer();
            int maxLen = replyBuf.getReturnDataLimit();
            boolean resumeReq = (srchFlag & 4) != 0;
            int fileCnt = 0;
            int packLen = 0;
            int lastNameOff = 0;
            boolean pktDone = false;
            boolean searchDone = false;
            FileInfo info = new FileInfo();
            while (!pktDone && fileCnt < maxFiles) {
                if (!ctx.nextFileInfo(info)) {
                    pktDone = true;
                    searchDone = true;
                    continue;
                }
                if (FindInfoPacker.calcInfoSize(info, infoLevl, false, true) <= maxLen) {
                    if (resumeReq) {
                        dataBuf.putZeros(4);
                    }
                    lastNameOff = dataBuf.getPosition();
                    info.setFileAttributes(info.getFileAttributes() & 0x3F);
                    packLen = FindInfoPacker.packInfo(info, dataBuf, infoLevl, tbuf.isUnicode());
                    ++fileCnt;
                    maxLen -= packLen;
                    continue;
                }
                ctx.restartAt(info);
                pktDone = true;
            }
            paramBuf = replyBuf.getParameterBuffer();
            paramBuf.putShort(fileCnt);
            paramBuf.putShort(ctx.hasMoreFiles() ? 0 : 1);
            paramBuf.putShort(0);
            paramBuf.putShort(lastNameOff);
            SMBSrvTransPacket tpkt = new SMBSrvTransPacket(smbPkt);
            tpkt.doTransactionResponse(this.m_sess, replyBuf, smbPkt);
            if (this.m_sess.hasDebug(128)) {
                this.m_sess.debugPrintln("Search [" + searchId + "] Returned " + fileCnt + " files, moreFiles=" + ctx.hasMoreFiles());
            }
            if (searchDone) {
                if (this.m_sess.hasDebug(128)) {
                    this.m_sess.debugPrintln("End start search [" + searchId + "] (Search complete)");
                }
                vc.deallocateSearchSlot(searchId);
            }
        }
        catch (FileNotFoundException ex) {
            if (searchId != -1) {
                vc.deallocateSearchSlot(searchId);
            }
            this.m_sess.sendErrorResponseSMB(smbPkt, 18, 1);
        }
        catch (InvalidDeviceInterfaceException ex) {
            if (searchId != -1) {
                vc.deallocateSearchSlot(searchId);
            }
            this.m_sess.sendErrorResponseSMB(smbPkt, 13, 1);
        }
        catch (UnsupportedInfoLevelException ex) {
            if (searchId != -1) {
                vc.deallocateSearchSlot(searchId);
            }
            this.m_sess.sendErrorResponseSMB(smbPkt, 65535, 2);
        }
    }

    protected final void procTrans2QueryFile(SrvTransactBuffer tbuf, SMBSrvPacket smbPkt, SMBV1Parser parser) throws IOException, SMBSrvException {
        VirtualCircuit vc = this.m_sess.findVirtualCircuit(parser.getUserId());
        if (vc == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
            return;
        }
        int treeId = parser.getTreeId();
        TreeConnection conn = vc.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741790, 5, 1);
            return;
        }
        DataBuffer paramBuf = tbuf.getParameterBuffer();
        int fid = paramBuf.getShort();
        int infoLevl = paramBuf.getShort();
        NetworkFile netFile = conn.findFile(fid);
        if (netFile == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 6, 1);
            return;
        }
        if (this.m_sess.hasDebug(256)) {
            Debug.println("Query File - level=0x" + Integer.toHexString(infoLevl) + ", fid=" + fid + ", stream=" + netFile.getStreamId() + ", name=" + netFile.getFullName());
        }
        try {
            DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
            parser.setParameterCount(10);
            byte[] buf = parser.getBuffer();
            int prmPos = DataPacker.longwordAlign(parser.getByteOffset());
            int dataPos = prmPos + 4;
            parser.setPosition(prmPos);
            parser.packWord(0);
            DataBuffer replyBuf = new DataBuffer(buf, dataPos, buf.length - dataPos);
            boolean streams = false;
            if (disk instanceof NTFSStreamsInterface) {
                NTFSStreamsInterface ntfsStreams = (NTFSStreamsInterface)((Object)disk);
                streams = ntfsStreams.hasStreamsEnabled(this.m_sess, conn);
            }
            int dataLen = 0;
            if (streams && (infoLevl == 265 || infoLevl == 1022)) {
                NTFSStreamsInterface ntfsStreams;
                StreamInfoList streamList;
                if (this.m_sess.hasDebug(0x100000)) {
                    Debug.println("Get NTFS streams list fid=" + fid + ", name=" + netFile.getFullName());
                }
                if ((streamList = (ntfsStreams = (NTFSStreamsInterface)((Object)disk)).getStreamList(this.m_sess, conn, netFile.getFullName())) == null) {
                    this.m_sess.sendErrorResponseSMB(smbPkt, -1073741772, 1, 2);
                    return;
                }
                dataLen = QueryInfoPacker.packStreamFileInfo(streamList, replyBuf, true);
            } else {
                FileInfo fileInfo = disk.getFileInformation(this.m_sess, conn, netFile.getFullNameStream());
                if (fileInfo == null) {
                    this.m_sess.sendErrorResponseSMB(smbPkt, -1073741772, 1, 2);
                    return;
                }
                fileInfo.setFileAttributes(fileInfo.getFileAttributes() & 0x3F);
                dataLen = QueryInfoPacker.packInfo(fileInfo, replyBuf, infoLevl, true);
            }
            if (dataLen == 0) {
                this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
                return;
            }
            SMBSrvTransPacket.initTransactReply(smbPkt, 2, prmPos, dataLen, dataPos);
            parser.setByteCount(replyBuf.getPosition() - parser.getByteOffset());
            this.m_sess.sendResponseSMB(smbPkt);
        }
        catch (AccessDeniedException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741790, 5, 1);
            return;
        }
        catch (FileNotFoundException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741772, 2, 1);
            return;
        }
        catch (PathNotFoundException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741766, 2, 1);
            return;
        }
        catch (InvalidDeviceInterfaceException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
            return;
        }
        catch (UnsupportedInfoLevelException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
            return;
        }
    }

    protected final void procTrans2QueryFileSys(SrvTransactBuffer tbuf, SMBSrvPacket smbPkt, SMBV1Parser parser) throws IOException, SMBSrvException {
        VirtualCircuit vc = this.m_sess.findVirtualCircuit(parser.getUserId());
        if (vc == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
            return;
        }
        int treeId = parser.getTreeId();
        TreeConnection conn = vc.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 5, 2);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 5, 1);
            return;
        }
        DataBuffer paramBuf = tbuf.getParameterBuffer();
        int infoLevl = paramBuf.getShort();
        if (this.m_sess.hasDebug(256)) {
            this.m_sess.debugPrintln("Query File System Info - level = 0x" + Integer.toHexString(infoLevl));
        }
        try {
            int prmPos;
            DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
            DiskDeviceContext diskCtx = (DiskDeviceContext)conn.getContext();
            parser.setParameterCount(10);
            byte[] buf = parser.getBuffer();
            int dataPos = prmPos = DataPacker.longwordAlign(parser.getByteOffset());
            DataBuffer replyBuf = new DataBuffer(buf, dataPos, buf.length - dataPos);
            SrvDiskInfo diskInfo = null;
            VolumeInfo volInfo = null;
            switch (infoLevl) {
                case 1: {
                    diskInfo = this.getDiskInformation(disk, diskCtx);
                    DiskInfoPacker.packStandardInfo(diskInfo, replyBuf);
                    break;
                }
                case 2: {
                    volInfo = this.getVolumeInformation(disk, diskCtx);
                    DiskInfoPacker.packVolumeInfo(volInfo, replyBuf, tbuf.isUnicode());
                    break;
                }
                case 258: {
                    volInfo = this.getVolumeInformation(disk, diskCtx);
                    DiskInfoPacker.packFsVolumeInformation(volInfo, replyBuf, tbuf.isUnicode());
                    break;
                }
                case 259: {
                    diskInfo = this.getDiskInformation(disk, diskCtx);
                    DiskInfoPacker.packFsSizeInformation(diskInfo, replyBuf);
                    break;
                }
                case 260: {
                    DiskInfoPacker.packFsDevice(0, 0, replyBuf);
                    break;
                }
                case 261: {
                    DiskInfoPacker.packFsAttribute(0, 255, "JFileSrv", tbuf.isUnicode(), replyBuf);
                }
            }
            if (replyBuf.getPosition() == dataPos) {
                this.m_sess.sendErrorResponseSMB(smbPkt, 65535, 2);
                return;
            }
            int bytCnt = replyBuf.getPosition() - parser.getByteOffset();
            replyBuf.setEndOfBuffer();
            int dataLen = replyBuf.getLength();
            SMBSrvTransPacket.initTransactReply(smbPkt, 0, prmPos, dataLen, dataPos);
            parser.setByteCount(bytCnt);
            this.m_sess.sendResponseSMB(smbPkt);
        }
        catch (InvalidDeviceInterfaceException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 13, 1);
            return;
        }
    }

    protected final void procTrans2QueryPath(SrvTransactBuffer tbuf, SMBSrvPacket smbPkt, SMBV1Parser parser) throws IOException, SMBSrvException {
        VirtualCircuit vc = this.m_sess.findVirtualCircuit(parser.getUserId());
        if (vc == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
            return;
        }
        int treeId = parser.getTreeId();
        TreeConnection conn = vc.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 6);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 5, 1);
            return;
        }
        DataBuffer paramBuf = tbuf.getParameterBuffer();
        int infoLevl = paramBuf.getShort();
        paramBuf.skipBytes(4);
        String path = paramBuf.getString(tbuf.isUnicode());
        if (this.m_sess.hasDebug(256)) {
            this.m_sess.debugPrintln("Query Path - level = 0x" + Integer.toHexString(infoLevl) + ", path = " + path);
        }
        try {
            int prmPos;
            DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
            parser.setParameterCount(10);
            byte[] buf = parser.getBuffer();
            int dataPos = prmPos = DataPacker.longwordAlign(parser.getByteOffset());
            DataBuffer replyBuf = new DataBuffer(buf, dataPos, buf.length - dataPos);
            FileInfo fileInfo = disk.getFileInformation(this.m_sess, conn, path);
            if (fileInfo == null) {
                this.m_sess.sendErrorResponseSMB(smbPkt, -1073741772, 6);
                return;
            }
            fileInfo.setFileAttributes(fileInfo.getFileAttributes() & 0x3F);
            int dataLen = QueryInfoPacker.packInfo(fileInfo, replyBuf, infoLevl, true);
            if (dataLen == 0) {
                this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 6);
                return;
            }
            SMBSrvTransPacket.initTransactReply(smbPkt, 0, prmPos, dataLen, dataPos);
            parser.setByteCount(replyBuf.getPosition() - parser.getByteOffset());
            this.m_sess.sendResponseSMB(smbPkt);
        }
        catch (FileNotFoundException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741772, 6);
            return;
        }
        catch (InvalidDeviceInterfaceException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 6);
            return;
        }
        catch (UnsupportedInfoLevelException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 6);
            return;
        }
    }

    protected void procTreeConnectAndX(SMBSrvPacket smbPkt, SMBV1Parser parser) throws SMBSrvException, TooManyConnectionsException, IOException {
        String uncPath;
        if (!parser.checkPacketIsValid(4, 3)) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 64, 2);
            return;
        }
        VirtualCircuit vc = this.m_sess.findVirtualCircuit(parser.getUserId());
        if (vc == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
            return;
        }
        int flags = parser.getParameter(2);
        int pwdLen = parser.getParameter(3);
        int dataPos = parser.getByteOffset();
        int dataLen = parser.getByteCount();
        byte[] buf = parser.getBuffer();
        String pwd = null;
        if (pwdLen > 0) {
            pwd = new String(buf, dataPos, pwdLen);
            dataPos += pwdLen;
            dataLen -= pwdLen;
        }
        if ((uncPath = DataPacker.getString(buf, dataPos, dataLen)) == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 13, 1);
            return;
        }
        String service = DataPacker.getString(buf, dataPos += uncPath.length() + 1, dataLen -= uncPath.length() + 1);
        if (service == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 13, 1);
            return;
        }
        ShareType servType = ShareType.ServiceAsType(service);
        if (servType == ShareType.UNKNOWN && service.compareTo("?????") != 0) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 13, 1);
            return;
        }
        if (this.m_sess.hasDebug(64)) {
            this.m_sess.debugPrintln("Tree Connect AndX - " + uncPath + ", " + service);
        }
        PCShare share = null;
        try {
            share = new PCShare(uncPath);
        }
        catch (InvalidUNCPathException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 13, 1);
            return;
        }
        if (servType == ShareType.NAMEDPIPE && share.getShareName().compareTo("IPC$") == 0) {
            servType = ShareType.ADMINPIPE;
        }
        SharedDevice shareDev = null;
        try {
            shareDev = this.m_sess.getSMBServer().findShare(share.getNodeName(), share.getShareName(), servType, this.getSession(), true);
        }
        catch (InvalidUserException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 5, 1);
            return;
        }
        catch (Exception ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 6, 2);
            return;
        }
        if (shareDev == null || servType != ShareType.UNKNOWN && shareDev.getType() != servType) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 15, 1);
            return;
        }
        ISMBAuthenticator auth = this.getSession().getSMBServer().getSMBAuthenticator();
        ISMBAuthenticator.ShareStatus sharePerm = ISMBAuthenticator.ShareStatus.WRITEABLE;
        if (auth != null && (sharePerm = auth.authenticateShareConnect(this.m_sess.getClientInformation(), shareDev, pwd, this.m_sess)) == ISMBAuthenticator.ShareStatus.NO_ACCESS) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 4, 2);
            return;
        }
        int treeId = vc.addConnection(shareDev);
        parser.setTreeId(treeId);
        TreeConnection tree = vc.findConnection(treeId);
        tree.setPermission(sharePerm);
        if (this.m_sess.hasDebug(64)) {
            this.m_sess.debugPrintln("Tree Connect AndX - Allocated Tree Id = " + treeId + ", Permission = " + sharePerm.name());
        }
        parser.setParameterCount(3);
        parser.setAndXCommand(255);
        parser.setParameter(1, 0);
        parser.setParameter(2, 0);
        int pos = parser.getByteOffset();
        pos = DataPacker.putString(ShareType.TypeAsService(shareDev.getType()), buf, pos, true);
        parser.setByteCount(pos - parser.getByteOffset());
        this.m_sess.sendResponseSMB(smbPkt);
        if (tree.getInterface() != null) {
            tree.getInterface().treeOpened(this.m_sess, tree);
        }
    }

    protected final void procWriteAndX(SMBSrvPacket smbPkt, SMBV1Parser parser) throws IOException, SMBSrvException {
        if (!parser.checkPacketIsValid(12, 0)) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 64, 2);
            return;
        }
        VirtualCircuit vc = this.m_sess.findVirtualCircuit(parser.getUserId());
        if (vc == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
            return;
        }
        int treeId = parser.getTreeId();
        TreeConnection conn = vc.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 5, 2);
            return;
        }
        if (!conn.hasWriteAccess()) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 5, 1);
            return;
        }
        if (conn.getSharedDevice().getType() == ShareType.ADMINPIPE) {
            IPCHandler.processIPCRequest(this.m_sess, smbPkt);
            return;
        }
        int fid = parser.getParameter(2);
        int offset = parser.getParameterLong(3);
        int dataLen = parser.getParameter(10);
        int dataPos = parser.getParameter(11) + 4;
        NetworkFile netFile = conn.findFile(fid);
        if (netFile == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 6, 1);
            return;
        }
        if (this.m_sess.hasDebug(1024)) {
            this.m_sess.debugPrintln("File Write AndX [" + netFile.getFileId() + "] : Size=" + dataLen + " ,Pos=" + offset);
        }
        byte[] buf = parser.getBuffer();
        int wrtlen = 0;
        try {
            DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
            wrtlen = disk.writeFile(this.m_sess, conn, netFile, buf, dataPos, dataLen, offset);
        }
        catch (InvalidDeviceInterfaceException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 13, 1);
            return;
        }
        catch (IOException ex) {
            if (this.m_sess.hasDebug(1024)) {
                this.m_sess.debugPrintln("File Write Error [" + netFile.getFileId() + "] : " + ex.toString());
            }
            this.m_sess.sendErrorResponseSMB(smbPkt, 29, 3);
            return;
        }
        parser.setParameterCount(6);
        parser.setAndXCommand(255);
        parser.setParameter(1, 0);
        parser.setParameter(2, wrtlen);
        parser.setParameter(3, 0);
        parser.setParameter(4, 0);
        parser.setParameter(5, 0);
        parser.setByteCount(0);
        this.m_sess.sendResponseSMB(smbPkt);
    }

    protected final void procWriteMPX(SMBSrvPacket smbPkt, SMBV1Parser parser) throws IOException, SMBSrvException {
        if (!parser.checkPacketIsValid(12, 0)) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 64, 2);
            return;
        }
        TreeConnection conn = this.m_sess.findTreeConnection(smbPkt);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 5, 2);
            return;
        }
        if (!conn.hasWriteAccess()) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 5, 1);
            return;
        }
        if (conn.getSharedDevice().getType() == ShareType.ADMINPIPE) {
            IPCHandler.processIPCRequest(this.m_sess, smbPkt);
            return;
        }
        int fid = parser.getParameter(0);
        int totLen = parser.getParameter(1);
        int offset = parser.getParameterLong(3);
        int dataLen = parser.getParameter(10);
        int dataPos = parser.getParameter(11) + 4;
        NetworkFile netFile = conn.findFile(fid);
        if (netFile == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 6, 1);
            return;
        }
        if (this.m_sess.hasDebug(1024)) {
            Debug.println("File WriteMPX [" + netFile.getFileId() + "] : Size=" + dataLen + " ,Pos=" + offset + ", TotLen=" + totLen);
        }
        byte[] buf = parser.getBuffer();
        int wrtlen = 0;
        try {
            DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
            wrtlen = disk.writeFile(this.m_sess, conn, netFile, buf, dataPos, dataLen, offset);
            parser.setParameterCount(1);
            parser.setAndXCommand(255);
            parser.setParameter(1, 65535);
            parser.setByteCount(0);
            this.m_sess.sendResponseSMB(smbPkt);
            totLen -= wrtlen;
            offset += wrtlen;
            boolean rxlen = false;
            SMBSrvPacket curPkt = null;
            while (totLen > 0) {
                if (smbPkt.hasAssociatedPacket()) {
                    this.m_sess.getPacketPool().releasePacket(smbPkt.getAssociatedPacket());
                    smbPkt.setAssociatedPacket(null);
                }
                curPkt = this.m_sess.getPacketHandler().readPacket();
                smbPkt.setAssociatedPacket(curPkt);
                if (parser.getCommand() != 31) {
                    throw new IOException("Write MPX invalid packet type received");
                }
                dataLen = parser.getParameter(6);
                dataPos = parser.getParameter(7) + 4;
                if (this.m_sess.hasDebug(1024)) {
                    Debug.println("File WriteMPX Secondary [" + netFile.getFileId() + "] : Size=" + dataLen + " ,Pos=" + offset);
                }
                wrtlen = disk.writeFile(this.m_sess, conn, netFile, buf, dataPos, dataLen, offset);
                totLen -= wrtlen;
                offset += wrtlen;
            }
        }
        catch (InvalidDeviceInterfaceException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 13, 1);
            return;
        }
        catch (IOException ex) {
            Debug.println("File WriteMPX Error [" + netFile.getFileId() + "] : " + ex);
            this.m_sess.sendErrorResponseSMB(smbPkt, 29, 3);
            return;
        }
    }

    @Override
    public boolean runProtocol(SMBSrvPacket smbPkt) throws IOException, SMBSrvException, TooManyConnectionsException {
        if (!smbPkt.isSMB1()) {
            throw new IOException("Invalid SMB signature");
        }
        if (!smbPkt.hasParser()) {
            throw new IOException("SMB packet does not have a parser");
        }
        SMBV1Parser parser = (SMBV1Parser)smbPkt.getParser();
        if (this.m_sess.hasDebug(2) && parser.hasChainedCommand()) {
            this.m_sess.debugPrintln("AndX Command = 0x" + Integer.toHexString(parser.getAndXCommand()));
        }
        parser.resetBytePointer();
        boolean handledOK = true;
        switch (parser.getCommand()) {
            case 115: {
                this.procSessionSetup(smbPkt, parser);
                break;
            }
            case 117: {
                this.procTreeConnectAndX(smbPkt, parser);
                break;
            }
            case 37: 
            case 50: {
                this.procTransact2(smbPkt, parser);
                break;
            }
            case 38: 
            case 51: {
                this.procTransact2Secondary(smbPkt, parser);
                break;
            }
            case 52: {
                this.procFindClose(smbPkt, parser);
                break;
            }
            case 45: {
                this.procOpenAndX(smbPkt, parser);
                break;
            }
            case 46: {
                this.procReadAndX(smbPkt, parser);
                break;
            }
            case 27: {
                this.procReadMPX(smbPkt, parser);
                break;
            }
            case 47: {
                this.procWriteAndX(smbPkt, parser);
                break;
            }
            case 30: {
                this.procWriteMPX(smbPkt, parser);
                break;
            }
            case 113: {
                this.procTreeDisconnect(smbPkt, parser);
                break;
            }
            case 36: {
                this.procLockingAndX(smbPkt, parser);
                break;
            }
            case 116: {
                this.procLogoffAndX(smbPkt, parser);
                break;
            }
            case 112: {
                super.runProtocol(smbPkt);
                break;
            }
            case 7: {
                this.procRenameFile(smbPkt, parser);
                break;
            }
            case 43: {
                super.procEcho(smbPkt, parser);
                break;
            }
            default: {
                int treeId = parser.getTreeId();
                TreeConnection conn = null;
                if (treeId != -1) {
                    conn = this.m_sess.findTreeConnection(smbPkt);
                }
                if (conn == null) break;
                if (conn.getSharedDevice().getType() == ShareType.DISK || conn.getSharedDevice().getType() == ShareType.PRINTER) {
                    handledOK = super.runProtocol(smbPkt);
                    break;
                }
                if (conn.getSharedDevice().getType() != ShareType.ADMINPIPE) break;
                IPCHandler.processIPCRequest(this.m_sess, smbPkt);
                handledOK = true;
            }
        }
        this.runRequestPostProcessors(this.m_sess);
        return handledOK;
    }
}

