/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.smb.server;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.Time;
import java.util.Set;
import org.filesys.debug.Debug;
import org.filesys.locking.FileLock;
import org.filesys.locking.LockConflictException;
import org.filesys.locking.NotLockedException;
import org.filesys.server.auth.ISMBAuthenticator;
import org.filesys.server.auth.InvalidUserException;
import org.filesys.server.auth.acl.AccessControlManager;
import org.filesys.server.core.InvalidDeviceInterfaceException;
import org.filesys.server.core.ShareType;
import org.filesys.server.core.SharedDevice;
import org.filesys.server.filesys.AccessDeniedException;
import org.filesys.server.filesys.CreateDisposition;
import org.filesys.server.filesys.DeferredPacketException;
import org.filesys.server.filesys.DirectoryNotEmptyException;
import org.filesys.server.filesys.DiskDeviceContext;
import org.filesys.server.filesys.DiskFullException;
import org.filesys.server.filesys.DiskInterface;
import org.filesys.server.filesys.DiskOfflineException;
import org.filesys.server.filesys.FileAction;
import org.filesys.server.filesys.FileExistsException;
import org.filesys.server.filesys.FileInfo;
import org.filesys.server.filesys.FileName;
import org.filesys.server.filesys.FileNameException;
import org.filesys.server.filesys.FileOfflineException;
import org.filesys.server.filesys.FileOpenParams;
import org.filesys.server.filesys.FileSharingException;
import org.filesys.server.filesys.FileStatus;
import org.filesys.server.filesys.IOControlNotImplementedException;
import org.filesys.server.filesys.IOCtlInterface;
import org.filesys.server.filesys.NetworkFile;
import org.filesys.server.filesys.NotifyAction;
import org.filesys.server.filesys.NotifyChange;
import org.filesys.server.filesys.PathNotFoundException;
import org.filesys.server.filesys.PermissionDeniedException;
import org.filesys.server.filesys.SearchContext;
import org.filesys.server.filesys.SecurityDescriptorInterface;
import org.filesys.server.filesys.SrvDiskInfo;
import org.filesys.server.filesys.TooManyConnectionsException;
import org.filesys.server.filesys.TooManyFilesException;
import org.filesys.server.filesys.TooManySearchesException;
import org.filesys.server.filesys.TreeConnection;
import org.filesys.server.filesys.UnsupportedInfoLevelException;
import org.filesys.server.filesys.VolumeInfo;
import org.filesys.server.locking.FileLockingInterface;
import org.filesys.server.locking.LocalOpLockDetails;
import org.filesys.server.locking.LockManager;
import org.filesys.server.locking.LockParams;
import org.filesys.server.locking.OpLockDetails;
import org.filesys.server.locking.OpLockInterface;
import org.filesys.server.locking.OpLockManager;
import org.filesys.smb.ImpersonationLevel;
import org.filesys.smb.InvalidUNCPathException;
import org.filesys.smb.LockingAndX;
import org.filesys.smb.NTTime;
import org.filesys.smb.OpLockType;
import org.filesys.smb.PCShare;
import org.filesys.smb.SMBDate;
import org.filesys.smb.SMBException;
import org.filesys.smb.SharingMode;
import org.filesys.smb.TreeConnectAndX;
import org.filesys.smb.nt.LoadException;
import org.filesys.smb.nt.NTIOCtl;
import org.filesys.smb.nt.SaveException;
import org.filesys.smb.nt.SecurityDescriptor;
import org.filesys.smb.server.CoreProtocolHandler;
import org.filesys.smb.server.DiskInfoPacker;
import org.filesys.smb.server.FindInfoPacker;
import org.filesys.smb.server.IPCHandler;
import org.filesys.smb.server.NTParameterPacker;
import org.filesys.smb.server.OpLockHelper;
import org.filesys.smb.server.QueryInfoPacker;
import org.filesys.smb.server.SMBSrvException;
import org.filesys.smb.server.SMBSrvPacket;
import org.filesys.smb.server.SMBSrvSession;
import org.filesys.smb.server.SMBSrvTransPacket;
import org.filesys.smb.server.SMBV1OplockOwner;
import org.filesys.smb.server.SMBV1Parser;
import org.filesys.smb.server.SessionState;
import org.filesys.smb.server.SrvTransactBuffer;
import org.filesys.smb.server.VirtualCircuit;
import org.filesys.smb.server.notify.NotifyChangeEvent;
import org.filesys.smb.server.notify.NotifyChangeEventList;
import org.filesys.smb.server.notify.NotifyChangeHandler;
import org.filesys.smb.server.notify.NotifyRequest;
import org.filesys.smb.server.ntfs.NTFSStreamsInterface;
import org.filesys.smb.server.ntfs.StreamInfoList;
import org.filesys.util.DataBuffer;
import org.filesys.util.DataPacker;
import org.filesys.util.MemorySize;
import org.filesys.util.WildCard;

public class NTProtocolHandler
extends CoreProtocolHandler {
    public static final boolean ReturnDotFiles = true;
    public static final long DotFileDateTime = System.currentTimeMillis();
    public static final boolean FakeOpLocks = false;
    public static final int FileSizeChangeRate = 10;
    public static final int MaxPathLength = 255;
    public static final int NTFSStreamsInfoBufsize = 4096;
    private static byte[] _sdEveryOne = new byte[]{1, 0, 4, -128, 20, 0, 0, 0, 32, 0, 0, 0, 0, 0, 0, 0, 44, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 2, 0, 28, 0, 1, 0, 0, 0, 0, 0, 20, 0, -1, 1, 31, 0, 1, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0};

    protected NTProtocolHandler() {
    }

    protected NTProtocolHandler(SMBSrvSession sess) {
        super(sess);
    }

    @Override
    public String getName() {
        return "NT";
    }

    @Override
    protected void procSessionSetup(SMBSrvPacket smbPkt, SMBV1Parser parser) throws SMBSrvException, IOException, TooManyConnectionsException {
        ISMBAuthenticator smbAuthenticator = this.m_sess.getSMBServer().getSMBAuthenticator();
        try {
            smbAuthenticator.processSessionSetup(this.m_sess, smbPkt);
        }
        catch (SMBSrvException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, ex.getNTErrorCode(), ex.getErrorCode(), ex.getErrorClass());
            return;
        }
        SMBSrvPacket outPkt = smbPkt;
        if (smbPkt.hasAssociatedPacket() && !parser.hasAndXCommand()) {
            outPkt = outPkt.getAssociatedPacket();
        }
        SMBV1Parser respParser = (SMBV1Parser)outPkt.getParser();
        int pos = respParser.getLength();
        if (parser.hasAndXCommand() && parser.getPosition() < smbPkt.getReceivedLength()) {
            pos = this.procAndXCommands(outPkt, parser, null);
            pos -= 4;
            outPkt = smbPkt.getAssociatedPacket();
            respParser = (SMBV1Parser)outPkt.getParser();
        } else {
            respParser.setAndXCommand(255);
        }
        respParser.setResponse();
        this.m_sess.sendResponseSMB(outPkt, pos);
        if (respParser.getLongErrorCode() == 0) {
            this.m_sess.setState(SessionState.SMB_SESSION);
            this.m_sess.findVirtualCircuit(respParser.getUserId());
            this.m_sess.getSMBServer().sessionLoggedOn(this.m_sess);
        }
    }

    protected final int procAndXCommands(SMBSrvPacket smbPkt, SMBV1Parser parser, NetworkFile file) {
        SMBSrvPacket respPkt = smbPkt.getAssociatedPacket();
        if (respPkt == null) {
            throw new RuntimeException("No response packet allocated for AndX request");
        }
        int andxCmd = parser.getAndXCommand();
        int andxOff = parser.getParameter(1) + 4;
        respPkt.setParser(SMBSrvPacket.Version.V1);
        SMBV1Parser respParser = (SMBV1Parser)respPkt.getParser();
        respParser.setAndXCommand(andxCmd);
        int endOfPkt = respParser.getByteOffset() + respParser.getByteCount();
        respParser.setParameter(1, endOfPkt - 4);
        int paramBlk = 36;
        boolean andxErr = false;
        while (andxCmd != 255 && !andxErr) {
            int prevEndOfPkt = endOfPkt;
            boolean endOfChain = false;
            switch (andxCmd) {
                case 117: {
                    endOfPkt = this.procChainedTreeConnectAndX(andxOff, smbPkt, respPkt, endOfPkt);
                    break;
                }
                case 4: {
                    endOfPkt = this.procChainedClose(andxOff, smbPkt, respPkt, endOfPkt);
                    endOfChain = true;
                    break;
                }
                case 46: {
                    endOfPkt = this.procChainedReadAndX(andxOff, smbPkt, respPkt, endOfPkt, file);
                    break;
                }
                default: {
                    Debug.println("<<<<< Chained command : 0x" + Integer.toHexString(andxCmd) + " Not Processed >>>>>");
                }
            }
            respParser.setAndXCommand(paramBlk, andxCmd);
            respParser.setAndXParameter(paramBlk, 1, prevEndOfPkt - 4);
            if (!endOfChain) {
                andxCmd = parser.getAndXParameter(andxOff, 0) & 0xFF;
                andxOff = parser.getAndXParameter(andxOff, 1);
                paramBlk = prevEndOfPkt;
            } else {
                andxCmd = 255;
            }
            if (respParser.getErrorCode() == 0) continue;
            andxErr = true;
        }
        return endOfPkt;
    }

    protected final int procChainedTreeConnectAndX(int cmdOff, SMBSrvPacket smbPkt, SMBSrvPacket respPkt, int endOff) {
        String devType;
        byte[] outBuf;
        int pos;
        SMBV1Parser respParser;
        block28: {
            boolean unicode;
            String uncPath;
            SMBV1Parser reqParser = (SMBV1Parser)smbPkt.getParser();
            respParser = (SMBV1Parser)respPkt.getParser();
            int flags = reqParser.getAndXParameter(cmdOff, 2);
            int pwdLen = reqParser.getAndXParameter(cmdOff, 3);
            VirtualCircuit vc = this.m_sess.findVirtualCircuit(respParser.getUserId());
            if (vc == null) {
                respParser.setError(reqParser.isLongErrorCode(), -1073741811, 1, 2);
                return endOff;
            }
            reqParser.setBytePointer(reqParser.getAndXByteOffset(cmdOff), reqParser.getAndXByteCount(cmdOff));
            String pwd = null;
            if (pwdLen > 0) {
                byte[] pwdByt = reqParser.unpackBytes(pwdLen);
                pwd = new String(pwdByt);
            }
            if ((uncPath = reqParser.unpackString(unicode = reqParser.isUnicode())) == null) {
                respParser.setError(reqParser.isLongErrorCode(), -1073741811, 1, 2);
                return endOff;
            }
            String service = reqParser.unpackString(false);
            if (service == null) {
                respParser.setError(reqParser.isLongErrorCode(), -1073741811, 1, 2);
                return endOff;
            }
            ShareType servType = ShareType.ServiceAsType(service);
            if (servType == ShareType.UNKNOWN && service.compareTo("?????") != 0) {
                respParser.setError(reqParser.isLongErrorCode(), -1073741811, 1, 2);
                return endOff;
            }
            if (this.m_sess.hasDebug(64)) {
                this.m_sess.debugPrintln("NT ANDX Tree Connect AndX - " + uncPath + ", " + service);
            }
            PCShare share = null;
            try {
                share = new PCShare(uncPath);
            }
            catch (InvalidUNCPathException ex) {
                respParser.setError(reqParser.isLongErrorCode(), -1073741811, 1, 2);
                return endOff;
            }
            if (share.getShareName().compareTo("IPC$") == 0) {
                servType = ShareType.ADMINPIPE;
            }
            if (this.m_sess.hasClientInformation() && this.m_sess.getClientInformation().isNullSession() && servType != ShareType.ADMINPIPE) {
                respParser.setError(reqParser.isLongErrorCode(), -1073741790, 5, 1);
                return endOff;
            }
            SharedDevice shareDev = null;
            try {
                shareDev = this.m_sess.getSMBServer().findShare(share.getNodeName(), share.getShareName(), servType, this.m_sess, true);
            }
            catch (InvalidUserException ex) {
                respParser.setError(reqParser.isLongErrorCode(), -1073741715, 5, 1);
                return endOff;
            }
            catch (Exception ex) {
                respParser.setError(reqParser.isLongErrorCode(), -1073741620, 6, 2);
                return endOff;
            }
            if (shareDev == null || servType != ShareType.UNKNOWN && shareDev.getType() != servType) {
                respParser.setError(reqParser.isLongErrorCode(), -1073741620, 6, 2);
                return endOff;
            }
            ISMBAuthenticator auth = this.getSession().getSMBServer().getSMBAuthenticator();
            ISMBAuthenticator.ShareStatus sharePerm = ISMBAuthenticator.ShareStatus.WRITEABLE;
            if (auth != null && auth.getAccessMode() == ISMBAuthenticator.AuthMode.SHARE && (sharePerm = auth.authenticateShareConnect(this.m_sess.getClientInformation(), shareDev, pwd, this.m_sess)) == ISMBAuthenticator.ShareStatus.NO_ACCESS) {
                respParser.setError(reqParser.isLongErrorCode(), -1073741790, 5, 1);
                return endOff;
            }
            if (this.getSession().getServer().hasAccessControlManager() && shareDev.hasAccessControls()) {
                AccessControlManager aclMgr = this.getSession().getServer().getAccessControlManager();
                int aclPerm = aclMgr.checkAccessControl(this.getSession(), shareDev);
                if (aclPerm == 0) {
                    respParser.setError(reqParser.isLongErrorCode(), -1073741790, 5, 1);
                    return endOff;
                }
                if (aclPerm != -1) {
                    sharePerm = this.asShareStatus(aclPerm);
                }
            }
            TreeConnection tree = null;
            try {
                int treeId = vc.addConnection(shareDev);
                respParser.setTreeId(treeId);
                tree = vc.findConnection(treeId);
                tree.setPermission(sharePerm);
                if (tree.getInterface() != null) {
                    tree.getInterface().treeOpened(this.m_sess, tree);
                }
                if (this.m_sess.hasDebug(64)) {
                    this.m_sess.debugPrintln("ANDX Tree Connect AndX - Allocated Tree Id = " + treeId);
                }
            }
            catch (TooManyConnectionsException ex) {
                respParser.setError(89, 2);
                return endOff;
            }
            respParser.setAndXParameterCount(endOff, 2);
            respParser.setAndXParameter(endOff, 0, 255);
            respParser.setAndXParameter(endOff, 1, 0);
            pos = respParser.getAndXByteOffset(endOff);
            outBuf = respParser.getBuffer();
            pos = DataPacker.putString(ShareType.TypeAsService(shareDev.getType()), outBuf, pos, true);
            devType = "";
            try {
                if (shareDev.getType() == ShareType.DISK) {
                    if (shareDev.getInterface() instanceof NTFSStreamsInterface) {
                        NTFSStreamsInterface ntfsStreams = (NTFSStreamsInterface)((Object)shareDev.getInterface());
                        if (ntfsStreams.hasStreamsEnabled(this.m_sess, tree)) {
                            devType = "NTFS";
                        }
                    } else {
                        DiskDeviceContext diskCtx = (DiskDeviceContext)tree.getContext();
                        devType = diskCtx.getFilesystemType();
                    }
                }
            }
            catch (InvalidDeviceInterfaceException ex) {
                if (!this.m_sess.hasDebug(64)) break block28;
                Debug.println("ANDX TreeConnectAndX error " + ex.getMessage());
            }
        }
        pos = DataPacker.putString(devType, outBuf, pos, true, respParser.isUnicode());
        int bytLen = pos - respParser.getAndXByteOffset(endOff);
        respParser.setAndXByteCount(endOff, bytLen);
        return pos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final int procChainedReadAndX(int cmdOff, SMBSrvPacket smbPkt, SMBSrvPacket respPkt, int endOff, NetworkFile netFile) {
        SMBV1Parser reqParser = (SMBV1Parser)smbPkt.getParser();
        SMBV1Parser respParser = (SMBV1Parser)respPkt.getParser();
        TreeConnection conn = this.m_sess.findTreeConnection(smbPkt);
        if (conn == null) {
            respParser.setError(15, 1);
            return endOff;
        }
        long offset = reqParser.getAndXParameterLong(cmdOff, 3);
        offset &= 0xFFFFFFFFL;
        int maxCount = reqParser.getAndXParameter(cmdOff, 5);
        if (reqParser.getAndXParameterCount(cmdOff) == 12) {
            long topOff = reqParser.getAndXParameterLong(cmdOff, 10);
            offset += topOff << 32;
        }
        if (this.m_sess.hasDebug(512)) {
            this.m_sess.debugPrintln("Chained File Read AndX : Size=" + maxCount + " ,Pos=" + offset);
        }
        byte[] buf = respPkt.getBuffer();
        int dataPos = 0;
        int rdlen = 0;
        try {
            DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
            respParser.setAndXParameterCount(endOff, 12);
            dataPos = respParser.getAndXByteOffset(endOff);
            dataPos = DataPacker.wordAlign(dataPos);
            int dataLen = buf.length - dataPos;
            if (dataLen < maxCount) {
                maxCount = dataLen;
            }
            NetworkFile networkFile = netFile;
            synchronized (networkFile) {
                rdlen = disk.readFile(this.m_sess, conn, netFile, buf, dataPos, maxCount, offset);
            }
            respParser.setAndXParameter(endOff, 0, 255);
            respParser.setAndXParameter(endOff, 1, 0);
            respParser.setAndXParameter(endOff, 2, 0);
            respParser.setAndXParameter(endOff, 3, 0);
            respParser.setAndXParameter(endOff, 4, 0);
            respParser.setAndXParameter(endOff, 5, rdlen);
            respParser.setAndXParameter(endOff, 6, dataPos - 4);
            for (int i = 7; i < 12; ++i) {
                respParser.setAndXParameter(endOff, i, 0);
            }
            respParser.setAndXByteCount(endOff, dataPos + rdlen - respParser.getAndXByteOffset(endOff));
            endOff = dataPos + rdlen;
        }
        catch (InvalidDeviceInterfaceException ex) {
            respParser.setError(13, 1);
            return endOff;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return endOff;
    }

    protected final int procChainedClose(int cmdOff, SMBSrvPacket smbPkt, SMBSrvPacket respPkt, int endOff) {
        SMBV1Parser reqParser = (SMBV1Parser)smbPkt.getParser();
        SMBV1Parser respParser = (SMBV1Parser)respPkt.getParser();
        TreeConnection conn = this.m_sess.findTreeConnection(smbPkt);
        if (conn == null) {
            respParser.setError(15, 1);
            return endOff;
        }
        int fid = reqParser.getAndXParameter(cmdOff, 0);
        int ftime = reqParser.getAndXParameter(cmdOff, 1);
        int fdate = reqParser.getAndXParameter(cmdOff, 2);
        NetworkFile netFile = conn.findFile(fid);
        if (netFile == null) {
            respParser.setError(15, 1);
            return endOff;
        }
        if (this.m_sess.hasDebug(512)) {
            this.m_sess.debugPrintln("Chained File Close [" + reqParser.getTreeId() + "] fid=" + fid);
        }
        try {
            DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
            if (disk != null) {
                disk.closeFile(this.m_sess, conn, netFile);
            }
            netFile.setClosed(true);
        }
        catch (InvalidDeviceInterfaceException ex) {
            respParser.setError(13, 1);
            return endOff;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        respParser.setAndXParameterCount(endOff, 0);
        respParser.setAndXByteCount(endOff, 0);
        endOff = respParser.getAndXByteOffset(endOff) - 4;
        conn.removeFile(fid, this.getSession());
        return endOff;
    }

    protected void procTreeConnectAndX(SMBSrvPacket smbPkt, SMBV1Parser parser) throws SMBSrvException, TooManyConnectionsException, IOException {
        String devType;
        int pos;
        TreeConnection tree;
        block34: {
            String uncPath;
            if (!parser.checkPacketIsValid(4, 3)) {
                this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
                return;
            }
            VirtualCircuit vc = this.m_sess.findVirtualCircuit(parser.getUserId());
            if (vc == null) {
                this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
                return;
            }
            int flags = parser.getParameter(2);
            int pwdLen = parser.getParameter(3);
            parser.resetBytePointer();
            boolean unicode = parser.isUnicode();
            String pwd = null;
            if (pwdLen > 0) {
                byte[] pwdByts = parser.unpackBytes(pwdLen);
                pwd = new String(pwdByts);
            }
            if ((uncPath = parser.unpackString(unicode)) == null) {
                this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
                return;
            }
            String service = parser.unpackString(false);
            if (service == null) {
                this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
                return;
            }
            ShareType servType = ShareType.ServiceAsType(service);
            if (servType == ShareType.UNKNOWN && service.compareTo("?????") != 0) {
                this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
                return;
            }
            if (this.m_sess.hasDebug(64)) {
                this.m_sess.debugPrintln("NT Tree Connect AndX - " + uncPath + ", " + service + ", flags=" + TreeConnectAndX.asStringRequest(flags) + "/0x" + Integer.toHexString(flags));
            }
            String shareName = null;
            String hostName = null;
            if (uncPath.startsWith("\\")) {
                try {
                    PCShare share = new PCShare(uncPath);
                    shareName = share.getShareName();
                    hostName = share.getNodeName();
                }
                catch (InvalidUNCPathException ex) {
                    this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
                    return;
                }
            } else {
                shareName = uncPath;
            }
            if (shareName.compareTo("IPC$") == 0) {
                servType = ShareType.ADMINPIPE;
            }
            if (this.m_sess.hasClientInformation() && this.m_sess.getClientInformation().isNullSession() && servType != ShareType.ADMINPIPE) {
                this.m_sess.sendErrorResponseSMB(smbPkt, -1073741790, 5, 1);
                return;
            }
            SharedDevice shareDev = null;
            try {
                shareDev = this.m_sess.getSMBServer().findShare(hostName, shareName, servType, this.m_sess, true);
            }
            catch (InvalidUserException ex) {
                this.m_sess.sendErrorResponseSMB(smbPkt, -1073741715, 5, 1);
                return;
            }
            catch (Exception ex) {
                this.m_sess.sendErrorResponseSMB(smbPkt, -1073741620, 6, 2);
                return;
            }
            if (shareDev == null || servType != ShareType.UNKNOWN && shareDev.getType() != servType) {
                this.m_sess.sendErrorResponseSMB(smbPkt, -1073741620, 6, 2);
                return;
            }
            ISMBAuthenticator auth = this.getSession().getSMBServer().getSMBAuthenticator();
            ISMBAuthenticator.ShareStatus sharePerm = ISMBAuthenticator.ShareStatus.WRITEABLE;
            if (auth != null && (sharePerm = auth.authenticateShareConnect(this.m_sess.getClientInformation(), shareDev, pwd, this.m_sess)) == ISMBAuthenticator.ShareStatus.NO_ACCESS) {
                if (this.m_sess.hasDebug(64)) {
                    this.m_sess.debugPrint("Tree connect to " + shareName + ", access denied");
                }
                this.m_sess.sendErrorResponseSMB(smbPkt, -1073741790, 5, 1);
                return;
            }
            if (this.getSession().getServer().hasAccessControlManager() && shareDev.hasAccessControls()) {
                AccessControlManager aclMgr = this.getSession().getServer().getAccessControlManager();
                int aclPerm = aclMgr.checkAccessControl(this.getSession(), shareDev);
                if (aclPerm == 0) {
                    this.m_sess.sendErrorResponseSMB(smbPkt, -1073741790, 5, 1);
                    return;
                }
                if (aclPerm != -1) {
                    sharePerm = this.asShareStatus(aclPerm);
                }
            }
            int treeId = vc.addConnection(shareDev);
            parser.setTreeId(treeId);
            tree = vc.findConnection(treeId);
            tree.setPermission(sharePerm);
            if (this.m_sess.hasDebug(64)) {
                this.m_sess.debugPrintln("Tree Connect AndX - Allocated Tree Id = " + treeId + ", Permission = " + sharePerm.name() + ", extendedResponse=" + TreeConnectAndX.hasExtendedResponse(flags));
            }
            if (TreeConnectAndX.hasExtendedResponse(flags) && servType != ShareType.ADMINPIPE) {
                parser.setParameterCount(7);
                parser.setAndXCommand(255);
                parser.setParameter(1, 0);
                parser.setParameter(2, 0);
                if (sharePerm == ISMBAuthenticator.ShareStatus.WRITEABLE) {
                    parser.setParameterLong(3, 0x1F01FF);
                } else {
                    parser.setParameterLong(3, 1179785);
                }
                parser.setParameterLong(5, 0);
            } else {
                parser.setParameterCount(3);
                parser.setAndXCommand(255);
                parser.setParameter(1, 0);
                parser.setParameter(2, 0);
            }
            pos = parser.getByteOffset();
            pos = DataPacker.putString(ShareType.TypeAsService(shareDev.getType()), smbPkt.getBuffer(), pos, true);
            devType = "";
            try {
                if (shareDev.getType() == ShareType.DISK) {
                    if (shareDev.getInterface() instanceof NTFSStreamsInterface) {
                        NTFSStreamsInterface ntfsStreams = (NTFSStreamsInterface)((Object)shareDev.getInterface());
                        if (ntfsStreams.hasStreamsEnabled(this.m_sess, tree)) {
                            devType = "NTFS";
                        }
                    } else {
                        DiskDeviceContext diskCtx = (DiskDeviceContext)tree.getContext();
                        devType = diskCtx.getFilesystemType();
                    }
                }
            }
            catch (InvalidDeviceInterfaceException ex) {
                if (!this.m_sess.hasDebug(64)) break block34;
                Debug.println("TreeConnectAndX error " + ex.getMessage());
            }
        }
        pos = DataPacker.wordAlign(pos);
        pos = DataPacker.putString(devType, smbPkt.getBuffer(), pos, true, parser.isUnicode());
        parser.setByteCount(pos - parser.getByteOffset());
        this.m_sess.sendResponseSMB(smbPkt);
        if (tree.getInterface() != null) {
            tree.getInterface().treeOpened(this.m_sess, tree);
        }
    }

    @Override
    protected void procCloseFile(SMBSrvPacket smbPkt, SMBV1Parser parser) throws IOException, SMBSrvException {
        if (!parser.checkPacketIsValid(3, 0)) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 64, 2);
            return;
        }
        TreeConnection conn = this.m_sess.findTreeConnection(smbPkt);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 4, 2);
            return;
        }
        int fid = parser.getParameter(0);
        int ftime = parser.getParameter(1);
        int fdate = parser.getParameter(2);
        NetworkFile netFile = conn.findFile(fid);
        if (netFile == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 6, 1);
            return;
        }
        if (this.m_sess.hasDebug(512)) {
            this.m_sess.debugPrintln("File close [" + parser.getTreeId() + "] fid=" + fid + ", fileId=" + netFile.getFileId());
        }
        boolean delayedClose = false;
        try {
            DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
            if (disk != null) {
                long startTime = 0L;
                if (netFile.hasDeleteOnClose() && this.m_sess.hasDebug(0x2000000)) {
                    startTime = System.currentTimeMillis();
                }
                if (netFile.hasOpLock()) {
                    OpLockHelper.releaseOpLock(this.m_sess, smbPkt, disk, conn, netFile);
                }
                disk.closeFile(this.m_sess, conn, netFile);
                if (netFile.hasLocks() && disk instanceof FileLockingInterface) {
                    FileLockingInterface flIface = (FileLockingInterface)((Object)disk);
                    LockManager lockMgr = flIface.getLockManager(this.m_sess, conn);
                    if (this.m_sess.hasDebug(32768)) {
                        Debug.println("Releasing locks for closed file, file=" + netFile.getFullName() + ", locks=" + netFile.numberOfLocks());
                    }
                    lockMgr.releaseLocksForFile(this.m_sess, conn, netFile);
                }
                if (netFile.hasDelayedClose()) {
                    delayedClose = true;
                    netFile.setDelayedClose(false);
                    if (this.m_sess.hasDebug(512)) {
                        this.m_sess.debugPrintln("File close delayed [" + parser.getTreeId() + "] fid=" + fid + ", path=" + netFile.getFullName());
                    }
                }
                if (startTime != 0L && this.m_sess.hasDebug(0x2000000)) {
                    Debug.println("Benchmark: Delete on close " + netFile.getName() + " took " + (System.currentTimeMillis() - startTime) + "ms");
                }
            }
            if (!delayedClose) {
                netFile.setClosed(true);
            }
            if (this.m_sess.hasDebug(0x2000000)) {
                if (!netFile.isDirectory()) {
                    if (netFile.wasCreated() && netFile.getWriteCount() > 0) {
                        this.m_sess.debugPrintln("Benchmark: File=" + netFile.getFullName() + ", Size=" + MemorySize.asScaledString(netFile.getFileSize()) + ", Write Time=" + (System.currentTimeMillis() - netFile.getCreationDate()) + "ms, ClosedAt=" + new Time(System.currentTimeMillis()));
                    }
                } else if (netFile.getCreationDate() != 0L) {
                    this.m_sess.debugPrintln("Benchmark: Dir=" + netFile.getFullName() + ", Write Time=" + (System.currentTimeMillis() - netFile.getCreationDate()) + "ms, CreatedAt=" + new Time(netFile.getCreationDate()));
                } else {
                    this.m_sess.debugPrintln("Benchmark: Dir=" + netFile.getFullName() + ", ClosedAt=" + new Time(System.currentTimeMillis()));
                }
            }
        }
        catch (InvalidDeviceInterfaceException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 13, 1);
            return;
        }
        catch (AccessDeniedException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741790, 5, 1);
            return;
        }
        catch (Throwable ex) {
            // empty catch block
        }
        if (!delayedClose) {
            conn.removeFile(fid, this.getSession());
        }
        parser.setParameterCount(0);
        parser.setByteCount(0);
        this.m_sess.sendResponseSMB(smbPkt);
        DiskDeviceContext diskCtx = (DiskDeviceContext)conn.getContext();
        if (diskCtx != null && diskCtx.hasFileServerNotifications()) {
            if (netFile.getWriteCount() > 0) {
                diskCtx.getChangeHandler().notifyFileSizeChanged(netFile.getFullName());
            }
            if (netFile.hasDeleteOnClose()) {
                diskCtx.getChangeHandler().notifyFileChanged(NotifyAction.Removed, netFile.getFullName());
            }
        }
    }

    protected void procTransact2(SMBSrvPacket smbPkt, SMBV1Parser parser) throws IOException, SMBSrvException {
        if (!parser.checkPacketIsValid(14, 0)) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
            return;
        }
        VirtualCircuit vc = this.m_sess.findVirtualCircuit(parser.getUserId());
        if (vc == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
            return;
        }
        TreeConnection conn = vc.findConnection(parser.getTreeId());
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 4, 2);
            return;
        }
        SMBSrvTransPacket tranPkt = new SMBSrvTransPacket(parser);
        SrvTransactBuffer transBuf = null;
        int subCmd = tranPkt.getSubFunction();
        if (tranPkt.getTotalParameterCount() == tranPkt.getRxParameterBlockLength() && tranPkt.getTotalDataCount() == tranPkt.getRxDataBlockLength()) {
            transBuf = new SrvTransactBuffer(tranPkt);
        } else {
            transBuf = new SrvTransactBuffer(tranPkt.getSetupCount(), tranPkt.getTotalParameterCount(), tranPkt.getTotalDataCount());
            transBuf.setType(parser.getCommand());
            transBuf.setFunction(subCmd);
            byte[] buf = tranPkt.getBuffer();
            transBuf.appendSetup(buf, tranPkt.getSetupOffset(), tranPkt.getSetupCount() * 2);
            transBuf.appendParameter(buf, tranPkt.getRxParameterBlock(), tranPkt.getRxParameterBlockLength());
            transBuf.appendData(buf, tranPkt.getRxDataBlock(), tranPkt.getRxDataBlockLength());
        }
        transBuf.setReturnLimits(tranPkt.getMaximumReturnSetupCount(), tranPkt.getMaximumReturnParameterCount(), tranPkt.getMaximumReturnDataCount());
        tranPkt.setBuffer(null);
        if (transBuf.isMultiPacket()) {
            vc.setTransaction(transBuf);
            this.m_sess.sendSuccessResponseSMB(smbPkt);
            return;
        }
        if (conn.getSharedDevice().getType() == ShareType.ADMINPIPE) {
            IPCHandler.procTransaction(vc, transBuf, this.m_sess, smbPkt);
            return;
        }
        if (this.m_sess.hasDebug(2048)) {
            this.m_sess.debugPrintln("Transaction [" + parser.getTreeId() + "] tbuf=" + transBuf);
        }
        this.processTransactionBuffer(transBuf, smbPkt, parser);
    }

    protected void procTransact2Secondary(SMBSrvPacket smbPkt, SMBV1Parser parser) throws IOException, SMBSrvException {
        int dlen;
        if (!parser.checkPacketIsValid(8, 0)) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
            return;
        }
        VirtualCircuit vc = this.m_sess.findVirtualCircuit(parser.getUserId());
        if (vc == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
            return;
        }
        int treeId = parser.getTreeId();
        TreeConnection conn = vc.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 4, 2);
            return;
        }
        if (!vc.hasTransaction() || vc.getTransaction().isType() == 37 && parser.getCommand() != 38 || vc.getTransaction().isType() == 50 && parser.getCommand() != 51) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 1, 2);
            return;
        }
        SMBSrvTransPacket tpkt = new SMBSrvTransPacket(parser.getBuffer());
        byte[] buf = tpkt.getBuffer();
        SrvTransactBuffer transBuf = vc.getTransaction();
        int plen = tpkt.getSecondaryParameterBlockCount();
        if (plen > 0) {
            DataBuffer paramBuf = transBuf.getParameterBuffer();
            paramBuf.appendData(buf, tpkt.getSecondaryParameterBlockOffset(), plen);
        }
        if ((dlen = tpkt.getSecondaryDataBlockCount()) > 0) {
            DataBuffer dataBuf = transBuf.getDataBuffer();
            dataBuf.appendData(buf, tpkt.getSecondaryDataBlockOffset(), dlen);
        }
        if (this.m_sess.hasDebug(2048)) {
            this.m_sess.debugPrintln("Transaction Secondary [" + treeId + "] paramLen=" + plen + ", dataLen=" + dlen);
        }
        int totParam = tpkt.getTotalParameterCount();
        int totData = tpkt.getTotalDataCount();
        int paramDisp = tpkt.getParameterBlockDisplacement();
        int dataDisp = tpkt.getDataBlockDisplacement();
        if (paramDisp + plen == totParam && dataDisp + dlen == totData) {
            if (this.m_sess.hasDebug(2048)) {
                this.m_sess.debugPrintln("Transaction complete, processing ...");
            }
            vc.setTransaction(null);
            if (conn.getSharedDevice().getType() == ShareType.ADMINPIPE) {
                IPCHandler.procTransaction(vc, transBuf, this.m_sess, smbPkt);
                return;
            }
            if (this.m_sess.hasDebug(2048)) {
                this.m_sess.debugPrintln("Transaction second [" + treeId + "] tbuf=" + transBuf);
            }
            this.processTransactionBuffer(transBuf, smbPkt, parser);
        } else {
            this.m_sess.sendSuccessResponseSMB(smbPkt);
        }
    }

    private final void processTransactionBuffer(SrvTransactBuffer tbuf, SMBSrvPacket smbPkt, SMBV1Parser parser) throws IOException, SMBSrvException {
        switch (tbuf.getFunction()) {
            case 1: {
                this.procTrans2FindFirst(tbuf, smbPkt, parser);
                break;
            }
            case 2: {
                this.procTrans2FindNext(tbuf, smbPkt, parser);
                break;
            }
            case 3: {
                this.procTrans2QueryFileSys(tbuf, smbPkt, parser);
                break;
            }
            case 5: {
                this.procTrans2QueryPath(tbuf, smbPkt, parser);
                break;
            }
            case 7: {
                this.procTrans2QueryFile(tbuf, smbPkt, parser);
                break;
            }
            case 8: {
                this.procTrans2SetFile(tbuf, smbPkt, parser);
                break;
            }
            case 6: {
                this.procTrans2SetPath(tbuf, smbPkt, parser);
                break;
            }
            default: {
                this.m_sess.debugPrintln("NT Error Transact2 Command = 0x" + Integer.toHexString(tbuf.getFunction()));
                this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
            }
        }
    }

    protected final void procFindClose(SMBSrvPacket smbPkt, SMBV1Parser parser) throws IOException, SMBSrvException {
        if (!parser.checkPacketIsValid(1, 0)) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
            return;
        }
        VirtualCircuit vc = this.m_sess.findVirtualCircuit(parser.getUserId());
        if (vc == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
            return;
        }
        int treeId = parser.getTreeId();
        TreeConnection conn = vc.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 4, 2);
            return;
        }
        int searchId = parser.getParameter(0);
        SearchContext ctx = vc.getSearchContext(searchId);
        if (ctx == null) {
            this.m_sess.sendSuccessResponseSMB(smbPkt);
            return;
        }
        if (this.m_sess.hasDebug(128)) {
            this.m_sess.debugPrintln("Close trans search [" + searchId + "]");
        }
        vc.deallocateSearchSlot(searchId);
        this.m_sess.sendSuccessResponseSMB(smbPkt);
    }

    protected final void procLockingAndX(SMBSrvPacket smbPkt, SMBV1Parser parser) throws IOException, SMBSrvException {
        if (!parser.checkPacketIsValid(8, 0)) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
            return;
        }
        VirtualCircuit vc = this.m_sess.findVirtualCircuit(parser.getUserId());
        if (vc == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
            return;
        }
        int treeId = parser.getTreeId();
        TreeConnection conn = vc.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 4, 2);
            return;
        }
        int fid = parser.getParameter(2);
        int lockType = parser.getParameter(3);
        long lockTmo = parser.getParameterLong(4);
        int unlockCnt = parser.getParameter(6);
        int lockCnt = parser.getParameter(7);
        NetworkFile netFile = conn.findFile(fid);
        if (netFile == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 6, 6, 1);
            return;
        }
        if (this.m_sess.hasDebug(32768)) {
            this.m_sess.debugPrintln("File Lock [" + netFile.getFileId() + "] : type=0x" + Integer.toHexString(lockType) + ", tmo=" + lockTmo + ", locks=" + lockCnt + ", unlocks=" + unlockCnt);
        }
        DiskInterface disk = null;
        try {
            disk = (DiskInterface)conn.getSharedDevice().getInterface();
        }
        catch (InvalidDeviceInterfaceException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 13, 1);
            return;
        }
        if (LockingAndX.hasOplockBreak(lockType)) {
            if (this.m_sess.hasDebug(0x4000000)) {
                Debug.println("Oplock break, flags=0x" + Integer.toHexString(lockType) + " file=" + netFile);
            }
            if (disk instanceof OpLockInterface) {
                OpLockInterface oplockIface = (OpLockInterface)((Object)disk);
                OpLockManager oplockMgr = oplockIface.getOpLockManager(this.m_sess, conn);
                if (oplockMgr == null) {
                    if (this.m_sess.hasDebug(0x4000000)) {
                        Debug.print("  OpLock manager is null, tree=" + conn);
                    }
                    this.m_sess.sendErrorResponseSMB(smbPkt, 65535, 2);
                    return;
                }
                OpLockDetails oplock = oplockMgr.getOpLockDetails(netFile.getFullName());
                if (oplock == null) {
                    this.m_sess.sendErrorResponseSMB(smbPkt, -1073741698, 158, 1);
                    return;
                }
                if (!LockingAndX.hasLevelIIOplock(lockType)) {
                    oplockMgr.releaseOpLock(oplock.getPath());
                    if (this.m_sess.hasDebug(0x4000000)) {
                        Debug.println("  Oplock released, oplock=" + oplock);
                    }
                } else {
                    oplockMgr.changeOpLockType(oplock, OpLockType.LEVEL_II);
                    if (this.m_sess.hasDebug(0x4000000)) {
                        Debug.println("  Oplock converted to LevelII, oplock=" + oplock);
                    }
                }
            } else {
                this.m_sess.sendErrorResponseSMB(smbPkt, 65535, 2);
                return;
            }
        }
        if (unlockCnt > 0 || lockCnt > 0) {
            if (disk instanceof FileLockingInterface) {
                FileLockingInterface lockInterface = (FileLockingInterface)((Object)disk);
                LockManager lockMgr = lockInterface.getLockManager(this.m_sess, conn);
                parser.resetBytePointer();
                boolean largeFileLock = LockingAndX.hasLargeFiles(lockType);
                int lockIdx = 0;
                while (lockIdx < unlockCnt + lockCnt) {
                    boolean isLock;
                    int pid = parser.unpackWord();
                    long offset = -1L;
                    long length = -1L;
                    if (!largeFileLock) {
                        offset = parser.unpackInt();
                        length = parser.unpackInt();
                    } else {
                        parser.skipBytes(2);
                        offset = (long)parser.unpackInt() << 32;
                        offset += (long)parser.unpackInt();
                        length = (long)parser.unpackInt() << 32;
                        length += (long)parser.unpackInt();
                    }
                    FileLock fLock = lockMgr.createLockObject(this.m_sess, conn, netFile, new LockParams(offset, length, pid));
                    boolean bl = isLock = lockIdx++ < lockCnt;
                    if (this.m_sess.hasDebug(32768)) {
                        this.m_sess.debugPrintln("  " + (isLock ? "Lock" : "UnLock") + " lock=" + fLock);
                    }
                    try {
                        if (!isLock) {
                            lockMgr.unlockFile(this.m_sess, conn, netFile, fLock);
                            continue;
                        }
                        lockMgr.lockFile(this.m_sess, conn, netFile, fLock);
                    }
                    catch (NotLockedException ex) {
                        this.m_sess.sendErrorResponseSMB(smbPkt, -1073741698, 158, 1);
                        return;
                    }
                    catch (LockConflictException ex) {
                        this.m_sess.sendErrorResponseSMB(smbPkt, -1073741739, 33, 1);
                        return;
                    }
                    catch (IOException ex) {
                        this.m_sess.sendErrorResponseSMB(smbPkt, 65, 2);
                        return;
                    }
                }
            } else if (unlockCnt > 0) {
                this.m_sess.sendErrorResponseSMB(smbPkt, -1073741698, 158, 1);
                return;
            }
            parser.setParameterCount(2);
            parser.setAndXCommand(255);
            parser.setParameter(1, 0);
            parser.setByteCount(0);
            this.m_sess.sendResponseSMB(smbPkt);
        }
    }

    protected final void procLogoffAndX(SMBSrvPacket smbPkt, SMBV1Parser parser) throws IOException, SMBSrvException {
        if (!parser.checkPacketIsValid(2, 0)) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
            return;
        }
        int uid = parser.getUserId();
        VirtualCircuit vc = this.m_sess.findVirtualCircuit(uid);
        if (vc == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
            return;
        }
        if (this.m_sess.hasDebug(32)) {
            Debug.println("[SMB] LogoffAndX vc=" + vc);
        }
        vc.setLoggedOn(false);
        if (vc.getConnectionCount() == 0) {
            this.m_sess.removeVirtualCircuit(vc.getId());
            if (this.m_sess.hasDebug(32)) {
                this.m_sess.debugPrintln("  Removed virtual circuit " + vc);
            }
        }
        this.m_sess.sendSuccessResponseSMB(smbPkt);
        if (this.m_sess.numberOfVirtualCircuits() == 0) {
            if (this.m_sess.hasDebug(32)) {
                Debug.println("  Closing session, no more virtual circuits");
            }
            this.m_sess.hangupSession("Client logoff");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void procOpenAndX(SMBSrvPacket smbPkt, SMBV1Parser parser) throws IOException, SMBSrvException {
        int fid;
        if (!parser.checkPacketIsValid(15, 1)) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
            return;
        }
        VirtualCircuit vc = this.m_sess.findVirtualCircuit(parser.getUserId());
        if (vc == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
            return;
        }
        int treeId = parser.getTreeId();
        TreeConnection conn = vc.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741790, 5, 1);
            return;
        }
        if (conn.getSharedDevice().getType() == ShareType.ADMINPIPE) {
            IPCHandler.processIPCRequest(this.m_sess, smbPkt);
            return;
        }
        if (conn.getSharedDevice().getType() != ShareType.DISK) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741790, 5, 1);
            return;
        }
        int flags = parser.getParameter(2);
        int access = parser.getParameter(3);
        int srchAttr = parser.getParameter(4);
        int fileAttr = parser.getParameter(5);
        int crTime = parser.getParameter(6);
        int crDate = parser.getParameter(7);
        int openFunc = parser.getParameter(8);
        int allocSiz = parser.getParameterLong(9);
        String fileName = parser.unpackString(parser.isUnicode());
        if (fileName == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 13, 1);
            return;
        }
        long crDateTime = 0L;
        if (crTime > 0 && crDate > 0) {
            crDateTime = new SMBDate(crDate, crTime).getTime();
        }
        FileOpenParams params = new FileOpenParams(fileName, openFunc, access, srchAttr, fileAttr, allocSiz, crDateTime, parser.getProcessIdFull());
        if (this.m_sess.hasDebug(512)) {
            this.m_sess.debugPrintln("File Open AndX [" + treeId + "] params=" + params);
        }
        if (!FileName.isValidPath(params.getPath())) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741773, 13, 1);
            return;
        }
        NetworkFile netFile = null;
        int respAction = 0;
        try {
            block26: {
                DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
                FileStatus fileSts = disk.fileExists(this.m_sess, conn, fileName);
                if (fileSts == FileStatus.NotExist) {
                    if (FileAction.createNotExists(openFunc)) {
                        if (!conn.hasWriteAccess()) {
                            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741790, 5, 1);
                            return;
                        }
                        netFile = disk.createFile(this.m_sess, conn, params);
                        respAction = 2;
                        break block26;
                    } else {
                        if (fileSts == FileStatus.DirectoryExists) {
                            this.m_sess.sendErrorResponseSMB(smbPkt, 5, 1);
                            return;
                        }
                        this.m_sess.sendErrorResponseSMB(smbPkt, 2, 1);
                        return;
                    }
                }
                netFile = disk.openFile(this.m_sess, conn, params);
                if (FileAction.truncateExistingFile(openFunc)) {
                    disk.truncateFile(this.m_sess, conn, netFile, 0L);
                    respAction = 3;
                } else {
                    respAction = 1;
                }
            }
            fid = conn.addFile(netFile, this.getSession());
        }
        catch (InvalidDeviceInterfaceException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 13, 1);
            return;
        }
        catch (TooManyFilesException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 4, 1);
            return;
        }
        catch (AccessDeniedException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741790, 5, 1);
            return;
        }
        catch (FileSharingException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741757, 32, 1);
            return;
        }
        catch (FileOfflineException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741209, 21, 3);
            return;
        }
        catch (DiskOfflineException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741766, 21, 3);
            return;
        }
        catch (IOException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 2, 1);
            return;
        }
        parser.setParameterCount(15);
        parser.setAndXCommand(255);
        parser.setParameter(1, 0);
        parser.setParameter(2, fid);
        parser.setParameter(3, netFile.getFileAttributes());
        SMBDate modDate = null;
        if (netFile.hasModifyDate()) {
            modDate = new SMBDate(netFile.getModifyDate());
        }
        parser.setParameter(4, modDate != null ? modDate.asSMBTime() : 0);
        parser.setParameter(5, modDate != null ? modDate.asSMBDate() : 0);
        parser.setParameterLong(6, netFile.getFileSizeInt());
        parser.setParameter(8, netFile.getGrantedAccess().intValue());
        parser.setParameter(9, 0);
        parser.setParameter(10, 0);
        parser.setParameter(11, respAction);
        parser.setParameter(12, 0);
        parser.setParameter(13, 0);
        parser.setParameter(14, 0);
        parser.setByteCount(0);
        this.m_sess.sendResponseSMB(smbPkt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void procReadAndX(SMBSrvPacket smbPkt, SMBV1Parser parser) throws IOException, SMBSrvException {
        NetworkFile netFile;
        if (!parser.checkPacketIsValid(10, 0)) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
            return;
        }
        VirtualCircuit vc = this.m_sess.findVirtualCircuit(parser.getUserId());
        if (vc == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
            return;
        }
        int treeId = parser.getTreeId();
        TreeConnection conn = vc.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741790, 5, 1);
            return;
        }
        if (conn.getSharedDevice().getType() == ShareType.ADMINPIPE) {
            IPCHandler.processIPCRequest(this.m_sess, smbPkt);
            return;
        }
        int fid = parser.getParameter(2);
        long offset = parser.getParameterLong(3);
        offset &= 0xFFFFFFFFL;
        int maxCount = parser.getParameter(5);
        if (parser.getParameterCount() == 12) {
            long topOff = parser.getParameterLong(10);
            offset += topOff << 32;
        }
        if ((netFile = conn.findFile(fid)) == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 6, 1);
            return;
        }
        if (this.m_sess.hasDebug(1024)) {
            this.m_sess.debugPrintln("File Read AndX [" + netFile.getFileId() + "] : Size=" + maxCount + " ,Pos=" + offset);
        }
        SMBSrvPacket respPkt = smbPkt;
        byte[] buf = respPkt.getBuffer();
        int dataPos = 0;
        int rdlen = 0;
        try {
            int dataLen;
            DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
            parser.setParameterCount(12);
            dataPos = parser.getByteOffset();
            dataPos = DataPacker.wordAlign(dataPos);
            if (maxCount > buf.length - dataPos) {
                respPkt = this.m_sess.getPacketPool().allocatePacket(maxCount + dataPos, smbPkt);
                respPkt.setParser(SMBSrvPacket.Version.V1);
                parser = (SMBV1Parser)respPkt.getParser();
                buf = respPkt.getBuffer();
                parser.setParameterCount(12);
            }
            if ((dataLen = buf.length - dataPos) < maxCount) {
                maxCount = dataLen;
            }
            NetworkFile networkFile = netFile;
            synchronized (networkFile) {
                rdlen = disk.readFile(this.m_sess, conn, netFile, buf, dataPos, maxCount, offset);
            }
        }
        catch (InvalidDeviceInterfaceException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 13, 1);
            return;
        }
        catch (FileOfflineException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741209, 30, 3);
            return;
        }
        catch (LockConflictException ex) {
            if (this.m_sess.hasDebug(32768)) {
                this.m_sess.debugPrintln("Read Lock Error [" + netFile.getFileId() + "] : Size=" + maxCount + " ,Pos=" + offset);
            }
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741740, 33, 1);
            return;
        }
        catch (AccessDeniedException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741790, 5, 1);
            return;
        }
        catch (DiskOfflineException ex) {
            if (this.m_sess.hasDebug(1024)) {
                this.m_sess.debugPrintln("Filesystem Offline Error [" + netFile.getFileId() + "] Read File");
            }
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741766, 21, 3);
            return;
        }
        catch (IOException ex) {
            if (this.m_sess.hasDebug(1024)) {
                this.m_sess.debugPrintln("File Read Error [" + netFile.getFileId() + "] : " + ex.toString());
                this.m_sess.debugPrintln(ex);
                this.m_sess.debugPrintln("  NetworkFile name=" + netFile.getName() + "/" + netFile.getFullName());
                this.m_sess.debugPrintln("  attr=0x" + Integer.toHexString(netFile.getFileAttributes()) + ", size=" + netFile.getFileSize());
                this.m_sess.debugPrintln("  fid=" + netFile.getFileId() + ", cdate=" + netFile.getCreationDate() + ", mdate=" + netFile.getModifyDate());
                this.m_sess.debugPrintln("Offset = " + offset + " (0x" + Long.toHexString(offset) + ")");
            }
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741209, 30, 3);
            return;
        }
        parser.setAndXCommand(255);
        parser.setParameter(1, 0);
        parser.setParameter(2, 0);
        parser.setParameter(3, 0);
        parser.setParameter(4, 0);
        parser.setParameter(5, rdlen);
        parser.setParameter(6, dataPos - 4);
        for (int i = 7; i < 12; ++i) {
            parser.setParameter(i, 0);
        }
        parser.setByteCount(dataPos + rdlen - parser.getByteOffset());
        if (parser.hasAndXCommand()) {
            int pos = this.procAndXCommands(smbPkt, parser, netFile);
            this.m_sess.sendResponseSMB(smbPkt.getAssociatedPacket(), pos);
        } else {
            this.m_sess.sendResponseSMB(respPkt);
        }
    }

    @Override
    protected void procRenameFile(SMBSrvPacket smbPkt, SMBV1Parser parser) throws IOException, SMBSrvException {
        if (!parser.checkPacketIsValid(1, 4)) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 64, 2);
            return;
        }
        VirtualCircuit vc = this.m_sess.findVirtualCircuit(parser.getUserId());
        if (vc == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
            return;
        }
        int treeId = parser.getTreeId();
        TreeConnection conn = vc.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
            return;
        }
        if (!conn.hasWriteAccess()) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741622, 5, 1);
            return;
        }
        boolean isUni = parser.isUnicode();
        parser.resetBytePointer();
        if (parser.unpackByte() != 4) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 13, 1);
            return;
        }
        String oldName = parser.unpackString(isUni);
        if (oldName == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 13, 1);
            return;
        }
        if (parser.unpackByte() != 4) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 13, 1);
            return;
        }
        String newName = parser.unpackString(isUni);
        if (newName == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 13, 1);
            return;
        }
        if (this.m_sess.hasDebug(512)) {
            this.m_sess.debugPrintln("File Rename [" + treeId + "] old name=" + oldName + ", new name=" + newName);
        }
        if (!FileName.isValidPath(oldName)) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741773, 13, 1);
            return;
        }
        if (!FileName.isValidPath(newName)) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741773, 13, 1);
            return;
        }
        Object netFile = null;
        try {
            DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
            disk.renameFile(this.m_sess, conn, oldName, newName);
        }
        catch (InvalidDeviceInterfaceException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 13, 1);
            return;
        }
        catch (FileNotFoundException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741772, 2, 1);
            return;
        }
        catch (FileExistsException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741771, 80, 1);
            return;
        }
        catch (AccessDeniedException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741790, 5, 1);
            return;
        }
        catch (PermissionDeniedException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741622, 5, 1);
            return;
        }
        catch (FileSharingException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741757, 32, 1);
            return;
        }
        catch (DiskOfflineException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741766, 21, 3);
        }
        catch (IOException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
            return;
        }
        parser.setParameterCount(0);
        parser.setByteCount(0);
        parser.setSuccessStatus();
        this.m_sess.sendResponseSMB(smbPkt);
        DiskDeviceContext diskCtx = (DiskDeviceContext)conn.getContext();
        if (diskCtx.hasFileServerNotifications()) {
            diskCtx.getChangeHandler().notifyRename(oldName, newName);
        }
    }

    @Override
    protected void procDeleteFile(SMBSrvPacket smbPkt, SMBV1Parser parser) throws IOException, SMBSrvException {
        if (!parser.checkPacketIsValid(1, 2)) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 64, 2);
            return;
        }
        VirtualCircuit vc = this.m_sess.findVirtualCircuit(parser.getUserId());
        if (vc == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
            return;
        }
        int treeId = parser.getTreeId();
        TreeConnection conn = vc.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
            return;
        }
        if (!conn.hasWriteAccess()) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741790, 5, 1);
            return;
        }
        boolean isUni = parser.isUnicode();
        parser.resetBytePointer();
        if (parser.unpackByte() != 4) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 13, 1);
            return;
        }
        String fileName = parser.unpackString(isUni);
        if (fileName == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 13, 1);
            return;
        }
        if (this.m_sess.hasDebug(512)) {
            this.m_sess.debugPrintln("File Delete [" + treeId + "] name=" + fileName);
        }
        Object netFile = null;
        long startTime = 0L;
        try {
            if (this.m_sess.hasDebug(0x2000000)) {
                startTime = System.currentTimeMillis();
            }
            DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
            disk.deleteFile(this.m_sess, conn, fileName);
            if (this.m_sess.hasDebug(0x2000000)) {
                Debug.println("Benchmark: Delete file " + fileName + " took " + (System.currentTimeMillis() - startTime) + "ms");
            }
        }
        catch (InvalidDeviceInterfaceException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 13, 1);
            return;
        }
        catch (AccessDeniedException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741790, 5, 1);
            return;
        }
        catch (DiskOfflineException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741766, 21, 3);
            return;
        }
        catch (IOException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741772, 2, 1);
            return;
        }
        parser.setParameterCount(0);
        parser.setByteCount(0);
        parser.setSuccessStatus();
        this.m_sess.sendResponseSMB(smbPkt);
        DiskDeviceContext diskCtx = (DiskDeviceContext)conn.getContext();
        if (diskCtx.hasFileServerNotifications()) {
            diskCtx.getChangeHandler().notifyFileChanged(NotifyAction.Removed, fileName);
        }
    }

    @Override
    protected void procDeleteDirectory(SMBSrvPacket smbPkt, SMBV1Parser parser) throws IOException, SMBSrvException {
        if (!parser.checkPacketIsValid(0, 2)) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 64, 2);
            return;
        }
        VirtualCircuit vc = this.m_sess.findVirtualCircuit(parser.getUserId());
        if (vc == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
            return;
        }
        int treeId = parser.getTreeId();
        TreeConnection conn = vc.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
            return;
        }
        if (!conn.hasWriteAccess()) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741790, 5, 1);
            return;
        }
        boolean isUni = parser.isUnicode();
        parser.resetBytePointer();
        if (parser.unpackByte() != 4) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 13, 1);
            return;
        }
        String dirName = parser.unpackString(isUni);
        if (dirName == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 13, 1);
            return;
        }
        if (this.m_sess.hasDebug(512)) {
            this.m_sess.debugPrintln("Directory Delete [" + treeId + "] name=" + dirName);
        }
        try {
            DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
            disk.deleteDirectory(this.m_sess, conn, dirName);
        }
        catch (InvalidDeviceInterfaceException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 13, 1);
            return;
        }
        catch (AccessDeniedException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741790, 5, 1);
            return;
        }
        catch (DirectoryNotEmptyException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741567, 5, 6);
            return;
        }
        catch (DiskOfflineException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741766, 21, 3);
            return;
        }
        catch (IOException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 3, 1);
            return;
        }
        parser.setParameterCount(0);
        parser.setByteCount(0);
        parser.setSuccessStatus();
        this.m_sess.sendResponseSMB(smbPkt);
        DiskDeviceContext diskCtx = (DiskDeviceContext)conn.getContext();
        if (diskCtx.hasFileServerNotifications()) {
            diskCtx.getChangeHandler().notifyDirectoryChanged(NotifyAction.Removed, dirName);
        }
    }

    protected final void procTrans2FindFirst(SrvTransactBuffer tbuf, SMBSrvPacket smbPkt, SMBV1Parser parser) throws IOException, SMBSrvException {
        VirtualCircuit vc = this.m_sess.findVirtualCircuit(parser.getUserId());
        if (vc == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
            return;
        }
        int treeId = parser.getTreeId();
        TreeConnection conn = vc.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 4, 2);
            return;
        }
        DataBuffer paramBuf = tbuf.getParameterBuffer();
        int srchAttr = paramBuf.getShort();
        int maxFiles = paramBuf.getShort();
        int srchFlag = paramBuf.getShort();
        int infoLevl = paramBuf.getShort();
        paramBuf.skipBytes(4);
        String srchPath = paramBuf.getString(tbuf.isUnicode());
        if (tbuf.isUnicode() && WildCard.containsUnicodeWildcard(srchPath)) {
            srchPath = WildCard.convertUnicodeWildcardToDOS(srchPath);
            if (this.m_sess.hasDebug(128)) {
                this.m_sess.debugPrintln("Converted Unicode wildcards to:" + srchPath);
            }
        }
        if (!FileName.isValidSearchPath(srchPath)) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741773, 13, 1);
            return;
        }
        if (srchPath == null || srchPath.length() == 0) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 13, 1);
            return;
        }
        if (srchPath.endsWith("\\")) {
            srchPath = srchPath + "*.*";
        } else if (!srchPath.startsWith("\\")) {
            srchPath = "\\" + srchPath;
            if (this.m_sess.hasDebug(128)) {
                this.m_sess.debugPrintln("Search path missing leading slash, converted to relative path");
            }
        }
        if (infoLevl == 770 && !this.getSession().hasMacintoshExtensions()) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 65535, 2);
            return;
        }
        SearchContext ctx = null;
        DiskInterface disk = null;
        int searchId = -1;
        boolean wildcardSearch = false;
        try {
            disk = (DiskInterface)conn.getSharedDevice().getInterface();
            searchId = vc.allocateSearchSlot();
            if (WildCard.containsWildcards(srchPath)) {
                wildcardSearch = true;
            }
            if ((ctx = disk.startSearch(this.m_sess, conn, srchPath, srchAttr)) == null) {
                if (searchId != -1) {
                    vc.deallocateSearchSlot(searchId);
                }
                this.m_sess.sendErrorResponseSMB(smbPkt, -1073741809, 2, 1);
                return;
            }
            ctx.setTreeId(treeId);
            ctx.setMaximumFiles(maxFiles);
            vc.setSearchContext(searchId, ctx);
            SrvTransactBuffer replyBuf = new SrvTransactBuffer(tbuf);
            DataBuffer dataBuf = replyBuf.getDataBuffer();
            int maxLen = replyBuf.getReturnDataLimit();
            if (this.m_sess.hasDebug(128)) {
                this.m_sess.debugPrintln("Start trans search [" + searchId + "] - " + srchPath + ", attr=0x" + Integer.toHexString(srchAttr) + ", maxFiles=" + maxFiles + ", maxLen=" + maxLen + ", infoLevel=" + infoLevl + ", flags=0x" + Integer.toHexString(srchFlag) + ",dotFiles=" + ctx.hasDotFiles());
            }
            int fileCnt = 0;
            int packLen = 0;
            int lastNameOff = 0;
            boolean resumeIds = false;
            if (infoLevl == 1 && (srchFlag & 4) != 0) {
                resumeIds = true;
            }
            if (wildcardSearch && WildCard.isWildcardAll(srchPath)) {
                if (resumeIds) {
                    dataBuf.putInt(-1);
                    maxLen -= 4;
                }
                lastNameOff = dataBuf.getPosition();
                FileInfo dotInfo = new FileInfo(".", 0L, 16);
                dotInfo.setFileId(dotInfo.getFileName().hashCode());
                if (ctx.hasDotFiles()) {
                    ctx.getDotInfo(dotInfo);
                }
                packLen = FindInfoPacker.packInfo(dotInfo, dataBuf, infoLevl, tbuf.isUnicode());
                ++fileCnt;
                maxLen -= packLen;
                if (resumeIds) {
                    dataBuf.putInt(-2);
                    maxLen -= 4;
                }
                lastNameOff = dataBuf.getPosition();
                if (ctx.hasDotFiles()) {
                    ctx.getDotDotInfo(dotInfo);
                } else {
                    dotInfo.setFileName("..");
                    dotInfo.setFileId(dotInfo.getFileName().hashCode());
                    dotInfo.setCreationDateTime(DotFileDateTime);
                    dotInfo.setModifyDateTime(DotFileDateTime);
                    dotInfo.setAccessDateTime(DotFileDateTime);
                }
                packLen = FindInfoPacker.packInfo(dotInfo, dataBuf, infoLevl, tbuf.isUnicode());
                ++fileCnt;
                maxLen -= packLen;
            }
            boolean pktDone = false;
            boolean searchDone = false;
            FileInfo info = new FileInfo();
            while (!pktDone && fileCnt < maxFiles) {
                if (!ctx.nextFileInfo(info)) {
                    pktDone = true;
                    searchDone = true;
                    continue;
                }
                if (FindInfoPacker.calcInfoSize(info, infoLevl, false, true) <= maxLen) {
                    if (resumeIds) {
                        dataBuf.putInt(ctx.getResumeId());
                        maxLen -= 4;
                    }
                    lastNameOff = dataBuf.getPosition();
                    packLen = FindInfoPacker.packInfo(info, dataBuf, infoLevl, tbuf.isUnicode());
                    ++fileCnt;
                    maxLen -= packLen;
                    continue;
                }
                ctx.restartAt(info);
                pktDone = true;
                if (!this.m_sess.hasDebug(128)) continue;
                this.m_sess.debugPrintln("Find first response full, restart at " + info.getFileName());
            }
            if (fileCnt == 0) {
                throw new FileNotFoundException(srchPath);
            }
            if (maxFiles == 1 && fileCnt == 1) {
                searchDone = true;
            }
            FindInfoPacker.clearNextOffset(dataBuf, infoLevl, lastNameOff);
            paramBuf = replyBuf.getParameterBuffer();
            paramBuf.putShort(searchId);
            paramBuf.putShort(fileCnt);
            paramBuf.putShort(ctx.hasMoreFiles() ? 0 : 1);
            paramBuf.putShort(0);
            paramBuf.putShort(lastNameOff);
            SMBSrvTransPacket tpkt = new SMBSrvTransPacket(smbPkt);
            tpkt.doTransactionResponse(this.m_sess, replyBuf, smbPkt);
            if (this.m_sess.hasDebug(128)) {
                this.m_sess.debugPrintln("Search [" + searchId + "] Returned " + fileCnt + " files, dataLen=" + dataBuf.getLength() + ", moreFiles=" + ctx.hasMoreFiles());
            }
            if (searchDone || !ctx.hasMoreFiles()) {
                if (this.m_sess.hasDebug(128)) {
                    this.m_sess.debugPrintln("End start search [" + searchId + "] (Search complete)");
                }
                vc.deallocateSearchSlot(searchId);
            } else if ((srchFlag & 1) != 0) {
                if (this.m_sess.hasDebug(128)) {
                    this.m_sess.debugPrintln("End start search [" + searchId + "] (Close)");
                }
                vc.deallocateSearchSlot(searchId);
            }
        }
        catch (TooManySearchesException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 89, 2);
        }
        catch (FileNotFoundException ex) {
            if (searchId != -1) {
                vc.deallocateSearchSlot(searchId);
            }
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741809, 18, 1);
        }
        catch (PathNotFoundException ex) {
            if (searchId != -1) {
                vc.deallocateSearchSlot(searchId);
            }
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741766, 2, 1);
            return;
        }
        catch (InvalidDeviceInterfaceException ex) {
            if (searchId != -1) {
                vc.deallocateSearchSlot(searchId);
            }
            this.m_sess.sendErrorResponseSMB(smbPkt, 13, 1);
        }
        catch (UnsupportedInfoLevelException ex) {
            if (searchId != -1) {
                vc.deallocateSearchSlot(searchId);
            }
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741496, 65535, 2);
        }
        catch (DiskOfflineException ex) {
            if (searchId != -1) {
                vc.deallocateSearchSlot(searchId);
            }
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741766, 21, 3);
        }
    }

    protected final void procTrans2FindNext(SrvTransactBuffer tbuf, SMBSrvPacket smbPkt, SMBV1Parser parser) throws IOException, SMBSrvException {
        VirtualCircuit vc = this.m_sess.findVirtualCircuit(parser.getUserId());
        if (vc == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
            return;
        }
        int treeId = parser.getTreeId();
        TreeConnection conn = vc.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741790, 5, 1);
            return;
        }
        DataBuffer paramBuf = tbuf.getParameterBuffer();
        int searchId = paramBuf.getShort();
        int maxFiles = paramBuf.getShort();
        int infoLevl = paramBuf.getShort();
        int reskey = paramBuf.getInt();
        int srchFlag = paramBuf.getShort();
        String resumeName = paramBuf.getString(tbuf.isUnicode());
        SearchContext ctx = null;
        DiskInterface disk = null;
        try {
            disk = (DiskInterface)conn.getSharedDevice().getInterface();
            ctx = vc.getSearchContext(searchId);
            if (ctx == null) {
                this.m_sess.debugPrintln("Search context null - [" + searchId + "]");
                this.m_sess.sendErrorResponseSMB(smbPkt, 18, 1);
                return;
            }
            SrvTransactBuffer replyBuf = new SrvTransactBuffer(tbuf);
            DataBuffer dataBuf = replyBuf.getDataBuffer();
            int maxLen = replyBuf.getReturnDataLimit();
            if (this.m_sess.hasDebug(128)) {
                this.m_sess.debugPrintln("Continue search [" + searchId + "] - " + resumeName + ", maxFiles=" + maxFiles + ", maxLen=" + maxLen + ", infoLevel=" + infoLevl + ", flags=0x" + Integer.toHexString(srchFlag));
            }
            int fileCnt = 0;
            int packLen = 0;
            int lastNameOff = 0;
            boolean resumeIds = false;
            if (infoLevl == 1 && (srchFlag & 4) != 0) {
                resumeIds = true;
            }
            boolean pktDone = false;
            boolean searchDone = false;
            FileInfo info = new FileInfo();
            while (!pktDone && fileCnt < maxFiles) {
                if (!ctx.nextFileInfo(info)) {
                    pktDone = true;
                    searchDone = true;
                    continue;
                }
                if (FindInfoPacker.calcInfoSize(info, infoLevl, false, true) <= maxLen) {
                    if (resumeIds) {
                        dataBuf.putInt(ctx.getResumeId());
                        maxLen -= 4;
                    }
                    lastNameOff = dataBuf.getPosition();
                    packLen = FindInfoPacker.packInfo(info, dataBuf, infoLevl, tbuf.isUnicode());
                    ++fileCnt;
                    maxLen -= packLen;
                    continue;
                }
                ctx.restartAt(info);
                pktDone = true;
                if (!this.m_sess.hasDebug(128)) continue;
                this.m_sess.debugPrintln("Find next response full, restart at " + info.getFileName());
            }
            paramBuf = replyBuf.getParameterBuffer();
            paramBuf.putShort(fileCnt);
            paramBuf.putShort(ctx.hasMoreFiles() ? 0 : 1);
            paramBuf.putShort(0);
            paramBuf.putShort(lastNameOff);
            SMBSrvTransPacket tpkt = new SMBSrvTransPacket(smbPkt);
            tpkt.doTransactionResponse(this.m_sess, replyBuf, smbPkt);
            if (this.m_sess.hasDebug(128)) {
                this.m_sess.debugPrintln("Search [" + searchId + "] Returned " + fileCnt + " files, dataLen=" + dataBuf.getLength() + ", moreFiles=" + ctx.hasMoreFiles());
            }
            if (searchDone || !ctx.hasMoreFiles()) {
                if (this.m_sess.hasDebug(128)) {
                    this.m_sess.debugPrintln("End start search [" + searchId + "] (Search complete)");
                }
                vc.deallocateSearchSlot(searchId);
            } else if ((srchFlag & 1) != 0) {
                if (this.m_sess.hasDebug(128)) {
                    this.m_sess.debugPrintln("End start search [" + searchId + "] (Close)");
                }
                vc.deallocateSearchSlot(searchId);
            }
        }
        catch (FileNotFoundException ex) {
            if (searchId != -1) {
                vc.deallocateSearchSlot(searchId);
            }
            this.m_sess.sendErrorResponseSMB(smbPkt, 18, 1);
        }
        catch (InvalidDeviceInterfaceException ex) {
            if (searchId != -1) {
                vc.deallocateSearchSlot(searchId);
            }
            this.m_sess.sendErrorResponseSMB(smbPkt, 13, 1);
        }
        catch (UnsupportedInfoLevelException ex) {
            if (searchId != -1) {
                vc.deallocateSearchSlot(searchId);
            }
            this.m_sess.sendErrorResponseSMB(smbPkt, 65535, 2);
        }
    }

    protected final void procTrans2QueryFileSys(SrvTransactBuffer tbuf, SMBSrvPacket smbPkt, SMBV1Parser parser) throws IOException, SMBSrvException {
        VirtualCircuit vc = this.m_sess.findVirtualCircuit(parser.getUserId());
        if (vc == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
            return;
        }
        int treeId = parser.getTreeId();
        TreeConnection conn = vc.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741790, 5, 1);
            return;
        }
        DataBuffer paramBuf = tbuf.getParameterBuffer();
        int infoLevl = paramBuf.getShort();
        if (this.m_sess.hasDebug(256)) {
            this.m_sess.debugPrintln("Query File System Info - level = 0x" + Integer.toHexString(infoLevl));
        }
        try {
            int prmPos;
            DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
            DiskDeviceContext diskCtx = (DiskDeviceContext)conn.getContext();
            parser.setParameterCount(10);
            byte[] buf = parser.getBuffer();
            int dataPos = prmPos = DataPacker.longwordAlign(parser.getByteOffset());
            DataBuffer replyBuf = new DataBuffer(buf, dataPos, buf.length - dataPos);
            SrvDiskInfo diskInfo = null;
            VolumeInfo volInfo = null;
            switch (infoLevl) {
                case 1: {
                    diskInfo = this.getDiskInformation(disk, diskCtx);
                    DiskInfoPacker.packStandardInfo(diskInfo, replyBuf);
                    break;
                }
                case 2: {
                    volInfo = this.getVolumeInformation(disk, diskCtx);
                    DiskInfoPacker.packVolumeInfo(volInfo, replyBuf, tbuf.isUnicode());
                    break;
                }
                case 258: {
                    volInfo = this.getVolumeInformation(disk, diskCtx);
                    DiskInfoPacker.packFsVolumeInformation(volInfo, replyBuf, tbuf.isUnicode());
                    break;
                }
                case 259: {
                    diskInfo = this.getDiskInformation(disk, diskCtx);
                    DiskInfoPacker.packFsSizeInformation(diskInfo, replyBuf);
                    break;
                }
                case 260: {
                    DiskInfoPacker.packFsDevice(7, diskCtx.getDeviceAttributes(), replyBuf);
                    break;
                }
                case 261: {
                    NTFSStreamsInterface ntfsStreams;
                    String fsType = diskCtx.getFilesystemType();
                    if (disk instanceof NTFSStreamsInterface && (ntfsStreams = (NTFSStreamsInterface)((Object)disk)).hasStreamsEnabled(this.m_sess, conn)) {
                        fsType = "NTFS";
                    }
                    DiskInfoPacker.packFsAttribute(diskCtx.getFilesystemAttributes(), 255, fsType, tbuf.isUnicode(), replyBuf);
                    break;
                }
                case 769: {
                    boolean ntfs = false;
                    if (disk instanceof NTFSStreamsInterface) {
                        NTFSStreamsInterface ntfsStreams = (NTFSStreamsInterface)((Object)disk);
                        ntfs = ntfsStreams.hasStreamsEnabled(this.m_sess, conn);
                    }
                    if (ntfs) break;
                    diskInfo = this.getDiskInformation(disk, diskCtx);
                    volInfo = this.getVolumeInformation(disk, diskCtx);
                    DiskInfoPacker.packMacFsInformation(diskInfo, volInfo, ntfs, replyBuf);
                    break;
                }
                case 1007: {
                    diskInfo = this.getDiskInformation(disk, diskCtx);
                    long userLimit = -1L;
                    long userTotalSpace = -1L;
                    if (diskCtx.hasQuotaManager()) {
                        userTotalSpace = diskCtx.getQuotaManager().getUserTotalSpace(this.m_sess, conn);
                        userLimit = diskCtx.getQuotaManager().getUserFreeSpace(this.m_sess, conn);
                    }
                    userTotalSpace = userTotalSpace > 0L ? (userTotalSpace /= diskInfo.getUnitSize()) : diskInfo.getTotalUnits();
                    userLimit = userLimit != -1L ? (userLimit /= diskInfo.getUnitSize()) : diskInfo.getFreeUnits();
                    DiskInfoPacker.packFullFsSizeInformation(userTotalSpace, userLimit, diskInfo, replyBuf);
                }
            }
            if (replyBuf.getPosition() == dataPos) {
                this.m_sess.sendErrorResponseSMB(smbPkt, 65535, 2);
                return;
            }
            int bytCnt = replyBuf.getPosition() - parser.getByteOffset();
            replyBuf.setEndOfBuffer();
            int dataLen = replyBuf.getLength();
            SMBSrvTransPacket.initTransactReply(smbPkt, 0, prmPos, dataLen, dataPos);
            parser.setByteCount(bytCnt);
            this.m_sess.sendResponseSMB(smbPkt);
        }
        catch (InvalidDeviceInterfaceException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 13, 1);
            return;
        }
    }

    protected final void procTrans2QueryPath(SrvTransactBuffer tbuf, SMBSrvPacket smbPkt, SMBV1Parser parser) throws IOException, SMBSrvException {
        VirtualCircuit vc = this.m_sess.findVirtualCircuit(parser.getUserId());
        if (vc == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
            return;
        }
        int treeId = parser.getTreeId();
        TreeConnection conn = vc.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741790, 5, 1);
            return;
        }
        DataBuffer paramBuf = tbuf.getParameterBuffer();
        int infoLevl = paramBuf.getShort();
        paramBuf.skipBytes(4);
        String path = paramBuf.getString(tbuf.isUnicode());
        if (path.length() == 0) {
            path = "\\";
        }
        if (path.endsWith(":$DATA")) {
            path = path.substring(0, path.length() - ":$DATA".length());
        }
        if (this.m_sess.hasDebug(256)) {
            this.m_sess.debugPrintln("Query Path - level = 0x" + Integer.toHexString(infoLevl) + ", path = " + path);
        }
        try {
            DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
            parser.setParameterCount(10);
            byte[] buf = parser.getBuffer();
            int prmPos = DataPacker.longwordAlign(parser.getByteOffset());
            int dataPos = prmPos + 4;
            parser.setPosition(prmPos);
            parser.packWord(0);
            DataBuffer replyBuf = new DataBuffer(256);
            boolean streams = false;
            if (disk instanceof NTFSStreamsInterface) {
                NTFSStreamsInterface ntfsStreams = (NTFSStreamsInterface)((Object)disk);
                streams = ntfsStreams.hasStreamsEnabled(this.m_sess, conn);
            }
            if (!streams && path.indexOf(":") != -1) {
                this.m_sess.sendErrorResponseSMB(smbPkt, -1073741773, 2, 1);
                return;
            }
            int dataLen = 0;
            if (streams && (infoLevl == 265 || infoLevl == 1022)) {
                NTFSStreamsInterface ntfsStreams;
                StreamInfoList streamList;
                if (this.m_sess.hasDebug(0x100000)) {
                    this.m_sess.debugPrintln("Get NTFS streams list path=" + path);
                }
                if ((streamList = (ntfsStreams = (NTFSStreamsInterface)((Object)disk)).getStreamList(this.m_sess, conn, path)) == null) {
                    this.m_sess.sendErrorResponseSMB(smbPkt, -1073741809, 2, 1);
                    return;
                }
                dataLen = QueryInfoPacker.packStreamFileInfo(streamList, replyBuf, true);
            } else {
                FileInfo fileInfo = disk.getFileInformation(this.m_sess, conn, path);
                if (fileInfo == null) {
                    this.m_sess.sendErrorResponseSMB(smbPkt, -1073741809, 2, 1);
                    return;
                }
                dataLen = QueryInfoPacker.packInfo(fileInfo, replyBuf, infoLevl, true);
            }
            if (dataLen == 0) {
                this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
                return;
            }
            SMBSrvPacket respPkt = smbPkt;
            SMBSrvTransPacket.initTransactReply(respPkt, 2, prmPos, dataLen, dataPos);
            if (parser.getAvailableLength() < dataLen + 4) {
                respPkt = this.m_sess.getPacketPool().allocatePacket(parser.getByteOffset() + dataLen + 4, smbPkt, parser.getByteOffset());
                respPkt.setParser(SMBSrvPacket.Version.V1);
                parser = (SMBV1Parser)respPkt.getParser();
            }
            replyBuf.setEndOfBuffer();
            replyBuf.copyData(respPkt.getBuffer(), dataPos);
            parser.setByteCount(dataPos + dataLen - parser.getByteOffset());
            this.m_sess.sendResponseSMB(respPkt);
        }
        catch (FileNotFoundException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741809, 2, 1);
            return;
        }
        catch (PathNotFoundException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741766, 2, 1);
            return;
        }
        catch (InvalidDeviceInterfaceException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
            return;
        }
        catch (UnsupportedInfoLevelException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
            return;
        }
        catch (DiskOfflineException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741766, 21, 3);
            return;
        }
        catch (AccessDeniedException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741790, 5, 1);
            return;
        }
    }

    protected final void procTrans2QueryFile(SrvTransactBuffer tbuf, SMBSrvPacket smbPkt, SMBV1Parser parser) throws IOException, SMBSrvException {
        VirtualCircuit vc = this.m_sess.findVirtualCircuit(parser.getUserId());
        if (vc == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
            return;
        }
        int treeId = parser.getTreeId();
        TreeConnection conn = vc.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741790, 5, 1);
            return;
        }
        DataBuffer paramBuf = tbuf.getParameterBuffer();
        int fid = paramBuf.getShort();
        int infoLevl = paramBuf.getShort();
        NetworkFile netFile = conn.findFile(fid);
        if (netFile == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 6, 1);
            return;
        }
        if (this.m_sess.hasDebug(256)) {
            this.m_sess.debugPrintln("Query File - level=0x" + Integer.toHexString(infoLevl) + ", fid=" + fid + ", stream=" + netFile.getStreamId() + ", name=" + netFile.getFullName());
        }
        try {
            DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
            parser.setParameterCount(10);
            byte[] buf = parser.getBuffer();
            int prmPos = DataPacker.longwordAlign(parser.getByteOffset());
            int dataPos = prmPos + 4;
            parser.setPosition(prmPos);
            parser.packWord(0);
            boolean streams = false;
            DataBuffer replyBuf = null;
            if (disk instanceof NTFSStreamsInterface) {
                NTFSStreamsInterface ntfsStreams = (NTFSStreamsInterface)((Object)disk);
                streams = ntfsStreams.hasStreamsEnabled(this.m_sess, conn);
            }
            int dataLen = 0;
            if (streams && (infoLevl == 265 || infoLevl == 1022)) {
                NTFSStreamsInterface ntfsStreams;
                StreamInfoList streamList;
                if (this.m_sess.hasDebug(0x100000)) {
                    this.m_sess.debugPrintln("Get NTFS streams list fid=" + fid + ", name=" + netFile.getFullName());
                }
                if ((streamList = (ntfsStreams = (NTFSStreamsInterface)((Object)disk)).getStreamList(this.m_sess, conn, netFile.getFullName())) == null) {
                    this.m_sess.sendErrorResponseSMB(smbPkt, -1073741772, 1, 2);
                    return;
                }
                if (streamList.numberOfStreams() > 1 && buf.length < 4096) {
                    smbPkt = this.m_sess.getPacketPool().allocatePacket(4096, smbPkt, dataPos);
                    buf = parser.getBuffer();
                }
                replyBuf = new DataBuffer(buf, dataPos, buf.length - dataPos);
                dataLen = QueryInfoPacker.packStreamFileInfo(streamList, replyBuf, true);
            } else {
                FileInfo fileInfo = disk.getFileInformation(this.m_sess, conn, netFile.getFullName());
                if (fileInfo == null) {
                    this.m_sess.sendErrorResponseSMB(smbPkt, -1073741772, 1, 2);
                    return;
                }
                fileInfo.setFileSize(netFile.getFileSize());
                fileInfo.setAllocationSize(MemorySize.roundupLongSize(fileInfo.getSize()));
                if (netFile.hasAccessDate()) {
                    fileInfo.setAccessDateTime(netFile.getAccessDate());
                }
                replyBuf = new DataBuffer(buf, dataPos, buf.length - dataPos);
                dataLen = QueryInfoPacker.packInfo(fileInfo, replyBuf, infoLevl, true);
            }
            if (dataLen == 0) {
                this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
                return;
            }
            SMBSrvTransPacket.initTransactReply(smbPkt, 2, prmPos, dataLen, dataPos);
            parser.setByteCount(replyBuf.getPosition() - parser.getByteOffset());
            this.m_sess.sendResponseSMB(smbPkt);
        }
        catch (FileNotFoundException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741772, 2, 1);
            return;
        }
        catch (PathNotFoundException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741766, 2, 1);
            return;
        }
        catch (InvalidDeviceInterfaceException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
            return;
        }
        catch (UnsupportedInfoLevelException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
            return;
        }
        catch (DiskOfflineException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741766, 21, 3);
        }
    }

    protected final void procTrans2SetFile(SrvTransactBuffer tbuf, SMBSrvPacket smbPkt, SMBV1Parser parser) throws IOException, SMBSrvException {
        VirtualCircuit vc = this.m_sess.findVirtualCircuit(parser.getUserId());
        if (vc == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
            return;
        }
        int treeId = parser.getTreeId();
        TreeConnection conn = vc.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
            return;
        }
        if (!conn.hasWriteAccess()) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741790, 5, 1);
            return;
        }
        DataBuffer paramBuf = tbuf.getParameterBuffer();
        int fid = paramBuf.getShort();
        int infoLevl = paramBuf.getShort();
        NetworkFile netFile = conn.findFile(fid);
        if (netFile == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 6, 1);
            return;
        }
        if (this.m_sess.hasDebug(256)) {
            this.m_sess.debugPrintln("Set File - level=0x" + Integer.toHexString(infoLevl) + ", fid=" + fid + ", name=" + netFile.getFullName());
        }
        try {
            DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
            DataBuffer dataBuf = tbuf.getDataBuffer();
            FileInfo finfo = null;
            switch (infoLevl) {
                case 257: 
                case 1004: {
                    int setFlags = 0;
                    finfo = new FileInfo(netFile.getFullName(), 0L, -1);
                    long timeNow = System.currentTimeMillis();
                    long nttim = dataBuf.getLong();
                    boolean hasSetTime = false;
                    if (nttim != 0L) {
                        if (nttim != -1L) {
                            finfo.setCreationDateTime(NTTime.toJavaDate(nttim));
                            setFlags += 16;
                        }
                        hasSetTime = true;
                    }
                    if ((nttim = dataBuf.getLong()) != 0L) {
                        if (nttim != -1L) {
                            finfo.setAccessDateTime(NTTime.toJavaDate(nttim));
                            setFlags += 32;
                        } else {
                            finfo.setAccessDateTime(timeNow);
                            setFlags += 32;
                        }
                        hasSetTime = true;
                    }
                    if ((nttim = dataBuf.getLong()) > 0L) {
                        if (nttim != -1L) {
                            finfo.setModifyDateTime(NTTime.toJavaDate(nttim));
                            setFlags += 8;
                        } else {
                            finfo.setModifyDateTime(timeNow);
                            setFlags += 8;
                        }
                        hasSetTime = true;
                    }
                    if ((nttim = dataBuf.getLong()) > 0L) {
                        if (nttim != -1L) {
                            finfo.setChangeDateTime(NTTime.toJavaDate(nttim));
                            setFlags += 64;
                        }
                        hasSetTime = true;
                    }
                    int attr = dataBuf.getInt();
                    int unknown = dataBuf.getInt();
                    if (!hasSetTime && unknown == 0) {
                        finfo.setFileAttributes(attr);
                        setFlags += 4;
                    }
                    finfo.setNetworkFile(netFile);
                    finfo.setFileInformationFlags(setFlags);
                    disk.setFileInformation(this.m_sess, conn, netFile.getFullName(), finfo);
                    if (!this.m_sess.hasDebug(256)) break;
                    this.m_sess.debugPrintln("  Set Basic Info [" + treeId + "] name=" + netFile.getFullName() + ", attr=0x" + Integer.toHexString(attr) + ", setTime=" + hasSetTime + ", setFlags=0x" + Integer.toHexString(setFlags) + ", unknown=" + unknown);
                    break;
                }
                case 260: 
                case 1020: {
                    long eofPos = dataBuf.getLong();
                    disk.truncateFile(this.m_sess, conn, netFile, eofPos);
                    if (!this.m_sess.hasDebug(256)) break;
                    this.m_sess.debugPrintln("  Set end of file position fid=" + fid + ", eof=" + eofPos);
                    break;
                }
                case 259: 
                case 1019: {
                    long allocSize = dataBuf.getLong();
                    disk.truncateFile(this.m_sess, conn, netFile, allocSize);
                    if (!this.m_sess.hasDebug(256)) break;
                    this.m_sess.debugPrintln("  Set allocation size fid=" + fid + ", allocSize=" + allocSize);
                    break;
                }
                case 1010: {
                    NTFSStreamsInterface ntfsStreams;
                    boolean overwrite = dataBuf.getByte() == 1;
                    dataBuf.skipBytes(3);
                    int rootFid = dataBuf.getInt();
                    int nameLen = dataBuf.getInt();
                    String newName = dataBuf.getString(nameLen, true);
                    if (this.m_sess.hasDebug(256)) {
                        this.m_sess.debugPrintln("  Set rename fid=" + fid + ", newName=" + newName + ", overwrite=" + overwrite + ", rootFID=" + rootFid);
                    }
                    if (newName.indexOf("\\") != -1 || netFile.isDirectory()) {
                        this.m_sess.sendErrorResponseSMB(smbPkt, -1073741637, 65535, 2);
                        return;
                    }
                    boolean streams = false;
                    if (disk instanceof NTFSStreamsInterface) {
                        ntfsStreams = (NTFSStreamsInterface)((Object)disk);
                        streams = ntfsStreams.hasStreamsEnabled(this.m_sess, conn);
                    }
                    if (!streams) {
                        if (!FileName.containsStreamName(newName)) {
                            String[] paths = FileName.splitPath(netFile.getFullName());
                            String newPath = null;
                            newPath = paths[0] != null ? paths[0] + "\\" + newName : "\\" + newName;
                            FileStatus fileSts = disk.fileExists(this.m_sess, conn, newPath);
                            if (fileSts == FileStatus.FileExists && !overwrite) {
                                this.m_sess.sendErrorResponseSMB(smbPkt, -1073741790, 5, 1);
                                return;
                            }
                            if (this.m_sess.hasDebug(512)) {
                                this.m_sess.debugPrintln("Transact rename via standard rename from=" + netFile.getFullName() + " to=" + newPath);
                            }
                            disk.renameFile(this.m_sess, conn, netFile.getFullName(), newPath);
                            break;
                        }
                        this.m_sess.sendErrorResponseSMB(smbPkt, -1073741637, 65535, 2);
                        return;
                    }
                    if (this.m_sess.hasDebug(0x100000)) {
                        this.m_sess.debugPrintln("Rename stream fid=" + fid + ", name=" + netFile.getFullNameStream() + ", newName=" + newName + ", overwrite=" + overwrite);
                    }
                    ntfsStreams = (NTFSStreamsInterface)((Object)disk);
                    ntfsStreams.renameStream(this.m_sess, conn, netFile.getFullNameStream(), newName, overwrite);
                    break;
                }
                case 258: 
                case 1013: {
                    int flag = dataBuf.getByte();
                    boolean delFlag = flag == 1;
                    FileInfo delInfo = new FileInfo();
                    delInfo.setDeleteOnClose(delFlag);
                    delInfo.setFileInformationFlags(1024);
                    disk.setFileInformation(this.m_sess, conn, netFile.getFullName(), delInfo);
                    netFile.setDeleteOnClose(delFlag);
                    if (!this.m_sess.hasDebug(256)) break;
                    this.m_sess.debugPrintln("  Set file disposition fid=" + fid + ", name=" + netFile.getName() + ", delete=" + delFlag);
                }
            }
            parser.setParameterCount(10);
            byte[] buf = parser.getBuffer();
            int prmPos = parser.getByteOffset();
            prmPos = DataPacker.longwordAlign(prmPos);
            DataPacker.putIntelShort(0, buf, prmPos);
            SMBSrvTransPacket.initTransactReply(smbPkt, 2, prmPos, 0, prmPos + 4);
            parser.setByteCount(prmPos - parser.getByteOffset() + 4);
            this.m_sess.sendResponseSMB(smbPkt);
            DiskDeviceContext diskCtx = (DiskDeviceContext)conn.getContext();
            if (diskCtx.hasFileServerNotifications() && netFile.getFullName() != null) {
                NotifyChangeHandler changeHandler = diskCtx.getChangeHandler();
                if (finfo != null) {
                    if (finfo.hasSetFlag(4)) {
                        changeHandler.notifyAttributesChanged(netFile.getFullName(), netFile.isDirectory());
                    }
                    if (finfo.hasSetFlag(8)) {
                        changeHandler.notifyLastWriteTimeChanged(netFile.getFullName(), netFile.isDirectory());
                    }
                } else if (infoLevl == 259 || infoLevl == 260) {
                    changeHandler.notifyFileSizeChanged(netFile.getFullName());
                }
            }
        }
        catch (FileNotFoundException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741772, 2, 1);
        }
        catch (PermissionDeniedException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741622, 5, 1);
            return;
        }
        catch (AccessDeniedException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741790, 5, 1);
        }
        catch (DiskFullException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741697, 29, 3);
        }
        catch (InvalidDeviceInterfaceException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
        }
        catch (DiskOfflineException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741766, 21, 3);
        }
        catch (DirectoryNotEmptyException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 145, 1);
        }
        catch (Exception ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
        }
    }

    protected final void procTrans2SetPath(SrvTransactBuffer tbuf, SMBSrvPacket smbPkt, SMBV1Parser parser) throws IOException, SMBSrvException {
        VirtualCircuit vc = this.m_sess.findVirtualCircuit(parser.getUserId());
        if (vc == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
            return;
        }
        int treeId = parser.getTreeId();
        TreeConnection conn = vc.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
            return;
        }
        if (!conn.hasWriteAccess()) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741790, 5, 1);
            return;
        }
        DataBuffer paramBuf = tbuf.getParameterBuffer();
        int infoLevl = paramBuf.getShort();
        paramBuf.skipBytes(4);
        String path = paramBuf.getString(tbuf.isUnicode());
        if (path.length() == 0) {
            path = "\\";
        }
        if (this.m_sess.hasDebug(256)) {
            this.m_sess.debugPrintln("Set Path - path=" + path + ", level=0x" + Integer.toHexString(infoLevl));
        }
        if (!FileName.isValidPath(path)) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741773, 13, 1);
            return;
        }
        try {
            DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
            DataBuffer dataBuf = tbuf.getDataBuffer();
            FileInfo finfo = null;
            int setFlags = 0;
            int attr = 0;
            switch (infoLevl) {
                case 1: {
                    int fileSize;
                    finfo = new FileInfo(path, 0L, -1);
                    int smbDate = dataBuf.getShort();
                    int smbTime = dataBuf.getShort();
                    boolean hasSetTime = false;
                    if (smbDate != 0 && smbTime != 0) {
                        finfo.setCreationDateTime(new SMBDate(smbDate, smbTime).getTime());
                        setFlags += 16;
                        hasSetTime = true;
                    }
                    smbDate = dataBuf.getShort();
                    smbTime = dataBuf.getShort();
                    if (smbDate != 0 && smbTime != 0) {
                        finfo.setAccessDateTime(new SMBDate(smbDate, smbTime).getTime());
                        setFlags += 32;
                        hasSetTime = true;
                    }
                    smbDate = dataBuf.getShort();
                    smbTime = dataBuf.getShort();
                    if (smbDate != 0 && smbTime != 0) {
                        finfo.setModifyDateTime(new SMBDate(smbDate, smbTime).getTime());
                        setFlags += 8;
                        hasSetTime = true;
                    }
                    if ((fileSize = dataBuf.getInt()) != 0) {
                        finfo.setFileSize(fileSize);
                        ++setFlags;
                    }
                    if ((fileSize = dataBuf.getInt()) != 0) {
                        finfo.setAllocationSize(fileSize);
                        setFlags += 2;
                    }
                    attr = dataBuf.getInt();
                    int eaListLen = dataBuf.getInt();
                    if (!hasSetTime && eaListLen == 0) {
                        finfo.setFileAttributes(attr);
                        setFlags += 4;
                    }
                    finfo.setFileInformationFlags(setFlags);
                    disk.setFileInformation(this.m_sess, conn, path, finfo);
                    if (!this.m_sess.hasDebug(256)) break;
                    this.m_sess.debugPrintln("  Set Standard Info [" + treeId + "] name=" + path + ", attr=0x" + Integer.toHexString(attr) + ", setTime=" + hasSetTime + ", setFlags=0x" + Integer.toHexString(setFlags) + ", eaListLen=" + eaListLen);
                    break;
                }
                case 257: {
                    finfo = new FileInfo(path, 0L, -1);
                    long dateTime = NTTime.toJavaDate(dataBuf.getLong());
                    if (dateTime != 0L) {
                        finfo.setCreationDateTime(dateTime);
                        setFlags += 16;
                    }
                    if ((dateTime = NTTime.toJavaDate(dataBuf.getLong())) != 0L) {
                        finfo.setAccessDateTime(dateTime);
                        setFlags += 32;
                    }
                    if ((dateTime = NTTime.toJavaDate(dataBuf.getLong())) != 0L) {
                        finfo.setModifyDateTime(dateTime);
                        setFlags += 8;
                    }
                    if ((dateTime = NTTime.toJavaDate(dataBuf.getLong())) != 0L) {
                        finfo.setChangeDateTime(dateTime);
                        setFlags += 64;
                    }
                    if ((attr = dataBuf.getInt()) != 0) {
                        finfo.setFileAttributes(attr);
                        setFlags += 4;
                    }
                    finfo.setFileInformationFlags(setFlags);
                    disk.setFileInformation(this.m_sess, conn, path, finfo);
                    if (!this.m_sess.hasDebug(256)) break;
                    this.m_sess.debugPrintln("  Set Basic Info [" + treeId + "] name=" + path + ", attr=0x" + Integer.toHexString(attr) + ", setFlags=0x" + Integer.toHexString(setFlags));
                }
            }
            parser.setParameterCount(10);
            byte[] buf = parser.getBuffer();
            int prmPos = parser.getByteOffset();
            prmPos = DataPacker.longwordAlign(prmPos);
            DataPacker.putIntelShort(0, buf, prmPos);
            SMBSrvTransPacket.initTransactReply(smbPkt, 2, prmPos, 0, prmPos + 4);
            parser.setByteCount(prmPos - parser.getByteOffset() + 4);
            this.m_sess.sendResponseSMB(smbPkt);
            DiskDeviceContext diskCtx = (DiskDeviceContext)conn.getContext();
            if (diskCtx.hasFileServerNotifications() && path != null) {
                NotifyChangeHandler changeHandler = diskCtx.getChangeHandler();
                if (finfo != null) {
                    FileStatus fileSts = disk.fileExists(this.m_sess, conn, path);
                    if (finfo.hasSetFlag(4)) {
                        changeHandler.notifyAttributesChanged(path, fileSts == FileStatus.DirectoryExists);
                    }
                    if (finfo.hasSetFlag(8)) {
                        changeHandler.notifyLastWriteTimeChanged(path, fileSts == FileStatus.DirectoryExists);
                    }
                }
            }
        }
        catch (FileNotFoundException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741772, 2, 1);
        }
        catch (AccessDeniedException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741790, 5, 1);
        }
        catch (DiskFullException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741697, 29, 3);
        }
        catch (InvalidDeviceInterfaceException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
        }
        catch (DiskOfflineException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741766, 21, 3);
        }
        catch (Exception ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void procWriteAndX(SMBSrvPacket smbPkt, SMBV1Parser parser) throws IOException, SMBSrvException {
        NetworkFile netFile;
        if (!parser.checkPacketIsValid(12, 0)) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
            return;
        }
        VirtualCircuit vc = this.m_sess.findVirtualCircuit(parser.getUserId());
        if (vc == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
            return;
        }
        int treeId = parser.getTreeId();
        TreeConnection conn = vc.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
            return;
        }
        if (!conn.hasWriteAccess()) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741790, 5, 1);
            return;
        }
        if (conn.getSharedDevice().getType() == ShareType.ADMINPIPE) {
            IPCHandler.processIPCRequest(this.m_sess, smbPkt);
            return;
        }
        int fid = parser.getParameter(2);
        long offset = (long)parser.getParameterLong(3) & 0xFFFFFFFFL;
        int dataPos = parser.getParameter(11) + 4;
        int dataLen = parser.getParameter(10);
        int dataLenHigh = 0;
        if (smbPkt.getReceivedLength() > 65535) {
            dataLenHigh = parser.getParameter(9) & 1;
        }
        if (dataLenHigh > 0) {
            dataLen += dataLenHigh << 16;
        }
        if (parser.getParameterCount() == 14) {
            long topOff = (long)parser.getParameterLong(12) & 0xFFFFFFFFL;
            offset += topOff << 32;
        }
        if ((netFile = conn.findFile(fid)) == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 6, 1);
            return;
        }
        if (this.m_sess.hasDebug(1024)) {
            this.m_sess.debugPrintln("File Write AndX [" + netFile.getFileId() + "] : Size=" + dataLen + " ,Pos=" + offset);
        }
        byte[] buf = parser.getBuffer();
        int wrtlen = 0;
        try {
            DiskInterface disk = (DiskInterface)conn.getSharedDevice().getInterface();
            NetworkFile networkFile = netFile;
            synchronized (networkFile) {
                wrtlen = disk.writeFile(this.m_sess, conn, netFile, buf, dataPos, dataLen, offset);
            }
        }
        catch (InvalidDeviceInterfaceException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 13, 1);
            return;
        }
        catch (AccessDeniedException ex) {
            if (this.m_sess.hasDebug(1024)) {
                this.m_sess.debugPrintln("File Write Error [" + netFile.getFileId() + "] : " + ex.toString());
            }
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741790, 5, 1);
            return;
        }
        catch (LockConflictException ex) {
            if (this.m_sess.hasDebug(32768)) {
                this.m_sess.debugPrintln("Write Lock Error [" + netFile.getFileId() + "] : Size=" + dataLen + " ,Pos=" + offset);
            }
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741740, 5, 1);
            return;
        }
        catch (DiskFullException ex) {
            if (this.m_sess.hasDebug(1024)) {
                this.m_sess.debugPrintln("Write Quota Error [" + netFile.getFileId() + "] Disk full : Size=" + dataLen + " ,Pos=" + offset);
            }
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741697, 29, 3);
            return;
        }
        catch (DiskOfflineException ex) {
            if (this.m_sess.hasDebug(1024)) {
                this.m_sess.debugPrintln("Filesystem Offline Error [" + netFile.getFileId() + "] Write File");
            }
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741766, 21, 3);
        }
        catch (IOException ex) {
            if (this.m_sess.hasDebug(1024)) {
                this.m_sess.debugPrintln("File Write Error [" + netFile.getFileId() + "] : " + ex.toString());
            }
            this.m_sess.sendErrorResponseSMB(smbPkt, 29, 3);
            return;
        }
        parser.setSuccessStatus();
        parser.setParameterCount(6);
        parser.setAndXCommand(255);
        parser.setParameter(1, 0);
        parser.setParameter(2, wrtlen);
        parser.setParameter(3, 65535);
        if (dataLenHigh > 0) {
            parser.setParameter(4, dataLen >> 16);
            parser.setParameter(5, 0);
        } else {
            parser.setParameterLong(4, 0);
        }
        parser.setByteCount(0);
        parser.setParameter(1, parser.getLength());
        this.m_sess.sendResponseSMB(smbPkt);
        DiskDeviceContext diskCtx = (DiskDeviceContext)conn.getContext();
        if (netFile.getWriteCount() % 10 == 0 && diskCtx.hasFileServerNotifications() && netFile.getFullName() != null) {
            NotifyChangeHandler changeHandler = diskCtx.getChangeHandler();
            changeHandler.notifyFileSizeChanged(netFile.getFullName());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void procNTCreateAndX(SMBSrvPacket smbPkt, SMBV1Parser parser) throws IOException, SMBSrvException {
        int fid;
        if (!parser.checkPacketIsValid(24, 1)) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
            return;
        }
        VirtualCircuit vc = this.m_sess.findVirtualCircuit(parser.getUserId());
        if (vc == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
            return;
        }
        int treeId = parser.getTreeId();
        TreeConnection conn = vc.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 5, 2);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741790, 5, 1);
            return;
        }
        if (conn.getSharedDevice().getType() == ShareType.ADMINPIPE) {
            IPCHandler.processIPCRequest(this.m_sess, smbPkt);
            return;
        }
        if (conn.getSharedDevice().getType() != ShareType.DISK) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741790, 5, 1);
            return;
        }
        NTParameterPacker prms = new NTParameterPacker(parser.getBuffer(), 42);
        int nameLen = prms.unpackWord();
        int flags = prms.unpackInt();
        int rootFID = prms.unpackInt();
        int accessMask = prms.unpackInt();
        long allocSize = prms.unpackLong();
        int attrib = prms.unpackInt();
        SharingMode shrAccess = SharingMode.fromInt(prms.unpackInt());
        CreateDisposition createDisp = CreateDisposition.fromInt(prms.unpackInt());
        int createOptn = prms.unpackInt();
        ImpersonationLevel impersonLev = ImpersonationLevel.fromInt(prms.unpackInt());
        int secFlags = prms.unpackByte();
        String fileName = DataPacker.getUnicodeString(parser.getBuffer(), DataPacker.wordAlign(parser.getByteOffset()), nameLen / 2);
        if (fileName == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
            return;
        }
        DiskInterface disk = null;
        try {
            disk = (DiskInterface)conn.getSharedDevice().getInterface();
        }
        catch (InvalidDeviceInterfaceException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 13, 1);
            return;
        }
        if (fileName.indexOf(":") != -1) {
            boolean streams = false;
            if (disk instanceof NTFSStreamsInterface) {
                NTFSStreamsInterface ntfsStreams = (NTFSStreamsInterface)((Object)disk);
                streams = ntfsStreams.hasStreamsEnabled(this.m_sess, conn);
            }
            if (!streams) {
                this.m_sess.sendErrorResponseSMB(smbPkt, -1073741773, 2, 1);
                return;
            }
        }
        FileOpenParams params = new FileOpenParams(fileName, createDisp, accessMask, attrib, shrAccess, allocSize, createOptn, rootFID, impersonLev, secFlags, parser.getProcessIdFull());
        params.setNTCreateFlags(flags);
        params.setTreeId(treeId);
        params.setSession(this.m_sess);
        SMBV1OplockOwner oplockOwner = null;
        if (params.requestedOplockType() != OpLockType.LEVEL_NONE) {
            oplockOwner = new SMBV1OplockOwner(treeId, parser.getProcessId(), parser.getUserId());
            params.setOplockOwner(oplockOwner);
        }
        if (this.m_sess.hasDebug(512)) {
            this.m_sess.debugPrintln("NT Create AndX [" + treeId + "] params=" + params);
        }
        if (!FileName.isValidPath(params.getPath())) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741773, 13, 1);
            return;
        }
        NetworkFile netFile = null;
        int respAction = 0;
        OpLockDetails oplock = null;
        try {
            block69: {
                block67: {
                    int idx;
                    FileStatus fldrSts;
                    StringBuilder pathStr;
                    String[] paths;
                    block68: {
                        FileStatus fileSts;
                        block64: {
                            block65: {
                                block66: {
                                    FileInfo finfo;
                                    fileSts = disk.fileExists(this.m_sess, conn, params.getFullPath());
                                    if (!params.isDirectory() && fileSts == FileStatus.DirectoryExists) {
                                        params.setCreateOption(1);
                                    }
                                    if (fileSts == FileStatus.FileExists && (finfo = disk.getFileInformation(this.m_sess, conn, params.getFullPath())) != null && finfo.isPseudoFile()) {
                                        createDisp = CreateDisposition.OPEN;
                                        if (params.requestBatchOpLock() || params.requestExclusiveOpLock()) {
                                            if (params.requestExtendedResponse()) {
                                                params.setNTCreateFlags(16);
                                            } else {
                                                params.setNTCreateFlags(0);
                                            }
                                        }
                                        if (this.m_sess.hasDebug(512)) {
                                            this.m_sess.debugPrintln("Converted create to open for pseudo file " + params);
                                        }
                                    }
                                    if (fileSts != FileStatus.NotExist) break block64;
                                    if (createDisp != CreateDisposition.CREATE && createDisp != CreateDisposition.OPEN_IF && createDisp != CreateDisposition.OVERWRITE_IF && createDisp != CreateDisposition.SUPERSEDE) break block65;
                                    if (!conn.hasWriteAccess()) {
                                        this.m_sess.sendErrorResponseSMB(smbPkt, -1073741790, 5, 1);
                                        return;
                                    }
                                    if ((createOptn & 1) != 0) break block66;
                                    netFile = disk.createFile(this.m_sess, conn, params);
                                    if (netFile != null && this.m_sess.hasDebug(0x2000000)) {
                                        netFile.setStatusFlag(NetworkFile.Flags.CREATED, true);
                                        netFile.setCreationDate(System.currentTimeMillis());
                                    }
                                    oplock = OpLockHelper.grantOpLock(this.m_sess, smbPkt, disk, conn, params, netFile);
                                    break block67;
                                }
                                paths = FileName.splitAllPaths(params.getPath());
                                pathStr = new StringBuilder(params.getPath().length());
                                fldrSts = FileStatus.Unknown;
                                idx = 0;
                                break block68;
                            }
                            if (fileSts == FileStatus.DirectoryExists) {
                                this.m_sess.sendErrorResponseSMB(smbPkt, -1073741771, 80, 1);
                                return;
                            }
                            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741772, 2, 1);
                            return;
                        }
                        if (createDisp == CreateDisposition.CREATE) {
                            if (fileSts != FileStatus.FileExists && fileSts != FileStatus.DirectoryExists) {
                                this.m_sess.sendErrorResponseSMB(smbPkt, -1073741790, 5, 1);
                                return;
                            }
                            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741771, 80, 1);
                            return;
                        }
                        if ((createOptn & 0x40) != 0 && fileSts == FileStatus.DirectoryExists) {
                            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741638, 5, 1);
                            return;
                        }
                        OpLockHelper.checkOpLock(this.m_sess, smbPkt, disk, params, conn);
                        netFile = disk.openFile(this.m_sess, conn, params);
                        oplock = OpLockHelper.grantOpLock(this.m_sess, smbPkt, disk, conn, params, netFile);
                        if (createDisp == CreateDisposition.SUPERSEDE || createDisp == CreateDisposition.OVERWRITE_IF) {
                            disk.truncateFile(this.m_sess, conn, netFile, 0L);
                            if (this.m_sess.hasDebug(512)) {
                                this.m_sess.debugPrintln("  [" + treeId + "] name=" + fileName + " truncated");
                            }
                            if (netFile != null && this.m_sess.hasDebug(0x2000000)) {
                                netFile.setStatusFlag(NetworkFile.Flags.CREATED, true);
                                netFile.setCreationDate(System.currentTimeMillis());
                            }
                        }
                        respAction = 1;
                        break block69;
                    }
                    while (idx < paths.length) {
                        pathStr.append("\\");
                        pathStr.append(paths[idx++]);
                        fldrSts = disk.fileExists(this.m_sess, conn, pathStr.toString());
                        if (fldrSts == FileStatus.FileExists) {
                            if (idx < paths.length) {
                                this.m_sess.sendErrorResponseSMB(smbPkt, -1073741771, 80, 1);
                                return;
                            }
                            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741766, 3, 1);
                            return;
                        }
                        if (fldrSts != FileStatus.NotExist) continue;
                        FileOpenParams fldrParams = new FileOpenParams(pathStr.toString(), createDisp, accessMask, attrib, shrAccess, allocSize, createOptn, rootFID, impersonLev, secFlags, parser.getProcessIdFull());
                        disk.createDirectory(this.m_sess, conn, fldrParams);
                    }
                    netFile = disk.openFile(this.m_sess, conn, params);
                    if (netFile != null && this.m_sess.hasDebug(0x2000000)) {
                        netFile.setStatusFlag(NetworkFile.Flags.CREATED, true);
                        netFile.setCreationDate(System.currentTimeMillis());
                    }
                }
                if (netFile != null && (createOptn & 0x1000) != 0) {
                    netFile.setDeleteOnClose(true);
                }
                respAction = 2;
            }
            fid = conn.addFile(netFile, this.getSession());
            if (oplock != null && oplock.getLockType() != OpLockType.LEVEL_NONE && oplock.getLockType() != OpLockType.LEVEL_II) {
                oplock.setOwnerFileId(fid);
                oplockOwner.setFileId(fid);
            }
            if (this.m_sess.hasDebug(512)) {
                this.m_sess.debugPrintln("  [" + treeId + "] name=" + fileName + " fid=" + fid + ", fileId=" + netFile.getFileId() + ", opLock=" + oplock);
            }
        }
        catch (TooManyFilesException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741537, 4, 1);
            return;
        }
        catch (AccessDeniedException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741790, 5, 1);
            return;
        }
        catch (FileExistsException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741771, 80, 1);
            return;
        }
        catch (FileSharingException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741757, 32, 1);
            return;
        }
        catch (FileOfflineException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741209, 21, 3);
            return;
        }
        catch (FileNameException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741773, 11, 1);
            return;
        }
        catch (DiskOfflineException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741766, 21, 3);
            return;
        }
        catch (DiskFullException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741697, 29, 3);
            return;
        }
        catch (DeferredPacketException ex) {
            throw ex;
        }
        catch (IOException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741772, 2, 1);
            return;
        }
        boolean extendedResponse = params.requestExtendedResponse();
        parser.setParameterCount(extendedResponse ? 42 : 34);
        parser.setAndXCommand(255);
        parser.setParameter(1, 0);
        prms.reset(parser.getBuffer(), 41);
        if (oplock != null) {
            prms.packByte(oplock.getLockType().intValue());
        } else {
            prms.packByte(0);
        }
        prms.packWord(fid);
        prms.packInt(respAction);
        if (netFile.hasCreationDate()) {
            prms.packLong(NTTime.toNTTime(netFile.getCreationDate()));
        } else {
            prms.packLong(0L);
        }
        if (netFile.hasAccessDate()) {
            prms.packLong(NTTime.toNTTime(netFile.getAccessDate()));
        } else if (netFile.hasModifyDate()) {
            prms.packLong(NTTime.toNTTime(netFile.getModifyDate()));
        } else {
            prms.packLong(0L);
        }
        if (netFile.hasModifyDate()) {
            long modDate = NTTime.toNTTime(netFile.getModifyDate());
            prms.packLong(modDate);
            prms.packLong(modDate);
        } else {
            prms.packLong(0L);
            prms.packLong(0L);
        }
        prms.packInt(netFile.getFileAttributes());
        long fileSize = netFile.getFileSize();
        if (fileSize > 0L) {
            fileSize = fileSize + 512L & 0xFFFFFFFFFFFFFE00L;
        }
        prms.packLong(fileSize);
        prms.packLong(netFile.getFileSize());
        prms.packWord(0);
        prms.packWord(extendedResponse ? 7 : 0);
        prms.packByte(netFile.isDirectory() ? 1 : 0);
        prms.packWord(0);
        if (extendedResponse) {
            prms.packLong(0L);
            prms.packLong(0L);
            prms.packInt(0);
            prms.packWord(0);
            if (netFile.isDirectory() || netFile.getAllowedAccess() == NetworkFile.Access.READ_WRITE) {
                prms.packInt(0x1F01FF);
            } else {
                prms.packInt(1179785);
            }
            prms.packInt(0);
            prms.packInt(0);
        }
        int endPos = prms.getPosition();
        parser.setParameter(1, endPos - 4);
        parser.setLongErrorCode(0);
        if (parser.hasAndXCommand()) {
            endPos = this.procAndXCommands(smbPkt, parser, netFile);
        }
        this.m_sess.sendResponseSMB(smbPkt, endPos - 4);
        DiskDeviceContext diskCtx = (DiskDeviceContext)conn.getContext();
        if (!diskCtx.hasFileServerNotifications()) return;
        if (respAction != 2) return;
        if (netFile.isDirectory()) {
            diskCtx.getChangeHandler().notifyDirectoryChanged(NotifyAction.Added, fileName);
            return;
        }
        diskCtx.getChangeHandler().notifyFileChanged(NotifyAction.Added, fileName);
    }

    protected final void procNTCancel(SMBSrvPacket smbPkt, SMBV1Parser parser) throws IOException, SMBSrvException {
        if (!parser.checkPacketIsValid(0, 0)) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
            return;
        }
        VirtualCircuit vc = this.m_sess.findVirtualCircuit(parser.getUserId());
        if (vc == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
            return;
        }
        int treeId = parser.getTreeId();
        TreeConnection conn = vc.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
            return;
        }
        NotifyRequest req = this.m_sess.findNotifyRequest(parser.getMultiplexId(), parser.getTreeId(), parser.getUserId(), parser.getProcessId());
        if (req != null) {
            this.m_sess.removeNotifyRequest(req);
            parser.setParameterCount(0);
            parser.setByteCount(0);
            if (!parser.isLongErrorCode()) {
                parser.setFlags2(parser.getFlags2() + 16384);
            }
            parser.setLongErrorCode(-1073741536);
            if (!parser.isUnicode()) {
                parser.setFlags2(parser.getFlags2() + 32768);
            }
            this.m_sess.sendResponseSMB(smbPkt);
            if (this.m_sess.hasDebug(524288)) {
                DiskDeviceContext diskCtx = (DiskDeviceContext)conn.getContext();
                this.m_sess.debugPrintln("NT Cancel notify mid=" + req.getId() + ", dir=" + req.getWatchPath() + ", queue=" + diskCtx.getChangeHandler().getRequestQueueSize());
            }
        } else {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
        }
    }

    protected final void procNTTransaction(SMBSrvPacket smbPkt, SMBV1Parser parser) throws IOException, SMBSrvException {
        if (!parser.checkPacketIsValid(19, 0)) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
            return;
        }
        VirtualCircuit vc = this.m_sess.findVirtualCircuit(parser.getUserId());
        if (vc == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
            return;
        }
        int treeId = parser.getTreeId();
        TreeConnection conn = vc.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741790, 5, 1);
            return;
        }
        if (conn.getSharedDevice().getType() == ShareType.ADMINPIPE) {
            IPCHandler.processIPCRequest(this.m_sess, smbPkt);
            return;
        }
        int subCmd = parser.getNTFunction();
        if (subCmd == 4) {
            this.procNTTransactNotifyChange(smbPkt, parser);
            return;
        }
        SrvTransactBuffer transBuf = null;
        if (parser.getTotalParameterCount() == parser.getParameterBlockCount() && parser.getTotalDataCount() == parser.getDataBlockCount()) {
            transBuf = new SrvTransactBuffer(parser);
        } else {
            transBuf = new SrvTransactBuffer(parser.getSetupCount(), parser.getTotalParameterCount(), parser.getTotalDataCount());
            transBuf.setType(parser.getCommand());
            transBuf.setFunction(subCmd);
            if (this.m_sess.hasDebug(2048)) {
                this.m_sess.debugPrintln("NT Transaction [" + treeId + "] transbuf=" + transBuf);
            }
            byte[] buf = parser.getBuffer();
            int cnt = parser.getSetupCount();
            if (cnt > 0) {
                transBuf.appendSetup(buf, parser.getSetupOffset(), cnt * 2);
            }
            if (this.m_sess.hasDebug(2048)) {
                this.m_sess.debugPrintln("NT Transaction [" + treeId + "] pcnt=" + parser.getNTParameter(4) + ", offset=" + parser.getNTParameter(5));
            }
            if ((cnt = parser.getParameterBlockCount()) > 0) {
                transBuf.appendParameter(buf, parser.getParameterBlockOffset(), cnt);
            }
            if ((cnt = parser.getDataBlockCount()) > 0) {
                transBuf.appendData(buf, parser.getDataBlockOffset(), cnt);
            }
        }
        if (this.m_sess.hasDebug(2048)) {
            this.m_sess.debugPrintln("NT Transaction [" + treeId + "] cmd=0x" + Integer.toHexString(subCmd) + ", multiPkt=" + transBuf.isMultiPacket());
        }
        if (transBuf.isMultiPacket()) {
            vc.setTransaction(transBuf);
            this.m_sess.sendSuccessResponseSMB(smbPkt);
            return;
        }
        this.processNTTransactionBuffer(transBuf, smbPkt, parser);
    }

    protected final void procNTTransactionSecondary(SMBSrvPacket smbPkt, SMBV1Parser parser) throws IOException, SMBSrvException {
        int dlen;
        if (!parser.checkPacketIsValid(18, 0)) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
            return;
        }
        VirtualCircuit vc = this.m_sess.findVirtualCircuit(parser.getUserId());
        if (vc == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
            return;
        }
        int treeId = parser.getTreeId();
        TreeConnection conn = vc.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741790, 5, 1);
            return;
        }
        if (conn.getSharedDevice().getType() == ShareType.ADMINPIPE) {
            IPCHandler.processIPCRequest(this.m_sess, smbPkt);
            return;
        }
        if (!vc.hasTransaction() || vc.getTransaction().isType() != 160) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 1, 2);
            return;
        }
        byte[] buf = parser.getBuffer();
        SrvTransactBuffer transBuf = vc.getTransaction();
        int plen = parser.getParameterBlockCount();
        if (plen > 0) {
            DataBuffer paramBuf = transBuf.getParameterBuffer();
            paramBuf.appendData(buf, parser.getParameterBlockOffset(), plen);
        }
        if ((dlen = parser.getDataBlockCount()) > 0) {
            DataBuffer dataBuf = transBuf.getDataBuffer();
            dataBuf.appendData(buf, parser.getDataBlockOffset(), dlen);
        }
        if (this.m_sess.hasDebug(2048)) {
            this.m_sess.debugPrintln("NT Transaction Secondary [" + treeId + "] paramLen=" + plen + ", dataLen=" + dlen);
        }
        int totParam = parser.getTotalParameterCount();
        int totData = parser.getTotalDataCount();
        int paramDisp = parser.getParameterBlockDisplacement();
        int dataDisp = parser.getDataBlockDisplacement();
        if (paramDisp + plen == totParam && dataDisp + dlen == totData) {
            if (this.m_sess.hasDebug(2048)) {
                this.m_sess.debugPrintln("NT Transaction complete, processing ...");
            }
            vc.setTransaction(null);
            this.processNTTransactionBuffer(transBuf, smbPkt, parser);
        }
    }

    private final void processNTTransactionBuffer(SrvTransactBuffer tbuf, SMBSrvPacket smbPkt, SMBV1Parser parser) throws IOException, SMBSrvException {
        switch (tbuf.getFunction()) {
            case 1: {
                this.procNTTransactCreate(tbuf, smbPkt, parser);
                break;
            }
            case 2: {
                this.procNTTransactIOCtl(tbuf, smbPkt, parser);
                break;
            }
            case 6: {
                this.procNTTransactQuerySecurityDesc(tbuf, smbPkt, parser);
                break;
            }
            case 3: {
                this.procNTTransactSetSecurityDesc(tbuf, smbPkt, parser);
                break;
            }
            case 5: {
                this.procNTTransactRename(tbuf, smbPkt, parser);
                break;
            }
            case 7: {
                if (this.m_sess.hasDebug(2048)) {
                    this.m_sess.debugPrintln("NT GetUserQuota transaction");
                }
                this.m_sess.sendErrorResponseSMB(smbPkt, -1073741822, 65535, 2);
                break;
            }
            case 8: {
                if (this.m_sess.hasDebug(2048)) {
                    this.m_sess.debugPrintln("NT SetUserQuota transaction");
                }
                this.m_sess.sendErrorResponseSMB(smbPkt, -1073741822, 65535, 2);
                break;
            }
            default: {
                this.m_sess.debugPrintln("NT Error unknown NT transact command = 0x" + Integer.toHexString(tbuf.isType()));
                this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void procNTTransactCreate(SrvTransactBuffer tbuf, SMBSrvPacket smbPkt, SMBV1Parser parser) throws IOException, SMBSrvException {
        int fid;
        if (this.m_sess.hasDebug(2048)) {
            this.m_sess.debugPrintln("NT TransactCreate");
        }
        if (tbuf.hasParameterBuffer() && tbuf.getParameterBuffer().getLength() < 52) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
            return;
        }
        VirtualCircuit vc = this.m_sess.findVirtualCircuit(parser.getUserId());
        if (vc == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
            return;
        }
        int treeId = tbuf.getTreeId();
        TreeConnection conn = vc.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
            return;
        }
        if (!conn.hasWriteAccess()) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741790, 5, 1);
            return;
        }
        if (conn.getSharedDevice().getType() != ShareType.DISK) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741790, 5, 1);
            return;
        }
        DataBuffer tparams = tbuf.getParameterBuffer();
        int flags = tparams.getInt();
        int rootFID = tparams.getInt();
        int accessMask = tparams.getInt();
        long allocSize = tparams.getLong();
        int attrib = tparams.getInt();
        SharingMode shrAccess = SharingMode.fromInt(tparams.getInt());
        CreateDisposition createDisp = CreateDisposition.fromInt(tparams.getInt());
        int createOptn = tparams.getInt();
        int sdLen = tparams.getInt();
        int eaLen = tparams.getInt();
        int nameLen = tparams.getInt();
        ImpersonationLevel impersonLev = ImpersonationLevel.fromInt(tparams.getInt());
        int secFlags = tparams.getByte();
        tparams.wordAlign();
        String fileName = tparams.getString(nameLen, true);
        if (fileName == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
            return;
        }
        DiskInterface disk = null;
        try {
            disk = (DiskInterface)conn.getSharedDevice().getInterface();
        }
        catch (InvalidDeviceInterfaceException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, 13, 1);
            return;
        }
        if (fileName.indexOf(":") != -1) {
            boolean streams = false;
            if (disk instanceof NTFSStreamsInterface) {
                NTFSStreamsInterface ntfsStreams = (NTFSStreamsInterface)((Object)disk);
                streams = ntfsStreams.hasStreamsEnabled(this.m_sess, conn);
            }
            if (!streams) {
                this.m_sess.sendErrorResponseSMB(smbPkt, -1073741772, 2, 1);
                return;
            }
        }
        FileOpenParams params = new FileOpenParams(fileName, createDisp, accessMask, attrib, shrAccess, allocSize, createOptn, rootFID, impersonLev, secFlags, parser.getProcessIdFull());
        if (this.m_sess.hasDebug(512)) {
            this.m_sess.debugPrintln("NT TransactCreate [" + treeId + "] params=" + params);
            this.m_sess.debugPrintln("  secDescLen=" + sdLen + ", extAttribLen=" + eaLen);
        }
        NetworkFile netFile = null;
        int respAction = 0;
        try {
            block40: {
                FileStatus fileSts = disk.fileExists(this.m_sess, conn, fileName);
                if (fileSts == FileStatus.NotExist) {
                    if (createDisp == CreateDisposition.CREATE || createDisp == CreateDisposition.OPEN_IF || createDisp == CreateDisposition.OVERWRITE_IF || createDisp == CreateDisposition.SUPERSEDE) {
                        if ((createOptn & 1) == 0) {
                            netFile = disk.createFile(this.m_sess, conn, params);
                        } else {
                            disk.createDirectory(this.m_sess, conn, params);
                            netFile = disk.openFile(this.m_sess, conn, params);
                        }
                        respAction = 2;
                        break block40;
                    } else {
                        if (fileSts == FileStatus.DirectoryExists) {
                            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741771, 80, 1);
                            return;
                        }
                        this.m_sess.sendErrorResponseSMB(smbPkt, -1073741772, 2, 1);
                        return;
                    }
                }
                if (createDisp == CreateDisposition.CREATE) {
                    if (fileSts != FileStatus.FileExists && fileSts != FileStatus.DirectoryExists) {
                        this.m_sess.sendErrorResponseSMB(smbPkt, -1073741790, 5, 1);
                        return;
                    }
                    this.m_sess.sendErrorResponseSMB(smbPkt, -1073741771, 80, 1);
                    return;
                }
                netFile = disk.openFile(this.m_sess, conn, params);
                if (createDisp == CreateDisposition.SUPERSEDE || createDisp == CreateDisposition.OVERWRITE_IF) {
                    disk.truncateFile(this.m_sess, conn, netFile, 0L);
                    if (this.m_sess.hasDebug(512)) {
                        this.m_sess.debugPrintln("  [" + treeId + "] name=" + fileName + " truncated");
                    }
                }
                respAction = 1;
            }
            fid = conn.addFile(netFile, this.getSession());
        }
        catch (TooManyFilesException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741537, 4, 1);
            return;
        }
        catch (AccessDeniedException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741790, 5, 1);
            return;
        }
        catch (FileExistsException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741771, 80, 1);
            return;
        }
        catch (FileSharingException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741757, 32, 1);
            return;
        }
        catch (FileOfflineException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741209, 21, 3);
            return;
        }
        catch (DiskOfflineException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741766, 21, 3);
            return;
        }
        catch (IOException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741772, 2, 1);
            return;
        }
        DataBuffer prms = new DataBuffer(128);
        if ((flags & 4) != 0) {
            prms.putByte(2);
        } else if ((flags & 2) != 0) {
            prms.putByte(1);
        } else {
            prms.putByte(0);
        }
        prms.putByte(0);
        prms.putShort(fid);
        prms.putInt(respAction);
        prms.putInt(0);
        if (netFile.hasCreationDate()) {
            prms.putLong(NTTime.toNTTime(netFile.getCreationDate()));
        } else {
            prms.putLong(0L);
        }
        if (netFile.hasModifyDate()) {
            long modDate = NTTime.toNTTime(netFile.getModifyDate());
            prms.putLong(modDate);
            prms.putLong(modDate);
            prms.putLong(modDate);
        } else {
            prms.putLong(0L);
            prms.putLong(0L);
            prms.putLong(0L);
        }
        prms.putInt(netFile.getFileAttributes());
        prms.putLong(netFile.getFileSize());
        prms.putLong(netFile.getFileSize());
        prms.putShort(0);
        prms.putShort(0);
        prms.putByte(netFile.isDirectory() ? 1 : 0);
        parser.initTransactReply(prms.getBuffer(), prms.getLength(), null, 0);
        this.m_sess.sendResponseSMB(smbPkt);
        DiskDeviceContext diskCtx = (DiskDeviceContext)conn.getContext();
        if (!diskCtx.hasFileServerNotifications()) return;
        if (respAction != 2) return;
        if (netFile.isDirectory()) {
            diskCtx.getChangeHandler().notifyDirectoryChanged(NotifyAction.Added, fileName);
            return;
        }
        diskCtx.getChangeHandler().notifyFileChanged(NotifyAction.Added, fileName);
    }

    protected final void procNTTransactIOCtl(SrvTransactBuffer tbuf, SMBSrvPacket smbPkt, SMBV1Parser parser) throws IOException, SMBSrvException {
        VirtualCircuit vc = this.m_sess.findVirtualCircuit(parser.getUserId());
        if (vc == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
            return;
        }
        int treeId = tbuf.getTreeId();
        TreeConnection conn = vc.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
            return;
        }
        DataBuffer setupBuf = tbuf.getSetupBuffer();
        int ctrlCode = setupBuf.getInt();
        int fid = setupBuf.getShort();
        boolean fsctrl = setupBuf.getByte() == 1;
        int filter = setupBuf.getByte();
        if (this.m_sess.hasDebug(2048)) {
            this.m_sess.debugPrintln("NT IOCtl code=" + NTIOCtl.asString(ctrlCode) + ", fid=" + fid + ", fsctrl=" + fsctrl + ", filter=" + filter);
        }
        DiskInterface disk = null;
        try {
            disk = (DiskInterface)conn.getSharedDevice().getInterface();
        }
        catch (InvalidDeviceInterfaceException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 13, 1);
            return;
        }
        if (disk instanceof IOCtlInterface) {
            IOCtlInterface ioControl = (IOCtlInterface)((Object)disk);
            SMBSrvPacket respPkt = smbPkt;
            try {
                DataBuffer response = ioControl.processIOControl(this.m_sess, conn, ctrlCode, fid, tbuf.getDataBuffer(), fsctrl, filter);
                if (response != null) {
                    int respPktLen = SMBV1Parser.calculateResponseLength(0, response.getLength(), 1);
                    if (parser.getBufferLength() < respPktLen) {
                        SMBSrvPacket pkt = this.m_sess.getPacketPool().allocatePacket(respPktLen, smbPkt, parser.getLength());
                        respPkt = new SMBSrvPacket(pkt.getBuffer());
                        respPkt.setParser(SMBSrvPacket.Version.V1);
                        parser = (SMBV1Parser)respPkt.getParser();
                    }
                    parser.initTransactReply(null, 0, response.getBuffer(), response.getLength(), 1);
                    parser.setSetupParameter(0, response.getLength());
                } else {
                    parser.initTransactReply(null, 0, null, 0, 1);
                    parser.setSetupParameter(0, 0);
                }
            }
            catch (IOControlNotImplementedException ex) {
                this.m_sess.sendErrorResponseSMB(smbPkt, -1073741822, 65, 2);
                return;
            }
            catch (SMBException ex) {
                this.m_sess.sendErrorResponseSMB(smbPkt, ex.getErrorCode(), 65, 2);
                return;
            }
            this.m_sess.sendResponseSMB(respPkt);
        } else {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741822, 65535, 2);
        }
    }

    protected final void procNTTransactQuerySecurityDesc(SrvTransactBuffer tbuf, SMBSrvPacket smbPkt, SMBV1Parser parser) throws IOException, SMBSrvException {
        NetworkFile netFile;
        VirtualCircuit vc = this.m_sess.findVirtualCircuit(parser.getUserId());
        if (vc == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
            return;
        }
        int treeId = tbuf.getTreeId();
        TreeConnection conn = vc.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741790, 5, 1);
            return;
        }
        DataBuffer paramBuf = tbuf.getParameterBuffer();
        int fid = paramBuf.getShort();
        int flags = paramBuf.getShort();
        if (this.m_sess.hasDebug(2048)) {
            this.m_sess.debugPrintln("NT QuerySecurityDesc fid=" + fid + ", flags=" + flags);
        }
        if ((netFile = conn.findFile(fid)) == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
            return;
        }
        DiskInterface disk = null;
        try {
            disk = (DiskInterface)conn.getSharedDevice().getInterface();
        }
        catch (InvalidDeviceInterfaceException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 13, 1);
            return;
        }
        SMBSrvPacket respPkt = smbPkt;
        if (disk instanceof SecurityDescriptorInterface) {
            SecurityDescriptorInterface secDescInterface = (SecurityDescriptorInterface)((Object)disk);
            if (tbuf.getReturnDataLimit() == 0) {
                int secDescLen = secDescInterface.getSecurityDescriptorLength(this.m_sess, conn, netFile);
                byte[] paramblk = new byte[4];
                DataPacker.putIntelInt(secDescLen, paramblk, 0);
                parser.initTransactReply(paramblk, paramblk.length, null, 0);
                parser.setLongErrorCode(-1073741789);
            } else {
                SecurityDescriptor secDesc = secDescInterface.loadSecurityDescriptor(this.m_sess, conn, netFile);
                byte[] secBuf = null;
                int secLen = 0;
                byte[] paramblk = new byte[4];
                if (secDesc != null) {
                    DataBuffer buf = new DataBuffer(4096);
                    try {
                        secLen = secDesc.saveDescriptor(buf);
                        secBuf = buf.getBuffer();
                    }
                    catch (SaveException ex) {
                        this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
                        return;
                    }
                    parser.initTransactReply(paramblk, paramblk.length, null, 0);
                    int availLen = respPkt.getBufferLength() - parser.getLength();
                    if (availLen <= secLen + 8) {
                        SMBSrvPacket pkt = this.m_sess.getPacketPool().allocatePacket(parser.getLength() + secLen + 8, smbPkt);
                        respPkt = new SMBSrvPacket(pkt.getBuffer());
                        respPkt.setParser(SMBSrvPacket.Version.V1);
                        parser = (SMBV1Parser)respPkt.getParser();
                    }
                }
                DataPacker.putIntelInt(secLen, paramblk, 0);
                parser.initTransactReply(paramblk, paramblk.length, secBuf, secLen);
            }
        } else if (tbuf.getReturnDataLimit() == 0) {
            byte[] paramblk = new byte[4];
            DataPacker.putIntelInt(_sdEveryOne.length, paramblk, 0);
            parser.initTransactReply(paramblk, paramblk.length, null, 0);
            parser.setLongErrorCode(-1073741789);
        } else {
            byte[] paramblk = new byte[4];
            DataPacker.putIntelInt(_sdEveryOne.length, paramblk, 0);
            parser.initTransactReply(paramblk, paramblk.length, _sdEveryOne, _sdEveryOne.length);
        }
        this.m_sess.sendResponseSMB(respPkt);
    }

    protected final void procNTTransactSetSecurityDesc(SrvTransactBuffer tbuf, SMBSrvPacket smbPkt, SMBV1Parser parser) throws IOException, SMBSrvException {
        DataBuffer paramBuf = tbuf.getParameterBuffer();
        VirtualCircuit vc = this.m_sess.findVirtualCircuit(parser.getUserId());
        if (vc == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
            return;
        }
        int treeId = tbuf.getTreeId();
        TreeConnection conn = vc.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
            return;
        }
        if (!conn.hasWriteAccess()) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741790, 5, 1);
            return;
        }
        int fid = paramBuf.getShort();
        paramBuf.skipBytes(2);
        int flags = paramBuf.getInt();
        DataBuffer dataBuf = tbuf.getDataBuffer();
        SecurityDescriptor secDesc = new SecurityDescriptor();
        try {
            secDesc.loadDescriptor(dataBuf.getBuffer(), dataBuf.getOffset());
        }
        catch (LoadException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
            return;
        }
        if (this.m_sess.hasDebug(2048)) {
            this.m_sess.debugPrintln("NT SetSecurityDesc fid=" + fid + ", flags=" + flags);
            this.m_sess.debugPrintln("   sd=" + secDesc);
        }
        DiskInterface disk = null;
        try {
            disk = (DiskInterface)conn.getSharedDevice().getInterface();
        }
        catch (InvalidDeviceInterfaceException ex) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 13, 1);
            return;
        }
        if (disk instanceof SecurityDescriptorInterface) {
            SecurityDescriptorInterface secDescInterface = (SecurityDescriptorInterface)((Object)disk);
            NetworkFile netFile = conn.findFile(fid);
            if (netFile == null) {
                this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
                return;
            }
            secDescInterface.saveSecurityDescriptor(this.m_sess, conn, netFile, secDesc);
            parser.initTransactReply(null, 0, null, 0);
            parser.setError(0, 0);
            this.m_sess.sendResponseSMB(smbPkt);
        } else {
            this.m_sess.sendSuccessResponseSMB(smbPkt);
        }
    }

    protected final void procNTTransactNotifyChange(SMBSrvPacket smbPkt, SMBV1Parser parser) throws IOException, SMBSrvException {
        NotifyRequest req;
        VirtualCircuit vc = this.m_sess.findVirtualCircuit(parser.getUserId());
        if (vc == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
            return;
        }
        int treeId = parser.getTreeId();
        TreeConnection conn = vc.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741790, 5, 1);
            return;
        }
        if (conn.getContext() == null || !(conn.getContext() instanceof DiskDeviceContext)) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
            return;
        }
        DiskDeviceContext diskCtx = (DiskDeviceContext)conn.getContext();
        if (!diskCtx.hasChangeHandler()) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741822, 1, 2);
            return;
        }
        parser.resetSetupPointer();
        Set<NotifyChange> filter = NotifyChange.setFromInt(parser.unpackInt());
        int fid = parser.unpackWord();
        boolean watchTree = parser.unpackByte() == 1;
        int mid = parser.getMultiplexId();
        NetworkFile dir = conn.findFile(fid);
        if (dir == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 1, 2);
            return;
        }
        int maxQueue = 0;
        if (this.m_sess.hasDebug(524288)) {
            this.m_sess.debugPrintln("NT NotifyChange fid=" + fid + ", mid=" + mid + ", filter=" + filter + ", dir=" + dir.getFullName() + ", maxQueue=" + maxQueue);
        }
        if ((req = this.m_sess.findNotifyRequest(dir, filter, watchTree)) != null && req.isCompleted()) {
            req.setId(mid);
            req.setCompleted(false);
            if (req.hasBufferedEvents() || req.hasNotifyEnum()) {
                NotifyChangeEventList bufList = req.getBufferedEventList();
                req.clearBufferedEvents();
                diskCtx.getChangeHandler().sendBufferedNotifications(req, bufList);
                if (this.m_sess.hasDebug(524288)) {
                    if (bufList == null) {
                        this.m_sess.debugPrintln("   Sent buffered notifications, req=" + req.toString() + ", Enum");
                    } else {
                        this.m_sess.debugPrintln("   Sent buffered notifications, req=" + req.toString() + ", count=" + bufList.numberOfEvents());
                    }
                }
            } else if (this.m_sess.hasDebug(524288)) {
                this.m_sess.debugPrintln("   Reset notify request, " + req.toString());
            }
        } else {
            req = new NotifyRequest(filter, watchTree, this.m_sess, dir, mid, parser.getTreeId(), parser.getProcessId(), parser.getUserId(), maxQueue);
            this.m_sess.addNotifyRequest(req, diskCtx);
            if (this.m_sess.hasDebug(524288)) {
                this.m_sess.debugPrintln("   Added new request, " + req.toString());
                this.m_sess.debugPrintln("   Global notify mask=" + diskCtx.getChangeHandler().getGlobalNotifyMask() + ", reqQueue=" + diskCtx.getChangeHandler().getRequestQueueSize());
            }
        }
    }

    protected final void procNTTransactRename(SrvTransactBuffer tbuf, SMBSrvPacket smbPkt, SMBV1Parser parser) throws IOException, SMBSrvException {
        VirtualCircuit vc = this.m_sess.findVirtualCircuit(parser.getUserId());
        if (vc == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
            return;
        }
        int treeId = tbuf.getTreeId();
        TreeConnection conn = vc.findConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741811, 15, 1);
            return;
        }
        if (!conn.hasWriteAccess()) {
            this.m_sess.sendErrorResponseSMB(smbPkt, -1073741790, 5, 1);
            return;
        }
        if (this.m_sess.hasDebug(2048)) {
            this.m_sess.debugPrintln("NT TransactRename");
        }
        this.m_sess.sendErrorResponseSMB(smbPkt, 1, 2);
    }

    @Override
    public SMBSrvPacket buildChangeNotificationResponse(NotifyChangeEvent evt, NotifyRequest req) {
        SMBSrvPacket smbPkt = new SMBSrvPacket();
        smbPkt.setParser(SMBSrvPacket.Version.V1);
        SMBV1Parser parser = (SMBV1Parser)smbPkt.getParser();
        parser.setParameterCount(18);
        parser.resetBytePointerAlign();
        int pos = parser.getPosition();
        parser.setNTParameter(1, 0);
        parser.setNTParameter(3, pos - 4);
        parser.setCommand(160);
        parser.setLongErrorCode(0);
        parser.setFlags(24);
        parser.setFlags2(49152);
        parser.setMultiplexId(req.getIdAsInt());
        parser.setTreeId(req.getTreeId());
        parser.setUserId(req.getUserId());
        parser.setProcessId(req.getProcessId());
        if (!req.hasNotifyEnum()) {
            String relName = evt.getFileName();
            if (relName == null) {
                relName = evt.getShortFileName();
            }
            if (this.m_sess.hasDebug(524288)) {
                this.m_sess.debugPrintln("  Notify evtPath=" + evt.getFileName() + ", MID=" + req.getId() + ", reqPath=" + req.getWatchPath() + ", relative=" + relName);
            }
            parser.packInt(0);
            parser.packInt(evt.getAction().intValue());
            parser.packInt(relName.length() * 2);
            parser.packString(relName, true, false);
            if (evt.getAction() == NotifyAction.RenamedNewName && evt.hasOldFileName()) {
                int newPos = DataPacker.longwordAlign(parser.getPosition());
                DataPacker.putIntelInt(newPos - pos, parser.getBuffer(), pos);
                relName = FileName.makeRelativePath(req.getWatchPath(), evt.getOldFileName());
                if (relName == null) {
                    relName = evt.getOldFileName();
                }
                parser.packInt(0);
                parser.packInt(NotifyAction.RenamedOldName.intValue());
                parser.packInt(relName.length() * 2);
                parser.packString(relName, true, false);
            }
            int prmLen = parser.getPosition() - pos;
            parser.alignBytePointer();
            pos = pos + 3 & 0xFFFFFFFC;
            parser.setNTParameter(0, prmLen);
            parser.setNTParameter(2, prmLen);
            parser.setNTParameter(6, parser.getPosition() - 4);
            parser.setByteCount();
        } else {
            parser.setLongErrorCode(268);
        }
        return smbPkt;
    }

    @Override
    public SMBSrvPacket buildOpLockBreakResponse(LocalOpLockDetails oplock) {
        SMBV1OplockOwner oplockOwner = (SMBV1OplockOwner)oplock.getOplockOwner();
        if (oplockOwner == null) {
            return null;
        }
        SMBSrvPacket opBreakPkt = new SMBSrvPacket(128);
        opBreakPkt.setParser(SMBSrvPacket.Version.V1);
        SMBV1Parser parser = (SMBV1Parser)opBreakPkt.getParser();
        opBreakPkt.clearHeader();
        parser.setCommand(36);
        parser.setFlags(0);
        parser.setFlags2(0);
        parser.setTreeId(oplockOwner.getTreeId());
        parser.setProcessId(65535);
        parser.setUserId(0);
        parser.setMultiplexId(65535);
        parser.setParameterCount(8);
        parser.setAndXCommand(255);
        parser.setParameter(1, 0);
        parser.setParameter(2, oplockOwner.getFileId());
        parser.setParameter(3, 258);
        parser.setParameterLong(4, 0);
        parser.setParameter(6, 0);
        parser.setParameter(7, 0);
        parser.setByteCount(0);
        parser.setRequestPacket(true);
        return opBreakPkt;
    }

    @Override
    public boolean runProtocol(SMBSrvPacket smbPkt) throws IOException, SMBSrvException, TooManyConnectionsException {
        if (!smbPkt.isSMB1()) {
            throw new IOException("Invalid SMB signature");
        }
        SMBV1Parser parser = (SMBV1Parser)smbPkt.getParser();
        if (parser == null) {
            throw new IOException("SMB packet does not have a parser");
        }
        if (this.m_sess.hasDebug(2) && parser.hasChainedCommand()) {
            this.m_sess.debugPrintln("AndX Command = 0x" + Integer.toHexString(parser.getAndXCommand()));
        }
        parser.resetBytePointer();
        this.m_sess.setProcessId(parser.getProcessId());
        boolean handledOK = true;
        switch (parser.getCommand()) {
            case 115: {
                this.procSessionSetup(smbPkt, parser);
                break;
            }
            case 117: {
                this.procTreeConnectAndX(smbPkt, parser);
                break;
            }
            case 37: 
            case 50: {
                this.procTransact2(smbPkt, parser);
                break;
            }
            case 38: 
            case 51: {
                this.procTransact2Secondary(smbPkt, parser);
                break;
            }
            case 52: {
                this.procFindClose(smbPkt, parser);
                break;
            }
            case 45: {
                this.procOpenAndX(smbPkt, parser);
                break;
            }
            case 4: {
                this.procCloseFile(smbPkt, parser);
                break;
            }
            case 46: {
                this.procReadAndX(smbPkt, parser);
                break;
            }
            case 47: {
                this.procWriteAndX(smbPkt, parser);
                break;
            }
            case 7: {
                this.procRenameFile(smbPkt, parser);
                break;
            }
            case 6: {
                this.procDeleteFile(smbPkt, parser);
                break;
            }
            case 1: {
                this.procDeleteDirectory(smbPkt, parser);
                break;
            }
            case 113: {
                this.procTreeDisconnect(smbPkt, parser);
                break;
            }
            case 36: {
                this.procLockingAndX(smbPkt, parser);
                break;
            }
            case 116: {
                this.procLogoffAndX(smbPkt, parser);
                break;
            }
            case 162: {
                this.procNTCreateAndX(smbPkt, parser);
                break;
            }
            case 112: {
                super.runProtocol(smbPkt);
                break;
            }
            case 164: {
                this.procNTCancel(smbPkt, parser);
                break;
            }
            case 160: {
                this.procNTTransaction(smbPkt, parser);
                break;
            }
            case 161: {
                this.procNTTransactionSecondary(smbPkt, parser);
                break;
            }
            case 43: {
                super.procEcho(smbPkt, parser);
                break;
            }
            default: {
                int treeId = parser.getTreeId();
                TreeConnection conn = null;
                if (treeId != -1) {
                    conn = this.m_sess.findTreeConnection(smbPkt);
                }
                if (conn != null) {
                    if (conn.getSharedDevice().getType() == ShareType.DISK || conn.getSharedDevice().getType() == ShareType.PRINTER) {
                        handledOK = super.runProtocol(smbPkt);
                        break;
                    }
                    if (conn.getSharedDevice().getType() != ShareType.ADMINPIPE) break;
                    IPCHandler.processIPCRequest(this.m_sess, smbPkt);
                    handledOK = true;
                    break;
                }
                this.m_sess.sendErrorResponseSMB(smbPkt, 5, 2);
            }
        }
        this.runRequestPostProcessors(this.m_sess);
        return handledOK;
    }
}

