/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.smb.server;

import java.io.IOException;
import org.filesys.debug.Debug;
import org.filesys.server.filesys.AccessDeniedException;
import org.filesys.server.filesys.DeferFailedException;
import org.filesys.server.filesys.DeferredPacketException;
import org.filesys.server.filesys.DiskInterface;
import org.filesys.server.filesys.ExistingOpLockException;
import org.filesys.server.filesys.FileOpenParams;
import org.filesys.server.filesys.NetworkFile;
import org.filesys.server.filesys.TreeConnection;
import org.filesys.server.locking.LocalOpLockDetails;
import org.filesys.server.locking.OpLockDetails;
import org.filesys.server.locking.OpLockInterface;
import org.filesys.server.locking.OpLockManager;
import org.filesys.smb.OpLockType;
import org.filesys.smb.server.SMBSrvPacket;
import org.filesys.smb.server.SMBSrvSession;

public class OpLockHelper {
    public static final OpLockDetails grantOpLock(SMBSrvSession sess, SMBSrvPacket pkt, DiskInterface disk, TreeConnection tree, FileOpenParams params, NetworkFile netFile) {
        OpLockDetails oplock;
        block14: {
            if (netFile.isDirectory()) {
                return null;
            }
            oplock = null;
            if (disk instanceof OpLockInterface) {
                OpLockInterface oplockIface = (OpLockInterface)((Object)disk);
                if (!oplockIface.isOpLocksEnabled(sess, tree)) {
                    return null;
                }
                OpLockManager oplockMgr = oplockIface.getOpLockManager(sess, tree);
                if (oplockMgr != null) {
                    oplock = oplockMgr.getOpLockDetails(params.getPath());
                    if (oplock != null && oplock.getLockType() == OpLockType.LEVEL_II) {
                        return oplock;
                    }
                    OpLockType oplockTyp = params.requestedOplockType();
                    if (oplockTyp == OpLockType.LEVEL_NONE) {
                        return null;
                    }
                    oplock = params.hasOplockOwner() ? new LocalOpLockDetails(oplockTyp, params.getPath(), sess, params.getOplockOwner(), netFile.isDirectory()) : new LocalOpLockDetails(oplockTyp, params.getPath(), sess, pkt, netFile.isDirectory());
                    try {
                        if (oplockMgr.grantOpLock(params.getPath(), oplock, netFile)) {
                            netFile.setOpLock(oplock);
                            if (sess.hasDebug(0x4000000)) {
                                sess.debugPrintln("Granted oplock sess=" + sess.getUniqueId() + " oplock=" + oplock);
                            }
                            break block14;
                        }
                        if (sess.hasDebug(0x4000000)) {
                            sess.debugPrintln("Oplock not granted sess=" + sess.getUniqueId() + " oplock=" + oplock + " (Open count)");
                        }
                        oplock = null;
                    }
                    catch (ExistingOpLockException ex) {
                        if (sess.hasDebug(0x4000000)) {
                            sess.debugPrintln("Failed to grant oplock sess=" + sess.getUniqueId() + ", file=" + params.getPath() + " (Oplock exists)");
                        }
                        oplock = null;
                    }
                } else if (sess.hasDebug(0x4000000)) {
                    sess.debugPrintln("OpLock manager is null, tree=" + tree);
                }
            }
        }
        return oplock;
    }

    public static final void checkOpLock(SMBSrvSession sess, SMBSrvPacket pkt, DiskInterface disk, FileOpenParams params, TreeConnection tree) throws DeferredPacketException, AccessDeniedException {
        if (disk instanceof OpLockInterface) {
            OpLockInterface oplockIface = (OpLockInterface)((Object)disk);
            if (!oplockIface.isOpLocksEnabled(sess, tree)) {
                return;
            }
            OpLockManager oplockMgr = oplockIface.getOpLockManager(sess, tree);
            if (oplockMgr == null) {
                if (sess.hasDebug(0x4000000)) {
                    sess.debugPrintln("OpLock manager is null, tree=" + tree);
                }
                return;
            }
            OpLockDetails oplock = oplockMgr.getOpLockDetails(params.getFullPath());
            if (oplock != null && oplock.getLockType() != OpLockType.LEVEL_II) {
                if (sess.hasDebug(0x4000000)) {
                    sess.debugPrintln("Check oplock on file " + params.getPath() + ", oplock=" + oplock);
                }
                boolean deferredPkt = false;
                if (oplock instanceof LocalOpLockDetails) {
                    LocalOpLockDetails localOpLock = (LocalOpLockDetails)oplock;
                    SMBSrvSession opSess = localOpLock.getOwnerSession();
                    if (!opSess.isShutdown()) {
                        if ((params.getAccessMode() & 7) == 0 && (params.getAccessMode() & 0xE0000000) == 0) {
                            if (sess.hasDebug(0x4000000)) {
                                sess.debugPrintln("No oplock break, access attributes only, params=" + params + ", oplock=" + oplock);
                            }
                            return;
                        }
                        if (oplock.getLockType() == OpLockType.LEVEL_BATCH && params.requestBatchOpLock() && localOpLock.getOplockOwner().isOwner(OpLockType.LEVEL_BATCH, params.getOplockOwner())) {
                            if (sess.hasDebug(0x4000000)) {
                                sess.debugPrintln("No oplock break, oplock owner, params=" + params + ", oplock=" + oplock);
                            }
                            return;
                        }
                        if (oplock.hasOplockBreakFailed()) {
                            if (sess.hasDebug(0x4000000)) {
                                sess.debugPrintln("Oplock has failed break attempt, failing open request params=" + params);
                            }
                            throw new AccessDeniedException("Oplock has failed break");
                        }
                        try {
                            if (sess.hasDebug(0x4000000)) {
                                sess.debugPrintln("Oplock break required, owner=" + oplock + ", open=" + sess.getUniqueId());
                            }
                            oplockMgr.requestOpLockBreak(oplock.getPath(), oplock, sess, pkt);
                            deferredPkt = true;
                        }
                        catch (DeferFailedException ex) {
                            Debug.println("Failed to defer request for local oplock break, oplock=" + oplock, 1);
                            throw new AccessDeniedException("Oplock break defer failed");
                        }
                        catch (IOException ex) {
                            Debug.println("Failed to send local oplock break:", 1);
                            Debug.println(ex, 1);
                            throw new AccessDeniedException("Oplock break send failed");
                        }
                    } else {
                        oplockMgr.releaseOpLock(oplock.getPath());
                        if (sess.hasDebug(0x4000000)) {
                            sess.debugPrintln("Oplock released, session invalid sess=" + opSess.getUniqueId());
                        }
                    }
                } else if (oplock.isRemoteLock()) {
                    if ((params.getAccessMode() & 7) == 0 && (params.getAccessMode() & 0xE0000000) == 0) {
                        return;
                    }
                    if (oplock.hasOplockBreakFailed()) {
                        if (sess.hasDebug(0x4000000)) {
                            sess.debugPrintln("Oplock has failed break attempt, failing open request params=" + params);
                        }
                        throw new AccessDeniedException("Oplock has failed break");
                    }
                    try {
                        oplockMgr.requestOpLockBreak(oplock.getPath(), oplock, sess, pkt);
                        if (sess.hasDebug(0x4000000)) {
                            sess.debugPrintln("Remote oplock break sent, oplock=" + oplock);
                        }
                        deferredPkt = true;
                    }
                    catch (DeferFailedException ex) {
                        Debug.println("Failed to defer request for remote oplock break, oplock=" + oplock, 1);
                        throw new AccessDeniedException("Oplock break defer failed");
                    }
                    catch (IOException ex) {
                        Debug.println("Failed to send remote oplock break:", 1);
                        Debug.println(ex, 1);
                        throw new AccessDeniedException("Oplock break send failed");
                    }
                }
                if (deferredPkt) {
                    throw new DeferredPacketException("Waiting for oplock break");
                }
            }
        }
    }

    public static final void releaseOpLock(SMBSrvSession sess, SMBSrvPacket pkt, DiskInterface disk, TreeConnection tree, NetworkFile netFile) {
        OpLockDetails oplock;
        OpLockInterface oplockIface;
        OpLockManager oplockMgr;
        if (disk instanceof OpLockInterface && (oplockMgr = (oplockIface = (OpLockInterface)((Object)disk)).getOpLockManager(sess, tree)) != null && (oplock = netFile.getOpLock()) != null) {
            oplockMgr.releaseOpLock(oplock.getPath());
            netFile.setOpLock(null);
            if (sess.hasDebug(0x4000000)) {
                sess.debugPrintln("Released oplock sess=" + sess.getUniqueId() + " oplock=" + oplock);
            }
        }
    }
}

