/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.smb.server;

import org.filesys.server.filesys.FileInfo;
import org.filesys.server.filesys.UnsupportedInfoLevelException;
import org.filesys.smb.Compression;
import org.filesys.smb.NTTime;
import org.filesys.smb.SMBDate;
import org.filesys.smb.server.ntfs.StreamInfo;
import org.filesys.smb.server.ntfs.StreamInfoList;
import org.filesys.util.DataBuffer;

public class QueryInfoPacker {
    private static final int PathStandardLen = 36;
    private static final int PathQueryEASizeLen = 36;
    private static final int PathAllEAsLen = 4;
    private static final int PathFileBasicLen = 40;
    private static final int PathFileStandardLen = 24;
    private static final int PathFileEAInfoLen = 4;
    private static final int PathFileNameLen = 4;
    private static final int PathFileAllLen = 100;
    private static final int PathFileStreamLen = 38;
    private static final int PathFileCompressionLen = 12;
    private static final int NTFileInternalLen = 8;
    private static final int NTFilePositionLen = 8;
    private static final int NTAttributeTagLen = 16;
    private static final int NTNetworkOpenLen = 56;

    public static final int packInfo(FileInfo info, DataBuffer buf, int infoLevel, boolean uni) throws UnsupportedInfoLevelException {
        int startPos = buf.getPosition();
        switch (infoLevel) {
            case 1: {
                QueryInfoPacker.packInfoStandard(info, buf, false, uni);
                break;
            }
            case 2: {
                QueryInfoPacker.packInfoStandard(info, buf, true, uni);
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                QueryInfoPacker.packAllEAsInfo(info, buf);
                break;
            }
            case 6: {
                break;
            }
            case 257: 
            case 1004: {
                QueryInfoPacker.packBasicFileInfo(info, buf);
                break;
            }
            case 258: 
            case 1005: {
                QueryInfoPacker.packStandardFileInfo(info, buf);
                break;
            }
            case 259: 
            case 1007: {
                QueryInfoPacker.packEAFileInfo(info, buf);
                break;
            }
            case 260: 
            case 1009: 
            case 1048: {
                QueryInfoPacker.packNameFileInfo(info, buf, uni);
                break;
            }
            case 263: 
            case 1018: {
                QueryInfoPacker.packAllFileInfo(info, buf, uni);
                break;
            }
            case 264: 
            case 1021: {
                QueryInfoPacker.packAlternateNameFileInfo(info, buf);
                break;
            }
            case 265: 
            case 1022: {
                QueryInfoPacker.packStreamFileInfo(info, buf, uni);
                break;
            }
            case 267: 
            case 1028: {
                QueryInfoPacker.packCompressionFileInfo(info, buf);
                break;
            }
            case 1006: {
                QueryInfoPacker.packFileInternalInfo(info, buf);
                break;
            }
            case 1014: {
                QueryInfoPacker.packFilePositionInfo(info, buf);
                break;
            }
            case 1035: {
                QueryInfoPacker.packFileAttributeTagInfo(info, buf);
                break;
            }
            case 1034: {
                QueryInfoPacker.packFileNetworkOpenInfo(info, buf);
                break;
            }
            default: {
                throw new UnsupportedInfoLevelException("" + infoLevel);
            }
        }
        return buf.getPosition() - startPos;
    }

    private static void packInfoStandard(FileInfo info, DataBuffer buf, boolean eaFlag, boolean uni) {
        SMBDate dateTime = new SMBDate(0);
        if (info.hasCreationDateTime()) {
            dateTime.setTime(info.getCreationDateTime());
            buf.putShort(dateTime.asSMBDate());
            buf.putShort(dateTime.asSMBTime());
        } else {
            buf.putZeros(4);
        }
        if (info.hasAccessDateTime()) {
            dateTime.setTime(info.getAccessDateTime());
            buf.putShort(dateTime.asSMBDate());
            buf.putShort(dateTime.asSMBTime());
        } else {
            buf.putZeros(4);
        }
        if (info.hasModifyDateTime()) {
            dateTime.setTime(info.getModifyDateTime());
            buf.putShort(dateTime.asSMBDate());
            buf.putShort(dateTime.asSMBTime());
        } else {
            buf.putZeros(4);
        }
        buf.putInt(info.getSizeInt());
        if (info.getAllocationSize() < info.getSize()) {
            buf.putInt(info.getSizeInt());
        } else {
            buf.putInt(info.getAllocationSizeInt());
        }
        buf.putShort(info.getFileAttributes());
        if (eaFlag) {
            buf.putInt(0);
        }
    }

    private static void packBasicFileInfo(FileInfo info, DataBuffer buf) {
        if (info.hasCreationDateTime()) {
            buf.putLong(NTTime.toNTTime(info.getCreationDateTime()));
        } else {
            buf.putZeros(8);
        }
        if (info.hasAccessDateTime()) {
            buf.putLong(NTTime.toNTTime(info.getAccessDateTime()));
        } else if (info.hasModifyDateTime()) {
            buf.putLong(NTTime.toNTTime(info.getModifyDateTime()));
        } else {
            buf.putZeros(8);
        }
        if (info.hasModifyDateTime()) {
            long ntTime = NTTime.toNTTime(info.getModifyDateTime());
            buf.putLong(ntTime);
            buf.putLong(ntTime);
        } else {
            buf.putZeros(16);
        }
        buf.putInt(info.getFileAttributes());
        buf.putZeros(4);
    }

    private static void packStandardFileInfo(FileInfo info, DataBuffer buf) {
        if (info.getAllocationSize() < info.getSize()) {
            buf.putLong(info.getSize());
        } else {
            buf.putLong(info.getAllocationSize());
        }
        buf.putLong(info.getSize());
        buf.putInt(1);
        buf.putByte(info.hasDeleteOnClose() ? 1 : 0);
        buf.putByte(info.isDirectory() ? 1 : 0);
        buf.putZeros(2);
    }

    private static void packEAFileInfo(FileInfo info, DataBuffer buf) {
        buf.putInt(0);
    }

    private static void packNameFileInfo(FileInfo info, DataBuffer buf, boolean uni) {
        int nameLen = info.getFileNameLength();
        if (uni) {
            nameLen *= 2;
        }
        buf.putInt(nameLen);
        if (nameLen > 0) {
            buf.putString(info.getFileName(), uni, false);
        }
    }

    private static void packAllFileInfo(FileInfo info, DataBuffer buf, boolean uni) {
        if (info.hasCreationDateTime()) {
            buf.putLong(NTTime.toNTTime(info.getCreationDateTime()));
        } else {
            buf.putZeros(8);
        }
        if (info.hasAccessDateTime()) {
            buf.putLong(NTTime.toNTTime(info.getAccessDateTime()));
        } else {
            buf.putZeros(8);
        }
        if (info.hasModifyDateTime()) {
            long ntTime = NTTime.toNTTime(info.getModifyDateTime());
            buf.putLong(ntTime);
            buf.putLong(ntTime);
        } else {
            buf.putZeros(16);
        }
        buf.putInt(info.getFileAttributes());
        buf.putInt(0);
        if (info.getAllocationSize() < info.getSize()) {
            buf.putLong(info.getSize());
        } else {
            buf.putLong(info.getAllocationSize());
        }
        buf.putLong(info.getSize());
        buf.putInt(1);
        buf.putByte(info.hasDeleteOnClose() ? 1 : 0);
        buf.putByte(info.isDirectory() ? 1 : 0);
        buf.putShort(0);
        buf.putLong(info.getFileIdLong());
        buf.putInt(0);
        buf.putInt(0x1F01FF);
        buf.putLong(0L);
        if (info.hasDeleteOnClose()) {
            buf.putInt(4096);
        } else {
            buf.putInt(0);
        }
        buf.putInt(0);
        int nameLen = info.getFileNameLength();
        if (uni) {
            nameLen *= 2;
        }
        buf.putInt(nameLen);
        if (nameLen > 0) {
            buf.putString(info.getFileName(), uni, false);
        }
    }

    private static void packAlternateNameFileInfo(FileInfo info, DataBuffer buf) {
    }

    private static void packStreamFileInfo(FileInfo info, DataBuffer buf, boolean uni) {
        String streamName = "::$DATA";
        buf.putInt(0);
        int nameLen = streamName.length();
        if (uni) {
            nameLen *= 2;
        }
        buf.putInt(nameLen);
        buf.putLong(info.getSize());
        if (info.getAllocationSize() < info.getSize()) {
            buf.putLong(info.getSize());
        } else {
            buf.putLong(info.getAllocationSize());
        }
        buf.putString(streamName, uni, false);
    }

    public static int packStreamFileInfo(StreamInfoList streams, DataBuffer buf, boolean uni) {
        int curPos;
        int startPos = curPos = buf.getPosition();
        int pos = 0;
        for (int i = 0; i < streams.numberOfStreams(); ++i) {
            StreamInfo sinfo = streams.getStreamAt(i);
            buf.putInt(0);
            String sName = sinfo.getName();
            if (!sName.endsWith(":$DATA")) {
                sName = sName + ":$DATA";
            }
            int nameLen = sName.length();
            if (uni) {
                nameLen *= 2;
            }
            buf.putInt(nameLen);
            buf.putLong(sinfo.getSize());
            if (sinfo.getAllocationSize() < sinfo.getSize()) {
                buf.putLong(sinfo.getSize());
            } else {
                buf.putLong(sinfo.getAllocationSize());
            }
            buf.putString(sName, uni, false);
            buf.longwordAlign();
            if (i >= streams.numberOfStreams() - 1) continue;
            pos = buf.getPosition();
            buf.setPosition(startPos);
            buf.putInt(pos - startPos);
            buf.setPosition(pos);
            startPos = pos;
        }
        return buf.getPosition() - curPos;
    }

    private static void packCompressionFileInfo(FileInfo info, DataBuffer buf) {
        buf.putLong(info.getSize());
        buf.putInt(Compression.None.ordinal());
    }

    private static void packFileInternalInfo(FileInfo info, DataBuffer buf) {
        buf.putInt(1);
        buf.putInt(0);
    }

    private static void packFilePositionInfo(FileInfo info, DataBuffer buf) {
        buf.putInt(0);
        buf.putInt(0);
    }

    private static void packFileNetworkOpenInfo(FileInfo info, DataBuffer buf) {
        if (info.hasCreationDateTime()) {
            buf.putLong(NTTime.toNTTime(info.getCreationDateTime()));
        } else {
            buf.putZeros(8);
        }
        if (info.hasAccessDateTime()) {
            buf.putLong(NTTime.toNTTime(info.getAccessDateTime()));
        } else if (info.hasModifyDateTime()) {
            buf.putLong(NTTime.toNTTime(info.getModifyDateTime()));
        } else {
            buf.putZeros(8);
        }
        if (info.hasModifyDateTime()) {
            long ntTime = NTTime.toNTTime(info.getModifyDateTime());
            buf.putLong(ntTime);
            buf.putLong(ntTime);
        } else {
            buf.putZeros(16);
        }
        if (info.getAllocationSize() < info.getSize()) {
            buf.putLong(info.getSize());
        } else {
            buf.putLong(info.getAllocationSize());
        }
        buf.putLong(info.getSize());
        buf.putInt(info.getFileAttributes());
        buf.putInt(0);
    }

    private static void packFileAttributeTagInfo(FileInfo info, DataBuffer buf) {
        buf.putInt(info.getFileAttributes());
        buf.putInt(0);
    }

    private static void packAllEAsInfo(FileInfo info, DataBuffer buf) {
        buf.putInt(4);
    }

    public static final int calculateInformationSize(FileInfo info, int infoLevel, boolean uni) {
        int infoLen = 0;
        switch (infoLevel) {
            case 1: {
                infoLen = 36;
                break;
            }
            case 2: {
                infoLen = 36;
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                infoLen = 4;
                break;
            }
            case 6: {
                break;
            }
            case 257: 
            case 1004: {
                infoLen = 40;
                break;
            }
            case 258: 
            case 1005: {
                infoLen = 24;
                break;
            }
            case 259: 
            case 1007: {
                infoLen = 4;
                break;
            }
            case 260: 
            case 1009: 
            case 1048: {
                infoLen = 4;
                infoLen += (info.getFileNameLength() + 1) * (uni ? 2 : 1);
                break;
            }
            case 263: 
            case 1018: {
                infoLen = 100;
                infoLen += (info.getFileNameLength() + 1) * (uni ? 2 : 1);
                break;
            }
            case 264: 
            case 1021: {
                break;
            }
            case 265: 
            case 1022: {
                infoLen = 38;
                break;
            }
            case 267: 
            case 1028: {
                infoLen = 12;
                break;
            }
            case 1006: {
                infoLen = 8;
                break;
            }
            case 1014: {
                infoLen = 8;
                break;
            }
            case 1035: {
                infoLen = 16;
                break;
            }
            case 1034: {
                infoLen = 56;
                break;
            }
        }
        return infoLen;
    }
}

