/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.smb.server;

import org.filesys.server.auth.AuthenticatorException;
import org.filesys.server.filesys.postprocess.PostRequestProcessor;
import org.filesys.server.locking.OpLockDetailsAdapter;
import org.filesys.smb.dcerpc.UUID;
import org.filesys.smb.server.NegotiateContext;
import org.filesys.smb.server.ProtocolHandler;
import org.filesys.smb.server.SMBServer;
import org.filesys.smb.server.SMBSrvException;
import org.filesys.smb.server.SMBSrvPacket;
import org.filesys.smb.server.SMBSrvSession;
import org.filesys.smb.server.SessionState;
import org.filesys.util.DataPacker;

public abstract class SMBParser {
    protected byte[] m_smbbuf;
    protected int m_pos;
    protected int m_endpos;
    protected int m_reqOffset;
    protected PostRequestProcessor m_postProcess;

    public SMBParser(byte[] buf, int len) {
        this.resetParser(buf, len);
    }

    public void resetParser(byte[] buffer, int len) {
        this.m_smbbuf = buffer;
        this.m_pos = 0;
        this.m_endpos = len;
    }

    public final int getRemainingLength() {
        return this.m_smbbuf.length - (this.m_pos + this.m_reqOffset);
    }

    public final void packByte(byte val) {
        this.m_smbbuf[this.m_reqOffset + this.m_pos++] = val;
    }

    public final void packByte(int val) {
        this.m_smbbuf[this.m_reqOffset + this.m_pos++] = (byte)val;
    }

    public final void packBytes(byte[] byts, int len) {
        if (this.m_reqOffset + this.m_pos + len > this.m_smbbuf.length) {
            throw new ArrayIndexOutOfBoundsException("buflen=" + this.m_smbbuf.length);
        }
        System.arraycopy(byts, 0, this.m_smbbuf, this.m_reqOffset + this.m_pos, len);
        this.m_pos += len;
    }

    public final void packBytes(byte[] byts) {
        if (this.m_reqOffset + this.m_pos + byts.length > this.m_smbbuf.length) {
            throw new ArrayIndexOutOfBoundsException("buflen=" + this.m_smbbuf.length);
        }
        System.arraycopy(byts, 0, this.m_smbbuf, this.m_reqOffset + this.m_pos, byts.length);
        this.m_pos += byts.length;
    }

    public final void packString(String str, boolean uni) {
        if (uni) {
            this.m_pos = DataPacker.wordAlign(this.m_pos);
            DataPacker.putUnicodeString(str, this.m_smbbuf, this.m_reqOffset + this.m_pos, true);
            this.m_pos += str.length() * 2 + 2;
        } else {
            DataPacker.putString(str, this.m_smbbuf, this.m_reqOffset + this.m_pos, true);
            this.m_pos += str.length() + 1;
        }
    }

    public final void packString(String str, boolean uni, boolean nul) {
        if (uni) {
            this.m_pos = DataPacker.wordAlign(this.m_pos);
            DataPacker.putUnicodeString(str, this.m_smbbuf, this.m_reqOffset + this.m_pos, nul);
            this.m_pos += str.length() * 2;
            if (nul) {
                this.m_pos += 2;
            }
        } else {
            DataPacker.putString(str, this.m_smbbuf, this.m_reqOffset + this.m_pos, nul);
            this.m_pos += str.length();
            if (nul) {
                ++this.m_pos;
            }
        }
    }

    public final int packStringAt(int pos, String str, boolean uni, boolean nul) {
        if (uni) {
            return DataPacker.putUnicodeString(str, this.m_smbbuf, pos, nul);
        }
        return DataPacker.putString(str, this.m_smbbuf, pos, nul);
    }

    public final void packWord(int val) {
        DataPacker.putIntelShort(val, this.m_smbbuf, this.m_reqOffset + this.m_pos);
        this.m_pos += 2;
    }

    public final void packInt(int val) {
        DataPacker.putIntelInt(val, this.m_smbbuf, this.m_reqOffset + this.m_pos);
        this.m_pos += 4;
    }

    public final void packLong(long val) {
        DataPacker.putIntelLong(val, this.m_smbbuf, this.m_reqOffset + this.m_pos);
        this.m_pos += 8;
    }

    public final void packWordAt(int pos, int val) {
        DataPacker.putIntelShort(val, this.m_smbbuf, this.m_reqOffset + pos);
    }

    public final void packIntAt(int pos, int val) {
        DataPacker.putIntelInt(val, this.m_smbbuf, this.m_reqOffset + pos);
    }

    public final void packLongAt(int pos, long val) {
        DataPacker.putIntelLong(val, this.m_smbbuf, this.m_reqOffset + pos);
    }

    public final void packZeroes(int cnt) {
        DataPacker.putZeros(this.m_smbbuf, this.m_reqOffset + this.m_pos, cnt);
        this.m_pos += cnt;
    }

    public final int getPosition() {
        return this.m_pos;
    }

    public final int getOffset() {
        return this.m_reqOffset;
    }

    public final int getReceivedLength() {
        return this.m_endpos;
    }

    public final void setOffset(int offset) {
        this.m_reqOffset = offset;
    }

    public void setPosition(int pos) {
        this.m_pos = pos;
    }

    public final int unpackByte() {
        return this.m_smbbuf[this.m_reqOffset + this.m_pos++];
    }

    public final byte[] unpackBytes(int len) {
        if (len <= 0) {
            return null;
        }
        byte[] buf = new byte[len];
        System.arraycopy(this.m_smbbuf, this.m_reqOffset + this.m_pos, buf, 0, len);
        this.m_pos += len;
        return buf;
    }

    public final int unpackWord() {
        int val = DataPacker.getIntelShort(this.m_smbbuf, this.m_reqOffset + this.m_pos);
        this.m_pos += 2;
        return val;
    }

    public final int unpackInt() {
        int val = DataPacker.getIntelInt(this.m_smbbuf, this.m_reqOffset + this.m_pos);
        this.m_pos += 4;
        return val;
    }

    public final long unpackLong() {
        long val = DataPacker.getIntelLong(this.m_smbbuf, this.m_reqOffset + this.m_pos);
        this.m_pos += 8;
        return val;
    }

    public final String unpackString(boolean uni) {
        String ret = null;
        if (uni) {
            this.m_pos = DataPacker.wordAlign(this.m_pos);
            ret = DataPacker.getUnicodeString(this.m_smbbuf, this.m_reqOffset + this.m_pos, this.m_smbbuf.length - this.m_pos);
            if (ret != null) {
                this.m_pos += ret.length() * 2 + 2;
            }
        } else {
            ret = DataPacker.getString(this.m_smbbuf, this.m_reqOffset + this.m_pos, this.m_smbbuf.length - this.m_pos);
            if (ret != null) {
                this.m_pos += ret.length() + 1;
            }
        }
        return ret;
    }

    public final String unpackStringWithLength(int len, boolean uni) {
        String ret = null;
        if (uni) {
            ret = DataPacker.getUnicodeString(this.m_smbbuf, this.m_reqOffset + this.m_pos, len);
            this.m_pos += ret.length() * 2;
        } else {
            ret = DataPacker.getString(this.m_smbbuf, this.m_reqOffset + this.m_pos, len);
            this.m_pos += ret.length();
        }
        return ret;
    }

    public final String unpackStringAt(int offset, boolean uni) {
        String ret = null;
        ret = uni ? DataPacker.getUnicodeString(this.m_smbbuf, offset, this.m_smbbuf.length - offset) : DataPacker.getString(this.m_smbbuf, offset, this.m_smbbuf.length - offset);
        return ret;
    }

    public final String unpackStringAt(int offset, int len, boolean uni) {
        String ret = null;
        ret = uni ? DataPacker.getUnicodeString(this.m_smbbuf, this.m_reqOffset + offset, len) : DataPacker.getString(this.m_smbbuf, this.m_reqOffset + offset, len);
        return ret;
    }

    public final UUID unpackUUID() {
        UUID uuid = new UUID(this.m_smbbuf, this.m_reqOffset + this.m_pos);
        this.m_pos += 16;
        return uuid;
    }

    public final boolean hasMoreData() {
        return this.m_pos < this.m_endpos;
    }

    public final void skipBytes(int cnt) {
        this.m_pos += cnt;
    }

    public final void skipByte() {
        ++this.m_pos;
    }

    public final void skipWord() {
        this.m_pos += 2;
    }

    public final void skipInt() {
        this.m_pos += 4;
    }

    public final void skipLong() {
        this.m_pos += 8;
    }

    public final byte[] getBuffer() {
        return this.m_smbbuf;
    }

    public final void setBuffer(byte[] buf, int len) {
        this.m_smbbuf = buf;
        this.m_endpos = len;
    }

    public final boolean hasPostProcessor() {
        return this.m_postProcess != null;
    }

    public final PostRequestProcessor getPostProcessor() {
        return this.m_postProcess;
    }

    public final void setPostProcessor(PostRequestProcessor postProcessor) {
        this.m_postProcess = postProcessor;
    }

    public abstract boolean checkPacketIsValid(int var1, int var2);

    public abstract void dumpPacket(boolean var1, boolean var2);

    public abstract String getName();

    public abstract SMBSrvPacket.Version isType();

    public abstract int getLength();

    public abstract void packSuccessRespone();

    public abstract void setResponse();

    public abstract String toShortString();

    public abstract boolean isLongErrorCode();

    public abstract int getErrorClass();

    public abstract int getErrorCode();

    public abstract SessionState nextStateForDialect(int var1);

    public abstract void buildErrorResponse(int var1, int var2, ProtocolHandler var3);

    public abstract NegotiateContext parseNegotiateRequest(SMBSrvSession var1) throws SMBSrvException;

    public abstract void packNegotiateResponse(SMBServer var1, SMBSrvSession var2, SMBSrvPacket var3, int var4, NegotiateContext var5) throws AuthenticatorException, SMBSrvException;

    public abstract void setOplockOwner(SMBSrvSession var1, OpLockDetailsAdapter var2);

    public void responsePreSend(SMBSrvSession sess, SMBSrvPacket smbPkt) {
    }
}

