/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.smb.server;

import org.filesys.smb.SMBErrorText;
import org.filesys.smb.server.SMBSrvPacket;

public class SMBSrvException
extends Exception {
    protected int m_errorclass;
    protected int m_errorcode;
    protected int m_NTerror = -1;

    public SMBSrvException(int errclass, int errcode) {
        super(SMBErrorText.ErrorString(errclass, errcode));
        this.m_errorclass = errclass;
        this.m_errorcode = errcode;
    }

    public SMBSrvException(int errclass, int errcode, String msg) {
        super(msg);
        this.m_errorclass = errclass;
        this.m_errorcode = errcode;
    }

    protected SMBSrvException(SMBSrvPacket pkt) {
        super(SMBErrorText.ErrorString(pkt.getParser().getErrorClass(), pkt.getParser().getErrorCode()));
        this.m_errorclass = pkt.getParser().getErrorClass();
        this.m_errorcode = pkt.getParser().getErrorCode();
    }

    public SMBSrvException(int nterror, int errclass, int errcode) {
        super(SMBErrorText.ErrorString(errclass, errcode));
        this.m_errorclass = errclass;
        this.m_errorcode = errcode;
        this.m_NTerror = nterror;
    }

    public SMBSrvException(int ntError) {
        super(SMBErrorText.ErrorString(6, ntError));
        this.m_NTerror = ntError;
        this.m_errorclass = 5;
        this.m_errorcode = 10;
    }

    public int getErrorClass() {
        return this.m_errorclass;
    }

    public int getErrorCode() {
        return this.m_errorcode;
    }

    public final boolean hasNTErrorCode() {
        return this.m_NTerror != -1;
    }

    public int getNTErrorCode() {
        return this.m_NTerror;
    }

    public String getErrorText() {
        if (this.getNTErrorCode() != 0) {
            return SMBErrorText.ErrorString(6, this.getNTErrorCode());
        }
        return SMBErrorText.ErrorString(this.m_errorclass, this.m_errorcode);
    }
}

