/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.smb.server;

import java.util.ArrayList;
import java.util.List;
import org.filesys.smb.server.SMBSrvPacket;

public class SMBSrvPacketQueue {
    private List<QueuedSMBPacket> m_pktQueue = new ArrayList<QueuedSMBPacket>();

    public final synchronized void addToQueue(SMBSrvPacket pkt, int offset, int len, boolean writeRaw) {
        pkt.setQueuedForAsyncIO(true);
        this.m_pktQueue.add(new QueuedSMBPacket(pkt, offset, len, writeRaw));
    }

    public final synchronized QueuedSMBPacket removeFromQueue() {
        return this.m_pktQueue.remove(0);
    }

    public final synchronized QueuedSMBPacket getHeadOfQueue() {
        return this.m_pktQueue.get(0);
    }

    public final synchronized int numberOfPackets() {
        return this.m_pktQueue.size();
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("[QueueLen=");
        str.append(this.numberOfPackets());
        str.append(":");
        if (this.numberOfPackets() > 0) {
            int idx = 0;
            while (idx < 5 && idx < this.m_pktQueue.size()) {
                str.append(idx);
                str.append("=");
                SMBSrvPacket srvPkt = this.m_pktQueue.get(idx).getPacket();
                str.append(srvPkt.getParser().toShortString());
                str.append(",");
            }
        }
        str.append("]");
        return str.toString();
    }

    public class QueuedSMBPacket {
        private SMBSrvPacket m_pkt;
        private int m_offset;
        private int m_len;
        private boolean m_writeRaw;

        public QueuedSMBPacket(SMBSrvPacket pkt, int offset, int len, boolean writeRaw) {
            this.m_pkt = pkt;
            this.m_offset = offset;
            this.m_len = len;
            this.m_writeRaw = writeRaw;
        }

        public final SMBSrvPacket getPacket() {
            return this.m_pkt;
        }

        public final int getWriteOffset() {
            return this.m_offset;
        }

        public final int getWriteLength() {
            return this.m_len;
        }

        public final boolean hasWriteRaw() {
            return this.m_writeRaw;
        }

        public final void updateSettings(int offset, int len) {
            this.m_offset = offset;
            this.m_len = len;
        }
    }
}

