/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.smb.server;

import org.filesys.debug.Debug;
import org.filesys.server.thread.ThreadRequest;
import org.filesys.smb.server.SMBSrvPacket;
import org.filesys.smb.server.SMBSrvSession;

public class SMBThreadRequest
implements ThreadRequest {
    private SMBSrvSession m_sess;
    private SMBSrvPacket m_smbPkt;

    public SMBThreadRequest(SMBSrvSession sess, SMBSrvPacket smbPkt) {
        this.m_sess = sess;
        this.m_smbPkt = smbPkt;
    }

    @Override
    public void runRequest() {
        if (!this.m_sess.isShutdown()) {
            this.m_sess.processPacket(this.m_smbPkt);
            int asyncCnt = this.m_sess.sendQueuedAsyncResponses();
            if (asyncCnt > 0 && this.m_sess.hasDebug(0x200000)) {
                Debug.println("Sent queued async packets count=" + asyncCnt + ", sess=" + this.m_sess.getUniqueId());
            }
        } else {
            this.m_sess.getPacketPool().releasePacket(this.m_smbPkt);
        }
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("[SMB Sess=");
        str.append(this.m_sess.getUniqueId());
        str.append(", pkt=");
        str.append(this.m_smbPkt.toString());
        str.append("]");
        return str.toString();
    }
}

