/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.smb.server;

import org.filesys.server.locking.OplockOwner;
import org.filesys.smb.OpLockType;

public class SMBV1OplockOwner
implements OplockOwner {
    private int m_treeId;
    private int m_userId;
    private int m_processId;
    private int m_fileId;

    public SMBV1OplockOwner(int treeId, int procId, int userId) {
        this.m_treeId = treeId;
        this.m_processId = procId;
        this.m_userId = userId;
        this.m_fileId = -1;
    }

    public final int getTreeId() {
        return this.m_treeId;
    }

    public final int getProcessId() {
        return this.m_processId;
    }

    public final int getUserId() {
        return this.m_userId;
    }

    public final int getFileId() {
        return this.m_fileId;
    }

    public final void setFileId(int fileId) {
        this.m_fileId = fileId;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof SMBV1OplockOwner)) {
            return false;
        }
        SMBV1OplockOwner v1Owner = (SMBV1OplockOwner)obj;
        return this.getTreeId() == v1Owner.getTreeId() && this.getUserId() == v1Owner.getUserId() && this.getProcessId() == v1Owner.getProcessId() && this.getFileId() == v1Owner.getFileId();
    }

    @Override
    public boolean isOwner(OpLockType opType, OplockOwner opOwner) {
        if (opOwner == null || !(opOwner instanceof SMBV1OplockOwner)) {
            return false;
        }
        SMBV1OplockOwner v1Owner = (SMBV1OplockOwner)opOwner;
        if (opType == OpLockType.LEVEL_BATCH) {
            return this.getTreeId() == v1Owner.getTreeId() && this.getUserId() == v1Owner.getUserId() && this.getProcessId() == v1Owner.getProcessId();
        }
        return this.getTreeId() == v1Owner.getTreeId() && this.getUserId() == v1Owner.getUserId() && this.getProcessId() == v1Owner.getProcessId() && this.getFileId() == v1Owner.getFileId();
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("[SMB V1 tree=");
        str.append(this.getTreeId());
        str.append(", pid=");
        str.append(this.getProcessId());
        str.append(", user=");
        str.append(this.getUserId());
        str.append(", fid=");
        str.append(this.getFileId());
        str.append("]");
        return str.toString();
    }
}

