/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.smb.server;

import org.filesys.smb.TransactBuffer;
import org.filesys.smb.server.SMBSrvTransPacket;
import org.filesys.smb.server.SMBV1Parser;
import org.filesys.util.DataBuffer;
import org.filesys.util.DataPacker;

class SrvTransactBuffer
extends TransactBuffer {
    public SrvTransactBuffer(int slen, int plen, int dlen) {
        super(slen, plen, dlen);
    }

    public SrvTransactBuffer(SMBV1Parser parser) {
        super(0, 0, 0);
        int dlen;
        int plen;
        this.setTreeId(parser.getTreeId());
        int slen = parser.getSetupCount() * 2;
        if (slen > 0) {
            this.m_setupBuf = new DataBuffer(parser.getBuffer(), parser.getSetupOffset(), slen);
        }
        if ((plen = parser.getTotalParameterCount()) > 0) {
            this.m_paramBuf = new DataBuffer(parser.getBuffer(), parser.getParameterBlockOffset(), plen);
        }
        if ((dlen = parser.getDataBlockCount()) > 0) {
            this.m_dataBuf = new DataBuffer(parser.getBuffer(), parser.getDataBlockOffset(), dlen);
        }
        this.setType(parser.getCommand());
        this.setFunction(parser.getNTFunction());
        this.setReturnParameterLimit(parser.getMaximumParameterReturn());
        this.setReturnDataLimit(parser.getMaximumDataReturn());
        this.setUnicode(parser.isUnicode());
        this.m_multi = false;
    }

    public SrvTransactBuffer(SrvTransactBuffer tbuf) {
        super(tbuf.getReturnSetupLimit(), tbuf.getReturnParameterLimit(), tbuf.getReturnDataLimit());
        this.setReturnLimits(tbuf.getReturnSetupLimit(), tbuf.getReturnParameterLimit(), tbuf.getReturnDataLimit());
        this.setType(tbuf.isType());
        this.setTreeId(tbuf.getTreeId());
    }

    public SrvTransactBuffer(SMBSrvTransPacket tpkt) {
        super(0, 0, 0);
        int dlen;
        int plen;
        SMBV1Parser parser = (SMBV1Parser)tpkt.getParser();
        this.setTreeId(parser.getTreeId());
        int slen = tpkt.getSetupCount() * 2;
        if (slen > 0) {
            this.m_setupBuf = new DataBuffer(tpkt.getBuffer(), tpkt.getSetupOffset(), slen);
        }
        if ((plen = tpkt.getTotalParameterCount()) > 0) {
            this.m_paramBuf = new DataBuffer(tpkt.getBuffer(), tpkt.getRxParameterBlock(), plen);
        }
        if ((dlen = tpkt.getRxDataBlockLength()) > 0) {
            this.m_dataBuf = new DataBuffer(tpkt.getBuffer(), tpkt.getRxDataBlock(), dlen);
        }
        this.setType(parser.getCommand());
        if (tpkt.getSetupCount() > 0) {
            this.setFunction(tpkt.getSetupParameter(0));
        }
        this.setUnicode(parser.isUnicode());
        if (this.isType() == 37) {
            int pos = parser.getByteOffset();
            byte[] buf = tpkt.getBuffer();
            if (this.isUnicode()) {
                pos = DataPacker.wordAlign(pos);
            }
            this.setName(DataPacker.getString(buf, pos, 64, this.isUnicode()));
        } else {
            this.setName("");
        }
        this.m_multi = false;
    }
}

