/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.smb.server;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.filesys.debug.Debug;
import org.filesys.server.SessionHandlerInterface;
import org.filesys.server.SessionHandlerList;
import org.filesys.server.SocketSessionHandler;
import org.filesys.server.config.InvalidConfigurationException;
import org.filesys.smb.mailslot.HostAnnouncer;
import org.filesys.smb.mailslot.TcpipNetBIOSHostAnnouncer;
import org.filesys.smb.server.NetBIOSSessionSocketHandler;
import org.filesys.smb.server.SMBChildConnectionHandler;
import org.filesys.smb.server.SMBConfigSection;
import org.filesys.smb.server.SMBConnectionsHandler;
import org.filesys.smb.server.SMBServer;
import org.filesys.smb.server.TcpipSMBSessionSocketHandler;
import org.filesys.util.PlatformType;

public class ThreadedSMBConnectionsHandler
implements SMBConnectionsHandler {
    private SessionHandlerList m_handlerList = new SessionHandlerList();
    private List<HostAnnouncer> m_hostAnnouncers = new ArrayList<HostAnnouncer>();
    private SMBServer m_server;
    private boolean m_debug;

    @Override
    public final boolean hasDebug() {
        return this.m_debug;
    }

    @Override
    public void initializeHandler(SMBServer srv, SMBConfigSection config) throws InvalidConfigurationException {
        SocketSessionHandler sessHandler;
        block22: {
            this.m_server = srv;
            if ((config.getSessionDebugFlags() & 0x200000) != 0) {
                this.m_debug = true;
            }
            if (config.hasNetBIOSSMB()) {
                sessHandler = new NetBIOSSessionSocketHandler(srv, config.getSessionPort(), config.getSMBBindAddress(), this.hasDebug());
                sessHandler.setSocketTimeout(config.getSocketTimeout());
                try {
                    sessHandler.initializeSessionHandler(srv);
                    this.m_handlerList.addHandler(sessHandler);
                    if (this.hasDebug()) {
                        Debug.println("[SMB] TCP NetBIOS session handler created");
                    }
                    if (!config.hasEnableAnnouncer()) break block22;
                    TcpipNetBIOSHostAnnouncer announcer = new TcpipNetBIOSHostAnnouncer();
                    announcer.addHostName(config.getServerName());
                    announcer.setDomain(config.getDomainName());
                    announcer.setComment(config.getComment());
                    announcer.setBindAddress(config.getSMBBindAddress());
                    if (config.getHostAnnouncerPort() != 0) {
                        announcer.setPort(config.getHostAnnouncerPort());
                    }
                    if (config.hasAliasNames()) {
                        announcer.addHostNames(config.getAliasNames());
                    }
                    if (config.getHostAnnounceInterval() > 0) {
                        announcer.setInterval(config.getHostAnnounceInterval());
                    }
                    try {
                        announcer.setBroadcastAddress(config.getBroadcastMask());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    announcer.setServerType(config.getServerType());
                    if (config.hasHostAnnounceDebug()) {
                        announcer.setDebug(true);
                    }
                    this.m_hostAnnouncers.add(announcer);
                    if (this.hasDebug()) {
                        Debug.println("[SMB] TCP NetBIOS host announcer created");
                    }
                }
                catch (IOException announcer) {
                    // empty catch block
                }
            }
        }
        if (config.hasTcpipSMB()) {
            sessHandler = new TcpipSMBSessionSocketHandler(srv, config.getTcpipSMBPort(), config.getSMBBindAddress(), this.hasDebug());
            sessHandler.setSocketTimeout(config.getSocketTimeout());
            try {
                sessHandler.initializeSessionHandler(srv);
                this.m_handlerList.addHandler(sessHandler);
                if (this.hasDebug()) {
                    Debug.println("[SMB] Native SMB TCP session handler created");
                }
            }
            catch (IOException ex) {
                throw new InvalidConfigurationException("Error initializing session handler, " + ex.getMessage());
            }
        }
        if (config.hasWin32NetBIOS() && PlatformType.isWindowsNTOnwards()) {
            SMBChildConnectionHandler win32Handler = null;
            try {
                win32Handler = (SMBChildConnectionHandler)Class.forName("org.filesys.smb.server.win32.Win32NetBIOSSMBConnectionsHandler").newInstance();
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (win32Handler != null) {
                win32Handler.initializeHandler(srv, config, this);
            }
        }
    }

    @Override
    public int numberOfSessionHandlers() {
        return this.m_handlerList.numberOfHandlers();
    }

    @Override
    public void addHostAnnouncer(HostAnnouncer announcer) {
        this.m_hostAnnouncers.add(announcer);
    }

    @Override
    public void addSessionHandler(SessionHandlerInterface sessHandler) {
        this.m_handlerList.addHandler(sessHandler);
    }

    @Override
    public void startHandler() {
        int idx;
        for (idx = 0; idx < this.m_handlerList.numberOfHandlers(); ++idx) {
            SessionHandlerInterface sessHandler = this.m_handlerList.getHandlerAt(idx);
            if (!(sessHandler instanceof Runnable)) continue;
            Thread handlerThread = new Thread((Runnable)((Object)sessHandler));
            handlerThread.setName("SMBSessHandler_" + sessHandler.getHandlerName());
            handlerThread.start();
            if (!this.hasDebug()) continue;
            Debug.println("[SMB] Created session handler thread " + handlerThread.getName());
        }
        if (this.m_hostAnnouncers.size() > 0) {
            for (idx = 0; idx < this.m_hostAnnouncers.size(); ++idx) {
                HostAnnouncer hostAnnouncer = this.m_hostAnnouncers.get(idx);
                hostAnnouncer.startAnnouncer();
                if (!this.hasDebug()) continue;
                Debug.println("[SMB] Started host announcer " + hostAnnouncer.getName());
            }
        }
    }

    @Override
    public void stopHandler() {
        int idx;
        for (idx = 0; idx < this.m_handlerList.numberOfHandlers(); ++idx) {
            SessionHandlerInterface sessHandler = this.m_handlerList.getHandlerAt(idx);
            sessHandler.closeSessionHandler(this.m_server);
            if (!this.hasDebug()) continue;
            Debug.println("[SMB] Shutting down session handler thread " + sessHandler.getHandlerName());
        }
        if (this.m_hostAnnouncers.size() > 0) {
            for (idx = 0; idx < this.m_hostAnnouncers.size(); ++idx) {
                HostAnnouncer hostAnnouncer = this.m_hostAnnouncers.get(idx);
                hostAnnouncer.shutdownAnnouncer();
                if (!this.hasDebug()) continue;
                Debug.println("[SMB] Shutting down host announcer " + hostAnnouncer.getName());
            }
        }
    }
}

