/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.smb.server;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.filesys.server.SrvSession;
import org.filesys.server.auth.ClientInfo;
import org.filesys.server.core.DeviceInterface;
import org.filesys.server.core.SharedDevice;
import org.filesys.server.filesys.SearchContext;
import org.filesys.server.filesys.SearchContextAdapter;
import org.filesys.server.filesys.SearchMap;
import org.filesys.server.filesys.SequentialSearchMap;
import org.filesys.server.filesys.TooManyConnectionsException;
import org.filesys.server.filesys.TooManySearchesException;
import org.filesys.server.filesys.TreeConnection;
import org.filesys.smb.server.SrvTransactBuffer;

public class VirtualCircuit {
    public static final int DefaultConnections = 4;
    public static final int MaxConnections = 16;
    private static final int TreeIdMask = 65535;
    private static final int DefaultSearches = 8;
    private static final int MaxSearches = 256;
    public static final int InvalidID = -1;
    public static final SearchContextAdapter SearchSlotMarker = new SearchContextAdapter();
    private int m_vcId = -1;
    private int m_vcNum;
    private ClientInfo m_clientInfo;
    private Map<Integer, TreeConnection> m_connections;
    private int m_treeId = 1;
    private SearchMap m_search;
    private SrvTransactBuffer m_transact;
    private boolean m_loggedOn;

    public VirtualCircuit(int vcNum, ClientInfo cInfo) {
        this.m_vcNum = vcNum;
        this.m_clientInfo = cInfo;
        this.m_loggedOn = true;
    }

    public final int getId() {
        return this.m_vcId;
    }

    public final int getVCNumber() {
        return this.m_vcNum;
    }

    public final ClientInfo getClientInformation() {
        return this.m_clientInfo;
    }

    public synchronized int addConnection(SharedDevice shrDev) throws TooManyConnectionsException {
        if (this.m_connections == null) {
            this.m_connections = new HashMap<Integer, TreeConnection>(4);
        }
        int treeId = 0;
        if (this.m_connections.size() == 16) {
            throw new TooManyConnectionsException();
        }
        treeId = this.m_treeId++ & 0xFFFF;
        while (this.m_connections.containsKey(treeId)) {
            treeId = this.m_treeId++ & 0xFFFF;
        }
        this.m_connections.put(treeId, new TreeConnection(shrDev, treeId));
        return treeId;
    }

    public final synchronized TreeConnection findConnection(int treeId) {
        if (this.m_connections == null) {
            return null;
        }
        return this.m_connections.get(treeId);
    }

    public synchronized void removeConnection(int treeId, SrvSession sess) {
        if (this.m_connections == null) {
            return;
        }
        TreeConnection tree = this.m_connections.get(treeId);
        if (tree != null) {
            tree.closeConnection(sess);
            this.m_connections.remove(treeId);
        }
    }

    public synchronized void removeAllConnections(SrvSession sess) {
        if (this.m_connections == null) {
            return;
        }
        Iterator<Integer> iterId = this.m_connections.keySet().iterator();
        while (iterId.hasNext()) {
            Integer treeId = iterId.next();
            TreeConnection tree = this.m_connections.get(treeId);
            if (tree == null) continue;
            tree.closeConnection(sess);
            iterId.remove();
        }
    }

    public final synchronized int getConnectionCount() {
        return this.m_connections != null ? this.m_connections.size() : 0;
    }

    public final synchronized int allocateSearchSlot() throws TooManySearchesException {
        if (this.m_search == null) {
            this.m_search = new SequentialSearchMap();
        }
        return this.m_search.allocateSearchSlot();
    }

    public final synchronized boolean allocateSearchSlotWithId(int searchId) throws TooManySearchesException {
        if (this.m_search == null) {
            this.m_search = new SequentialSearchMap();
        }
        return this.m_search.allocateSearchSlotWithId(searchId);
    }

    public final synchronized void deallocateSearchSlot(int ctxId) {
        if (this.m_search != null) {
            this.m_search.deallocateSearchSlot(ctxId);
        }
    }

    public final synchronized SearchContext getSearchContext(int srchId) {
        if (this.m_search == null) {
            return null;
        }
        return this.m_search.findSearchContext(srchId);
    }

    public final synchronized void setSearchContext(int slot, SearchContext srch) {
        if (this.m_search != null) {
            this.m_search.setSearchContext(slot, srch);
        }
    }

    protected final synchronized int getSearchCount() {
        if (this.m_search == null) {
            return 0;
        }
        return this.m_search.numberOfSearches();
    }

    public final synchronized boolean hasTransaction() {
        return this.m_transact != null;
    }

    public final synchronized SrvTransactBuffer getTransaction() {
        return this.m_transact;
    }

    public final synchronized void setTransaction(SrvTransactBuffer buf) {
        this.m_transact = buf;
    }

    public final void setId(int id) {
        this.m_vcId = id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void closeCircuit(SrvSession sess) {
        if (sess.hasDebug(2)) {
            sess.debugPrintln("Cleanup vc=" + this.getVCNumber() + ", id=" + this.getId() + ", searches=" + this.getSearchCount() + ", treeConns=" + this.getConnectionCount());
        }
        if (this.m_search != null && this.m_search.numberOfSearches() > 0) {
            VirtualCircuit virtualCircuit = this;
            synchronized (virtualCircuit) {
                this.m_search.closeAllSearches();
            }
        }
        if (this.m_connections != null) {
            for (TreeConnection tree : this.m_connections.values()) {
                DeviceInterface devIface = tree.getInterface();
                tree.closeConnection(sess);
                if (devIface == null) continue;
                devIface.treeClosed(sess, tree);
            }
            this.m_connections.clear();
        }
    }

    public final synchronized boolean isLoggedOn() {
        return this.m_loggedOn;
    }

    public final synchronized void setLoggedOn(boolean loggedOn) {
        this.m_loggedOn = loggedOn;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("[");
        str.append(this.getVCNumber());
        str.append(":");
        str.append(this.getId());
        str.append(",");
        str.append(this.getClientInformation());
        str.append(",Tree=");
        str.append(this.getConnectionCount());
        str.append(",Searches=");
        str.append(this.getSearchCount());
        str.append("]");
        return str.toString();
    }
}

