/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.smb.server.disk;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.filesys.debug.Debug;
import org.filesys.server.SrvSession;
import org.filesys.server.core.DeviceContext;
import org.filesys.server.core.DeviceContextException;
import org.filesys.server.filesys.AccessDeniedException;
import org.filesys.server.filesys.DirectoryNotEmptyException;
import org.filesys.server.filesys.DiskInterface;
import org.filesys.server.filesys.FileExistsException;
import org.filesys.server.filesys.FileInfo;
import org.filesys.server.filesys.FileName;
import org.filesys.server.filesys.FileOpenParams;
import org.filesys.server.filesys.FileStatus;
import org.filesys.server.filesys.NetworkFile;
import org.filesys.server.filesys.PathNotFoundException;
import org.filesys.server.filesys.SearchContext;
import org.filesys.server.filesys.TreeConnection;
import org.filesys.smb.server.disk.JavaNIODeviceContext;
import org.filesys.smb.server.disk.JavaNIONetworkFile;
import org.filesys.smb.server.disk.JavaNIOSearchContext;
import org.filesys.util.WildCard;
import org.springframework.extensions.config.ConfigElement;

public class JavaNIODiskDriver
implements DiskInterface {
    protected static long _globalCreateDate = System.currentTimeMillis();
    protected ExecutorService m_fileActionsExecutor = Executors.newSingleThreadExecutor();
    protected static final String TRASHCAN_NAME_PREFIX = "trash_";
    private static Random _trashCanIdGenerator = new Random();

    protected FileInfo buildFileInformation(String path, String relPath) {
        String[] pathStr = FileName.splitPath(path, File.separatorChar);
        FileInfo finfo = null;
        try {
            Path curPath = null;
            curPath = pathStr[1] != null ? Paths.get(pathStr[0], pathStr[1]) : Paths.get(pathStr[0], new String[0]);
            if (curPath != null && Files.exists(curPath, LinkOption.NOFOLLOW_LINKS)) {
                int fattr = 0;
                long falloc = 0L;
                long flen = 0L;
                String fname = curPath.getFileName().toString();
                if (Files.isDirectory(curPath, LinkOption.NOFOLLOW_LINKS)) {
                    fattr = 16;
                    if (Files.isHidden(curPath)) {
                        fattr += 2;
                    }
                } else {
                    flen = Files.size(curPath);
                    falloc = flen + 512L & 0xFFFFFFFFFFFFFE00L;
                    if (!Files.isWritable(curPath)) {
                        ++fattr;
                    }
                    if (Files.isHidden(curPath)) {
                        fattr += 2;
                    } else if (fname.equalsIgnoreCase("Desktop.ini") || fname.equalsIgnoreCase("Thumbs.db") || fname.startsWith(".")) {
                        fattr += 2;
                    }
                }
                finfo = new FileInfo(pathStr[1], flen, fattr);
                finfo.setAllocationSize(falloc);
                finfo.setFileId(relPath.toString().hashCode());
                FileTime modifyDate = Files.getLastModifiedTime(curPath, LinkOption.NOFOLLOW_LINKS);
                long modifyDateMs = modifyDate.toMillis();
                finfo.setModifyDateTime(modifyDateMs);
                finfo.setChangeDateTime(modifyDateMs);
                long dummyCreate = JavaNIODiskDriver.getGlobalCreateDateTime();
                if (dummyCreate > modifyDateMs) {
                    dummyCreate = modifyDateMs;
                }
                finfo.setCreationDateTime(dummyCreate);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return finfo;
    }

    @Override
    public void closeFile(SrvSession sess, TreeConnection tree, NetworkFile file) throws IOException {
        file.closeFile();
        if (file.hasDeleteOnClose()) {
            if (file.isDirectory()) {
                this.deleteDirectory(sess, tree, file.getFullName());
            } else {
                this.deleteFile(sess, tree, file.getFullName());
            }
        }
    }

    @Override
    public void createDirectory(SrvSession sess, TreeConnection tree, FileOpenParams params) throws IOException {
        String dirname = FileName.buildPath(tree.getContext().getDeviceName(), params.getPath(), null, File.separatorChar);
        File newDir = new File(dirname);
        if (!newDir.mkdir()) {
            throw new IOException("Failed to create directory " + dirname);
        }
    }

    @Override
    public NetworkFile createFile(SrvSession sess, TreeConnection tree, FileOpenParams params) throws IOException {
        DeviceContext ctx = tree.getContext();
        Path newPath = Paths.get(this.mapPath(ctx.getDeviceName(), params.getPath()), new String[0]);
        if (Files.exists(newPath, LinkOption.NOFOLLOW_LINKS)) {
            throw new FileExistsException();
        }
        Files.createFile(newPath, new FileAttribute[0]);
        JavaNIONetworkFile netFile = new JavaNIONetworkFile(newPath, params.getPath());
        netFile.setGrantedAccess(NetworkFile.Access.READ_WRITE);
        netFile.setFullName(params.getPath());
        return netFile;
    }

    @Override
    public void deleteDirectory(SrvSession sess, TreeConnection tree, String dir) throws IOException {
        String mappedPath;
        DeviceContext ctx = tree.getContext();
        Path dirPath = Paths.get(FileName.buildPath(ctx.getDeviceName(), dir, null, File.separatorChar), new String[0]);
        if (Files.exists(dirPath, new LinkOption[0]) && Files.isDirectory(dirPath, new LinkOption[0])) {
            try {
                Files.delete(dirPath);
            }
            catch (java.nio.file.DirectoryNotEmptyException ex) {
                throw new DirectoryNotEmptyException("Directory not empty");
            }
        }
        if (!Files.exists(dirPath, new LinkOption[0]) && (mappedPath = this.mapPath(ctx.getDeviceName(), dir)) != null && Files.isDirectory(dirPath = Paths.get(mappedPath, new String[0]), new LinkOption[0])) {
            try {
                Files.delete(dirPath);
            }
            catch (java.nio.file.DirectoryNotEmptyException ex) {
                throw new DirectoryNotEmptyException("Directory not empty");
            }
        }
    }

    @Override
    public void deleteFile(SrvSession sess, TreeConnection tree, String name) throws IOException {
        JavaNIODeviceContext ctx = (JavaNIODeviceContext)tree.getContext();
        Path filePath = Paths.get(FileName.buildPath(ctx.getDeviceName(), name, null, File.separatorChar), new String[0]);
        if (Files.exists(filePath, new LinkOption[0]) && !Files.isDirectory(filePath, new LinkOption[0])) {
            if (Files.size(filePath) < ctx.getLargeFileSize()) {
                Files.delete(filePath);
            } else {
                String[] paths = FileName.splitPath(name);
                String fileName = null;
                if (paths[1] != null) {
                    fileName = paths[1];
                }
                StringBuilder trashName = new StringBuilder();
                trashName.append(ctx.getTrashFolder().getAbsolutePath());
                trashName.append(File.separatorChar);
                trashName.append(TRASHCAN_NAME_PREFIX);
                trashName.append(sess.getSessionId());
                trashName.append("_");
                trashName.append(_trashCanIdGenerator.nextLong());
                final Path trashPath = Paths.get(trashName.toString(), new String[0]);
                if (ctx.hasDebug()) {
                    Debug.println("Delete file " + name + " via trashcan");
                }
                try {
                    Files.move(filePath, trashPath, StandardCopyOption.ATOMIC_MOVE);
                    this.m_fileActionsExecutor.execute(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                Files.delete(trashPath);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    });
                }
                catch (Exception ex) {
                    Files.delete(filePath);
                }
            }
        }
    }

    @Override
    public FileStatus fileExists(SrvSession sess, TreeConnection tree, String name) {
        DeviceContext ctx = tree.getContext();
        Path filePath = Paths.get(FileName.buildPath(ctx.getDeviceName(), name, null, File.separatorChar), new String[0]);
        if (Files.exists(filePath, LinkOption.NOFOLLOW_LINKS)) {
            if (Files.isDirectory(filePath, LinkOption.NOFOLLOW_LINKS)) {
                return FileStatus.DirectoryExists;
            }
            return FileStatus.FileExists;
        }
        try {
            String mappedPath = this.mapPath(ctx.getDeviceName(), name);
            if (mappedPath != null) {
                filePath = Paths.get(mappedPath, new String[0]);
                if (Files.exists(filePath, LinkOption.NOFOLLOW_LINKS)) {
                    if (Files.isDirectory(filePath, LinkOption.NOFOLLOW_LINKS)) {
                        return FileStatus.DirectoryExists;
                    }
                    return FileStatus.FileExists;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return FileStatus.NotExist;
    }

    @Override
    public void flushFile(SrvSession sess, TreeConnection tree, NetworkFile file) throws IOException {
        file.flushFile();
    }

    @Override
    public FileInfo getFileInformation(SrvSession sess, TreeConnection tree, String name) throws IOException {
        DeviceContext ctx = tree.getContext();
        String path = FileName.buildPath(ctx.getDeviceName(), name, null, File.separatorChar);
        FileInfo info = this.buildFileInformation(path, name);
        if (info != null) {
            return info;
        }
        String mappedPath = this.mapPath(ctx.getDeviceName(), name);
        if (mappedPath != null) {
            return this.buildFileInformation(mappedPath, name);
        }
        return null;
    }

    @Override
    public boolean isReadOnly(SrvSession sess, DeviceContext ctx) throws IOException {
        Path rootPath = Paths.get(ctx.getDeviceName(), new String[0]);
        if (!Files.exists(rootPath, new LinkOption[0]) || !Files.isDirectory(rootPath, new LinkOption[0])) {
            throw new FileNotFoundException(ctx.getDeviceName());
        }
        return !Files.isWritable(rootPath);
    }

    protected final String mapPath(String path) throws FileNotFoundException, PathNotFoundException {
        return this.mapPath("", path);
    }

    protected final String mapPath(String base, String path) throws FileNotFoundException, PathNotFoundException {
        String pathCopy = path;
        if (pathCopy.length() > 0 && pathCopy.startsWith("\\")) {
            pathCopy = pathCopy.substring(1);
        }
        StringTokenizer token = new StringTokenizer(pathCopy, "\\/");
        int tokCnt = token.countTokens();
        String mappedPath = null;
        if (tokCnt > 0) {
            String[] fileList;
            String[] dirs = new String[token.countTokens()];
            int idx = 0;
            while (token.hasMoreTokens()) {
                dirs[idx++] = token.nextToken();
            }
            int maxDir = dirs.length;
            if (!path.endsWith("\\")) {
                --maxDir;
            }
            StringBuffer pathStr = new StringBuffer(base);
            if (!base.endsWith(File.separator)) {
                pathStr.append(File.separator);
            }
            int lastPos = pathStr.length();
            idx = 0;
            File lastDir = null;
            if (base != null && base.length() > 0) {
                lastDir = new File(base);
            }
            File curDir = null;
            while (idx < maxDir) {
                pathStr.append(dirs[idx]);
                pathStr.append(File.separator);
                curDir = new File(pathStr.toString());
                if (!curDir.exists()) {
                    if (lastDir == null) {
                        throw new PathNotFoundException();
                    }
                    fileList = lastDir.list();
                    if (fileList == null || fileList.length == 0) {
                        throw new PathNotFoundException();
                    }
                    boolean foundPath = false;
                    for (int fidx = 0; fidx < fileList.length && !foundPath; ++fidx) {
                        if (!fileList[fidx].equalsIgnoreCase(dirs[idx])) continue;
                        pathStr.setLength(lastPos);
                        pathStr.append(fileList[fidx]);
                        pathStr.append(File.separator);
                        curDir = new File(pathStr.toString());
                        if (!curDir.exists()) continue;
                        foundPath = true;
                        break;
                    }
                    if (!foundPath) {
                        throw new PathNotFoundException();
                    }
                }
                lastDir = curDir;
                lastPos = pathStr.length();
                ++idx;
            }
            if (!path.endsWith("\\")) {
                fileList = lastDir.list();
                String fileName = dirs[dirs.length - 1];
                if (fileList == null) {
                    throw new FileNotFoundException(path);
                }
                idx = 0;
                boolean foundFile = false;
                while (idx < fileList.length && !foundFile) {
                    if (fileList[idx].compareTo(fileName) == 0) {
                        foundFile = true;
                        continue;
                    }
                    ++idx;
                }
                if (!foundFile) {
                    idx = 0;
                    while (idx < fileList.length && !foundFile) {
                        if (fileList[idx].equalsIgnoreCase(fileName)) {
                            foundFile = true;
                            fileName = fileList[idx];
                            continue;
                        }
                        ++idx;
                    }
                }
                pathStr.append(fileName);
            }
            mappedPath = pathStr.toString();
            if (File.separator.equals("\\") && mappedPath.startsWith("\\") && mappedPath.indexOf(58) > 1) {
                mappedPath = mappedPath.substring(1);
            }
        }
        return mappedPath;
    }

    @Override
    public NetworkFile openFile(SrvSession sess, TreeConnection tree, FileOpenParams params) throws IOException {
        DeviceContext ctx = tree.getContext();
        Path filePath = Paths.get(FileName.buildPath(ctx.getDeviceName(), params.getPath(), null, File.separatorChar), new String[0]);
        if (!Files.exists(filePath, new LinkOption[0])) {
            String mappedPath = this.mapPath(ctx.getDeviceName(), params.getPath());
            if (mappedPath == null) {
                throw new FileNotFoundException(filePath.toString());
            }
            filePath = Paths.get(mappedPath, new String[0]);
            if (!Files.exists(filePath, new LinkOption[0])) {
                throw new FileNotFoundException(filePath.toString());
            }
        }
        if (!Files.isWritable(filePath) && (params.isReadWriteAccess() || params.isWriteOnlyAccess())) {
            throw new AccessDeniedException("File " + filePath.toString() + " is read-only");
        }
        JavaNIONetworkFile netFile = new JavaNIONetworkFile(filePath, params.getPath());
        if (params.isReadOnlyAccess()) {
            netFile.setGrantedAccess(NetworkFile.Access.READ_ONLY);
        } else {
            netFile.setGrantedAccess(NetworkFile.Access.READ_WRITE);
        }
        netFile.setAccessMask(params.getAccessMode());
        netFile.setFullName(params.getPath());
        if (Files.isDirectory(filePath, new LinkOption[0])) {
            netFile.setAttributes(16);
        }
        return netFile;
    }

    @Override
    public int readFile(SrvSession sess, TreeConnection tree, NetworkFile file, byte[] buf, int bufPos, int siz, long filePos) throws IOException {
        if (file.isDirectory()) {
            throw new AccessDeniedException();
        }
        int rdlen = file.readFile(buf, siz, bufPos, filePos);
        if (rdlen == -1) {
            rdlen = 0;
        }
        return rdlen;
    }

    @Override
    public void renameFile(SrvSession sess, TreeConnection tree, String oldName, String newName) throws IOException {
        DeviceContext ctx = tree.getContext();
        Path oldPath = Paths.get(FileName.buildPath(ctx.getDeviceName(), oldName, null, File.separatorChar), new String[0]);
        Path newPath = Paths.get(FileName.buildPath(ctx.getDeviceName(), newName, null, File.separatorChar), new String[0]);
        if (!Files.exists(oldPath, new LinkOption[0])) {
            throw new FileNotFoundException("Rename file, does not exist " + oldName);
        }
        if (Files.exists(newPath, new LinkOption[0])) {
            throw new FileExistsException("Rename file, path exists " + newName);
        }
        try {
            Files.move(oldPath, newPath, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Exception ex) {
            throw new IOException("Rename " + oldPath + " to " + newPath + " failed");
        }
    }

    @Override
    public long seekFile(SrvSession sess, TreeConnection tree, NetworkFile file, long pos, int typ) throws IOException {
        return file.seekFile(pos, typ);
    }

    @Override
    public void setFileInformation(SrvSession sess, TreeConnection tree, String name, FileInfo info) throws IOException {
        if (info.hasSetFlag(8)) {
            DeviceContext ctx = tree.getContext();
            Path filePath = Paths.get(this.mapPath(ctx.getDeviceName(), name), new String[0]);
            Files.setLastModifiedTime(filePath, FileTime.fromMillis(info.getModifyDateTime()));
        }
    }

    @Override
    public SearchContext startSearch(SrvSession sess, TreeConnection tree, String searchPath, int attrib) throws FileNotFoundException {
        String path = FileName.buildPath(tree.getContext().getDeviceName(), null, searchPath, File.separatorChar);
        JavaNIOSearchContext ctx = null;
        try {
            path = this.mapPath(path);
            String[] paths = FileName.splitPath(path, File.separatorChar);
            if (sess != null && sess.hasDebug(128)) {
                sess.debugPrintln("  Start search path=" + path + ", relPath=" + paths[0]);
            }
            if (paths[1] != null && !WildCard.containsWildcards(paths[1])) {
                Path singlePath = Paths.get(paths[0], paths[1]);
                if (!Files.exists(singlePath, LinkOption.NOFOLLOW_LINKS)) {
                    throw new FileNotFoundException(singlePath.toString());
                }
                ctx = new JavaNIOSearchContext();
                ctx.initSinglePathSearch(singlePath);
            } else {
                Path rootPath;
                String root = paths[0];
                if (root.endsWith(":")) {
                    root = root + '\\';
                }
                if (Files.isDirectory(rootPath = Paths.get(root, new String[0]), LinkOption.NOFOLLOW_LINKS)) {
                    if (paths[1] == null) {
                        ctx = new JavaNIOSearchContext();
                        ctx.initSinglePathSearch(rootPath);
                    } else {
                        ctx = new JavaNIOSearchContext();
                        try {
                            ctx.initWildcardSearch(rootPath, attrib, new WildCard(paths[1], false));
                        }
                        catch (IOException ex) {
                            throw new FileNotFoundException(rootPath.toString());
                        }
                    }
                }
            }
            if (ctx != null) {
                ctx.setRelativePath(paths[0]);
            }
        }
        catch (PathNotFoundException ex) {
            throw new FileNotFoundException();
        }
        return ctx;
    }

    @Override
    public void truncateFile(SrvSession sess, TreeConnection tree, NetworkFile file, long siz) throws IOException {
        if (siz == 0L) {
            JavaNIODeviceContext ctx = (JavaNIODeviceContext)tree.getContext();
            if (file.getFileSize() >= ctx.getLargeFileSize()) {
                if (ctx.hasDebug()) {
                    Debug.println("Truncate large file via delete - " + file.getFullName());
                }
                file.closeFile();
                this.deleteFile(sess, tree, file.getFullName());
                file.openFile(true);
                return;
            }
        }
        file.truncateFile(siz);
        file.flushFile();
    }

    @Override
    public int writeFile(SrvSession sess, TreeConnection tree, NetworkFile file, byte[] buf, int bufoff, int siz, long fileoff) throws IOException {
        if (file.isDirectory()) {
            throw new AccessDeniedException();
        }
        file.writeFile(buf, siz, bufoff, fileoff);
        return siz;
    }

    @Override
    public DeviceContext createContext(String shareName, ConfigElement args) throws DeviceContextException {
        JavaNIODeviceContext ctx = new JavaNIODeviceContext(shareName, args);
        if (ctx.hasTrashFolder()) {
            Path trashPath = Paths.get(ctx.getTrashFolder().getAbsolutePath(), new String[0]);
            try (DirectoryStream<Path> trashStream = Files.newDirectoryStream(trashPath, "trash_*");){
                for (final Path trashFile : trashStream) {
                    if (ctx.hasDebug()) {
                        Debug.println("Queue trash file for delete - " + trashFile.getFileName());
                    }
                    this.m_fileActionsExecutor.execute(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                Files.delete(trashFile);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    });
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return ctx;
    }

    @Override
    public void treeOpened(SrvSession sess, TreeConnection tree) {
    }

    @Override
    public void treeClosed(SrvSession sess, TreeConnection tree) {
    }

    public static final long getGlobalCreateDateTime() {
        return _globalCreateDate;
    }
}

