/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.smb.server.disk;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.EnumSet;
import org.filesys.server.filesys.DiskFullException;
import org.filesys.server.filesys.NetworkFile;

public class JavaNIONetworkFile
extends NetworkFile {
    protected Path m_path;
    protected FileChannel m_io;
    protected boolean m_eof;

    public JavaNIONetworkFile(Path path, String netPath) throws IOException {
        super(path.getFileName().toString());
        this.m_path = path;
        this.setFileSize(Files.size(this.m_path));
        this.m_eof = false;
        long modDate = Files.getLastModifiedTime(this.m_path, new LinkOption[0]).toMillis();
        this.setModifyDate(modDate);
        this.setCreationDate(modDate);
        this.setFileId(netPath.hashCode());
    }

    public JavaNIONetworkFile(String name, String netPath) throws IOException {
        super(name);
        this.m_path = Paths.get(name, new String[0]);
        if (!Files.exists(this.m_path, new LinkOption[0])) {
            Files.createFile(this.m_path, new FileAttribute[0]);
        }
        this.setFileSize(Files.size(this.m_path));
        this.m_eof = false;
        long modDate = Files.getLastModifiedTime(this.m_path, new LinkOption[0]).toMillis();
        this.setModifyDate(modDate);
        this.setCreationDate(modDate);
        this.setFileId(netPath.hashCode());
    }

    @Override
    public void closeFile() throws IOException {
        if (this.m_io != null) {
            this.m_io.close();
            this.m_io = null;
            if (this.getWriteCount() > 0) {
                Files.setLastModifiedTime(this.m_path, FileTime.fromMillis(System.currentTimeMillis()));
            }
            this.setClosed(true);
        }
    }

    public long currentPosition() {
        try {
            if (this.m_io != null) {
                return this.m_io.position();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0L;
    }

    @Override
    public void flushFile() throws IOException {
        if (this.m_io != null) {
            this.m_io.force(false);
        }
    }

    public boolean isEndOfFile() throws IOException {
        return this.m_io != null && this.m_io.position() == this.m_io.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void openFile(boolean createFlag) throws IOException {
        Path path = this.m_path;
        synchronized (path) {
            if (this.m_io == null) {
                EnumSet<StandardOpenOption> openOptions = null;
                openOptions = this.getGrantedAccess() == NetworkFile.Access.READ_WRITE ? EnumSet.of(StandardOpenOption.READ, StandardOpenOption.WRITE) : EnumSet.of(StandardOpenOption.READ);
                this.m_io = FileChannel.open(this.m_path, openOptions, new FileAttribute[0]);
                this.setClosed(false);
            }
        }
    }

    @Override
    public int readFile(byte[] buf, int len, int pos, long fileOff) throws IOException {
        if (this.m_io == null) {
            this.openFile(false);
        }
        if (this.currentPosition() != fileOff) {
            this.seekFile(fileOff, 0);
        }
        ByteBuffer bytBuf = ByteBuffer.wrap(buf, pos, len);
        int rdlen = this.m_io.read(bytBuf);
        return rdlen;
    }

    @Override
    public long seekFile(long pos, int typ) throws IOException {
        if (this.m_io == null) {
            this.openFile(false);
        }
        switch (typ) {
            case 0: {
                if (this.currentPosition() == pos) break;
                this.m_io.position(pos);
                break;
            }
            case 1: {
                this.m_io.position(this.m_io.position() + pos);
                break;
            }
            case 2: {
                long newPos = this.m_io.size() + pos;
                this.m_io.position(newPos);
            }
        }
        return this.currentPosition();
    }

    @Override
    public void truncateFile(long siz) throws IOException {
        if (this.m_io == null) {
            this.openFile(true);
        } else {
            this.m_io.force(false);
        }
        boolean extendFile = siz > this.getFileSize();
        try {
            this.m_io.truncate(siz);
            this.setFileSize(siz);
        }
        catch (IOException ex) {
            if (extendFile) {
                throw new DiskFullException("Failed to extend file, " + this.getFullName());
            }
            throw ex;
        }
    }

    public void writeFile(byte[] buf, int len, int pos) throws IOException {
        if (this.m_io == null) {
            this.openFile(true);
        }
        ByteBuffer bytBuf = ByteBuffer.wrap(buf, pos, len);
        while (bytBuf.hasRemaining()) {
            this.m_io.write(bytBuf);
        }
        this.incrementWriteCount();
    }

    @Override
    public void writeFile(byte[] buf, int len, int pos, long offset) throws IOException {
        long fileLen;
        if (this.m_io == null) {
            this.openFile(true);
        }
        if (offset > (fileLen = this.m_io.size())) {
            this.m_io.truncate(offset + (long)len);
        }
        if (len == 0) {
            return;
        }
        this.m_io.position(offset);
        ByteBuffer bytBuf = ByteBuffer.wrap(buf, pos, len);
        while (bytBuf.hasRemaining()) {
            this.m_io.write(bytBuf);
        }
        this.incrementWriteCount();
    }
}

