/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.smb.server.nio;

import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.filesys.debug.Debug;
import org.filesys.server.ChannelSessionHandler;
import org.filesys.server.SessionHandlerInterface;
import org.filesys.server.SessionHandlerList;
import org.filesys.server.config.InvalidConfigurationException;
import org.filesys.smb.mailslot.HostAnnouncer;
import org.filesys.smb.server.PacketHandler;
import org.filesys.smb.server.SMBConfigSection;
import org.filesys.smb.server.SMBConnectionsHandler;
import org.filesys.smb.server.SMBServer;
import org.filesys.smb.server.SMBSrvSession;
import org.filesys.smb.server.nio.NetBIOSSMBChannelSessionHandler;
import org.filesys.smb.server.nio.RequestHandler;
import org.filesys.smb.server.nio.RequestHandlerListener;
import org.filesys.smb.server.nio.SMBRequestHandler;
import org.filesys.smb.server.nio.TcpipSMBChannelSessionHandler;

public class NIOSMBConnectionsHandler
implements SMBConnectionsHandler,
RequestHandlerListener,
Runnable {
    public static final int SessionSocketsPerHandler = 50;
    private SessionHandlerList m_handlerList = new SessionHandlerList();
    private Selector m_selector;
    private List<SMBRequestHandler> m_requestHandlers;
    private SMBServer m_server;
    private Thread m_thread;
    private boolean m_shutdown;
    private int m_sessId;
    private int m_clientSocketTimeout;
    private IdleSessionReaper m_idleSessReaper;
    private boolean m_debug;
    private boolean m_threadDebug;

    @Override
    public final boolean hasDebug() {
        return this.m_debug;
    }

    @Override
    public int numberOfSessionHandlers() {
        return this.m_handlerList.numberOfHandlers();
    }

    @Override
    public void addHostAnnouncer(HostAnnouncer announcer) {
    }

    @Override
    public void addSessionHandler(SessionHandlerInterface sessHandler) {
    }

    @Override
    public final void initializeHandler(SMBServer srv, SMBConfigSection config) throws InvalidConfigurationException {
        ChannelSessionHandler sessHandler;
        this.m_server = srv;
        if ((config.getSessionDebugFlags() & 0x200000) != 0) {
            this.m_debug = true;
        }
        if ((config.getSessionDebugFlags() & 0x1000000) != 0) {
            this.m_threadDebug = true;
        }
        if (config.hasTcpipSMB()) {
            sessHandler = new TcpipSMBChannelSessionHandler(srv, config.getSMBBindAddress(), config.getTcpipSMBPort());
            sessHandler.setDebug(this.hasDebug());
            try {
                sessHandler.initializeSessionHandler(srv);
                this.m_handlerList.addHandler(sessHandler);
            }
            catch (IOException ex) {
                throw new InvalidConfigurationException("Error initializing TCP-IP SMB session handler, " + ex.getMessage());
            }
        }
        if (config.hasNetBIOSSMB()) {
            sessHandler = new NetBIOSSMBChannelSessionHandler(srv, config.getSMBBindAddress(), config.getSessionPort());
            sessHandler.setDebug(this.hasDebug());
            try {
                sessHandler.initializeSessionHandler(srv);
                this.m_handlerList.addHandler(sessHandler);
            }
            catch (IOException ex) {
                throw new InvalidConfigurationException("Error initializing NetBIOS SMB session handler, " + ex.getMessage());
            }
        }
        if (this.m_handlerList.numberOfHandlers() == 0) {
            throw new InvalidConfigurationException("No SMB session handlers enabled");
        }
        this.m_clientSocketTimeout = config.getSocketTimeout();
        this.m_requestHandlers = new ArrayList<SMBRequestHandler>();
        SMBRequestHandler reqHandler = new SMBRequestHandler(this.m_server.getThreadPool(), 50, this.m_clientSocketTimeout, this.hasDebug());
        reqHandler.setThreadDebug(this.m_threadDebug);
        reqHandler.setListener(this);
        this.m_requestHandlers.add(reqHandler);
    }

    @Override
    public final void startHandler() {
        this.m_thread = new Thread(this);
        this.m_thread.setName("SMBConnectionsHandler");
        this.m_thread.setDaemon(false);
        this.m_thread.start();
        if (this.m_clientSocketTimeout > 0) {
            this.m_idleSessReaper = new IdleSessionReaper(this.m_clientSocketTimeout / 2);
        }
    }

    @Override
    public final void stopHandler() {
        if (this.m_thread != null) {
            this.m_shutdown = true;
            try {
                this.m_thread.interrupt();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.m_idleSessReaper != null) {
                this.m_idleSessReaper.shutdownRequest();
            }
        }
    }

    @Override
    public void run() {
        block21: {
            int idx;
            this.m_shutdown = false;
            try {
                this.m_selector = Selector.open();
                for (idx = 0; idx < this.m_handlerList.numberOfHandlers(); ++idx) {
                    ChannelSessionHandler curHandler = (ChannelSessionHandler)this.m_handlerList.getHandlerAt(idx);
                    ServerSocketChannel sockChannel = curHandler.getSocketChannel();
                    sockChannel.configureBlocking(false);
                    sockChannel.register(this.m_selector, 16, curHandler);
                    if (!this.hasDebug()) continue;
                    Debug.println("[SMB] Listening for connections on " + curHandler);
                }
            }
            catch (IOException ex) {
                if (this.hasDebug()) {
                    Debug.println("[SMB] Error opening/registering Selector");
                    Debug.println(ex);
                }
                this.m_shutdown = true;
            }
            while (!this.m_shutdown) {
                int connCnt;
                block19: {
                    if (this.hasDebug()) {
                        Debug.println("[SMB] Waiting for new connection ...");
                    }
                    connCnt = 0;
                    try {
                        connCnt = this.m_selector.select();
                    }
                    catch (IOException ex) {
                        if (!this.hasDebug()) break block19;
                        Debug.println("[SMB] Error waiting for connection");
                        Debug.println(ex);
                    }
                }
                if (connCnt == 0) continue;
                Iterator<SelectionKey> keysIter = this.m_selector.selectedKeys().iterator();
                while (keysIter.hasNext()) {
                    block20: {
                        SelectionKey selKey = keysIter.next();
                        if (selKey.isAcceptable()) {
                            try {
                                ServerSocketChannel srvChannel = (ServerSocketChannel)selKey.channel();
                                SocketChannel sockChannel = srvChannel.accept();
                                ChannelSessionHandler channelHandler = (ChannelSessionHandler)selKey.attachment();
                                PacketHandler pktHandler = channelHandler.createPacketHandler(sockChannel);
                                SMBSrvSession sess = SMBSrvSession.createSession(pktHandler, this.m_server, ++this.m_sessId);
                                if (this.hasDebug()) {
                                    Debug.println("[SMB] Created session " + sess.getUniqueId());
                                }
                                if (this.hasDebug()) {
                                    Debug.println("[SMB] Connection from " + sockChannel.socket().getRemoteSocketAddress() + ", handler=" + channelHandler + ", sess=" + sess.getUniqueId());
                                }
                                this.queueSessionToHandler(sess);
                            }
                            catch (IOException ex) {
                                if (!this.hasDebug()) break block20;
                                Debug.println("[SMB] Failed to accept connection");
                                Debug.println(ex);
                            }
                        }
                    }
                    keysIter.remove();
                }
            }
            for (idx = 0; idx < this.m_handlerList.numberOfHandlers(); ++idx) {
                ChannelSessionHandler sessHandler = (ChannelSessionHandler)this.m_handlerList.getHandlerAt(idx);
                sessHandler.closeSessionHandler(null);
                if (!this.hasDebug()) continue;
                Debug.println("[SMB] Closed session handler " + sessHandler);
            }
            while (this.m_requestHandlers.size() > 0) {
                SMBRequestHandler reqHandler = this.m_requestHandlers.remove(0);
                reqHandler.closeHandler();
                if (!this.hasDebug()) continue;
                Debug.println("[SMB] Closed request handler, " + reqHandler.getName());
            }
            if (this.m_selector != null) {
                try {
                    this.m_selector.close();
                }
                catch (Exception ex) {
                    if (!this.hasDebug()) break block21;
                    Debug.println("[SMB] Error closing socket selector, " + ex.getMessage());
                }
            }
        }
        this.m_thread = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void queueSessionToHandler(SMBSrvSession sess) {
        SMBRequestHandler reqHandler = null;
        List<SMBRequestHandler> list = this.m_requestHandlers;
        synchronized (list) {
            reqHandler = this.m_requestHandlers.get(0);
            if (reqHandler == null || !reqHandler.hasFreeSessionSlot()) {
                reqHandler = new SMBRequestHandler(this.m_server.getThreadPool(), 50, this.m_clientSocketTimeout, this.hasDebug());
                reqHandler.setThreadDebug(this.m_threadDebug);
                reqHandler.setListener(this);
                this.m_requestHandlers.add(0, reqHandler);
                if (this.hasDebug()) {
                    Debug.println("[SMB] Added new SMB request handler, " + reqHandler);
                }
            }
        }
        reqHandler.queueSessionToHandler(sess);
    }

    public final void setDebug(boolean ena) {
        this.m_debug = ena;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestHandlerEmpty(RequestHandler reqHandler) {
        SessionHandlerList sessionHandlerList = this.m_handlerList;
        synchronized (sessionHandlerList) {
            if (!this.m_requestHandlers.get(0).getName().equals(reqHandler.getName())) {
                this.m_requestHandlers.remove(reqHandler);
                reqHandler.closeHandler();
                if (this.hasDebug()) {
                    Debug.println("[SMB] Removed empty request handler, " + reqHandler.getName());
                }
            }
        }
    }

    protected class IdleSessionReaper
    implements Runnable {
        private long m_wakeup;
        private Thread m_reaperThread;
        private boolean m_shutdown = false;

        public IdleSessionReaper(long intvl) {
            this.m_wakeup = intvl;
            this.m_reaperThread = new Thread(this);
            this.m_reaperThread.setDaemon(true);
            this.m_reaperThread.setName("SMB_IdleSessionReaper_NIO");
            this.m_reaperThread.start();
        }

        public final void shutdownRequest() {
            this.m_shutdown = true;
            this.m_reaperThread.interrupt();
        }

        @Override
        public void run() {
            while (!this.m_shutdown) {
                try {
                    Thread.sleep(this.m_wakeup);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.m_shutdown) break;
                for (SMBRequestHandler curHandler : NIOSMBConnectionsHandler.this.m_requestHandlers) {
                    int idleCnt;
                    if (curHandler == null || (idleCnt = curHandler.checkForIdleSessions()) <= 0 || !NIOSMBConnectionsHandler.this.hasDebug()) continue;
                    Debug.println("[SMB] Idle session check, removed " + idleCnt + " sessions for " + curHandler.getName());
                }
            }
        }
    }
}

