/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.smb.server.nio;

import org.filesys.smb.server.SMBSrvSession;
import org.filesys.smb.server.nio.RequestHandlerListener;

public abstract class RequestHandler {
    private int m_maxSessions;
    private boolean m_debug;
    private RequestHandlerListener m_listener;

    public RequestHandler(int maxSess) {
        this.m_maxSessions = maxSess;
    }

    public abstract int getCurrentSessionCount();

    public final int getMaximumSessionCount() {
        return this.m_maxSessions;
    }

    public abstract boolean hasFreeSessionSlot();

    public abstract void queueSessionToHandler(SMBSrvSession var1);

    public abstract String getName();

    public abstract void closeHandler();

    public final boolean hasDebug() {
        return this.m_debug;
    }

    public final void setDebug(boolean ena) {
        this.m_debug = ena;
    }

    public final boolean hasListener() {
        return this.m_listener != null;
    }

    public final RequestHandlerListener getListener() {
        return this.m_listener;
    }

    public final void setListener(RequestHandlerListener listener) {
        this.m_listener = listener;
    }

    protected final void fireRequestHandlerEmptyEvent() {
        if (this.hasListener()) {
            this.getListener().requestHandlerEmpty(this);
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof RequestHandler) {
            RequestHandler reqHandler = (RequestHandler)obj;
            return reqHandler.getName().equals(this.getName());
        }
        return false;
    }
}

