/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import org.filesys.debug.DebugInterface;
import org.filesys.util.BadHexFormatException;

public final class HexDump {
    private static String _hexChars = "0123456789ABCDEF";

    public static final void Dump(byte[] byt) {
        HexDump.Dump(byt, byt.length, 0, System.out);
    }

    public static final void Dump(byte[] byt, int len, int offset) {
        HexDump.Dump(byt, len, offset, System.out);
    }

    public static final void Dump(byte[] byt, int len, int offset, PrintStream stream) {
        StringBuilder ascBuf = new StringBuilder();
        StringBuilder hexBuf = new StringBuilder();
        int doff = offset;
        int endoff = offset + len;
        String posStr = null;
        for (int dlen = 0; dlen < len; dlen += 16) {
            ascBuf.setLength(0);
            hexBuf.setLength(0);
            posStr = HexDump.generatePositionString(doff);
            doff = HexDump.generateLine(byt, doff, ascBuf, hexBuf, endoff);
            stream.print(posStr);
            stream.print(hexBuf.toString());
            stream.println(ascBuf.toString());
        }
    }

    public static final void Dump(byte[] byt, int len, int offset, DebugInterface dbgDev) {
        StringBuilder ascBuf = new StringBuilder();
        StringBuilder hexBuf = new StringBuilder();
        int doff = offset;
        int endoff = offset + len;
        String posStr = null;
        for (int dlen = 0; dlen < len; dlen += 16) {
            ascBuf.setLength(0);
            hexBuf.setLength(0);
            posStr = HexDump.generatePositionString(doff);
            doff = HexDump.generateLine(byt, doff, ascBuf, hexBuf, endoff);
            dbgDev.debugPrintln(posStr + hexBuf.toString() + ascBuf.toString());
        }
    }

    public static final String hexString(String str) {
        if (str != null) {
            return HexDump.hexString(str.getBytes());
        }
        return "";
    }

    public static final String hexString(String str, String gap) {
        if (str != null) {
            return HexDump.hexString(str.getBytes(), gap);
        }
        return "";
    }

    public static final String hexString(byte[] buf) {
        return HexDump.hexString(buf, buf.length, null);
    }

    public static final String hexString(byte[] buf, String gap) {
        return HexDump.hexString(buf, buf.length, gap);
    }

    public static final String hexString(byte[] buf, int len, String gap) {
        if (buf == null) {
            return "";
        }
        int buflen = buf.length * 2;
        if (gap != null) {
            buflen += buf.length * gap.length();
        }
        StringBuilder hex = new StringBuilder(buflen);
        for (int i = 0; i < len; ++i) {
            int curbyt = buf[i] & 0xFF;
            hex.append(Integer.toHexString((curbyt & 0xF0) >> 4));
            hex.append(Integer.toHexString(curbyt & 0xF));
            if (gap == null || i >= len - 1) continue;
            hex.append(gap);
        }
        return hex.toString();
    }

    public static final String hexString(byte[] buf, int off, int len, String gap) {
        if (buf == null) {
            return "";
        }
        int buflen = (buf.length - off) * 2;
        if (gap != null) {
            buflen += buf.length * gap.length();
        }
        StringBuilder hex = new StringBuilder(buflen);
        for (int i = 0; i < len; ++i) {
            int curbyt = buf[off + i] & 0xFF;
            hex.append(Integer.toHexString((curbyt & 0xF0) >> 4));
            hex.append(Integer.toHexString(curbyt & 0xF));
            if (gap == null || i >= len - 1) continue;
            hex.append(gap);
        }
        return hex.toString();
    }

    public static final byte[] loadFromHexDump(String[] hexStr) throws BadHexFormatException {
        byte[] byts = new byte[hexStr.length * 16];
        int idx = 0;
        for (String hex : hexStr) {
            if (hex.length() < 8) {
                throw new BadHexFormatException();
            }
            hex = hex.toUpperCase();
            int hexIdx = 6;
            boolean lineDone = false;
            while (hexIdx < 55 && !lineDone) {
                if (hex.charAt(hexIdx) == ' ' && hex.charAt(hexIdx + 1) == ' ') {
                    lineDone = true;
                    continue;
                }
                int hex1 = _hexChars.indexOf(hex.charAt(hexIdx));
                int hex2 = _hexChars.indexOf(hex.charAt(hexIdx + 1));
                if (hex1 == -1 || hex2 == -1) {
                    throw new BadHexFormatException();
                }
                byts[idx++] = (byte)((hex1 << 4) + hex2 & 0xFF);
                if (hex.charAt(hexIdx += 3) != ' ') continue;
                ++hexIdx;
            }
        }
        if (idx < byts.length) {
            byts = Arrays.copyOf(byts, idx);
        }
        return byts;
    }

    public static final byte[] loadFromHexDumpFile(String hexFileName) throws BadHexFormatException, FileNotFoundException, IOException {
        String line;
        File hexFile = new File(hexFileName);
        FileReader reader = new FileReader(hexFile);
        BufferedReader lineReader = new BufferedReader(reader);
        ArrayList<String> lines = new ArrayList<String>();
        while ((line = lineReader.readLine()) != null) {
            lines.add(line);
        }
        String[] hexStrs = lines.toArray(new String[0]);
        return HexDump.loadFromHexDump(hexStrs);
    }

    public static final byte[] loadHexString(String hex) {
        if (hex == null || hex.length() == 0 || hex.length() % 2 == 1) {
            return null;
        }
        if (hex.indexOf(32) != -1) {
            hex = hex.replaceAll("\\s", "");
        }
        byte[] byts = new byte[hex.length() / 2];
        hex = hex.toUpperCase();
        int bytIdx = 0;
        for (int idx = 0; idx < hex.length(); idx += 2) {
            int hex1 = _hexChars.indexOf(hex.charAt(idx));
            int hex2 = _hexChars.indexOf(hex.charAt(idx + 1));
            byts[bytIdx++] = (byte)((hex1 << 4) + hex2 & 0xFF);
        }
        return byts;
    }

    private static final String generatePositionString(int off) {
        StringBuilder posStr = new StringBuilder(8);
        posStr.append(Integer.toString(off));
        posStr.append(" - ");
        while (posStr.length() < 8) {
            posStr.insert(0, " ");
        }
        return posStr.toString();
    }

    private static final int generateLine(byte[] byt, int off, StringBuilder ascBuf, StringBuilder hexBuf, int endOff) {
        int dumplen = byt.length - off;
        if (dumplen > 16) {
            dumplen = 16;
        }
        for (int i = 0; i < dumplen; ++i) {
            int curbyt = byt[off++] & 0xFF;
            hexBuf.append(Integer.toHexString((curbyt & 0xF0) >> 4));
            hexBuf.append(Integer.toHexString(curbyt & 0xF));
            hexBuf.append(off == endOff ? "]" : " ");
            if (Character.isLetterOrDigit((char)curbyt) || Character.getType((char)curbyt) != 15) {
                ascBuf.append((char)curbyt);
                continue;
            }
            ascBuf.append(".");
        }
        hexBuf.append("  - ");
        return off;
    }
}

