/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.util;

import java.util.ArrayList;
import java.util.List;
import org.filesys.util.NameValue;

public class NameValueList {
    private List<NameValue> m_list = new ArrayList<NameValue>();

    public final void addItem(NameValue nameVal) {
        this.m_list.add(nameVal);
    }

    public final int numberOfItems() {
        return this.m_list.size();
    }

    public final NameValue getItemAt(int idx) {
        if (idx < 0 || idx >= this.m_list.size()) {
            return null;
        }
        return this.m_list.get(idx);
    }

    public final NameValue findItem(String name) {
        for (int i = 0; i < this.m_list.size(); ++i) {
            NameValue nameVal = this.m_list.get(i);
            if (nameVal.getName().compareTo(name) != 0) continue;
            return nameVal;
        }
        return null;
    }

    public final NameValueList findAllItems(String name) {
        NameValueList list = new NameValueList();
        for (int i = 0; i < this.m_list.size(); ++i) {
            NameValue nameVal = this.m_list.get(i);
            if (nameVal.getName().compareTo(name) != 0) continue;
            list.addItem(nameVal);
        }
        if (list.numberOfItems() == 0) {
            list = null;
        }
        return list;
    }

    public final NameValue findItemCaseless(String name) {
        for (int i = 0; i < this.m_list.size(); ++i) {
            NameValue nameVal = this.m_list.get(i);
            if (!nameVal.getName().equalsIgnoreCase(name)) continue;
            return nameVal;
        }
        return null;
    }

    public final void removeAllItems() {
        this.m_list.clear();
    }

    public String toString() {
        StringBuffer str = new StringBuffer(256);
        str.append("[");
        for (int i = 0; i < this.numberOfItems(); ++i) {
            if (str.length() > 1) {
                str.append(",");
            }
            NameValue nameVal = this.getItemAt(i);
            str.append(nameVal.getName());
            str.append("=");
            str.append(nameVal.getValue());
        }
        str.append("]");
        return str.toString();
    }
}

