/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.app;

import com.sun.jna.Platform;
import java.io.File;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import org.filesys.app.DriveMappingsConfigSection;
import org.filesys.app.XMLServerConfiguration;
import org.filesys.debug.Debug;
import org.filesys.debug.DebugConfigSection;
import org.filesys.netbios.server.NetBIOSNameServer;
import org.filesys.oncrpc.nfs.NFSConfigSection;
import org.filesys.server.NetworkServer;
import org.filesys.server.ServerListener;
import org.filesys.server.config.ServerConfiguration;
import org.filesys.smb.SMBErrorText;
import org.filesys.smb.server.SMBConfigSection;
import org.filesys.smb.server.SMBServer;
import org.filesys.smb.util.DriveMapping;
import org.filesys.smb.util.DriveMappingList;
import org.filesys.util.ConsoleIO;
import org.filesys.util.win32.Win32Utils;

public class FileServer
implements ServerListener {
    protected static final String DEFAULT_CONFIGFILENAME = "fileserver.xml";
    private static final boolean CheckLocalIPAddress = false;
    protected static boolean m_shutdown = false;
    protected static boolean m_restart = false;
    protected static boolean m_allowShutViaConsole = true;
    protected static boolean m_dumpStackOnError = true;
    private ServerConfiguration m_srvConfig;
    private Thread m_mainThread;

    public static void main(String[] args) {
        FileServer fileServer = new FileServer();
        while (!m_shutdown) {
            fileServer.start(args);
            if (!m_restart) continue;
            Debug.println("Restarting server ...");
            Debug.println("--------------------------------------------------");
        }
    }

    protected FileServer() {
    }

    public static final void setAllowConsoleShutdown(boolean consoleShut) {
        m_allowShutViaConsole = consoleShut;
    }

    protected final void enableExceptionStackDump(boolean ena) {
        m_dumpStackOnError = ena;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void start(String[] args) {
        PrintStream out = this.createOutputStream();
        m_shutdown = true;
        m_restart = false;
        this.checkPoint(out, CheckPoint.Starting);
        this.m_srvConfig = null;
        try {
            this.checkPoint(out, CheckPoint.ConfigLoading);
            this.m_srvConfig = this.loadConfiguration(out, args);
            this.checkPoint(out, CheckPoint.ConfigLoaded);
        }
        catch (Exception ex) {
            this.checkPointError(out, CheckPoint.ConfigLoading, ex);
            return;
        }
        try {
            if (this.m_srvConfig.hasConfigSection("SMB")) {
                this.checkPoint(out, CheckPoint.CreateSMBServer);
                SMBConfigSection smbConfig = (SMBConfigSection)this.m_srvConfig.getConfigSection("SMB");
                if (smbConfig.hasNetBIOSSMB()) {
                    this.m_srvConfig.addServer(this.createNetBIOSServer(this.m_srvConfig));
                }
                this.m_srvConfig.addServer(this.createSMBServer(this.m_srvConfig));
            }
            if (this.m_srvConfig.hasConfigSection("FTP")) {
                this.checkPoint(out, CheckPoint.CreateFTPServer);
                this.m_srvConfig.addServer(this.createFTPServer(this.m_srvConfig));
            }
            if (this.m_srvConfig.hasConfigSection("NFS")) {
                this.checkPoint(out, CheckPoint.CreateNFSServer);
                NFSConfigSection nfsConfig = (NFSConfigSection)this.m_srvConfig.getConfigSection("NFS");
                if (nfsConfig.hasNFSPortMapper()) {
                    this.m_srvConfig.addServer(this.createNFSPortMapper(this.m_srvConfig));
                }
                this.m_srvConfig.addServer(this.createNFSMountServer(this.m_srvConfig));
                this.m_srvConfig.addServer(this.createNFSServer(this.m_srvConfig));
            }
            this.checkPoint(out, CheckPoint.ServerStart);
            DebugConfigSection dbgConfig = (DebugConfigSection)this.m_srvConfig.getConfigSection("Debug");
            for (int i = 0; i < this.m_srvConfig.numberOfServers(); ++i) {
                NetworkServer server = this.m_srvConfig.getServer(i);
                if (dbgConfig != null && dbgConfig.hasDebug()) {
                    Debug.println("Starting server " + server.getProtocolName() + " ...");
                }
                this.m_srvConfig.getServer(i).startServer();
            }
            this.checkPoint(out, CheckPoint.ServerStarted);
            boolean service = false;
            if (!ConsoleIO.isValid()) {
                service = true;
            }
            this.checkPoint(out, CheckPoint.Running);
            this.m_mainThread = Thread.currentThread();
            Runtime.getRuntime().addShutdownHook(new FileServerShutdownHook(this));
            m_shutdown = false;
            while (!m_shutdown && !m_restart) {
                if (!service && m_allowShutViaConsole) {
                    int inChar = ConsoleIO.readCharacter();
                    if (inChar == 120 || inChar == 88) {
                        m_shutdown = true;
                        continue;
                    }
                    if (inChar == 114 || inChar == 82) {
                        m_restart = true;
                        continue;
                    }
                    if (inChar == 115 || inChar == 83) {
                        this.dumpSessions(false);
                        continue;
                    }
                    if (inChar == 118 || inChar == 86) {
                        this.dumpSessions(true);
                        continue;
                    }
                    if (inChar == 103 || inChar == 71) {
                        Debug.println("Running garbage collection ...");
                        System.gc();
                        continue;
                    }
                    if (inChar != -1) continue;
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException inChar) {}
            }
            this.checkPoint(out, CheckPoint.ServerStop);
            int idx = this.m_srvConfig.numberOfServers() - 1;
            while (idx >= 0) {
                NetworkServer server = this.m_srvConfig.getServer(idx--);
                if (dbgConfig != null && dbgConfig.hasDebug()) {
                    Debug.println("Shutting server " + server.getProtocolName() + " ...");
                }
                server.shutdownServer(false);
            }
            this.m_srvConfig.closeConfiguration();
            this.checkPoint(out, CheckPoint.ServerStopped);
        }
        catch (Exception ex) {
            this.checkPointError(out, CheckPoint.ServerStarted, ex);
        }
        finally {
            int idx = this.m_srvConfig.numberOfServers() - 1;
            while (idx >= 0) {
                NetworkServer srv;
                if (!(srv = this.m_srvConfig.getServer(idx--)).isActive()) continue;
                srv.shutdownServer(true);
            }
        }
        this.checkPoint(out, CheckPoint.Finished);
        this.m_mainThread = null;
    }

    public final boolean isRunning() {
        return !m_shutdown && this.m_mainThread != null;
    }

    public final void requestShutdown() {
        m_shutdown = true;
        DebugConfigSection dbgConfig = (DebugConfigSection)this.m_srvConfig.getConfigSection("Debug");
        int idx = this.m_srvConfig.numberOfServers() - 1;
        while (idx >= 0) {
            NetworkServer server = this.m_srvConfig.getServer(idx--);
            if (dbgConfig != null && dbgConfig.hasDebug()) {
                Debug.println("Shutting server " + server.getProtocolName() + " ...");
            }
            server.shutdownServer(false);
        }
        this.m_srvConfig.closeConfiguration();
    }

    public static final void shutdownServer(String[] args) {
        m_shutdown = true;
    }

    protected NetworkServer createSMBServer(ServerConfiguration config) throws Exception {
        SMBServer smbServer = new SMBServer(config);
        if (Platform.isWindows() && config.hasConfigSection("DriveMappings")) {
            smbServer.addServerListener(this);
        }
        return smbServer;
    }

    protected NetworkServer createNetBIOSServer(ServerConfiguration config) throws Exception {
        return new NetBIOSNameServer(config);
    }

    protected NetworkServer createFTPServer(ServerConfiguration config) throws Exception {
        return this.createServer("org.filesys.ftp.FTPServer", config);
    }

    protected NetworkServer createNFSServer(ServerConfiguration config) throws Exception {
        return this.createServer("org.filesys.oncrpc.nfs.NFSServer", config);
    }

    protected NetworkServer createNFSMountServer(ServerConfiguration config) throws Exception {
        return this.createServer("org.filesys.oncrpc.mount.MountServer", config);
    }

    protected NetworkServer createNFSPortMapper(ServerConfiguration config) throws Exception {
        return this.createServer("org.filesys.oncrpc.portmap.PortMapperServer", config);
    }

    protected final NetworkServer createServer(String className, ServerConfiguration config) throws Exception {
        NetworkServer srv = null;
        Class[] classes = new Class[]{ServerConfiguration.class};
        Constructor<?> srvConstructor = Class.forName(className).getConstructor(classes);
        Object[] args = new Object[]{config};
        srv = (NetworkServer)srvConstructor.newInstance(args);
        return srv;
    }

    protected ServerConfiguration loadConfiguration(PrintStream out, String[] cmdLineArgs) throws Exception {
        String fileName = null;
        fileName = cmdLineArgs.length < 1 ? System.getProperty("user.home") + File.separator + DEFAULT_CONFIGFILENAME : cmdLineArgs[0];
        XMLServerConfiguration srvConfig = null;
        srvConfig = new XMLServerConfiguration();
        ((ServerConfiguration)srvConfig).loadConfiguration(fileName);
        return srvConfig;
    }

    protected PrintStream createOutputStream() {
        return System.out;
    }

    protected void checkPoint(PrintStream out, CheckPoint check) {
    }

    protected void checkPointError(PrintStream out, CheckPoint check, Exception ex) {
        String msg = "%% Error occurred";
        switch (check) {
            case ConfigLoading: {
                msg = "%% Failed to load server configuration";
                break;
            }
            case CheckIPAddress: {
                msg = "%% Failed to get local IP address details";
                break;
            }
            case ServerStarted: {
                msg = "%% Server error";
            }
        }
        out.println(msg);
        if (m_dumpStackOnError) {
            ex.printStackTrace(out);
        }
    }

    @Override
    public void serverStatusEvent(NetworkServer server, int event) {
        block5: {
            DriveMappingsConfigSection mapConfig;
            block6: {
                if (!(server instanceof SMBServer)) break block5;
                mapConfig = (DriveMappingsConfigSection)this.m_srvConfig.getConfigSection("DriveMappings");
                if (mapConfig == null) {
                    return;
                }
                if (event != 0) break block6;
                DriveMappingList mapList = mapConfig.getMappedDrives();
                for (int i = 0; i < mapList.numberOfMappings(); ++i) {
                    int sts;
                    DriveMapping driveMap = mapList.getMappingAt(i);
                    if (mapConfig.hasDebug()) {
                        Debug.println("Mapping drive " + driveMap.getLocalDrive() + " to " + driveMap.getRemotePath() + " ...");
                    }
                    if ((sts = Win32Utils.MapNetworkDrive(driveMap.getRemotePath(), driveMap.getLocalDrive(), driveMap.getUserName(), driveMap.getPassword(), driveMap.hasInteractive(), driveMap.hasPrompt())) == 0) continue;
                    Debug.println("Failed to map drive " + driveMap.getLocalDrive() + " to " + driveMap.getRemotePath() + ", status = " + SMBErrorText.ErrorString(8, sts));
                }
                break block5;
            }
            if (event != 2) break block5;
            DriveMappingList mapList = mapConfig.getMappedDrives();
            for (int i = 0; i < mapList.numberOfMappings(); ++i) {
                int sts;
                DriveMapping driveMap = mapList.getMappingAt(i);
                if (mapConfig.hasDebug()) {
                    Debug.println("Removing mapped drive " + driveMap.getLocalDrive() + " to " + driveMap.getRemotePath() + " ...");
                }
                if ((sts = Win32Utils.DeleteNetworkDrive(driveMap.getLocalDrive(), false, true)) == 0) continue;
                Debug.println("Failed to delete mapped drive " + driveMap.getLocalDrive() + " from " + driveMap.getRemotePath() + ", status = " + SMBErrorText.ErrorString(8, sts));
            }
        }
    }

    protected void dumpSessions(boolean verbose) {
        Debug.println("Dump the active server sessions lists:");
        for (int idx = 0; idx < this.m_srvConfig.numberOfServers(); ++idx) {
            NetworkServer curServer = this.m_srvConfig.getServer(idx);
            if (curServer == null || !curServer.isActive()) continue;
            curServer.dumpSessionLists(verbose);
        }
    }

    protected class FileServerShutdownHook
    extends Thread {
        private FileServer m_fileServer;

        public FileServerShutdownHook(FileServer fileServer) {
            this.m_fileServer = fileServer;
        }

        @Override
        public void run() {
            if (this.m_fileServer != null && this.m_fileServer.isRunning()) {
                this.m_fileServer.requestShutdown();
            }
        }
    }

    public static enum CheckPoint {
        Starting,
        ConfigLoading,
        ConfigLoaded,
        CheckIPAddress,
        CreateSMBServer,
        CreateFTPServer,
        CreateNFSServer,
        ServerStart,
        ServerStarted,
        Running,
        ServerStop,
        ServerStopped,
        Finished;

    }
}

