/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.audit;

import java.util.EnumSet;
import org.filesys.audit.AuditGroup;
import org.filesys.audit.AuditType;
import org.filesys.debug.DebugInterface;

public class Audit {
    private static DebugInterface m_audit = null;
    private static EnumSet<AuditGroup> m_enabledGroups = EnumSet.allOf(AuditGroup.class);

    private Audit() {
    }

    public static final DebugInterface getAuditInterface() {
        return m_audit;
    }

    public static final boolean isGroupEnabled(AuditGroup group) {
        if (m_enabledGroups == null) {
            return false;
        }
        return m_enabledGroups.contains((Object)group);
    }

    public static final boolean isGroupEnabled(AuditType typ) {
        if (m_enabledGroups == null) {
            return false;
        }
        return m_enabledGroups.contains((Object)Audit.getAuditGroup(typ));
    }

    public static final AuditGroup getAuditGroup(AuditType typ) {
        AuditGroup group = AuditGroup.LOGON;
        switch (typ) {
            case Logon: 
            case Logoff: {
                group = AuditGroup.LOGON;
                break;
            }
            case FileClose: 
            case FileCreate: 
            case FileDelete: 
            case FileMove: 
            case FileOpen: 
            case FileRename: {
                group = AuditGroup.FILE;
                break;
            }
            case SessionCreated: 
            case SessionClosed: {
                group = AuditGroup.SESSION;
            }
        }
        return group;
    }

    public static final void setAuditInterface(DebugInterface dbg) {
        m_audit = dbg;
    }

    public static final void setAuditGroups(EnumSet<AuditGroup> groups) {
        m_enabledGroups = groups;
    }

    public static final void println(String str) {
        m_audit.debugPrintln(str);
    }
}

