/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.audit;

import org.filesys.audit.Audit;
import org.filesys.debug.DebugInterface;
import org.filesys.server.config.ConfigSection;
import org.filesys.server.config.InvalidConfigurationException;
import org.filesys.server.config.ServerConfiguration;
import org.springframework.extensions.config.ConfigElement;

public class AuditConfigSection
extends ConfigSection {
    public static final String SectionName = "Audit";
    private DebugInterface m_auditDev;
    private ConfigElement m_auditParams;

    public AuditConfigSection(ServerConfiguration config) {
        super(SectionName, config);
    }

    public final DebugInterface getAudit() {
        return this.m_auditDev;
    }

    public final ConfigElement getAuditParameters() {
        return this.m_auditParams;
    }

    public final boolean hasAudit() {
        return this.m_auditDev != null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final int setAudit(String dbgClass, ConfigElement params) throws InvalidConfigurationException {
        int sts = 0;
        try {
            if (dbgClass != null) {
                Object obj = Class.forName(dbgClass).newInstance();
                if (!(obj instanceof DebugInterface)) throw new InvalidConfigurationException("Audit Debugclass does not implement the Debug interface");
                DebugInterface dbg = (DebugInterface)obj;
                dbg.initialize(params, this.getServerConfiguration());
                this.m_auditDev = dbg;
                this.m_auditParams = params;
                Audit.setAuditInterface(dbg);
                return sts;
            } else {
                this.m_auditDev = null;
                this.m_auditParams = null;
            }
            return sts;
        }
        catch (ClassNotFoundException ex) {
            throw new InvalidConfigurationException("Audit Debugclass not found, " + dbgClass);
        }
        catch (IllegalAccessException ex) {
            throw new InvalidConfigurationException("Cannot load audit debugclass " + dbgClass + ", access error");
        }
        catch (InstantiationException ex) {
            throw new InvalidConfigurationException("Cannot instantiate audit debugclass " + dbgClass);
        }
        catch (Exception ex) {
            throw new InvalidConfigurationException("Failed to initialize audit debug class, " + ex.toString());
        }
    }

    @Override
    public void closeConfig() {
        if (this.m_auditDev != null) {
            this.m_auditDev.close();
            this.m_auditDev = null;
        }
    }
}

