/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.client;

import java.net.InetAddress;
import org.filesys.netbios.NetBIOSSession;
import org.filesys.smb.DialectSelector;
import org.filesys.smb.Protocol;

public class SessionSettings {
    private int m_primaryProto = 1;
    private int m_secondaryProto = 2;
    private DialectSelector m_dialects;
    private int m_timeout = 30000;
    private int m_netbiosPort = 139;
    private int m_nativeSMBPort = 445;
    private String m_netbiosScopeId;
    private int m_netbiosNamePort = 137;
    private String m_subnetMask;
    private InetAddress m_WINSServer = NetBIOSSession.getDefaultWINSServer();
    private NetBIOSSession.LookupType m_lookupType = NetBIOSSession.getDefaultLookupType();
    private int m_lookupTmo = NetBIOSSession.getDefaultLookupTimeout();
    private boolean m_useWildcardName = NetBIOSSession.getDefaultWildcardFileServerName();
    private boolean m_updateProtocol;
    private int m_vcircuit;

    public SessionSettings() {
    }

    public SessionSettings(int primaryProto, int secondaryProto) {
        this.m_primaryProto = primaryProto;
        this.m_secondaryProto = secondaryProto;
    }

    public SessionSettings(int primaryProto, int secondaryProto, int tmo) {
        this.m_primaryProto = primaryProto;
        this.m_secondaryProto = secondaryProto;
        this.m_timeout = tmo;
    }

    public final int getPrimaryProtocol() {
        return this.m_primaryProto;
    }

    public final int getSecondaryProtocol() {
        return this.m_secondaryProto;
    }

    public final int getSessionTimeout() {
        return this.m_timeout;
    }

    public final DialectSelector getDialects() {
        return this.m_dialects;
    }

    public final int getNetBIOSSessionPort() {
        return this.m_netbiosPort;
    }

    public final int getNetBIOSNamePort() {
        return this.m_netbiosNamePort;
    }

    public final int getNativeSMBPort() {
        return this.m_nativeSMBPort;
    }

    public final boolean hasNetBIOSNameScope() {
        return this.m_netbiosScopeId != null;
    }

    public final String getNetBIOSNameScope() {
        return this.m_netbiosScopeId;
    }

    public final String getSubnetMask() {
        return this.m_subnetMask;
    }

    public final InetAddress getWINSServer() {
        return this.m_WINSServer;
    }

    public final NetBIOSSession.LookupType getLookupType() {
        return this.m_lookupType;
    }

    public final int getLookupTimeout() {
        return this.m_lookupTmo;
    }

    public final boolean useWildcardServerName() {
        return this.m_useWildcardName;
    }

    public final boolean hasUpdateProtocol() {
        return this.m_updateProtocol;
    }

    public final int getVirtualCircuit() {
        return this.m_vcircuit;
    }

    public final void setPrimaryProtocol(int proto) {
        this.m_primaryProto = proto;
    }

    public final void setSecondaryProtocol(int proto) {
        this.m_secondaryProto = proto;
    }

    public final void setSessionTimeout(int tmo) {
        this.m_timeout = tmo;
    }

    public final void setDialects(DialectSelector dialects) {
        this.m_dialects = dialects;
    }

    public final void setNetBIOSSessionPort(int port) {
        this.m_netbiosPort = port;
    }

    public final void setNetBIOSNamePort(int port) {
        this.m_netbiosNamePort = port;
    }

    public final void setNativeSMBPort(int port) {
        this.m_nativeSMBPort = port;
    }

    public final void setNetBIOSNameScope(String scope) {
        this.m_netbiosScopeId = scope;
    }

    public final void setSubnetMask(String mask) {
        this.m_subnetMask = mask;
    }

    public final void setWINSServer(InetAddress addr) {
        this.m_WINSServer = addr;
    }

    public final void setLookupType(NetBIOSSession.LookupType typ) {
        this.m_lookupType = typ;
    }

    public final void setLookupTimeout(int tmo) {
        this.m_lookupTmo = tmo;
    }

    public final void setUseWildcardServerName(boolean ena) {
        this.m_useWildcardName = ena;
    }

    public final void setUpdateProtocol(boolean updateProto) {
        this.m_updateProtocol = updateProto;
    }

    public final void setVirtualCircuit(int vc) {
        this.m_vcircuit = vc;
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("[");
        str.append(Protocol.asString(this.getPrimaryProtocol()));
        str.append(",");
        str.append(Protocol.asString(this.getSecondaryProtocol()));
        str.append(",Tmo=");
        str.append(this.getSessionTimeout());
        str.append("ms,Dialects=");
        str.append(this.getDialects());
        if (this.getNetBIOSSessionPort() != 139) {
            str.append(",NB Port=");
            str.append(this.getNetBIOSSessionPort());
        }
        if (this.getNativeSMBPort() != 445) {
            str.append(",CIFS Port=");
            str.append(this.getNativeSMBPort());
        }
        if (this.hasNetBIOSNameScope()) {
            str.append(",ScopeId=");
            str.append(this.getNetBIOSNameScope());
        }
        str.append(",VC=");
        str.append(this.getVirtualCircuit());
        str.append("]");
        return str.toString();
    }
}

