/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.client.admin;

import java.io.IOException;
import org.filesys.client.IPCSession;
import org.filesys.client.admin.IPCPipeFile;
import org.filesys.smb.SMBException;
import org.filesys.smb.dcerpc.DCEBuffer;
import org.filesys.smb.dcerpc.DCEBufferException;
import org.filesys.smb.dcerpc.client.DCEPacket;
import org.filesys.smb.dcerpc.info.ConnectionInfoList;
import org.filesys.smb.dcerpc.info.ServerFileInfoList;
import org.filesys.smb.dcerpc.info.ServerInfo;
import org.filesys.smb.dcerpc.info.SessionInfoList;
import org.filesys.smb.dcerpc.info.ShareInfo;
import org.filesys.smb.dcerpc.info.ShareInfoList;

public class SrvsvcPipeFile
extends IPCPipeFile {
    public SrvsvcPipeFile(IPCSession sess, DCEPacket pkt, int handle, String name, int maxTx, int maxRx) {
        super(sess, pkt, handle, name, maxTx, maxRx);
    }

    public final ServerInfo getServerInformation() throws IOException, SMBException {
        String remName = "\\\\" + this.getSession().getPCShare().getNodeName();
        DCEBuffer buf = this.getBuffer();
        buf.resetBuffer();
        buf.putPointer(true);
        buf.putString(remName, 1, true);
        buf.putInt(101);
        DCEPacket pkt = this.getPacket();
        try {
            pkt.initializeDCERequest(this.getHandle(), 21, buf, this.getMaximumTransmitSize(), this.getNextCallId());
        }
        catch (DCEBufferException ex) {
            ex.printStackTrace();
        }
        this.doDCERequest(pkt);
        DCEBuffer rxBuf = this.getRxBuffer();
        ServerInfo srvInfo = new ServerInfo();
        try {
            this.checkStatus(rxBuf.getStatusCode());
            srvInfo.readObject(rxBuf);
        }
        catch (DCEBufferException dCEBufferException) {
            // empty catch block
        }
        return srvInfo;
    }

    public final ShareInfoList getShareList() throws IOException, SMBException {
        return this.getShareList(false);
    }

    public final ShareInfoList getShareList(boolean wantAdmin) throws IOException, SMBException {
        String remName = "\\\\" + this.getSession().getPCShare().getNodeName();
        DCEBuffer buf = this.getBuffer();
        buf.resetBuffer();
        buf.putPointer(true);
        buf.putString(remName, 1, true);
        buf.putInt(1);
        buf.putInt(1);
        buf.putPointer(true);
        buf.putInt(0);
        buf.putPointer(false);
        buf.putInt(-1);
        buf.putInt(0);
        DCEPacket pkt = this.getPacket();
        try {
            pkt.initializeDCERequest(this.getHandle(), wantAdmin ? 15 : 36, buf, this.getMaximumTransmitSize(), this.getNextCallId());
        }
        catch (DCEBufferException ex) {
            ex.printStackTrace();
        }
        this.doDCERequest(pkt);
        DCEBuffer rxBuf = this.getRxBuffer();
        ShareInfoList shrList = null;
        try {
            this.checkStatus(buf.getStatusCode());
            shrList = new ShareInfoList(rxBuf);
            shrList.readList(rxBuf);
        }
        catch (DCEBufferException dCEBufferException) {
            // empty catch block
        }
        return shrList;
    }

    public final ShareInfo getShareInformation(String shareName) throws IOException, SMBException {
        return this.getShareInformation(shareName, 2);
    }

    public final ShareInfo getShareInformation(String shareName, int infoLevel) throws IOException, SMBException {
        String remName = "\\\\" + this.getSession().getPCShare().getNodeName();
        DCEBuffer buf = this.getBuffer();
        buf.resetBuffer();
        buf.putPointer(true);
        buf.putString(remName, 1, true);
        buf.putString(shareName, 1, true);
        buf.putInt(infoLevel);
        DCEPacket pkt = this.getPacket();
        try {
            pkt.initializeDCERequest(this.getHandle(), 16, buf, this.getMaximumTransmitSize(), this.getNextCallId());
        }
        catch (DCEBufferException ex) {
            ex.printStackTrace();
        }
        this.doDCERequest(pkt);
        DCEBuffer rxBuf = this.getRxBuffer();
        ShareInfo shrInfo = new ShareInfo(infoLevel);
        try {
            this.checkStatus(rxBuf.getStatusCode());
            rxBuf.getInt();
            if (rxBuf.getPointer() != 0) {
                shrInfo.readObject(rxBuf);
                shrInfo.readStrings(rxBuf);
            }
        }
        catch (DCEBufferException dCEBufferException) {
            // empty catch block
        }
        return shrInfo;
    }

    public final SessionInfoList getSessionList(String clientName, String userName) throws IOException, SMBException {
        String remName = "\\\\" + this.getSession().getPCShare().getNodeName();
        DCEBuffer buf = this.getBuffer();
        buf.resetBuffer();
        buf.putPointer(true);
        buf.putString(remName, 1, true);
        if (clientName != null) {
            buf.putPointer(true);
            buf.putString(clientName, 1, true);
        } else {
            buf.putPointer(false);
        }
        if (userName != null) {
            buf.putPointer(true);
            buf.putString(userName, 1, true);
        } else {
            buf.putPointer(false);
        }
        buf.putInt(2);
        buf.putInt(2);
        buf.putPointer(true);
        buf.putInt(0);
        buf.putPointer(false);
        buf.putInt(-1);
        buf.putPointer(false);
        DCEPacket pkt = this.getPacket();
        try {
            pkt.initializeDCERequest(this.getHandle(), 12, buf, this.getMaximumTransmitSize(), this.getNextCallId());
        }
        catch (DCEBufferException ex) {
            ex.printStackTrace();
        }
        this.doDCERequest(pkt);
        DCEBuffer rxBuf = this.getRxBuffer();
        SessionInfoList sessList = null;
        try {
            this.checkStatus(rxBuf.getStatusCode());
            sessList = new SessionInfoList(rxBuf);
            sessList.readList(rxBuf);
        }
        catch (DCEBufferException dCEBufferException) {
            // empty catch block
        }
        return sessList;
    }

    public final ConnectionInfoList getConnectionList(String clientOrShare) throws IOException, SMBException {
        String remName = "\\\\" + this.getSession().getPCShare().getNodeName();
        DCEBuffer buf = this.getBuffer();
        buf.resetBuffer();
        buf.putPointer(true);
        buf.putString(remName, 1, true);
        buf.putPointer(true);
        buf.putString(clientOrShare, 1, true);
        buf.putInt(1);
        buf.putInt(1);
        buf.putPointer(true);
        buf.putInt(0);
        buf.putPointer(false);
        buf.putInt(-1);
        buf.putPointer(false);
        DCEPacket pkt = this.getPacket();
        try {
            pkt.initializeDCERequest(this.getHandle(), 8, buf, this.getMaximumTransmitSize(), this.getNextCallId());
        }
        catch (DCEBufferException ex) {
            ex.printStackTrace();
        }
        this.doDCERequest(pkt);
        DCEBuffer rxBuf = this.getRxBuffer();
        ConnectionInfoList connList = null;
        try {
            this.checkStatus(rxBuf.getStatusCode());
            connList = new ConnectionInfoList(rxBuf);
            connList.readList(rxBuf);
        }
        catch (DCEBufferException dCEBufferException) {
            // empty catch block
        }
        return connList;
    }

    public final ServerFileInfoList getOpenFileList() throws IOException, SMBException {
        String remName = "\\\\" + this.getSession().getPCShare().getNodeName();
        DCEBuffer buf = this.getBuffer();
        buf.resetBuffer();
        buf.putPointer(true);
        buf.putString(remName, 1, true);
        buf.putPointer(false);
        buf.putPointer(false);
        buf.putInt(3);
        buf.putInt(3);
        buf.putPointer(true);
        buf.putInt(0);
        buf.putPointer(false);
        buf.putInt(-1);
        buf.putPointer(false);
        DCEPacket pkt = this.getPacket();
        try {
            pkt.initializeDCERequest(this.getHandle(), 9, buf, this.getMaximumTransmitSize(), this.getNextCallId());
        }
        catch (DCEBufferException ex) {
            ex.printStackTrace();
        }
        this.doDCERequest(pkt);
        DCEBuffer rxBuf = this.getRxBuffer();
        ServerFileInfoList fileList = null;
        try {
            this.checkStatus(rxBuf.getStatusCode());
            fileList = new ServerFileInfoList(rxBuf);
            fileList.readList(rxBuf);
        }
        catch (DCEBufferException dCEBufferException) {
            // empty catch block
        }
        return fileList;
    }
}

