/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.client.demo;

import java.io.PrintStream;
import java.text.SimpleDateFormat;
import org.filesys.client.DiskSession;
import org.filesys.client.SearchContext;
import org.filesys.client.SessionFactory;
import org.filesys.client.demo.BaseApp;
import org.filesys.client.info.FileInfo;
import org.filesys.smb.InvalidUNCPathException;
import org.filesys.smb.PCShare;
import org.filesys.smb.SMBDate;
import org.filesys.util.MemorySize;
import org.filesys.util.NameValue;
import org.filesys.util.NameValueList;

public class srvDir
extends BaseApp {
    private SimpleDateFormat m_formatter;

    public srvDir() {
        super("srvDir", "Remote directory listing utility");
    }

    @Override
    protected void outputCommandHelp(PrintStream out) {
        out.println("Usage: srvDir \\\\<host>|<ip_address>\\<share_name>[\\<path\\<filespec>]");
        out.println("  The UNC path to the file/folder may use forward or backslash characters.");
        out.println("  Access control may be embedded in the UNC path using:-");
        out.println("    \\\\<host>\\<share>[%username][:<password.]\\<path>\\...");
    }

    @Override
    protected void doCommand(PrintStream out) throws Exception {
        PCShare remPath = this.getShare();
        DiskSession sess = SessionFactory.OpenDisk(remPath);
        this.setSession(sess);
        SearchContext srch = sess.StartSearch(remPath.getRelativePath(), 16);
        int fileCnt = 0;
        FileInfo finfo = srch.nextFileInfo();
        while (finfo != null) {
            this.formatOutput(System.out, finfo.getFileName(), 30, finfo.getFormattedAttributes(), 6, finfo.isDirectory() ? "" : MemorySize.asScaledString(finfo.getSize()), 32778, this.formatDate(finfo.getModifyDateTime(), finfo.getCreationDateTime()), -1);
            finfo = srch.nextFileInfo();
            ++fileCnt;
        }
        if (fileCnt > 0) {
            System.out.println();
        }
        System.out.println("Total of " + fileCnt + " files");
        sess.CloseSession();
        this.setSession(null);
    }

    @Override
    protected boolean validateCommandLine(NameValueList cmdLine, PrintStream out) {
        if (cmdLine.numberOfItems() > 3) {
            out.println("%% Wrong number of command line arguments");
            return false;
        }
        NameValue arg1 = cmdLine.findItem("Arg1");
        if (arg1 == null || arg1.getValue() == null || arg1.getValue().length() == 0) {
            out.println("%% Invalid command line argument, " + arg1 != null ? arg1.getValue() : "");
            return false;
        }
        PCShare share = null;
        try {
            share = new PCShare(arg1.getValue());
            if (share.getFileName() == null || share.getFileName().length() == 0) {
                share.setFileName("*");
            }
            this.setShare(share);
        }
        catch (InvalidUNCPathException ex) {
            out.println("%% Invalid UNC path, " + ex.toString());
            return false;
        }
        return true;
    }

    private final String formatDate(SMBDate modifyDate, SMBDate createDate) {
        SMBDate date;
        if (this.m_formatter == null) {
            this.m_formatter = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss.SSS");
        }
        if ((date = modifyDate) == null) {
            if (createDate != null) {
                date = createDate;
            } else {
                return "";
            }
        }
        return this.m_formatter.format(date);
    }

    public static void main(String[] args) {
        srvDir cmd = new srvDir();
        cmd.runCommand(args);
    }
}

