/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.client.demo;

import java.io.PrintStream;
import org.filesys.client.SessionFactory;
import org.filesys.client.demo.BaseApp;
import org.filesys.util.NameValue;
import org.filesys.util.NameValueList;

public class srvMessage
extends BaseApp {
    private String m_hostName;
    private String m_message;

    public srvMessage() {
        super("srvMessage", "Send message to remote host", false);
    }

    @Override
    protected void outputCommandHelp(PrintStream out) {
        out.println("Usage: srvMessage <host>|<ip_address> <message>");
    }

    @Override
    protected void doCommand(PrintStream out) throws Exception {
        SessionFactory.SendMessage(this.getHost(), this.getMessage());
        out.println("Message sent to " + this.getHost());
    }

    @Override
    protected boolean validateCommandLine(NameValueList cmdLine, PrintStream out) {
        if (cmdLine.numberOfItems() < 2) {
            out.println("%% Host name or address must be specified");
            return false;
        }
        NameValue arg1 = cmdLine.findItem("Arg1");
        if (arg1 == null || arg1.getValue() == null || arg1.getValue().length() == 0) {
            out.println("%% Invalid host name specified, " + arg1 != null ? arg1.getValue() : "");
            return false;
        }
        this.setHost(arg1.getValue());
        StringBuffer msgBuf = new StringBuffer(256);
        int cmdArg = 2;
        NameValue msgArg = cmdLine.findItem("Arg" + cmdArg++);
        while (msgArg != null) {
            msgBuf.append(msgArg.getValue());
            msgBuf.append(" ");
            msgArg = cmdLine.findItem("Arg" + cmdArg++);
        }
        if (msgBuf.length() > 0) {
            msgBuf.setLength(msgBuf.length() - 1);
        }
        this.setMessage(msgBuf.toString());
        return true;
    }

    protected final String getHost() {
        return this.m_hostName;
    }

    protected final String getMessage() {
        return this.m_message;
    }

    protected final void setHost(String host) {
        this.m_hostName = host;
    }

    protected final void setMessage(String msg) {
        this.m_message = msg;
    }

    public static void main(String[] args) {
        srvMessage cmd = new srvMessage();
        cmd.runCommand(args);
    }
}

