/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.client.demo;

import java.io.PrintStream;
import java.text.SimpleDateFormat;
import org.filesys.client.CIFSDiskSession;
import org.filesys.client.CIFSFile;
import org.filesys.client.DiskSession;
import org.filesys.client.SessionFactory;
import org.filesys.client.admin.AdminSession;
import org.filesys.client.admin.SamrPipeFile;
import org.filesys.client.demo.BaseApp;
import org.filesys.client.info.DeviceAttributesInfo;
import org.filesys.client.info.DiskInfo;
import org.filesys.client.info.ExtendedFileInfo;
import org.filesys.client.info.FileInfo;
import org.filesys.client.info.StreamInfo;
import org.filesys.server.filesys.FileAttribute;
import org.filesys.smb.InvalidUNCPathException;
import org.filesys.smb.PCShare;
import org.filesys.smb.SMBDate;
import org.filesys.smb.SharingMode;
import org.filesys.smb.nt.ACE;
import org.filesys.smb.nt.ACL;
import org.filesys.smb.nt.SecurityDescriptor;
import org.filesys.util.MemorySize;
import org.filesys.util.NameValue;
import org.filesys.util.NameValueList;

public class srvStat
extends BaseApp {
    private boolean m_basicInfo = false;
    private SimpleDateFormat m_formatter;

    public srvStat() {
        super("srvStat", "Remote file/folder detailed information");
    }

    @Override
    protected void outputCommandHelp(PrintStream out) {
        out.println("Usage: srvStat \\\\<host>|<ip_address>\\<share_name>[\\<path\\<file>");
        out.println("  The UNC path to the file/folder may use forward or backslash characters.");
        out.println("  Access control may be embedded in the UNC path using:-");
        out.println("    \\\\<host>\\<share>[%username][:<password.]\\<path>\\...");
    }

    @Override
    protected void doCommand(PrintStream out) throws Exception {
        PCShare share = this.getShare();
        DiskSession sess = SessionFactory.OpenDisk(share);
        this.setSession(sess);
        String path = share.getRelativePath();
        if (!sess.FileExists(path) && !sess.isDirectory(path)) {
            out.println("%% File/folder does not exist - " + path);
        } else if (!this.m_basicInfo && sess instanceof CIFSDiskSession) {
            CIFSDiskSession cifsSess = (CIFSDiskSession)sess;
            DeviceAttributesInfo fileSys = cifsSess.NTGetDeviceAttributes();
            DiskInfo diskInfo = cifsSess.getDiskInformation();
            CIFSFile statFile = cifsSess.NTCreate(path, 131209, 128, SharingMode.READ_WRITE.intValue(), 1, 0L, 0);
            FileInfo fInfo = cifsSess.NTGetFileInformation(statFile.getFileId(), 263);
            out.println("File name : " + path);
            out.println();
            out.println("Creation date : " + this.formatDate(fInfo.getCreationDateTime()));
            out.println("Last access   : " + this.formatDate(fInfo.getAccessDateTime()));
            out.println("Last write    : " + this.formatDate(fInfo.getModifyDateTime()));
            out.println();
            out.println("File size       : " + MemorySize.asScaledString(fInfo.getSize()) + " (" + fInfo.getSize() + " bytes)");
            out.println("Allocation size : " + MemorySize.asScaledString(fInfo.getAllocationSize()) + " (" + fInfo.getAllocationSize() + " bytes)");
            out.println();
            out.println("Attributes : " + FileAttribute.getNTAttributesAsString(fInfo.getFileAttributes()));
            out.println("Filesystem : " + fileSys.getFileSystemName() + ", Free space " + MemorySize.asScaledString(diskInfo.getDiskFreeSizeBytes()) + ", Total space " + MemorySize.asScaledString(diskInfo.getDiskSizeBytes()));
            if (fileSys.getFileSystemName().equals("NTFS")) {
                ExtendedFileInfo streamInfo = (ExtendedFileInfo)cifsSess.NTGetFileInformation(statFile.getFileId(), 265);
                if (streamInfo != null && streamInfo.hasNTFSStreams()) {
                    out.println();
                    out.println("NTFS Streams :");
                    for (int i = 0; i < streamInfo.numberOfNTFSStreams(); ++i) {
                        StreamInfo sInfo = streamInfo.getNTFSStreams().getStreamAt(i);
                        out.println("  Name : " + sInfo.getName());
                        out.println("    Size       : " + MemorySize.asScaledString(sInfo.getSize()) + " (" + sInfo.getSize() + " bytes)");
                        out.println("    Allocation : " + MemorySize.asScaledString(sInfo.getAllocationSize()) + " (" + sInfo.getAllocationSize() + " bytes)");
                    }
                    out.println();
                }
                int flags = 7;
                SecurityDescriptor secDesc = cifsSess.NTQuerySecurityDescriptor(statFile.getFileId(), flags);
                if (secDesc != null) {
                    AdminSession admSess = SessionFactory.OpenAdminSession(this.getShare());
                    SamrPipeFile samr = admSess.openSecurityAccountsManagerPipe();
                    samr.lookupName(secDesc.getOwner());
                    samr.lookupName(secDesc.getGroup());
                    out.println("Security descriptor:");
                    out.println("  Owner : " + secDesc.getOwner());
                    out.println("  Group : " + secDesc.getGroup());
                    out.println("  DACL:");
                    ACL acl = secDesc.getDACL();
                    for (int i = 0; i < acl.numberOfEntries(); ++i) {
                        ACE ace = acl.getACE(i);
                        samr.lookupName(ace.getSID());
                        out.print("     ");
                        this.formatOutput(out, ace.getTypeAsString(), 10, ace.getAccessMaskAsString(), 14, ace.getSID().toString(), -1);
                    }
                    admSess.CloseSession();
                }
            }
            statFile.Close();
        } else {
            DiskInfo diskInfo = sess.getDiskInformation();
            FileInfo fInfo = sess.getFileInformation(path);
            out.println("File name : " + path);
            out.println();
            out.println("Creation date : " + this.formatDate(fInfo.getCreationDateTime()));
            out.println("Last access   : " + this.formatDate(fInfo.getAccessDateTime()));
            out.println("Last write    : " + this.formatDate(fInfo.getModifyDateTime()));
            out.println();
            out.println("File size       : " + MemorySize.asScaledString(fInfo.getSize()) + " (" + fInfo.getSize() + " bytes)");
            out.println("Allocation size : " + MemorySize.asScaledString(fInfo.getAllocationSize()) + " (" + fInfo.getAllocationSize() + " bytes)");
            out.println();
            out.println("Attributes : " + FileAttribute.getNTAttributesAsString(fInfo.getFileAttributes()));
            out.println("Filesystem : Free space " + MemorySize.asScaledString(diskInfo.getDiskFreeSizeBytes()) + ", Total space " + MemorySize.asScaledString(diskInfo.getDiskSizeBytes()));
        }
        sess.CloseSession();
        this.setSession(null);
    }

    @Override
    protected boolean validateCommandLine(NameValueList cmdLine, PrintStream out) {
        if (cmdLine.numberOfItems() < 1) {
            out.println("%% Wrong number of command line arguments");
            return false;
        }
        NameValue arg1 = cmdLine.findItem("Arg1");
        if (arg1 == null || arg1.getValue() == null || arg1.getValue().length() == 0) {
            out.println("%% Invalid command line argument, " + arg1 != null ? arg1.getValue() : "");
            return false;
        }
        PCShare share = null;
        try {
            share = new PCShare(arg1.getValue());
            this.setShare(share);
        }
        catch (InvalidUNCPathException ex) {
            out.println("%% Invalid UNC path, " + ex.toString());
            return false;
        }
        if (cmdLine.findItemCaseless("basic") != null) {
            this.m_basicInfo = true;
        }
        return true;
    }

    private final String formatDate(SMBDate date) {
        if (this.m_formatter == null) {
            this.m_formatter = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss.SSS");
        }
        if (date == null) {
            return "<Not Specified>";
        }
        return this.m_formatter.format(date);
    }

    public static void main(String[] args) {
        srvStat cmd = new srvStat();
        cmd.runCommand(args);
    }
}

