/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.client.info;

import org.filesys.smb.SMBDate;

public class FileInfo {
    protected String m_name;
    protected String m_shortName;
    protected String m_path;
    protected long m_size;
    protected int m_attr;
    private SMBDate m_datetime;
    private SMBDate m_createDate;
    private SMBDate m_accessDate;
    private long m_allocSize;
    private int m_fileId = -1;

    public FileInfo() {
    }

    public FileInfo(String fname, long fsize, int fattr) {
        this.m_name = fname;
        this.m_size = fsize;
        this.m_attr = fattr;
        this.m_datetime = null;
        this.setAllocationSize(0L);
    }

    public FileInfo(String fname, long fsize, int fattr, int ftime) {
        this.m_name = fname;
        this.m_size = fsize;
        this.m_attr = fattr;
        this.m_datetime = new SMBDate(ftime);
        this.setAllocationSize(0L);
    }

    public FileInfo(String fname, long fsize, int fattr, int fdate, int ftime) {
        this.m_name = fname;
        this.m_size = fsize;
        this.m_attr = fattr;
        if (fdate != 0 && ftime != 0) {
            this.m_datetime = new SMBDate(fdate, ftime);
        }
        this.setAllocationSize(0L);
    }

    public FileInfo(String fpath, String fname, long fsize, int fattr) {
        this.m_path = fpath;
        this.m_name = fname;
        this.m_size = fsize;
        this.m_attr = fattr;
        this.m_datetime = null;
        this.setAllocationSize(0L);
    }

    public FileInfo(String fpath, String fname, long fsize, int fattr, int ftime) {
        this.m_path = fpath;
        this.m_name = fname;
        this.m_size = fsize;
        this.m_attr = fattr;
        this.m_datetime = new SMBDate(ftime);
        this.setAllocationSize(0L);
    }

    public FileInfo(String fpath, String fname, long fsize, int fattr, int fdate, int ftime) {
        this.m_path = fpath;
        this.m_name = fname;
        this.m_size = fsize;
        this.m_attr = fattr;
        this.m_datetime = new SMBDate(fdate, ftime);
        this.setAllocationSize(0L);
    }

    public SMBDate getAccessDateTime() {
        return this.m_accessDate;
    }

    public long getAllocationSize() {
        return this.m_allocSize;
    }

    public int getAllocationSizeInt() {
        return (int)(this.m_allocSize & 0xFFFFFFFFL);
    }

    public SMBDate getCreationDateTime() {
        return this.m_createDate;
    }

    public int getFileAttributes() {
        return this.m_attr;
    }

    public final String getFileName() {
        return this.m_name;
    }

    public final boolean hasShortName() {
        return this.m_shortName != null;
    }

    public final String getShortName() {
        return this.m_shortName;
    }

    public final SMBDate getModifyDateTime() {
        return this.m_datetime;
    }

    public final String getPath() {
        return this.m_path;
    }

    public final long getSize() {
        return this.m_size;
    }

    public final int getSizeInt() {
        return (int)(this.m_size & 0xFFFFFFFFL);
    }

    public final int getFileId() {
        return this.m_fileId;
    }

    public boolean hasAccessDateTime() {
        return this.m_accessDate != null;
    }

    public boolean hasCreationDateTime() {
        return this.m_createDate != null;
    }

    public boolean hasModifyDateTime() {
        return this.m_datetime != null;
    }

    public final boolean hasAttribute(int attr) {
        return (this.m_attr & attr) != 0;
    }

    public final boolean isDirectory() {
        return (this.m_attr & 0x10) != 0;
    }

    public final boolean isHidden() {
        return (this.m_attr & 2) != 0;
    }

    public final boolean isReadOnly() {
        return (this.m_attr & 1) != 0;
    }

    public final boolean isSystem() {
        return (this.m_attr & 4) != 0;
    }

    public final boolean isArchived() {
        return (this.m_attr & 0x20) != 0;
    }

    public final boolean isCompressed() {
        return (this.m_attr & 0x800) != 0;
    }

    public final boolean isOffline() {
        return (this.m_attr & 0x1000) != 0;
    }

    public final boolean isEncrypted() {
        return (this.m_attr & 0x4000) != 0;
    }

    public final boolean isTemporary() {
        return (this.m_attr & 0x100) != 0;
    }

    public final boolean isIndexed() {
        return (this.m_attr & 0x2000) != 0;
    }

    public final void resetInfo() {
        this.m_name = "";
        this.m_path = null;
        this.m_size = 0L;
        this.m_allocSize = 0L;
        this.m_attr = 0;
        this.m_accessDate = null;
        this.m_createDate = null;
        this.m_datetime = null;
        this.m_fileId = -1;
    }

    public void setAccessDateTime(int dat, int tim) {
        this.m_accessDate = new SMBDate(dat, tim);
    }

    public void setAccessDateTime(SMBDate dattim) {
        this.m_accessDate = dattim;
    }

    public void setAllocationSize(long siz) {
        this.m_allocSize = siz;
    }

    public void setCreationDateTime(int dat, int tim) {
        this.m_createDate = new SMBDate(dat, tim);
    }

    public void setCreationDateTime(SMBDate dattim) {
        this.m_createDate = dattim;
    }

    public final void setFileName(String name) {
        this.m_name = name;
    }

    public final void setFileSize(long siz) {
        this.m_size = siz;
    }

    public void setModifyDateTime(int dat, int tim) {
        this.m_datetime = new SMBDate(dat, tim);
    }

    public final void setModifyDateTime(SMBDate datetime) {
        this.m_datetime = datetime;
    }

    public final void setFileId(int id) {
        this.m_fileId = id;
    }

    public final void setShortName(String name) {
        this.m_shortName = name;
    }

    public final void setPath(String path) {
        this.m_path = path;
    }

    public final void setSize(int siz) {
        this.m_size = siz;
    }

    public final void setSize(long siz) {
        this.m_size = siz;
    }

    public final String getFormattedAttributes() {
        StringBuffer str = new StringBuffer();
        if (this.isReadOnly()) {
            str.append("R");
        } else {
            str.append("-");
        }
        if (this.isHidden()) {
            str.append("H");
        } else {
            str.append("-");
        }
        if (this.isSystem()) {
            str.append("S");
        } else {
            str.append("-");
        }
        if (this.isDirectory()) {
            str.append("D");
        } else {
            str.append("-");
        }
        return str.toString();
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        if (this.m_path != null) {
            str.append(this.m_path);
            if (!this.m_path.endsWith("\\")) {
                str.append("\\");
            }
        }
        str.append(this.m_name);
        while (str.length() < 15) {
            str.append(" ");
        }
        if (this.isReadOnly()) {
            str.append("R");
        } else {
            str.append("-");
        }
        if (this.isHidden()) {
            str.append("H");
        } else {
            str.append("-");
        }
        if (this.isSystem()) {
            str.append("S");
        } else {
            str.append("-");
        }
        if (this.isDirectory()) {
            str.append("D");
        } else {
            str.append("-");
        }
        str.append(" ");
        str.append(this.m_size);
        while (str.length() < 30) {
            str.append(" ");
        }
        if (this.m_datetime != null) {
            str.append(" - ");
            str.append(this.m_datetime.toString());
        }
        if (this.hasShortName()) {
            str.append(" (");
            str.append(this.getShortName());
            str.append(")");
        }
        return str.toString();
    }

    public final void setFileAttributes(int attr) {
        this.m_attr = attr;
    }
}

