/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.locking;

import java.io.Serializable;
import org.filesys.server.locking.LockParams;

public class FileLock
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final long LockWholeFile = -1L;
    private long m_offset;
    private long m_length;
    private int m_pid;
    private int m_flags;

    protected FileLock() {
    }

    public FileLock(long offset, long len, int pid) {
        this.setOffset(offset);
        this.setLength(len);
        this.setProcessId(pid);
    }

    public FileLock(LockParams params) {
        this.setOffset(params.getOffset());
        this.setLength(params.getLength());
        this.setProcessId(params.getOwner());
        this.setFlags(params.getFlags());
    }

    public final long getOffset() {
        return this.m_offset;
    }

    public final void setOffset(long offset) {
        this.m_offset = offset;
    }

    public final long getLength() {
        return this.m_length;
    }

    public final void setLength(long len) {
        this.m_length = len < 0L ? -1L : len;
    }

    public final int getProcessId() {
        return this.m_pid;
    }

    public final int getFlags() {
        return this.m_flags;
    }

    public final boolean isWholeFile() {
        return this.m_length == -1L;
    }

    public final void setProcessId(int pid) {
        this.m_pid = pid;
    }

    public final void setFlags(int flags) {
        this.m_flags = flags;
    }

    public final boolean hasOverlap(FileLock lock) {
        return this.hasOverlap(lock.getOffset(), lock.getLength());
    }

    public final boolean hasOverlap(long offset, long len) {
        if (this.isWholeFile()) {
            return true;
        }
        long endOff = this.getOffset() + (this.getLength() - 1L);
        if (this.getOffset() < offset && endOff < offset) {
            return false;
        }
        endOff = offset + (len - 1L);
        return this.getOffset() <= endOff;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("[Owner=");
        str.append(this.getProcessId());
        str.append(",Offset=");
        str.append(this.getOffset());
        str.append(",Len=");
        str.append(this.getLength());
        str.append(",flags=0x");
        str.append(Integer.toHexString(this.getFlags()));
        str.append("]");
        return str.toString();
    }
}

