/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.netbios;

import java.io.IOException;
import java.net.UnknownHostException;

public abstract class NetworkSession {
    private static int _defTimeout = 30000;
    private String m_protoName;
    private int m_tmo = _defTimeout;

    public NetworkSession(String protoName) {
        this.m_protoName = protoName;
    }

    public final String getProtocolName() {
        return this.m_protoName;
    }

    public abstract void Open(String var1, String var2, String var3) throws IOException, UnknownHostException;

    public abstract boolean isConnected();

    public abstract boolean hasData() throws IOException;

    public final int getTimeout() {
        return this.m_tmo;
    }

    public abstract int Receive(byte[] var1) throws IOException;

    public abstract boolean Send(byte[] var1, int var2) throws IOException;

    public abstract void Close() throws IOException;

    public void setTimeout(int tmo) {
        this.m_tmo = tmo;
    }

    public static final int getDefaultTimeout() {
        return _defTimeout;
    }

    public static final void setDefaultTimeout(int tmo) {
        _defTimeout = tmo;
    }
}

