/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.netbios;

public final class RFCNetBIOSProtocol {
    public static final int SESSION = 139;
    public static final int DATAGRAM = 138;
    public static final int NAMING = 137;
    public static final int TMO = 30000;
    public static final int HEADER_LEN = 4;
    public static final int SESSREQ_LEN = 72;
    public static final int SESSRESP_LEN = 9;
    public static final int MaxPacketSize = 131075;

    public static enum MsgType {
        MESSAGE(0),
        REQUEST(129),
        ACK(130),
        REJECT(131),
        RETARGET(132),
        KEEPALIVE(133),
        INVALID(-1);

        private final int msgType;

        private MsgType(int typ) {
            this.msgType = typ;
        }

        public final int intValue() {
            return this.msgType;
        }

        public static final MsgType fromInt(int typ) {
            MsgType msgType = INVALID;
            switch (typ) {
                case 0: {
                    msgType = MESSAGE;
                    break;
                }
                case 129: {
                    msgType = REQUEST;
                    break;
                }
                case 130: {
                    msgType = ACK;
                    break;
                }
                case 131: {
                    msgType = REJECT;
                    break;
                }
                case 132: {
                    msgType = RETARGET;
                    break;
                }
                case 133: {
                    msgType = KEEPALIVE;
                }
            }
            return msgType;
        }
    }
}

