/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.netbios.server;

import org.filesys.netbios.NetBIOSName;

class NetBIOSRequest {
    public static final int DefaultRetries = 5;
    public static final long DefaultInterval = 2000L;
    private Type m_type;
    private NetBIOSName m_nbName;
    private int m_retry;
    private long m_retryIntvl;
    private boolean m_error;
    private int m_tranId;

    public NetBIOSRequest(Type typ, NetBIOSName nbName, int tranId) {
        this.m_type = typ;
        this.m_nbName = nbName;
        this.m_tranId = tranId;
        this.m_retry = 5;
        this.m_retryIntvl = 2000L;
        this.m_error = false;
    }

    public NetBIOSRequest(Type typ, NetBIOSName nbName, int tranId, int retry) {
        this.m_type = typ;
        this.m_nbName = nbName;
        this.m_tranId = tranId;
        this.m_retry = retry;
        this.m_retryIntvl = 2000L;
        this.m_error = false;
    }

    public final Type isType() {
        return this.m_type;
    }

    public final NetBIOSName getNetBIOSName() {
        return this.m_nbName;
    }

    public final int getRetryCount() {
        return this.m_retry;
    }

    public final long getRetryInterval() {
        return this.m_retryIntvl;
    }

    public final int getTransactionId() {
        return this.m_tranId;
    }

    public final boolean hasErrorStatus() {
        return this.m_error;
    }

    protected final int decrementRetryCount() {
        return this.m_retry--;
    }

    protected final void setErrorStatus(boolean sts) {
        this.m_error = sts;
    }

    public final void setRetryCount(int retry) {
        this.m_retry = retry;
    }

    public final void setRetryInterval(long interval) {
        this.m_retryIntvl = interval;
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("[");
        str.append(this.isType().name());
        str.append(":");
        str.append(this.getNetBIOSName());
        str.append(",");
        str.append(this.getRetryCount());
        str.append(",");
        str.append(this.getRetryInterval());
        str.append(",");
        str.append(this.getTransactionId());
        str.append("]");
        return str.toString();
    }

    public static enum Type {
        ADD_NAME,
        DELETE_NAME,
        REFRESH_NAME;

    }
}

