/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.oncrpc;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import org.filesys.oncrpc.MultiThreadedTcpRpcPacketHandler;
import org.filesys.oncrpc.RpcPacket;
import org.filesys.oncrpc.RpcPacketPool;
import org.filesys.oncrpc.RpcProcessor;
import org.filesys.oncrpc.TcpRpcPacketHandler;
import org.filesys.oncrpc.TcpRpcSessionHandler;
import org.filesys.server.NetworkServer;
import org.filesys.server.core.NoPooledMemoryException;
import org.filesys.server.thread.ThreadRequestPool;

public class MultiThreadedTcpRpcSessionHandler
extends TcpRpcSessionHandler {
    public static final int DefaultPacketPoolSize = 50;
    public static final int DefaultSmallPacketSize = 512;
    private RpcPacketPool m_packetPool;
    private ThreadRequestPool m_threadPool;

    public MultiThreadedTcpRpcSessionHandler(String name, String protocol, RpcProcessor rpcServer, NetworkServer server, InetAddress addr, int port, int maxSize) {
        super(name, protocol, rpcServer, server, addr, port, maxSize);
    }

    public void initializeSessionHandler(NetworkServer server, RpcPacketPool pktPool, ThreadRequestPool threadPool) throws IOException {
        this.m_packetPool = pktPool;
        this.m_threadPool = threadPool;
        super.initializeSessionHandler(server);
    }

    protected final RpcPacket allocateRpcPacket(int size) throws NoPooledMemoryException {
        return this.m_packetPool.allocatePacket(size);
    }

    @Override
    protected TcpRpcPacketHandler createPacketHandler(int sessId, Socket sock) throws IOException {
        return new MultiThreadedTcpRpcPacketHandler(this, sessId, this.getRpcProcessor(), sock, this.getMaximumRpcSize(), this.m_packetPool, this.m_threadPool);
    }
}

