/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.oncrpc;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import org.filesys.debug.Debug;
import org.filesys.oncrpc.Rpc;
import org.filesys.oncrpc.RpcPacket;
import org.filesys.oncrpc.RpcPacketHandler;
import org.filesys.oncrpc.RpcPacketPool;
import org.filesys.oncrpc.RpcProcessor;
import org.filesys.oncrpc.RpcRequestQueue;
import org.filesys.oncrpc.RpcThreadRequest;
import org.filesys.oncrpc.UdpRpcDatagramHandler;
import org.filesys.server.NetworkServer;
import org.filesys.server.core.NoPooledMemoryException;
import org.filesys.server.thread.ThreadRequestPool;

public class MultiThreadedUdpRpcDatagramHandler
extends UdpRpcDatagramHandler
implements RpcPacketHandler {
    public static final int DefaultPacketPoolSize = 50;
    public static final int DefaultSmallPacketSize = 512;
    private RpcPacketPool m_packetPool;
    private ThreadRequestPool m_threadPool;
    private RpcRequestQueue m_txQueue;
    private DatagramSender m_txThread;
    private RpcPacket m_rxPkt;

    public MultiThreadedUdpRpcDatagramHandler(String name, String protocol, RpcProcessor rpcServer, NetworkServer server, InetAddress addr, int port, int maxSize) {
        super(name, protocol, rpcServer, server, addr, port, maxSize);
    }

    public void initializeSessionHandler(NetworkServer server, RpcPacketPool pktPool, ThreadRequestPool threadPool) throws IOException {
        this.m_packetPool = pktPool;
        this.m_threadPool = threadPool;
        this.m_txQueue = new RpcRequestQueue();
        this.m_txThread = new DatagramSender("UDP_Tx_" + this.getProtocolName());
        super.initializeSessionHandler(server);
    }

    @Override
    protected boolean processDatagram(DatagramPacket pkt) throws IOException {
        if (pkt.getData() != this.m_rxPkt.getBuffer()) {
            throw new IOException("Received datagram is not in expected buffer");
        }
        this.m_rxPkt.setBuffer(pkt.getData(), 0, pkt.getLength());
        this.m_rxPkt.setClientDetails(pkt.getAddress(), pkt.getPort(), Rpc.ProtocolId.UDP);
        this.m_rxPkt.setPacketHandler(this);
        this.queueRpcRequest(this.m_rxPkt);
        return false;
    }

    protected final void queueRpcRequest(RpcPacket rpc) {
        rpc.setPacketHandler(this);
        this.m_threadPool.queueRequest(new RpcThreadRequest(rpc, this.getRpcProcessor(), this));
    }

    @Override
    protected byte[] allocateBuffer(int bufSize) throws NoPooledMemoryException {
        this.m_rxPkt = this.m_packetPool.allocatePacket(bufSize);
        return this.m_rxPkt.getBuffer();
    }

    @Override
    public void sendRpcResponse(RpcPacket rpc) throws IOException {
        this.m_txQueue.addRequest(rpc);
    }

    public final void setPacketPool(RpcPacketPool pktPool) {
        if (this.m_packetPool == null) {
            this.m_packetPool = pktPool;
        }
    }

    public final void setThreadPool(ThreadRequestPool threadPool) {
        if (this.m_threadPool == null) {
            this.m_threadPool = threadPool;
        }
    }

    @Override
    public void closeSessionHandler(NetworkServer server) {
        this.m_txThread.shutdownRequest();
        super.closeSessionHandler(server);
    }

    @Override
    public RpcPacket receiveRpc() throws IOException {
        return null;
    }

    protected class DatagramSender
    implements Runnable {
        private Thread mi_thread = new Thread(this);
        private DatagramPacket mi_txPkt;
        private boolean mi_shutdown = false;

        public DatagramSender(String name) {
            this.mi_thread.setName(name);
            this.mi_thread.setDaemon(true);
            this.mi_thread.start();
        }

        public final void shutdownRequest() {
            this.mi_shutdown = true;
            try {
                this.mi_thread.interrupt();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public void run() {
            this.mi_txPkt = new DatagramPacket(new byte[4], 4);
            RpcPacket rpc = null;
            while (!this.mi_shutdown) {
                try {
                    rpc = MultiThreadedUdpRpcDatagramHandler.this.m_txQueue.removeRequest();
                }
                catch (InterruptedException ex) {
                    if (this.mi_shutdown) break;
                }
                if (rpc == null) continue;
                try {
                    this.mi_txPkt.setAddress(rpc.getClientAddress());
                    this.mi_txPkt.setPort(rpc.getClientPort());
                    this.mi_txPkt.setData(rpc.getBuffer(), rpc.getOffset(), rpc.getLength());
                    MultiThreadedUdpRpcDatagramHandler.this.getDatagramSocket().send(this.mi_txPkt);
                }
                catch (Throwable ex) {
                    if (this.mi_shutdown) continue;
                    Debug.println("DatagramSender " + Thread.currentThread().getName() + ":");
                    Debug.println(ex);
                }
                finally {
                    if (!rpc.isAllocatedFromPool()) continue;
                    rpc.getOwnerPacketPool().releasePacket(rpc);
                }
            }
        }
    }
}

