/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.oncrpc;

import org.filesys.oncrpc.Rpc;

public class PortMapping {
    private int m_programId;
    private int m_versionId;
    private Rpc.ProtocolId m_protocol;
    private int m_port;

    public PortMapping(int progId, int verId, Rpc.ProtocolId protocol, int port) {
        this.m_programId = progId;
        this.m_versionId = verId;
        this.m_protocol = protocol;
        this.m_port = port;
    }

    public final int getProgramId() {
        return this.m_programId;
    }

    public final int getVersionId() {
        return this.m_versionId;
    }

    public final Rpc.ProtocolId getProtocol() {
        return this.m_protocol;
    }

    public final int getPort() {
        return this.m_port;
    }

    public int hashCode() {
        return PortMapping.generateHashCode(this.m_programId, this.m_versionId, this.m_protocol.ordinal());
    }

    public static final int generateHashCode(int progId, int verId, int proto) {
        return (progId << 16) + (verId << 8) + proto;
    }

    public String toString() {
        StringBuffer str = new StringBuffer(64);
        str.append("[");
        str.append(this.getProgramId());
        str.append(":");
        str.append(this.getVersionId());
        str.append(this.getProtocol().name());
        str.append(this.getPort());
        str.append("]");
        return str.toString();
    }
}

