/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.oncrpc.nfs;

import org.filesys.oncrpc.RpcPacket;
import org.filesys.util.DataPacker;

public class NFSHandle {
    public static final byte VERSION = 1;
    public static final byte MIN_VERSION = 1;
    public static final byte MAX_VERSION = 1;
    public static final byte TYPE_SHARE = 1;
    public static final byte TYPE_DIR = 2;
    public static final byte TYPE_FILE = 3;
    private static final int VERSION_OFFSET = 0;
    private static final int TYPE_OFFSET = 1;
    private static final int SHARE_OFFSET = 2;
    private static final int DIR_OFFSET = 6;
    private static final int FILE_OFFSET = 10;
    private static final int NAME_OFFSET = 14;

    public static final int isVersion(byte[] handle) {
        return handle[0];
    }

    public static final int isType(byte[] handle) {
        return handle[1];
    }

    public static final boolean isShareHandle(byte[] handle) {
        return handle[1] == 1;
    }

    public static final boolean isDirectoryHandle(byte[] handle) {
        return handle[1] == 2;
    }

    public static final boolean isFileHandle(byte[] handle) {
        return handle[1] == 3;
    }

    public static final void packShareHandle(String name, byte[] handle) {
        handle[0] = 1;
        handle[1] = 1;
        DataPacker.putInt(name.hashCode(), handle, 2);
        int pos = 6;
        while (pos < handle.length) {
            handle[pos++] = 0;
        }
    }

    public static final void packShareHandle(String name, RpcPacket rpc, int hlen) {
        rpc.packInt(hlen);
        rpc.packByte(1);
        rpc.packByte(1);
        rpc.packInt(name.hashCode());
        rpc.packNulls(hlen - 6);
    }

    public static final void packDirectoryHandle(int shareId, int dirId, byte[] handle) {
        handle[0] = 1;
        handle[1] = 2;
        DataPacker.putInt(shareId, handle, 2);
        DataPacker.putInt(dirId, handle, 6);
        for (int i = 10; i < handle.length; ++i) {
            handle[i] = 0;
        }
    }

    public static final void packDirectoryHandle(int shareId, int dirId, RpcPacket rpc, int hlen) {
        rpc.packInt(hlen);
        rpc.packByte(1);
        rpc.packByte(2);
        rpc.packInt(shareId);
        rpc.packInt(dirId);
        rpc.packNulls(hlen - 10);
    }

    public static final void packFileHandle(int shareId, int dirId, int fileId, byte[] handle) {
        handle[0] = 1;
        handle[1] = 3;
        DataPacker.putInt(shareId, handle, 2);
        DataPacker.putInt(dirId, handle, 6);
        DataPacker.putInt(fileId, handle, 10);
        for (int i = 14; i < handle.length; ++i) {
            handle[i] = 0;
        }
    }

    public static final void packFileHandle(int shareId, int dirId, int fileId, RpcPacket rpc, int hlen) {
        rpc.packInt(hlen);
        rpc.packByte(1);
        rpc.packByte(3);
        rpc.packInt(shareId);
        rpc.packInt(dirId);
        rpc.packInt(fileId);
        rpc.packNulls(hlen - 14);
    }

    public static final int unpackShareId(byte[] handle) {
        int shareId = -1;
        if (handle[1] == 1 || handle[1] == 2 || handle[1] == 3) {
            shareId = DataPacker.getInt(handle, 2);
        }
        return shareId;
    }

    public static final int unpackDirectoryId(byte[] handle) {
        int dirId = -1;
        if (handle[1] == 2 || handle[1] == 3) {
            dirId = DataPacker.getInt(handle, 6);
        }
        return dirId;
    }

    public static final int unpackFileId(byte[] handle) {
        int fileId = -1;
        if (handle[1] == 3) {
            fileId = DataPacker.getInt(handle, 10);
        }
        return fileId;
    }

    public static final String asString(byte[] handle) {
        StringBuffer str = new StringBuffer();
        str.append("[");
        switch (handle[1]) {
            case 1: {
                str.append("Share:0x");
                str.append(Integer.toHexString(DataPacker.getInt(handle, 2)));
                break;
            }
            case 2: {
                str.append("Dir:share=0x");
                str.append(Integer.toHexString(DataPacker.getInt(handle, 2)));
                str.append(",dir=0x");
                str.append(Integer.toHexString(DataPacker.getInt(handle, 6)));
                break;
            }
            case 3: {
                str.append("File:share=0x");
                str.append(Integer.toHexString(DataPacker.getInt(handle, 2)));
                str.append(",dir=0x");
                str.append(Integer.toHexString(DataPacker.getInt(handle, 6)));
                str.append(",file=0x");
                str.append(Integer.toHexString(DataPacker.getInt(handle, 10)));
            }
        }
        str.append("]");
        return str.toString();
    }

    public static final boolean isValid(byte[] handle) {
        if (handle[0] < 1 || handle[0] > 1) {
            return false;
        }
        return handle[1] == 1 || handle[1] == 2 || handle[1] == 3;
    }
}

