/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.oncrpc.nfs;

import java.io.IOException;
import java.util.EnumSet;
import java.util.Enumeration;
import org.filesys.debug.Debug;
import org.filesys.oncrpc.AuthType;
import org.filesys.oncrpc.MultiThreadedTcpRpcSessionHandler;
import org.filesys.oncrpc.MultiThreadedUdpRpcDatagramHandler;
import org.filesys.oncrpc.PortMapping;
import org.filesys.oncrpc.Rpc;
import org.filesys.oncrpc.RpcAuthenticationException;
import org.filesys.oncrpc.RpcAuthenticator;
import org.filesys.oncrpc.RpcNetworkServer;
import org.filesys.oncrpc.RpcPacket;
import org.filesys.oncrpc.RpcPacketPool;
import org.filesys.oncrpc.RpcProcessor;
import org.filesys.oncrpc.RpcProcessorFactory;
import org.filesys.oncrpc.nfs.NFSConfigSection;
import org.filesys.oncrpc.nfs.NFSSessionTable;
import org.filesys.oncrpc.nfs.NFSSrvSession;
import org.filesys.oncrpc.nfs.RpcSessionProcessor;
import org.filesys.oncrpc.nfs.ShareDetails;
import org.filesys.oncrpc.nfs.ShareDetailsHash;
import org.filesys.oncrpc.nfs.nio.NFSConnectionsHandler;
import org.filesys.oncrpc.nfs.v3.NFS3;
import org.filesys.oncrpc.nfs.v3.NFS3RpcProcessor;
import org.filesys.server.SrvSession;
import org.filesys.server.Version;
import org.filesys.server.config.CoreServerConfigSection;
import org.filesys.server.config.ServerConfiguration;
import org.filesys.server.core.InvalidDeviceInterfaceException;
import org.filesys.server.core.ShareType;
import org.filesys.server.core.SharedDevice;
import org.filesys.server.core.SharedDeviceList;
import org.filesys.server.filesys.FileIdInterface;
import org.filesys.server.filesys.TreeConnection;
import org.filesys.server.filesys.TreeConnectionHash;
import org.filesys.server.thread.ThreadRequestPool;
import org.filesys.util.HexDump;

public class NFSServer
extends RpcNetworkServer
implements RpcProcessor {
    private static final String ServerVersion = Version.NFSServerVersion;
    public static final String UNIX_SEPERATOR = "/";
    public static final char UNIX_SEPERATOR_CHAR = '/';
    public static final String DOS_SEPERATOR = "\\";
    public static final char DOS_SEPERATOR_CHAR = '\\';
    public static final int MaxRequestSize = 65535;
    private CoreServerConfigSection m_coreConfig;
    private NFSConfigSection m_nfsConfig;
    private MultiThreadedUdpRpcDatagramHandler m_udpHandler;
    private MultiThreadedTcpRpcSessionHandler m_tcpHandler;
    private NFSConnectionsHandler m_nioTcpHandler;
    private ShareDetailsHash m_shareDetails;
    private TreeConnectionHash m_connections;
    private NFSSessionTable m_sessAuthNull;
    private NFSSessionTable m_sessAuthUnix;
    private int m_sessId = 1;
    private int m_port;
    private ThreadRequestPool m_threadPool;
    private RpcPacketPool m_packetPool;
    private RpcAuthenticator m_rpcAuthenticator;
    private long m_writeVerifier;
    private EnumSet<NFSSrvSession.Dbg> m_debug;

    public NFSServer(ServerConfiguration config) {
        super("NFS", config);
        this.setVersion(ServerVersion);
        this.m_coreConfig = (CoreServerConfigSection)config.getConfigSection("CoreServer");
        this.m_nfsConfig = (NFSConfigSection)config.getConfigSection("NFS");
        if (this.m_nfsConfig != null) {
            this.setDebugFlags(this.getNFSConfiguration().getNFSDebug());
            if (this.getNFSConfiguration().getNFSServerPort() != 0) {
                this.setPort(this.getNFSConfiguration().getNFSServerPort());
            } else {
                this.setPort(2049);
            }
            this.m_rpcAuthenticator = this.getNFSConfiguration().getRpcAuthenticator();
            this.m_writeVerifier = System.currentTimeMillis();
            this.setPortMapper(this.getNFSConfiguration().getPortMapperPort());
        } else {
            this.setEnabled(false);
        }
    }

    public final int getPort() {
        return this.m_port;
    }

    protected final NFSConfigSection getNFSConfiguration() {
        return this.m_nfsConfig;
    }

    public final ThreadRequestPool getThreadPool() {
        return this.m_threadPool;
    }

    public final RpcPacketPool getPacketPool() {
        return this.m_packetPool;
    }

    public final void setPort(int port) {
        this.m_port = port;
    }

    public final boolean hasDebug(Enum<NFSSrvSession.Dbg> flg) {
        return this.m_debug.contains(flg);
    }

    public final void setDebugFlags(EnumSet<NFSSrvSession.Dbg> dbg) {
        this.m_debug = dbg;
    }

    @Override
    public void startServer() {
        try {
            RpcProcessorFactory.addRpcProcessorClass(100003, 3, NFS3RpcProcessor.class);
            this.m_shareDetails = new ShareDetailsHash();
            this.m_connections = new TreeConnectionHash();
            this.checkForNewShares();
            this.m_threadPool = this.m_coreConfig.getThreadPool();
            this.m_packetPool = new RpcPacketPool(this.m_coreConfig.getMemoryPool(), this.m_coreConfig.getThreadPool());
            this.m_udpHandler = new MultiThreadedUdpRpcDatagramHandler("Nfsd", "Nfs", this, this, null, this.getPort(), 65535);
            this.m_udpHandler.initializeSessionHandler(this, this.m_packetPool, this.m_threadPool);
            Thread udpThread = new Thread(this.m_udpHandler);
            udpThread.setName("NFS_UDP");
            udpThread.start();
            if (!this.m_nfsConfig.hasDisableNIOCode()) {
                this.m_nioTcpHandler = new NFSConnectionsHandler();
                this.m_nioTcpHandler.initializeHandler(this, this.m_nfsConfig);
                this.m_port = this.m_nioTcpHandler.getPort();
                this.m_nioTcpHandler.startHandler();
            } else {
                if (this.hasDebug(NFSSrvSession.Dbg.SOCKET)) {
                    Debug.println("[NFS] Disabled NIO");
                }
                this.m_tcpHandler = new MultiThreadedTcpRpcSessionHandler("Nfsd", "Nfs", this, this, null, this.getPort(), 65535);
                this.m_tcpHandler.initializeSessionHandler(this, this.m_packetPool, this.m_threadPool);
                this.m_port = this.m_tcpHandler.getPort();
                Thread tcpThread = new Thread(this.m_tcpHandler);
                tcpThread.setName("NFS_TCP");
                tcpThread.start();
            }
            PortMapping[] mappings = new PortMapping[]{new PortMapping(100003, 3, Rpc.ProtocolId.UDP, this.getPort()), new PortMapping(100003, 3, Rpc.ProtocolId.TCP, this.getPort())};
            this.registerRPCServer(mappings);
            this.setActive(true);
        }
        catch (Exception ex) {
            this.setException(ex);
            Debug.println(ex);
        }
    }

    @Override
    public void shutdownServer(boolean immediate) {
        block5: {
            try {
                PortMapping[] mappings = new PortMapping[]{new PortMapping(100003, 3, Rpc.ProtocolId.UDP, this.getPort()), new PortMapping(100003, 3, Rpc.ProtocolId.TCP, this.getPort())};
                this.unregisterRPCServer(mappings);
            }
            catch (IOException ex) {
                if (!this.hasDebug(NFSSrvSession.Dbg.ERROR)) break block5;
                Debug.println(ex);
            }
        }
        if (this.m_udpHandler != null) {
            this.m_udpHandler.closeSessionHandler(this);
            this.m_udpHandler = null;
        }
        if (this.m_tcpHandler != null) {
            this.m_tcpHandler.closeSessionHandler(this);
            this.m_tcpHandler = null;
        }
        if (this.m_nioTcpHandler != null) {
            this.m_nioTcpHandler.stopHandler();
            this.m_nioTcpHandler = null;
        }
        this.fireServerEvent(2);
        this.setActive(false);
    }

    protected final synchronized int getNextSessionId() {
        return this.m_sessId++;
    }

    @Override
    public RpcPacket processRpc(RpcPacket rpc) throws IOException {
        if (this.hasDebug(NFSSrvSession.Dbg.DUMPDATA)) {
            Debug.println("NFS Req=" + rpc.toString());
        }
        int progId = rpc.getProgramId();
        int version = rpc.getProgramVersion();
        if (!RpcProcessorFactory.supportsRpcProgram(progId)) {
            rpc.buildAcceptErrorResponse(Rpc.AcceptSts.ProgUnavail);
            return rpc;
        }
        if (!RpcProcessorFactory.supportsRpcVersion(progId, version)) {
            int[] nfsVers = RpcProcessorFactory.getSupportedVersionRange(progId);
            rpc.buildProgramMismatchResponse(nfsVers[0], nfsVers[1]);
            return rpc;
        }
        NFSSrvSession nfsSess = null;
        try {
            nfsSess = this.findSessionForRequest(rpc);
        }
        catch (RpcAuthenticationException ex) {
            rpc.buildAuthFailResponse(ex.getAuthenticationErrorCode());
            return rpc;
        }
        RpcPacket response = null;
        if (nfsSess != null) {
            if (!nfsSess.hasRpcProcessor()) {
                RpcSessionProcessor rpcProc = RpcProcessorFactory.getRpcSessionProcessor(progId, version);
                if (rpcProc != null) {
                    nfsSess.setRpcProcessor(rpcProc);
                } else {
                    rpc.buildErrorResponse(NFS3.StatusCode.ServerFault.intValue());
                    return rpc;
                }
            }
            response = nfsSess.getRpcProcessor().processRpc(rpc, nfsSess);
        }
        if (nfsSess != null) {
            nfsSess.endTransaction();
        }
        if (this.hasDebug(NFSSrvSession.Dbg.DUMPDATA)) {
            Debug.println("NFS Resp=" + (rpc != null ? rpc.toString() : "<Null>"));
            HexDump.Dump(rpc.getBuffer(), rpc.getLength(), 0);
        }
        return response;
    }

    private final NFSSrvSession findSessionForRequest(RpcPacket rpc) throws RpcAuthenticationException {
        NFSSrvSession sess;
        boolean authFailed;
        block10: {
            AuthType authType = rpc.getCredentialsType();
            authFailed = true;
            sess = null;
            try {
                Object sessKey = this.getRpcAuthenticator().authenticateRpcClient(authType, rpc);
                switch (authType) {
                    case Null: {
                        sess = this.findAuthNullSession(rpc, sessKey);
                        break;
                    }
                    case Unix: {
                        sess = this.findAuthUnixSession(rpc, sessKey);
                    }
                }
                if (sess != null) {
                    this.getRpcAuthenticator().setCurrentUser(sess, sess.getClientInformation());
                    authFailed = false;
                    if (this.hasDebug(NFSSrvSession.Dbg.SESSION)) {
                        Debug.println("[NFS] Found session " + sess + ", client=" + sess.getClientInformation());
                    }
                }
            }
            catch (Throwable ex) {
                if (!this.hasDebug(NFSSrvSession.Dbg.ERROR)) break block10;
                Debug.println("[NFS] RPC Authencation Exception: " + ex.toString());
            }
        }
        if (authFailed) {
            rpc.positionAtParameters();
            if (rpc.getProcedureId() != NFS3.ProcedureId.Null.intValue()) {
                throw new RpcAuthenticationException(Rpc.AuthSts.BadCred);
            }
        }
        return sess;
    }

    private final NFSSrvSession findAuthNullSession(RpcPacket rpc, Object sessKey) {
        NFSSrvSession sess = null;
        if (this.m_sessAuthNull != null) {
            sess = this.m_sessAuthNull.findSession(sessKey);
        } else {
            this.m_sessAuthNull = new NFSSessionTable();
        }
        if (sess == null) {
            sess = new NFSSrvSession(this, rpc.getClientAddress(), rpc.getClientPort(), rpc.getClientProtocol());
            sess.setAuthIdentifier(sessKey);
            sess.setClientInformation(this.getRpcAuthenticator().getRpcClientInformation(sessKey, rpc));
            this.m_sessAuthNull.addSession(sess);
            sess.setUniqueId("" + sessKey.hashCode());
            sess.setDebugPrefix("[NFS_AN_" + this.getNextSessionId() + "] ");
            sess.setDebug(this.getNFSConfiguration().getNFSDebug());
            if (this.hasDebug(NFSSrvSession.Dbg.SESSION)) {
                Debug.println("[NFS] Added Null session " + sess.getUniqueId());
            }
        }
        return sess;
    }

    private final NFSSrvSession findAuthUnixSession(RpcPacket rpc, Object sessKey) {
        NFSSrvSession sess = null;
        if (this.m_sessAuthUnix != null) {
            sess = this.m_sessAuthUnix.findSession(sessKey);
        } else {
            this.m_sessAuthUnix = new NFSSessionTable();
        }
        if (sess == null) {
            sess = new NFSSrvSession(this, rpc.getClientAddress(), rpc.getClientPort(), rpc.getClientProtocol());
            sess.setAuthIdentifier(sessKey);
            sess.setUniqueId("" + sessKey.hashCode());
            sess.setDebugPrefix("[NFS_AU_" + this.getNextSessionId() + "] ");
            sess.setDebug(this.getNFSConfiguration().getNFSDebug());
            sess.setNFSClientInformation(this.getRpcAuthenticator().getRpcClientInformation(sessKey, rpc));
            sess.setClientInformation(sess.getNFSClientInformation());
            this.m_sessAuthUnix.addSession(sess);
            if (this.hasDebug(NFSSrvSession.Dbg.SESSION)) {
                Debug.println("[NFS] Added Unix session " + sess.getUniqueId());
            }
        } else {
            sess.setClientInformation(sess.getNFSClientInformation());
        }
        return sess;
    }

    public final ShareDetails findShareDetails(int shareId) {
        return this.m_shareDetails.findDetails(shareId);
    }

    public final ShareDetails findShareDetailsByName(String shareName) {
        return this.m_shareDetails.findDetails(shareName);
    }

    public final long getWriteVerifier() {
        return this.m_writeVerifier;
    }

    public final int checkForNewShares() {
        SharedDeviceList shareList = this.getShareMapper().getShareList(this.getConfiguration().getServerName(), null, false);
        Enumeration<SharedDevice> shares = shareList.enumerateShares();
        int newShares = 0;
        while (shares.hasMoreElements()) {
            SharedDevice share = shares.nextElement();
            if (share == null || share.getType() != ShareType.DISK) continue;
            boolean fileIdSupport = false;
            try {
                if (share.getInterface() instanceof FileIdInterface) {
                    fileIdSupport = true;
                }
            }
            catch (InvalidDeviceInterfaceException invalidDeviceInterfaceException) {
                // empty catch block
            }
            if (this.m_shareDetails.findDetails(share.getName()) != null) continue;
            this.m_shareDetails.addDetails(new ShareDetails(share.getName(), fileIdSupport));
            this.m_connections.addConnection(new TreeConnection(share));
            ++newShares;
        }
        return newShares;
    }

    public final TreeConnection findConnection(int shareHash) {
        if (this.m_connections == null) {
            return null;
        }
        return this.m_connections.findConnection(shareHash);
    }

    protected final RpcAuthenticator getRpcAuthenticator() {
        return this.m_rpcAuthenticator;
    }

    protected final void fireSessionOpened(SrvSession sess) {
        this.fireSessionOpenEvent(sess);
    }

    protected final void fireSessionClosed(SrvSession sess) {
        this.fireSessionClosedEvent(sess);
    }
}

