/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.oncrpc.nfs.nio;

import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.filesys.debug.Debug;
import org.filesys.oncrpc.Rpc;
import org.filesys.oncrpc.RpcPacketHandler;
import org.filesys.oncrpc.nfs.NFSConfigSection;
import org.filesys.oncrpc.nfs.NFSServer;
import org.filesys.oncrpc.nfs.NFSSrvSession;
import org.filesys.oncrpc.nfs.nio.NFSRequestHandler;
import org.filesys.oncrpc.nfs.nio.NFSRequestHandlerListener;
import org.filesys.oncrpc.nfs.nio.RpcChannelSessionHandler;
import org.filesys.oncrpc.nfs.nio.TcpRpcChannelSessionHandler;
import org.filesys.server.SessionHandlerList;
import org.filesys.server.config.InvalidConfigurationException;

public class NFSConnectionsHandler
implements Runnable,
NFSRequestHandlerListener {
    public static final int SessionSocketsPerHandler = 50;
    private SessionHandlerList m_handlerList = new SessionHandlerList();
    private Selector m_selector;
    private List<NFSRequestHandler> m_requestHandlers;
    private NFSServer m_server;
    private Thread m_thread;
    private boolean m_shutdown;
    private int m_sessId;
    private int m_clientSocketTimeout;
    private IdleSessionReaper m_idleSessReaper;
    private int m_port;
    private boolean m_debug;
    private boolean m_threadDebug;

    public final boolean hasDebug() {
        return this.m_debug;
    }

    public final int getPort() {
        return this.m_port;
    }

    public int numberOfSessionHandlers() {
        return this.m_handlerList.numberOfHandlers();
    }

    public final void initializeHandler(NFSServer srv, NFSConfigSection config) throws InvalidConfigurationException {
        this.m_server = srv;
        if (config.getNFSDebug().contains((Object)NFSSrvSession.Dbg.SESSION)) {
            this.m_debug = true;
        }
        this.m_port = config.getNFSServerPort();
        TcpRpcChannelSessionHandler sessHandler = new TcpRpcChannelSessionHandler(this.m_server, null, this.getPort());
        sessHandler.setDebug(this.hasDebug());
        try {
            sessHandler.initializeSessionHandler(srv);
            this.m_handlerList.addHandler(sessHandler);
        }
        catch (IOException ex) {
            throw new InvalidConfigurationException("Error initializing TCP-IP NFS session handler, " + ex.getMessage());
        }
        if (this.m_handlerList.numberOfHandlers() == 0) {
            throw new InvalidConfigurationException("No NFS session handlers enabled");
        }
        this.m_requestHandlers = new ArrayList<NFSRequestHandler>();
        NFSRequestHandler reqHandler = new NFSRequestHandler(this.m_server, 50, this.m_clientSocketTimeout, this.m_debug);
        reqHandler.setThreadDebug(this.m_threadDebug);
        reqHandler.setListener(this);
        this.m_requestHandlers.add(reqHandler);
    }

    public final void startHandler() {
        this.m_thread = new Thread(this);
        this.m_thread.setName("NFSConnectionsHandler");
        this.m_thread.setDaemon(false);
        this.m_thread.start();
        if (this.m_clientSocketTimeout > 0) {
            this.m_idleSessReaper = new IdleSessionReaper(this.m_clientSocketTimeout / 2);
        }
    }

    public final void stopHandler() {
        if (this.m_thread != null) {
            this.m_shutdown = true;
            try {
                this.m_thread.interrupt();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.m_idleSessReaper != null) {
                this.m_idleSessReaper.shutdownRequest();
            }
        }
    }

    @Override
    public void run() {
        block21: {
            int idx;
            this.m_shutdown = false;
            try {
                this.m_selector = Selector.open();
                for (idx = 0; idx < this.m_handlerList.numberOfHandlers(); ++idx) {
                    RpcChannelSessionHandler curHandler = (RpcChannelSessionHandler)this.m_handlerList.getHandlerAt(idx);
                    ServerSocketChannel sockChannel = curHandler.getSocketChannel();
                    sockChannel.configureBlocking(false);
                    sockChannel.register(this.m_selector, 16, curHandler);
                    if (!this.hasDebug()) continue;
                    Debug.println("[NFS] Listening for connections on " + curHandler);
                }
            }
            catch (IOException ex) {
                if (this.hasDebug()) {
                    Debug.println("[NFS] Error opening/registering Selector");
                    Debug.println(ex);
                }
                this.m_shutdown = true;
            }
            while (!this.m_shutdown) {
                int connCnt;
                block19: {
                    if (this.hasDebug()) {
                        Debug.println("[NFS] Waiting for new connection ...");
                    }
                    connCnt = 0;
                    try {
                        connCnt = this.m_selector.select();
                    }
                    catch (IOException ex) {
                        if (!this.hasDebug()) break block19;
                        Debug.println("[NFS] Error waiting for connection");
                        Debug.println(ex);
                    }
                }
                if (connCnt == 0) continue;
                Iterator<SelectionKey> keysIter = this.m_selector.selectedKeys().iterator();
                while (keysIter.hasNext()) {
                    block20: {
                        SelectionKey selKey = keysIter.next();
                        if (selKey.isAcceptable()) {
                            try {
                                ServerSocketChannel srvChannel = (ServerSocketChannel)selKey.channel();
                                SocketChannel sockChannel = srvChannel.accept();
                                RpcChannelSessionHandler channelHandler = (RpcChannelSessionHandler)selKey.attachment();
                                RpcPacketHandler pktHandler = channelHandler.createPacketHandler(sockChannel);
                                NFSSrvSession sess = NFSSrvSession.createSession(pktHandler, this.m_server, ++this.m_sessId, Rpc.ProtocolId.TCP, sockChannel.socket().getRemoteSocketAddress());
                                if (this.hasDebug()) {
                                    Debug.println("[NFS] Created session " + sess.getUniqueId());
                                }
                                if (this.hasDebug()) {
                                    Debug.println("[NFS] Connection from " + sockChannel.socket().getRemoteSocketAddress() + ", handler=" + channelHandler + ", sess=" + sess.getUniqueId());
                                }
                                this.queueSessionToHandler(sess);
                            }
                            catch (IOException ex) {
                                if (!this.hasDebug()) break block20;
                                Debug.println("[NFS] Failed to accept connection");
                                Debug.println(ex);
                            }
                        }
                    }
                    keysIter.remove();
                }
            }
            for (idx = 0; idx < this.m_handlerList.numberOfHandlers(); ++idx) {
                RpcChannelSessionHandler sessHandler = (RpcChannelSessionHandler)this.m_handlerList.getHandlerAt(idx);
                sessHandler.closeSessionHandler(null);
                if (!this.hasDebug()) continue;
                Debug.println("[NFS] Closed session handler " + sessHandler);
            }
            while (this.m_requestHandlers.size() > 0) {
                NFSRequestHandler reqHandler = this.m_requestHandlers.remove(0);
                reqHandler.closeHandler();
                if (!this.hasDebug()) continue;
                Debug.println("[NFS] Closed request handler, " + reqHandler.getName());
            }
            if (this.m_selector != null) {
                try {
                    this.m_selector.close();
                }
                catch (Exception ex) {
                    if (!this.hasDebug()) break block21;
                    Debug.println("[NFS] Error closing socket selector, " + ex.getMessage());
                }
            }
        }
        this.m_thread = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void queueSessionToHandler(NFSSrvSession sess) {
        NFSRequestHandler reqHandler = null;
        List<NFSRequestHandler> list = this.m_requestHandlers;
        synchronized (list) {
            reqHandler = this.m_requestHandlers.get(0);
            if (reqHandler == null || !reqHandler.hasFreeSessionSlot()) {
                reqHandler = new NFSRequestHandler(this.m_server, 50, this.m_clientSocketTimeout, this.hasDebug());
                reqHandler.setThreadDebug(this.m_threadDebug);
                reqHandler.setListener(this);
                this.m_requestHandlers.add(0, reqHandler);
                if (this.hasDebug()) {
                    Debug.println("[NFS] Added new NFS request handler, " + reqHandler);
                }
            }
        }
        reqHandler.queueSessionToHandler(sess);
    }

    public final void setDebug(boolean ena) {
        this.m_debug = ena;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestHandlerEmpty(NFSRequestHandler reqHandler) {
        SessionHandlerList sessionHandlerList = this.m_handlerList;
        synchronized (sessionHandlerList) {
            if (!this.m_requestHandlers.get(0).getName().equals(reqHandler.getName())) {
                this.m_requestHandlers.remove(reqHandler);
                reqHandler.closeHandler();
                if (this.hasDebug()) {
                    Debug.println("[NFS] Removed empty request handler, " + reqHandler.getName());
                }
            }
        }
    }

    protected class IdleSessionReaper
    implements Runnable {
        private long m_wakeup;
        private Thread m_reaperThread;
        private boolean m_shutdown = false;

        public IdleSessionReaper(long intvl) {
            this.m_wakeup = intvl;
            this.m_reaperThread = new Thread(this);
            this.m_reaperThread.setDaemon(true);
            this.m_reaperThread.setName("NFS_IdleSessionReaper_NIO");
            this.m_reaperThread.start();
        }

        public final void shutdownRequest() {
            this.m_shutdown = true;
            this.m_reaperThread.interrupt();
        }

        @Override
        public void run() {
            while (!this.m_shutdown) {
                try {
                    Thread.sleep(this.m_wakeup);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.m_shutdown) break;
                for (NFSRequestHandler curHandler : NFSConnectionsHandler.this.m_requestHandlers) {
                    int idleCnt;
                    if (curHandler == null || (idleCnt = curHandler.checkForIdleSessions()) <= 0 || !NFSConnectionsHandler.this.hasDebug()) continue;
                    Debug.println("[NFS] Idle session check, removed " + idleCnt + " sessions for " + curHandler.getName());
                }
            }
        }
    }
}

