/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.oncrpc.nfs.nio;

import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.filesys.debug.Debug;
import org.filesys.oncrpc.nfs.NFSServer;
import org.filesys.oncrpc.nfs.NFSSrvSession;
import org.filesys.oncrpc.nfs.nio.NFSRequestHandlerListener;
import org.filesys.oncrpc.nfs.nio.NIORpcThreadRequest;
import org.filesys.oncrpc.nfs.nio.RpcChannelPacketHandler;
import org.filesys.server.SessionListener;
import org.filesys.server.SrvSession;
import org.filesys.server.SrvSessionQueue;
import org.filesys.server.core.NoPooledMemoryException;
import org.filesys.server.thread.ThreadRequest;
import org.filesys.server.thread.ThreadRequestPool;

public class NFSRequestHandler
implements Runnable,
SessionListener {
    private int m_maxSessions;
    private static int _handlerId;
    private Selector m_selector;
    private List<ThreadRequest> m_reqList = new ArrayList<ThreadRequest>();
    private AtomicInteger m_sessionCount = new AtomicInteger();
    private Thread m_thread;
    private ThreadRequestPool m_threadPool;
    private SrvSessionQueue m_sessQueue;
    private int m_clientSocketTimeout;
    private AtomicBoolean m_runIdleSessReaper = new AtomicBoolean();
    private NFSRequestHandlerListener m_listener;
    private boolean m_shutdown;
    private boolean m_debug;

    public NFSRequestHandler(NFSServer nfsServer, int maxSess, int sockTmo, boolean debug) {
        this.m_maxSessions = maxSess;
        this.m_threadPool = nfsServer.getThreadPool();
        this.m_clientSocketTimeout = sockTmo;
        this.m_sessQueue = new SrvSessionQueue();
        nfsServer.addSessionListener(this);
        this.m_debug = debug;
        this.m_thread = new Thread(this);
        this.m_thread.setName("NFSRequestHandler_" + ++_handlerId);
        this.m_thread.setDaemon(false);
        this.m_thread.start();
    }

    public final int getCurrentSessionCount() {
        return this.m_sessionCount.get();
    }

    public final boolean hasFreeSessionSlot() {
        return this.getCurrentSessionCount() + this.m_sessQueue.numberOfSessions() < this.getMaximumSessionCount();
    }

    public final int getSocketTimeout() {
        return this.m_clientSocketTimeout;
    }

    public final void setSocketTimeout(int tmo) {
        this.m_clientSocketTimeout = tmo;
    }

    public final int getMaximumSessionCount() {
        return this.m_maxSessions;
    }

    public final boolean hasDebug() {
        return this.m_debug;
    }

    public final void setDebug(boolean ena) {
        this.m_debug = ena;
    }

    public final void queueSessionToHandler(NFSSrvSession sess) {
        this.m_sessQueue.addSession(sess);
        if (this.m_selector != null) {
            this.m_selector.wakeup();
        }
    }

    public final String getName() {
        if (this.m_thread != null) {
            return this.m_thread.getName();
        }
        return "NFSRequestHandler";
    }

    public final void setThreadDebug(boolean dbg) {
        this.m_threadPool.setDebug(dbg);
    }

    public final boolean hasListener() {
        return this.m_listener != null;
    }

    public final NFSRequestHandlerListener getListener() {
        return this.m_listener;
    }

    public final void setListener(NFSRequestHandlerListener listener) {
        this.m_listener = listener;
    }

    protected final void fireRequestHandlerEmptyEvent() {
        if (this.hasListener()) {
            this.getListener().requestHandlerEmpty(this);
        }
    }

    @Override
    public void run() {
        block29: {
            this.m_shutdown = false;
            try {
                this.m_selector = Selector.open();
            }
            catch (IOException ex) {
                if (this.hasDebug()) {
                    Debug.println("[NFS] Error opening/registering Selector");
                    Debug.println(ex);
                }
                this.m_shutdown = true;
            }
            while (!this.m_shutdown) {
                try {
                    int sessCnt;
                    block28: {
                        sessCnt = 0;
                        this.m_sessionCount.set(this.m_selector.keys().size());
                        if (this.m_sessionCount.get() == 0) {
                            this.fireRequestHandlerEmptyEvent();
                            if (this.hasDebug()) {
                                Debug.println("[NFS] Request handler " + this.m_thread.getName() + " waiting for session ...");
                            }
                            try {
                                this.m_sessQueue.waitWhileEmpty();
                            }
                            catch (InterruptedException interruptedException) {}
                        } else {
                            try {
                                sessCnt = this.m_selector.select();
                            }
                            catch (CancelledKeyException ex) {
                                if (this.hasDebug() && !this.m_shutdown) {
                                    Debug.println("[NFS] Request handler error waiting for events");
                                    Debug.println(ex);
                                }
                            }
                            catch (IOException ex) {
                                if (!this.hasDebug()) break block28;
                                Debug.println("[NFS] Request handler error waiting for events");
                                Debug.println(ex);
                            }
                        }
                    }
                    if (this.m_shutdown) continue;
                    if (sessCnt > 0) {
                        try {
                            this.processSocketEvents();
                        }
                        catch (Throwable ex) {
                            Debug.println(Thread.currentThread().getName() + ": Exception in processSocketEvents()");
                            Debug.println(ex);
                        }
                    }
                    if (this.m_sessQueue.numberOfSessions() > 0) {
                        try {
                            this.addNewSockets();
                        }
                        catch (Throwable ex) {
                            Debug.println(Thread.currentThread().getName() + ": Exception in addNewSockets()");
                            Debug.println(ex);
                        }
                    }
                    if (!this.m_runIdleSessReaper.get()) continue;
                    try {
                        int remCnt = this.runIdleSessionsReaper();
                        if (remCnt <= 0 || !this.hasDebug()) continue;
                        Debug.println("[NFS] Idle session reaper removed " + remCnt + " sessions");
                    }
                    catch (Throwable ex) {
                        Debug.println(Thread.currentThread().getName() + ": Exception in runIdleSessionsReaper()");
                        Debug.println(ex);
                    }
                }
                catch (Throwable ex) {
                    Debug.println(Thread.currentThread().getName() + ": Exception in run() method");
                    Debug.println(ex);
                }
            }
            if (this.m_selector != null) {
                for (SelectionKey curKey : this.m_selector.keys()) {
                    NFSSrvSession sess = (NFSSrvSession)curKey.attachment();
                    sess.closeSession();
                    if (!this.hasDebug()) continue;
                    Debug.println("[NFS] Closed session, " + sess.getUniqueId() + ", addr=" + sess.getRemoteAddress().getHostAddress());
                }
                try {
                    this.m_selector.close();
                }
                catch (IOException ex) {
                    if (!this.hasDebug()) break block29;
                    Debug.println("[NFS] Error closing Selector");
                    Debug.println(ex);
                }
            }
        }
        if (this.hasDebug()) {
            Debug.println("[NFS] Closed SMB request handler, " + this.m_thread.getName());
        }
    }

    private void processSocketEvents() {
        this.m_reqList.clear();
        Iterator<SelectionKey> keysIter = this.m_selector.selectedKeys().iterator();
        long timeNow = System.currentTimeMillis();
        while (keysIter.hasNext()) {
            SelectionKey selKey = keysIter.next();
            keysIter.remove();
            if (!selKey.isValid()) {
                Debug.println("NFSRequestHandler: Cancelling selection key - " + selKey);
                selKey.cancel();
                if (!this.hasDebug()) continue;
                Debug.println("[NFS] NIO Selection key not valid, sess=" + selKey.attachment());
                continue;
            }
            if (selKey.isReadable()) {
                selKey.interestOps(selKey.interestOps() & 0xFFFFFFFE);
                NFSSrvSession sess = (NFSSrvSession)selKey.attachment();
                this.m_reqList.add(new NIORpcThreadRequest(sess, selKey));
                sess.setLastIOTime(timeNow);
                if (this.m_reqList.size() < 5) continue;
                this.m_threadPool.queueRequests(this.m_reqList);
                this.m_reqList.clear();
                continue;
            }
            if (!selKey.isValid()) {
                Debug.println("SMBRequestHandler: Cancelling selection key - " + selKey);
                selKey.cancel();
                if (!this.hasDebug()) continue;
                Debug.println("[NFS] NIO Selection key not valid, sess=" + selKey.attachment());
                continue;
            }
            if (!this.hasDebug()) continue;
            Debug.println("[NFS] Unprocessed selection key, " + selKey);
        }
        if (this.m_reqList.size() > 0) {
            this.m_threadPool.queueRequests(this.m_reqList);
            this.m_reqList.clear();
        }
    }

    private void addNewSockets() {
        while (this.m_sessQueue.numberOfSessions() > 0) {
            NFSSrvSession sess = (NFSSrvSession)this.m_sessQueue.removeSessionNoWait();
            if (sess == null || sess.getRpcProcessor() != null) continue;
            if (this.hasDebug()) {
                Debug.println("[NFS] Register session with request handler, handler=" + this.m_thread.getName() + ", sess=" + sess.getUniqueId());
            }
            if (!(sess.getPacketHandler() instanceof RpcChannelPacketHandler)) continue;
            RpcChannelPacketHandler chanPktHandler = (RpcChannelPacketHandler)sess.getPacketHandler();
            SocketChannel sessChannel = chanPktHandler.getChannel();
            try {
                sessChannel.configureBlocking(false);
                sessChannel.register(this.m_selector, 1, sess);
                sess.setLastIOTime(System.currentTimeMillis());
            }
            catch (ClosedChannelException ex) {
                if (!this.hasDebug()) continue;
                Debug.println("[NFS] Failed to register session channel, closed channel");
            }
            catch (IOException ex) {
                if (!this.hasDebug()) continue;
                Debug.println("[NFS] Failed to set channel blocking mode, " + ex.getMessage());
            }
        }
    }

    public final void closeHandler() {
        if (this.m_thread != null) {
            this.m_shutdown = true;
            try {
                this.m_thread.interrupt();
                if (this.m_selector != null) {
                    this.m_selector.wakeup();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected final int checkForIdleSessions() {
        if (this.m_thread != null && this.m_selector != null && this.m_sessionCount.get() > 0) {
            if (this.m_runIdleSessReaper.get()) {
                this.dumpHandlerDetails();
            }
            this.m_runIdleSessReaper.set(true);
            this.m_selector.wakeup();
        }
        return 0;
    }

    private int runIdleSessionsReaper() {
        this.m_runIdleSessReaper.set(false);
        int idleCnt = 0;
        if (this.m_selector != null && this.m_sessionCount.get() > 0) {
            long checkTime = System.currentTimeMillis() - (long)this.m_clientSocketTimeout;
            for (SelectionKey curKey : this.m_selector.keys()) {
                NFSSrvSession sess = (NFSSrvSession)curKey.attachment();
                if (sess == null || sess.getLastIOTime() >= checkTime) continue;
                if (this.hasDebug()) {
                    Debug.println("[NFS] Closing idle session, " + sess.getUniqueId() + ", addr=" + sess.getRemoteAddress() + ":" + sess.getRemotePort());
                }
                sess.closeSession();
                ++idleCnt;
            }
            if (idleCnt > 0) {
                this.m_selector.wakeup();
            }
        }
        return idleCnt;
    }

    public boolean equals(Object obj) {
        if (obj instanceof NFSRequestHandler) {
            NFSRequestHandler reqHandler = (NFSRequestHandler)obj;
            return reqHandler.getName().equals(this.getName());
        }
        return false;
    }

    private void dumpHandlerDetails() {
        Debug.println("NFSRequestHandler details:");
        Debug.println("  Thread: " + this.m_thread);
        if (this.m_thread != null) {
            Debug.println("    Name  : " + this.m_thread.getName());
            Debug.println("    State : " + (Object)((Object)this.m_thread.getState()));
            StackTraceElement[] thStack = this.m_thread.getStackTrace();
            if (thStack != null) {
                Debug.println("    Stack : ");
                for (StackTraceElement stElem : thStack) {
                    Debug.println("        " + stElem);
                }
            } else {
                Debug.println("    No Stack");
            }
        }
        Debug.println("  Sessions: " + this.m_sessionCount.get());
        Debug.println("  Session Queue: " + this.m_sessQueue.numberOfSessions());
        Debug.println("  Selector: " + this.m_selector);
        Debug.println("  ThreadRequestPool: queue=" + this.m_threadPool.getNumberOfRequests());
        Debug.println("  NoPooledMemoryException: count=" + NoPooledMemoryException.getExceptionCounter());
    }

    @Override
    public void sessionClosed(SrvSession sess) {
    }

    @Override
    public void sessionCreated(SrvSession sess) {
    }

    @Override
    public void sessionLoggedOn(SrvSession sess) {
    }
}

